/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.ute.UTEHelperFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnection;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnectionFactory;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnectionFactoryImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector;
import java.util.Map;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;

final class JmsJcaConnectionFactoryImpl
implements JmsJcaConnectionFactory {
    private JmsJcaManagedConnectionFactoryImpl _managedConnectionFactory;
    private ConnectionManager _connectionManager;
    private boolean _managed;
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String CLASS_NAME = JmsJcaConnectionFactoryImpl.class.getName();
    private static final long serialVersionUID = 6803409986837640579L;
    private static TraceComponent TRACE = SibTr.register(JmsJcaConnectionFactoryImpl.class, "SIBJmsRa", "com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");

    JmsJcaConnectionFactoryImpl(JmsJcaManagedConnectionFactoryImpl jmsJcaManagedConnectionFactoryImpl, ConnectionManager connectionManager) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "JmsJcaConnectionFactoryImpl", new Object[]{jmsJcaManagedConnectionFactoryImpl, connectionManager});
        }
        this._managedConnectionFactory = jmsJcaManagedConnectionFactoryImpl;
        this._connectionManager = connectionManager;
        this._managed = true;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "JmsJcaConnectionFactoryImpl");
        }
    }

    JmsJcaConnectionFactoryImpl(JmsJcaManagedConnectionFactoryImpl jmsJcaManagedConnectionFactoryImpl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "JmsJcaConnectionFactoryImpl", new Object[]{jmsJcaManagedConnectionFactoryImpl});
        }
        this._managedConnectionFactory = jmsJcaManagedConnectionFactoryImpl;
        this._managed = false;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "JmsJcaConnectionFactoryImpl");
        }
    }

    public JmsJcaConnection createConnection() throws ResourceException, SIException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "createConnection");
        }
        JmsJcaConnectionImpl jmsJcaConnectionImpl = null;
        try {
            if (this._managed) {
                JmsJcaConnectionRequestInfo jmsJcaConnectionRequestInfo = new JmsJcaConnectionRequestInfo();
                Object object = null;
                boolean bl = true;
                do {
                    if ((object = this._connectionManager.allocateConnection((ManagedConnectionFactory)this._managedConnectionFactory, (ConnectionRequestInfo)jmsJcaConnectionRequestInfo)) instanceof JmsJcaSessionImpl) {
                        SICoreConnection sICoreConnection = jmsJcaConnectionRequestInfo.getSICoreConnection();
                        if (sICoreConnection != null) {
                            jmsJcaConnectionImpl = new JmsJcaConnectionImpl(this, sICoreConnection, (JmsJcaSessionImpl)object);
                        }
                        boolean bl2 = bl = sICoreConnection == null;
                        if (!bl) continue;
                        SibTr.info(TRACE, NLS.getFormattedMessage("CONNECTION_ERROR_RETRY_CWSJR1067", new Object[]{((JmsJcaSessionImpl)object).getManagedConnection().getConnectionException()}, null));
                        continue;
                    }
                    throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1061", new Object[]{"createConnection", JmsJcaSessionImpl.class.getName(), object.getClass().getName()}, null));
                } while (bl);
            } else {
                SICoreConnection sICoreConnection = this.createCoreConnection();
                jmsJcaConnectionImpl = new JmsJcaConnectionImpl(this, sICoreConnection);
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + ".createConnection"), (String)FFDC_PROBE_1, (Object)this);
            if (resourceException.getCause() instanceof SIException) {
                throw (SIException)resourceException.getCause();
            }
            if (resourceException.getCause() instanceof SIErrorException) {
                throw (SIErrorException)resourceException.getCause();
            }
            throw resourceException;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "createConnection", jmsJcaConnectionImpl);
        }
        return jmsJcaConnectionImpl;
    }

    public JmsJcaConnection createConnection(String string, String string2) throws ResourceException, SIException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "createConnection", new Object[]{string, "*****"});
        }
        JmsJcaConnectionImpl jmsJcaConnectionImpl = null;
        try {
            if (this._managed) {
                JmsJcaConnectionRequestInfo jmsJcaConnectionRequestInfo = new JmsJcaConnectionRequestInfo(string, string2);
                Object object = null;
                boolean bl = true;
                do {
                    if ((object = this._connectionManager.allocateConnection((ManagedConnectionFactory)this._managedConnectionFactory, (ConnectionRequestInfo)jmsJcaConnectionRequestInfo)) instanceof JmsJcaSessionImpl) {
                        SICoreConnection sICoreConnection = jmsJcaConnectionRequestInfo.getSICoreConnection();
                        if (sICoreConnection != null) {
                            jmsJcaConnectionImpl = new JmsJcaConnectionImpl(this, sICoreConnection, (JmsJcaSessionImpl)object, string, string2);
                        }
                        boolean bl2 = bl = sICoreConnection == null;
                        if (!bl) continue;
                        SibTr.info(TRACE, NLS.getFormattedMessage("CONNECTION_ERROR_RETRY_CWSJR1067", new Object[]{((JmsJcaSessionImpl)object).getManagedConnection().getConnectionException()}, null));
                        continue;
                    }
                    throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1061", new Object[]{"createConnection", JmsJcaSessionImpl.class.getName(), object.getClass().getName()}, null));
                } while (bl);
            } else {
                SICoreConnection sICoreConnection = this.createCoreConnection(string, string2);
                jmsJcaConnectionImpl = new JmsJcaConnectionImpl(this, sICoreConnection, string, string2);
            }
            if (TRACE.isEntryEnabled()) {
                SibTr.exit(this, TRACE, "createConnection", jmsJcaConnectionImpl);
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "createConnection"), (String)FFDC_PROBE_3, (Object)this);
            if (resourceException.getCause() instanceof SIException) {
                throw (SIException)resourceException.getCause();
            }
            if (resourceException.getCause() instanceof SIErrorException) {
                throw (SIErrorException)resourceException.getCause();
            }
            throw resourceException;
        }
        return jmsJcaConnectionImpl;
    }

    SICoreConnection createCoreConnection() throws ResourceException {
        return this.createCoreConnection(this._managedConnectionFactory.getUserName(), this._managedConnectionFactory.getPassword());
    }

    SICoreConnection createCoreConnection(String string, String string2) throws ResourceException {
        SICoreConnection sICoreConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "createCoreConnection", new Object[]{string, "*****"});
        }
        SICoreConnectionFactory sICoreConnectionFactory = null;
        if (!UTEHelperFactory.jmsTestEnvironmentEnabled) {
            try {
                sICoreConnectionFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory(FactoryType.TRM_CONNECTION);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_5, (Object)this);
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1064", new Object[]{sIException, "getSICoreConnectionFactory"}, null), (Throwable)sIException);
            }
        } else {
            sICoreConnectionFactory = UTEHelperFactory.getHelperInstance().setupJmsTestEnvironment();
        }
        if (sICoreConnectionFactory == null) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("SICORECONNECTION_ERROR_CWSJR1066", new Object[]{"createManagedConnection"}, null));
        }
        try {
            Map map = this._managedConnectionFactory.getTrmProperties();
            sICoreConnection = sICoreConnectionFactory.createConnection(string, string2, map);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".createManagedConnection (Subject, ConnectionRequestInfo)"), (String)FFDC_PROBE_6, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, TRACE, sIException);
            }
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1065", new Object[]{sIException, "createManagedConnection"}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".createManagedConnection (Subject, ConnectionRequestInfo)"), (String)FFDC_PROBE_7, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, TRACE, sIErrorException);
            }
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1065", new Object[]{sIErrorException, "createManagedConnection"}, null), (Throwable)sIErrorException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "createCoreConnection", sICoreConnection);
        }
        return sICoreConnection;
    }

    public String getClientID() {
        return this._managedConnectionFactory.getClientID();
    }

    public String getNonPersistentMapping() {
        return this._managedConnectionFactory.getNonPersistentMapping();
    }

    public String getPersistentMapping() {
        return this._managedConnectionFactory.getPersistentMapping();
    }

    public String getDurableSubscriptionHome() {
        return this._managedConnectionFactory.getDurableSubscriptionHome();
    }

    public String getReadAhead() {
        return this._managedConnectionFactory.getReadAhead();
    }

    public String getTemporaryQueueNamePrefix() {
        return this._managedConnectionFactory.getTemporaryQueueNamePrefix();
    }

    public String getTemporaryTopicNamePrefix() {
        return this._managedConnectionFactory.getTemporaryTopicNamePrefix();
    }

    public String getBusName() {
        return this._managedConnectionFactory.getBusName();
    }

    public String getUserName() {
        return this._managedConnectionFactory.getUserName();
    }

    public String getPassword() {
        return this._managedConnectionFactory.getPassword();
    }

    public String getTarget() {
        return this._managedConnectionFactory.getTarget();
    }

    public String getTargetSignificance() {
        return this._managedConnectionFactory.getTargetSignificance();
    }

    public String getTargetType() {
        return this._managedConnectionFactory.getTargetType();
    }

    public String getTargetTransportChain() {
        return this._managedConnectionFactory.getTargetTransportChain();
    }

    public String getProviderEndpoints() {
        return this._managedConnectionFactory.getProviderEndpoints();
    }

    public String getConnectionProximity() {
        return this._managedConnectionFactory.getConnectionProximity();
    }

    public String getShareDurableSubscriptions() {
        return this._managedConnectionFactory.getShareDurableSubscriptions();
    }

    public String getSubscriptionProtocol() {
        return this._managedConnectionFactory.getSubscriptionProtocol();
    }

    public String getMulticastInterface() {
        return this._managedConnectionFactory.getMulticastInterface();
    }

    public boolean isManaged() {
        return this._managed;
    }

    ConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    JmsJcaManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this._managedConnectionFactory;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JmsJcaConnectionFactoryImpl)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        boolean bl = this._managedConnectionFactory != null ? this._managedConnectionFactory.equals(((JmsJcaConnectionFactoryImpl)object).getManagedConnectionFactory()) : ((JmsJcaConnectionFactoryImpl)object).getManagedConnectionFactory() == null;
        return bl;
    }

    public int hashCode() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "hashCode");
        }
        int n = 31;
        n = 17 * n + (this._managed ? 0 : 1);
        n = 17 * n + (this._managedConnectionFactory == null ? 0 : this._managedConnectionFactory.hashCode());
        n = 17 * n + (this._connectionManager == null ? 0 : this._connectionManager.hashCode());
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "hashCode", new Integer(n));
        }
        return n;
    }

    public Reference getReference() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getReference");
        }
        Reference reference = this._managedConnectionFactory.getReference();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getReference", reference);
        }
        return reference;
    }

    public void setReference(Reference reference) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "setReference", reference);
        }
        this._managedConnectionFactory.setReference(reference);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "setReference");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(System.identityHashCode(this));
        stringBuffer.append(" <managedConnectionFactory=");
        stringBuffer.append(this._managedConnectionFactory);
        stringBuffer.append("> <connectionManager=");
        stringBuffer.append(this._connectionManager);
        stringBuffer.append("> <managed=");
        stringBuffer.append(this._managed);
        stringBuffer.append(">]");
        return stringBuffer.toString();
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug(TRACE, "Source info: @(#)SIB/ws/code/sib.api.jmsra.outbound.impl/src/com/ibm/ws/sib/api/jmsra/impl/JmsJcaConnectionFactoryImpl.java, SIB.api.jmsra, WAS602.SIB, o0610.11 1.64.1.1");
        }
    }
}

