/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicImpl;
import com.ibm.ws.sib.api.jms.impl.MsgDestEncodingUtilsImpl;
import com.ibm.ws.sib.utils.TopicWildcardTranslation;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jms.Destination;
import javax.jms.JMSException;

public class URIDestinationCreator
implements JmsInternalConstants {
    private static TraceComponent tcInt = SibTr.register(URIDestinationCreator.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    public static final int QM_ERROR = 0;
    public static final int QM_DISCARD = 1;
    public static final int QM_TRANSFORM = 2;
    public static final String DEST_TYPE_QUEUE = "QUEUE";
    public static final String DEST_TYPE_TOPIC = "TOPIC";
    public static final String QUEUE_NAME = "queueName";
    public static final String TOPIC_NAME = "topicName";
    public static final String TOPIC_SPACE = "topicSpace";
    public static final String REVERSE_RP = "reverseRP";
    public static final String FORWARD_RP = "forwardRP";
    private static final String TOPIC_PREFIX = "topic://";
    private static final String QUEUE_PREFIX = "queue://";
    private static final String DEST_PREFIX = "dest://";
    private static final String STRING_AMPERSAND = "&";
    private static final String STRING_SLASH = "/";
    private static final String STRING_BACKSLASH = "\\";
    private static final String STRING_EQUALS_SIGN = "=";
    private static final char CHAR_BACKSLASH = '\\';
    private static final String MA88_EXPIRY = "expiry";
    private static final String MA88_PERSISTENCE = "persistence";
    private static final String MA88_BROKER_VERSION = "brokerVersion";
    private MsgDestEncodingUtilsImpl destEncoder;
    private TopicWildcardTranslation twt;
    private Pattern pSplitNonEscapedQMark;
    private Pattern pSplitNonEscapedSlash;
    private Pattern pSplitNonEscapedAmpersand;
    private Pattern pSplitNonEscapedColon;
    private Pattern pMatchSlash;

    public URIDestinationCreator() {
        block3: {
            this.destEncoder = null;
            this.twt = null;
            this.pSplitNonEscapedQMark = Pattern.compile("(?<!\\\\)\\?");
            this.pSplitNonEscapedSlash = Pattern.compile("(?<!\\\\)/");
            this.pSplitNonEscapedAmpersand = Pattern.compile("(?<!\\\\)&");
            this.pSplitNonEscapedColon = Pattern.compile("(?<!\\\\):");
            this.pMatchSlash = Pattern.compile(".*(?<!\\\\)/.*");
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "@(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/URIDestinationCreator.java, SIB.api.jms, WAS602.SIB, o0610.11 1.32");
            }
            try {
                this.destEncoder = (MsgDestEncodingUtilsImpl)JmsInternalsFactory.getMessageDestEncodingUtils();
                this.twt = TopicWildcardTranslation.getInstance();
            }
            catch (Exception exception) {
                if (!tcInt.isDebugEnabled()) break block3;
                SibTr.debug(tcInt, "Exception caught creating MsgDestEncodingUtilsImpl");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String extractPropertyFromURI(String string, String string2) {
        String string3;
        String string4;
        String string5;
        block16: {
            String[] stringArray;
            block15: {
                block14: {
                    block13: {
                        string5 = null;
                        if (tcInt.isEntryEnabled()) {
                            SibTr.entry(tcInt, "extractPropertyFromURI");
                        }
                        if (string2 != null) break block13;
                        String string6 = null;
                        Object var11_7 = null;
                        if (tcInt.isEntryEnabled()) {
                            SibTr.exit(tcInt, "extractPropertyFromURI");
                        }
                        return string6;
                    }
                    string2 = string2.trim();
                    if (!string2.equals("")) break block14;
                    String string7 = null;
                    Object var11_8 = null;
                    if (tcInt.isEntryEnabled()) {
                        SibTr.exit(tcInt, "extractPropertyFromURI");
                    }
                    return string7;
                }
                stringArray = this.pSplitNonEscapedQMark.split(string2, 2);
                if (stringArray.length >= 2) break block15;
                String string8 = null;
                Object var11_9 = null;
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "extractPropertyFromURI");
                }
                return string8;
            }
            string4 = stringArray[1].trim();
            if (!string4.equals("")) break block16;
            String string9 = null;
            Object var11_10 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "extractPropertyFromURI");
            }
            return string9;
        }
        try {
            String[] stringArray = this.pSplitNonEscapedAmpersand.split(string4);
            String string10 = string + STRING_EQUALS_SIGN;
            for (int i = 0; i < stringArray.length; ++i) {
                String string11 = stringArray[i];
                if (!string11.startsWith(string10)) continue;
                string5 = string11.substring(string10.length());
                break;
            }
            string3 = string5;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            block17: {
                Object var11_12 = null;
                if (!tcInt.isEntryEnabled()) break block17;
                SibTr.exit(tcInt, "extractPropertyFromURI");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "extractPropertyFromURI");
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination createDestinationFromString(String string, String string2) throws JMSException {
        JmsDestination jmsDestination;
        JmsDestination jmsDestination2 = null;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "createDestFromURI");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "URI: " + string);
            SibTr.debug(tcInt, "destType: " + string2);
        }
        try {
            if (string.startsWith(DEST_PREFIX)) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "RESERVED_DEST_PREFIX_CWSIA0383", new Object[]{DEST_PREFIX, string}, tcInt);
            }
            if (string.startsWith(QUEUE_PREFIX) || string.startsWith(TOPIC_PREFIX)) {
                jmsDestination2 = this.processURI(string, 0, null);
            } else if (string2 == DEST_TYPE_QUEUE) {
                jmsDestination = new JmsQueueImpl();
                ((JmsQueueImpl)jmsDestination).setQueueName(string);
                jmsDestination2 = jmsDestination;
            } else {
                jmsDestination2 = this.processShortTopicForm(string);
            }
            jmsDestination = jmsDestination2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var6_6 = null;
                if (!tcInt.isEntryEnabled()) break block10;
                SibTr.exit(tcInt, "createDestFromURI");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "createDestFromURI");
        }
        return jmsDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JmsTopicImpl processShortTopicForm(String string) throws JMSException {
        JmsTopicImpl jmsTopicImpl;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "processShortTopicForm");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string);
        }
        try {
            String string2;
            String string3;
            String[] stringArray = this.pSplitNonEscapedColon.split(string, 2);
            stringArray[0] = this.unescape(stringArray[0], ':');
            if (stringArray.length > 1) {
                stringArray[1] = this.unescape(stringArray[1], ':');
            }
            stringArray[0] = this.unescapeBackslash(stringArray[0]);
            if (stringArray.length == 1) {
                string3 = stringArray[0];
                string2 = null;
            } else {
                string2 = stringArray[0];
                string3 = stringArray[1];
            }
            JmsTopicImpl jmsTopicImpl2 = new JmsTopicImpl();
            jmsTopicImpl2.setTopicName(string3);
            if (string2 != null) {
                jmsTopicImpl2.setTopicSpace(string2);
            }
            jmsTopicImpl = jmsTopicImpl2;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object var8_8 = null;
                if (!tcInt.isEntryEnabled()) break block9;
                SibTr.exit(tcInt, "processShortTopicForm");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "processShortTopicForm");
        }
        return jmsTopicImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsDestination processURI(String string, int n, Map map) throws JMSException {
        Object object;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "processURI");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string + "," + n);
        }
        try {
            boolean bl;
            JmsDestinationImpl jmsDestinationImpl;
            if (string.startsWith(TOPIC_PREFIX)) {
                jmsDestinationImpl = new JmsTopicImpl();
                bl = false;
            } else if (string.startsWith(QUEUE_PREFIX)) {
                jmsDestinationImpl = new JmsQueueImpl();
                bl = true;
            } else {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0386", null, tcInt);
            }
            String string2 = string.substring(8, string.length());
            String[] stringArray = this.pSplitNonEscapedQMark.split(string2, 2);
            String string3 = stringArray[0];
            String string4 = null;
            if (stringArray.length > 1) {
                string4 = stringArray[1].trim();
            }
            if (bl) {
                stringArray = this.pSplitNonEscapedSlash.split(string3, 2);
                object = null;
                String string5 = null;
                if (stringArray.length > 1) {
                    object = stringArray[0];
                    string5 = stringArray[1];
                    if (((String)object).trim().equals("")) {
                        object = null;
                    }
                } else {
                    string5 = stringArray[0];
                }
                string3 = string5;
                switch (n) {
                    case 2: {
                        if (object == null) break;
                        string3 = string3 + "@" + (String)object;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        if (object == null) break;
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_URI_ELEMENT_CWSIA0385", new Object[]{string}, tcInt);
                    }
                    default: {
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "Unknown value for qmProcessing: " + n);
                        }
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0386", null, tcInt);
                    }
                }
                string3 = this.unescape(string3, '/');
            }
            string3 = this.unescape(string3, '?');
            string3 = this.unescapeBackslash(string3);
            if (bl) {
                ((JmsQueueImpl)jmsDestinationImpl).setQueueName(string3);
            } else {
                ((JmsTopicImpl)jmsDestinationImpl).setTopicName(string3);
            }
            this.processNVPs(string4, jmsDestinationImpl, map);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Returned Destination = " + ((Object)jmsDestinationImpl).toString());
            }
            object = jmsDestinationImpl;
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            block23: {
                Object var13_13 = null;
                if (!tcInt.isEntryEnabled()) break block23;
                SibTr.exit(tcInt, "processQueueURI");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "processQueueURI");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNVPs(String string, JmsDestination jmsDestination, Map map) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "processNVPs");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string + "," + jmsDestination);
        }
        try {
            Object object;
            Map<String, String> map2;
            if (map == null) {
                map2 = new HashMap();
            } else {
                map.clear();
                map2 = map;
            }
            if (string != null && !string.equals("")) {
                object = this.pSplitNonEscapedAmpersand.split(string);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String[] stringArray;
                    String string2 = object[i];
                    int n = string2.indexOf(STRING_EQUALS_SIGN);
                    if (n == -1) {
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MALFORMED_URI_ELEMENT_CWSIA0382", new Object[]{string2, string}, tcInt);
                    }
                    if (n == string2.length() - 1) {
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MALFORMED_URI_ELEMENT_CWSIA0382", new Object[]{string2, string}, tcInt);
                    }
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    String[] stringArray2 = this.validateNVP(string3, string4, string, jmsDestination);
                    string3 = stringArray2[0];
                    string4 = stringArray2[1];
                    if (string3.equals(FORWARD_RP)) {
                        stringArray = string4.split("<#>");
                        ((JmsDestinationImpl)jmsDestination).setForwardRoutingPath(stringArray);
                        continue;
                    }
                    if (string3.equals(REVERSE_RP)) {
                        stringArray = string4.split("<#>");
                        ((JmsDestinationImpl)jmsDestination).setReverseRoutingPath(stringArray);
                        continue;
                    }
                    map2.put(string3, string4);
                }
            }
            if (jmsDestination instanceof JmsTopic && map2.containsKey(MA88_BROKER_VERSION) && (object = ((JmsTopicImpl)jmsDestination).getTopicName()) != null) {
                String string5 = (String)map2.remove(MA88_BROKER_VERSION);
                if ("1".equals(string5)) {
                    try {
                        object = this.twt.convertEventBrokerToSIB((String)object);
                    }
                    catch (ParseException parseException) {
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MALFORMED_URI_ELEMENT_CWSIA0382", new Object[]{object, string}, parseException, "URIDestinationCreator.processNVPs#1", this, tcInt);
                    }
                }
                try {
                    object = this.twt.convertMA0CToSIB((String)object);
                }
                catch (ParseException parseException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MALFORMED_URI_ELEMENT_CWSIA0382", new Object[]{object, string}, parseException, null, null, tcInt);
                }
                ((JmsTopicImpl)jmsDestination).setTopicName((String)object);
            }
            this.configureDestinationFromMap(jmsDestination, map2, string);
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "processNVPs");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "processNVPs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String unescape(String string, char c) {
        String string2;
        block9: {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "unescape");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "params: " + string + ", " + c);
            }
            if (string.indexOf(c) != -1) break block9;
            String string3 = string;
            Object var8_5 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "unescape");
            }
            return string3;
        }
        try {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(string);
            String string4 = new String(new char[]{c});
            while ((n = stringBuffer.indexOf(string4, n)) != -1) {
                if (n > 0 && stringBuffer.charAt(n - 1) == '\\') {
                    stringBuffer.deleteCharAt(n - 1);
                    continue;
                }
                ++n;
            }
            string2 = stringBuffer.toString();
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var8_7 = null;
                if (!tcInt.isEntryEnabled()) break block10;
                SibTr.exit(tcInt, "unescape");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "unescape");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String unescapeBackslash(String string) throws JMSException {
        String string2;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "unescapeBackslash");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string);
        }
        try {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(string);
            while ((n = stringBuffer.indexOf(STRING_BACKSLASH, n)) != -1) {
                if (n + 1 < stringBuffer.length() && stringBuffer.charAt(n + 1) == '\\') {
                    stringBuffer.deleteCharAt(n);
                    ++n;
                    continue;
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BAD_ESCAPE_CHAR_CWSIA0387", new Object[]{string}, tcInt);
            }
            string2 = stringBuffer.toString();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var6_6 = null;
                if (!tcInt.isEntryEnabled()) break block7;
                SibTr.exit(tcInt, "unescapeBackslash");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "unescapeBackslash");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] validateNVP(String string, String string2, String string3, JmsDestination jmsDestination) throws JMSException {
        String[] stringArray;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "validateNVP");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string + ", " + string2 + ", " + string3 + ", " + jmsDestination);
        }
        try {
            if (string2.indexOf(38) != -1) {
                string2 = string2.replaceAll("\\\\&", STRING_AMPERSAND);
            }
            string2 = this.unescapeBackslash(string2);
            if (string.equalsIgnoreCase(MA88_EXPIRY)) {
                string = "timeToLive";
            }
            if (string.equalsIgnoreCase(MA88_PERSISTENCE)) {
                string = "deliveryMode";
                string2 = string2.equals("1") ? "NonPersistent" : (string2.equals("2") ? "Persistent" : "Application");
            }
            String[] stringArray2 = new String[]{string, string2};
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "ret namePart=" + string + ", valuePart=" + string2);
            }
            stringArray = stringArray2;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object var8_8 = null;
                if (!tcInt.isEntryEnabled()) break block9;
                SibTr.exit(tcInt, "validateNVP");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "validateNVP");
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureDestinationFromMap(JmsDestination jmsDestination, Map map, String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "configureDestinationFromMap");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + jmsDestination + ", " + map + ", " + string);
        }
        try {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)map.get(string2);
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "name " + string2 + ", value " + string3);
                }
                boolean bl = true;
                Class clazz = this.destEncoder.getPropertyType(string2);
                if (clazz == null) {
                    bl = false;
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Ignoring invalid property " + string2 + " from URI: " + string);
                    }
                }
                if (!bl) continue;
                try {
                    Object object = null;
                    if (string3 != null) {
                        String string4 = this.destEncoder.getDefaultValueEncoding(string2, string3);
                        object = this.destEncoder.getDefaultValueDecoding(string2, string4);
                    }
                    if (string2.equals(TOPIC_NAME)) {
                        if (jmsDestination instanceof JmsTopicImpl) {
                            ((JmsTopicImpl)jmsDestination).setTopicName((String)object);
                            continue;
                        }
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0386", null, tcInt);
                    }
                    this.destEncoder.setDestinationProperty(jmsDestination, string2, object);
                }
                catch (NumberFormatException numberFormatException) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.exception(tcInt, numberFormatException);
                    }
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_URI_ELEMENT_CWSIA0384", new Object[]{string2, string3, string}, numberFormatException, null, null, tcInt);
                }
                catch (JMSException jMSException) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.exception(tcInt, (Exception)((Object)jMSException));
                    }
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_URI_ELEMENT_CWSIA0384", new Object[]{string2, string3, string}, tcInt);
                }
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "configureDestinationFromMap");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "configureDestinationFromMap");
        }
    }

    public static String escapeValueString(String string) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "escapeValueString");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string);
        }
        if (string != null) {
            int n;
            int n2;
            int n3 = 0;
            while ((n3 = string.indexOf(92, n3)) != -1) {
                n2 = 65535;
                if (n3 + 1 < string.length()) {
                    n2 = string.charAt(n3 + 1);
                }
                if (n2 != 92) {
                    string = string.substring(0, n3) + STRING_BACKSLASH + string.substring(n3);
                }
                n3 += 2;
            }
            n2 = 0;
            while ((n = string.indexOf(STRING_AMPERSAND, n2)) != -1) {
                int n4 = n;
                int n5 = 65535;
                if (n > 0) {
                    n5 = string.charAt(n - 1);
                }
                if (n5 != 92) {
                    string = string.substring(0, n4) + STRING_BACKSLASH + string.substring(n4);
                }
                n2 = n4 + 1;
            }
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "ret " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "escapeValueString");
        }
        return string;
    }

    public static String escapeDestName(String string) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "escapeDestName");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string);
        }
        if (string != null) {
            int n = 0;
            while ((n = string.indexOf(92, n)) != -1) {
                int n2 = 65535;
                if (n + 1 < string.length()) {
                    n2 = string.charAt(n + 1);
                }
                if (n2 != 92) {
                    string = string.substring(0, n) + STRING_BACKSLASH + string.substring(n);
                }
                n += 2;
            }
            n = 0;
            while ((n = string.indexOf(63, n)) != -1) {
                if (!URIDestinationCreator.charIsEscaped(string, n)) {
                    string = string.substring(0, n) + STRING_BACKSLASH + string.substring(n);
                }
                ++n;
            }
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "ret: " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "escapeDestName");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination createDestinationFromURI(String string, int n) throws JMSException {
        JmsDestination jmsDestination;
        JmsDestination jmsDestination2 = null;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "createDestinationFromURI");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string + ", " + n);
        }
        try {
            if (string != null) {
                jmsDestination2 = this.processURI(string, n, null);
            }
            jmsDestination = jmsDestination2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                if (!tcInt.isEntryEnabled()) break block6;
                SibTr.exit(tcInt, "createDestinationFromURI");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "createDestinationFromURI");
        }
        return jmsDestination;
    }

    private static boolean charIsEscaped(String string, int n) {
        boolean bl;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "charIsEscaped");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string + ", " + n);
        }
        if (string == null || n < 0 || n >= string.length()) {
            return false;
        }
        int n2 = 0;
        for (int i = n - 1; i >= 0 && string.charAt(i) == '\\'; --i) {
            ++n2;
        }
        boolean bl2 = bl = n2 % 2 == 1;
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "ret: " + bl);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "charIsEscaped");
        }
        return bl;
    }
}

