/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.JmsSharedUtils;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import javax.jms.JMSException;

public class ReportMessageConverter {
    private static JmsSharedUtils utils = null;
    private static TraceComponent tc = Tr.register((Class)JmsMessageImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    public static final byte byte_REPORT_NO_DATA = SIApiConstants.REPORT_NO_DATA;
    public static final byte byte_REPORT_WITH_DATA = SIApiConstants.REPORT_WITH_DATA;
    public static final byte byte_REPORT_WITH_FULL_DATA = SIApiConstants.REPORT_WITH_FULL_DATA;
    public static final byte byte_REPORT_EXPIRY = SIApiConstants.REPORT_EXPIRY.byteValue();
    public static final byte byte_REPORT_EXCEPTION = SIApiConstants.REPORT_EXCEPTION.byteValue();
    public static final byte byte_REPORT_COA = SIApiConstants.REPORT_COA.byteValue();
    public static final byte byte_REPORT_COD = SIApiConstants.REPORT_COD.byteValue();
    public static final byte byte_REPORT_PAN = SIApiConstants.REPORT_PAN.byteValue();
    public static final byte byte_REPORT_NAN = SIApiConstants.REPORT_NAN.byteValue();

    public static void setIntegerReportOption(String string, int n, SIBusMessage sIBusMessage) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setIntegerReportOption");
        }
        if (string.equals("JMS_IBM_Report_Exception")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_EXCEPTION_PROPERTY");
            }
            Byte by = null;
            switch (n) {
                case 0x1000000: {
                    by = SIApiConstants.REPORT_NO_DATA;
                    break;
                }
                case 0x3000000: {
                    by = SIApiConstants.REPORT_WITH_DATA;
                    break;
                }
                case 0x7000000: {
                    by = SIApiConstants.REPORT_WITH_FULL_DATA;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{string, "" + n}, tc);
                }
            }
            sIBusMessage.setReportException(by);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "REPORT_EXCEPTION set to : " + by);
            }
        } else if (string.equals("JMS_IBM_Report_Expiration")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_EXPIRATION_PROPERTY");
            }
            Byte by = null;
            switch (n) {
                case 0x200000: {
                    by = SIApiConstants.REPORT_NO_DATA;
                    break;
                }
                case 0x600000: {
                    by = SIApiConstants.REPORT_WITH_DATA;
                    break;
                }
                case 0xE00000: {
                    by = SIApiConstants.REPORT_WITH_FULL_DATA;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{string, "" + n}, tc);
                }
            }
            sIBusMessage.setReportExpiry(by);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "REPORT_EXPIRATION set to : " + by);
            }
        } else if (string.equals("JMS_IBM_Report_COA")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_COA_PROPERTY");
            }
            Byte by = null;
            switch (n) {
                case 256: {
                    by = SIApiConstants.REPORT_NO_DATA;
                    break;
                }
                case 768: {
                    by = SIApiConstants.REPORT_WITH_DATA;
                    break;
                }
                case 1792: {
                    by = SIApiConstants.REPORT_WITH_FULL_DATA;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{string, "" + n}, tc);
                }
            }
            sIBusMessage.setReportCOA(by);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "REPORT_COA set to : " + by);
            }
        } else if (string.equals("JMS_IBM_Report_COD")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_COD_PROPERTY");
            }
            Byte by = null;
            switch (n) {
                case 2048: {
                    by = SIApiConstants.REPORT_NO_DATA;
                    break;
                }
                case 6144: {
                    by = SIApiConstants.REPORT_WITH_DATA;
                    break;
                }
                case 14336: {
                    by = SIApiConstants.REPORT_WITH_FULL_DATA;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{string, "" + n}, tc);
                }
            }
            sIBusMessage.setReportCOD(by);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "REPORT_COD set to : " + by);
            }
        } else if (string.equals("JMS_IBM_Report_PAN")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_PAN_PROPERTY");
            }
            Boolean bl = null;
            switch (n) {
                case 1: {
                    bl = new Boolean(true);
                    break;
                }
                case 0: {
                    bl = new Boolean(false);
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{string, "" + n}, tc);
                }
            }
            sIBusMessage.setReportPAN(bl);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "REPORT_PAN set to : " + bl);
            }
        } else if (string.equals("JMS_IBM_Report_NAN")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_NAN_PROPERTY");
            }
            Boolean bl = null;
            switch (n) {
                case 2: {
                    bl = new Boolean(true);
                    break;
                }
                case 0: {
                    bl = new Boolean(false);
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{string, "" + n}, tc);
                }
            }
            sIBusMessage.setReportNAN(bl);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "REPORT_NAN set to : " + bl);
            }
        } else if (string.equals("JMS_IBM_Report_Pass_Msg_ID")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_MSGID_PROPERTY");
            }
            Boolean bl = null;
            switch (n) {
                case 128: {
                    bl = new Boolean(true);
                    break;
                }
                case 0: {
                    bl = new Boolean(false);
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{string, "" + n}, tc);
                }
            }
            sIBusMessage.setReportPassMsgId(bl);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "REPORT_MSGID set to : " + bl);
            }
        } else if (string.equals("JMS_IBM_Report_Pass_Correl_ID")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_CORRELID_PROPERTY");
            }
            Boolean bl = null;
            switch (n) {
                case 64: {
                    bl = new Boolean(true);
                    break;
                }
                case 0: {
                    bl = new Boolean(false);
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{string, "" + n}, tc);
                }
            }
            sIBusMessage.setReportPassCorrelId(bl);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "REPORT_CORRELID set to : " + bl);
            }
        } else if (string.equals("JMS_IBM_Report_Discard_Msg")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_DISCARD_PROPERTY");
            }
            Boolean bl = null;
            switch (n) {
                case 0x8000000: {
                    bl = new Boolean(true);
                    break;
                }
                case 0: {
                    bl = new Boolean(false);
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{string, "" + n}, tc);
                }
            }
            sIBusMessage.setReportDiscardMsg(bl);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "REPORT_DISCARD set to : " + bl);
            }
        } else if (string.equals("JMS_IBM_Feedback")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals FEEDBACK_PROPERTY");
            }
            if (utils == null) {
                utils = JmsInternalsFactory.getSharedUtils();
            }
            Integer n2 = utils.convertMQFeedbackToJS(n);
            sIBusMessage.setReportFeedback(n2);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "FEEDBACK_PROPERTY set to : " + n2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setIntegerReportOption");
        }
    }

    public static Object getReportOption(String string, SIBusMessage sIBusMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getReportOption");
        }
        Integer n = null;
        if (string.equals("JMS_IBM_Report_Exception")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_EXCEPTION_PROPERTY");
            }
            Byte by = sIBusMessage.getReportException();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Byte returned from core message getReportException():" + by);
            }
            if (by != null) {
                byte by2 = by;
                if (by2 == byte_REPORT_NO_DATA) {
                    n = new Integer(0x1000000);
                } else if (by2 == byte_REPORT_WITH_DATA) {
                    n = new Integer(0x3000000);
                } else if (by2 == byte_REPORT_WITH_FULL_DATA) {
                    n = new Integer(0x7000000);
                } else {
                    if (tc.isEntryEnabled()) {
                        SibTr.debug(tc, "Unexpected property value received: " + by);
                    }
                    n = null;
                }
            }
        } else if (string.equals("JMS_IBM_Report_Expiration")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_EXPIRATION_PROPERTY");
            }
            Byte by = sIBusMessage.getReportExpiry();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Byte returned from core message getReportExpiry():" + by);
            }
            if (by != null) {
                byte by3 = by;
                if (by3 == byte_REPORT_NO_DATA) {
                    n = new Integer(0x200000);
                } else if (by3 == byte_REPORT_WITH_DATA) {
                    n = new Integer(0x600000);
                } else if (by3 == byte_REPORT_WITH_FULL_DATA) {
                    n = new Integer(0xE00000);
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Unexpected property value received: " + by);
                    }
                    n = null;
                }
            }
        } else if (string.equals("JMS_IBM_Report_COA")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_COA_PROPERTY");
            }
            Byte by = sIBusMessage.getReportCOA();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Byte returned from core message getReportCOA():" + by);
            }
            if (by != null) {
                byte by4 = by;
                if (by4 == byte_REPORT_NO_DATA) {
                    n = new Integer(256);
                } else if (by4 == byte_REPORT_WITH_DATA) {
                    n = new Integer(768);
                } else if (by4 == byte_REPORT_WITH_FULL_DATA) {
                    n = new Integer(1792);
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Unexpected property value received: " + by);
                    }
                    n = null;
                }
            }
        } else if (string.equals("JMS_IBM_Report_COD")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_COD_PROPERTY");
            }
            Byte by = sIBusMessage.getReportCOD();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Byte returned from core message getReportCOD():" + by);
            }
            if (by != null) {
                byte by5 = by;
                if (by5 == byte_REPORT_NO_DATA) {
                    n = new Integer(2048);
                } else if (by5 == byte_REPORT_WITH_DATA) {
                    n = new Integer(6144);
                } else if (by5 == byte_REPORT_WITH_FULL_DATA) {
                    n = new Integer(14336);
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Unexpected property value received: " + by);
                    }
                    n = null;
                }
            }
        } else if (string.equals("JMS_IBM_Report_PAN")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_PAN_PROPERTY");
            }
            Boolean bl = sIBusMessage.getReportPAN();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Boolean returned from core message getReportPAN():" + bl);
            }
            if (bl != null) {
                boolean bl2 = bl;
                n = bl2 ? new Integer(1) : new Integer(0);
            }
        } else if (string.equals("JMS_IBM_Report_NAN")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_NAN_PROPERTY");
            }
            Boolean bl = sIBusMessage.getReportNAN();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Boolean returned from core message getReportNAN():" + bl);
            }
            if (bl != null) {
                boolean bl3 = bl;
                n = bl3 ? new Integer(2) : new Integer(0);
            }
        } else if (string.equals("JMS_IBM_Report_Pass_Msg_ID")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_MSGID_PROPERTY");
            }
            Boolean bl = sIBusMessage.getReportPassMsgId();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Boolean returned from core message getReportPassMsgId():" + bl);
            }
            if (bl != null) {
                boolean bl4 = bl;
                n = bl4 ? new Integer(128) : new Integer(0);
            }
        } else if (string.equals("JMS_IBM_Report_Pass_Correl_ID")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_CORRELID_PROPERTY");
            }
            Boolean bl = sIBusMessage.getReportPassCorrelId();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Boolean returned from core message getReportPassCorrelId():" + bl);
            }
            if (bl != null) {
                boolean bl5 = bl;
                n = bl5 ? new Integer(64) : new Integer(0);
            }
        } else if (string.equals("JMS_IBM_Report_Discard_Msg")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals REPORT_DISCARD_PROPERTY");
            }
            Boolean bl = sIBusMessage.getReportDiscardMsg();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Boolean returned from core message getReportDiscardMsg():" + bl);
            }
            if (bl != null) {
                boolean bl6 = bl;
                n = bl6 ? new Integer(0x8000000) : new Integer(0);
            }
        } else if (string.equals("JMS_IBM_Feedback")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals FEEDBACK_PROPERTY");
            }
            Integer n2 = sIBusMessage.getReportFeedback();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Byte returned from core message getReportFeedback():" + n2);
            }
            if (n2 != null) {
                if (utils == null) {
                    try {
                        utils = JmsInternalsFactory.getSharedUtils();
                    }
                    catch (JMSException jMSException) {
                        JmsErrorUtils.processThrowable(jMSException, "ReportMessageConverter.getReportOption#1", null, tc);
                        return null;
                    }
                }
                n = utils.convertJSFeedbackToMQ((int)n2);
            }
        } else if (string.equals("JMS_IBM_MsgType")) {
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "propName equals MSG_TYPE_PROPERTY");
            }
            Integer n3 = sIBusMessage.getReportFeedback();
            if (tc.isEntryEnabled()) {
                SibTr.debug(tc, "Value returned from core message getReportFeedback():" + n3);
            }
            if (n3 != null) {
                int n4 = n3;
                if (n4 != 0) {
                    n = new Integer(4);
                } else {
                    if (tc.isEntryEnabled()) {
                        SibTr.debug(tc, "byte returned from getReportFeedback() is not one of the expected values");
                    }
                    n = null;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Returned Integer set to : " + n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getReportOption");
        }
        return n;
    }
}

