/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.ws.sib.api.jms.MessageDestEncodingUtils;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Topic;

public class MsgDestEncodingUtilsImpl
implements MessageDestEncodingUtils {
    private static TraceComponent tcInt = SibTr.register(MsgDestEncodingUtilsImpl.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static final String DEFAULT_ENCODING_PREFIX = "*";
    private static final byte[] DEFAULT_ENCODING_BYTES;
    private static final Object[] ANY_STRING;
    private static final byte QUEUE_TYPE = 0;
    private static final byte TOPIC_TYPE = 16;
    private static final byte DM_NOT_SET = 0;
    private static final byte DM_PERSISTENT = 1;
    private static final byte DM_NON_PERSISTENT = 2;
    private static final byte PRIORITY_NOT_SET = -16;
    private static final byte TTL_NOT_SET = 0;
    private static final byte TTL_SET = 1;
    private static final String ENCODING = "UTF-8";
    private BiDirectionalMapping propertyNames = null;
    private Map propertyValues = null;
    private Map propertyTypes = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgDestEncodingUtilsImpl() throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "MsgDestEncodingUtilsImpl.<init>");
            }
            this.loadAndValidate();
            try {
                "test".getBytes(ENCODING);
            }
            catch (Exception exception) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Unable to execute getBytes(UTF-8)");
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_ENCODING_CWSIA0360", new Object[]{ENCODING}, exception, "MsgDestEncodingUtilsImpl.<init>#1", this, tcInt);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "MsgDestEncodingUtilsImpl.<init>");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "MsgDestEncodingUtilsImpl.<init>");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getMessageRepresentationFromDest(JmsDestination jmsDestination, boolean bl) throws JMSException {
        byte[] byArray;
        try {
            try {
                int n;
                Object object;
                Object object2;
                Object object3;
                if (tcInt.isEntryEnabled()) {
                    SibTr.entry(tcInt, "getMessageRepresentationFromDest");
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "dest: " + jmsDestination);
                    SibTr.debug(tcInt, "fullEncode: " + bl);
                }
                if (jmsDestination == null) {
                    JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_INVALID_VALUE_CWSIA0361", new Object[]{"null", "JmsDestination"}, tcInt);
                    JmsErrorUtils.processThrowable(jMSException, "MsgDestEncodingUtilsImpl.getMessageRepresentationFromDest#1", this, tcInt);
                    throw jMSException;
                }
                byte[] byArray2 = null;
                Map map = ((JmsDestinationImpl)jmsDestination).getCopyOfProperties();
                map.remove("forwardRP");
                map.remove("reverseRP");
                if (!bl) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Removing reply header properties from list");
                    }
                    map.remove("DEST_NAME");
                    map.remove("DEST_DISCRIM");
                    map.remove("priority");
                    map.remove("timeToLive");
                    map.remove("busName");
                }
                Vector<byte[]> vector = new Vector<byte[]>();
                boolean bl2 = jmsDestination instanceof Topic;
                byte[] byArray3 = this.getEncodedBasicInfo(map, bl2);
                vector.add(byArray3);
                if (bl2) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Renaming topic specific properties");
                    }
                    if ((object3 = map.remove("DEST_NAME")) != null) {
                        map.put("topicSpace", object3);
                    }
                    if ((object2 = map.remove("DEST_DISCRIM")) != null) {
                        map.put("topicName", object2);
                    }
                } else {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Renaming queue specific properties");
                    }
                    if ((object3 = map.remove("DEST_NAME")) != null) {
                        map.put("queueName", object3);
                    }
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Properties for encoding: " + map);
                }
                object3 = map.keySet().iterator();
                while (object3.hasNext()) {
                    byte[] byArray4;
                    int n2;
                    byte[] byArray5;
                    object2 = (String)object3.next();
                    Object v = map.get(object2);
                    Object object4 = this.getDefaultPropertyValue((String)object2);
                    if (object4 == null && object4 == v || object4 != null && object4.equals(v)) {
                        if (!tcInt.isDebugEnabled()) continue;
                        SibTr.debug(tcInt, "The default property value was supplied for " + object2);
                        continue;
                    }
                    object = this.getShortPropertyName((String)object2);
                    String string = this.getShortPropertyValue((String)object2, v);
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, " shortName for " + object2 + " is: " + (String)object);
                        SibTr.debug(tcInt, "shortValue for " + object2 + " is: " + string);
                    }
                    if (object != object2) {
                        vector.add(((String)object).getBytes(ENCODING));
                    } else {
                        vector.add(DEFAULT_ENCODING_BYTES);
                        byArray5 = ((String)object).getBytes(ENCODING);
                        n2 = byArray5.length;
                        byArray4 = this.convertIntToBytes(n2);
                        vector.add(byArray4);
                        vector.add(byArray5);
                    }
                    byArray5 = string.getBytes(ENCODING);
                    n2 = byArray5.length;
                    byArray4 = this.convertIntToBytes(n2);
                    vector.add(byArray4);
                    vector.add(byArray5);
                }
                int n3 = 0;
                for (n = 0; n < vector.size(); n3 += ((byte[])vector.elementAt(n)).length, ++n) {
                }
                byArray2 = new byte[n3];
                n = 0;
                for (int i = 0; i < vector.size(); ++i) {
                    object = (byte[])vector.elementAt(i);
                    for (int j = 0; j < ((Object)object).length; ++j) {
                        byArray2[n++] = (byte)object[j];
                    }
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Returning the following bytes");
                    SibTr.bytes(tcInt, byArray2);
                }
                byArray = byArray2;
                Object var18_25 = null;
            }
            catch (JMSException jMSException) {
                if (!tcInt.isDebugEnabled()) throw jMSException;
                SibTr.debug(tcInt, "passing on exception: ", (Object)jMSException);
                throw jMSException;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_ENCODING_CWSIA0360", new Object[]{ENCODING}, unsupportedEncodingException, "MsgDestEncodingUtilsImpl.getMessageRepresentationFromDest#2", this, tcInt);
            }
        }
        catch (Throwable throwable) {
            Object var18_26 = null;
            if (!tcInt.isEntryEnabled()) throw throwable;
            SibTr.exit(tcInt, "getMessageRepresentationFromDest");
            throw throwable;
        }
        if (!tcInt.isEntryEnabled()) return byArray;
        SibTr.exit(tcInt, "getMessageRepresentationFromDest");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsDestination getDestinationFromMsgRepresentation(byte[] byArray) throws JMSException {
        JmsDestinationImpl jmsDestinationImpl;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "getDestinationFromMsgRepresentation");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "parameter bytes:");
                SibTr.bytes(tcInt, byArray);
            }
            if (byArray == null) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_INVALID_VALUE_CWSIA0361", new Object[]{"null", "getDestinationFromMsgRepresentation(byte[])"}, tcInt);
            }
            JmsDestinationImpl jmsDestinationImpl2 = null;
            if ((byArray[0] & 0xF0) == 0) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Queue type destination found");
                }
                jmsDestinationImpl2 = new JmsQueueImpl();
            } else {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Topic type destination found");
                }
                jmsDestinationImpl2 = new JmsTopicImpl();
            }
            this.decodeDestProperties(byArray, jmsDestinationImpl2);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "returns: " + jmsDestinationImpl2);
            }
            jmsDestinationImpl = jmsDestinationImpl2;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block11: {
                Object var5_5 = null;
                if (!tcInt.isEntryEnabled()) break block11;
                SibTr.exit(tcInt, "getDestinationFromMsgRepresentation");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getDestinationFromMsgRepresentation");
        }
        return jmsDestinationImpl;
    }

    public String getShortPropertyName(String string) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getShortPropertyName");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "longPropertyName: " + string);
        }
        String string2 = null;
        string2 = (String)this.propertyNames.getShortKeyFromLong(string);
        if (string2 == null) {
            string2 = string;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + string2);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getShortPropertyName");
        }
        return string2;
    }

    public String getLongPropertyName(String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getLongPropertyName");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "shortPropertyName: " + string);
        }
        String string2 = null;
        string2 = (String)this.propertyNames.getLongKeyFromShort(string);
        if (string2 == null) {
            string2 = string;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + string2);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getLongPropertyName");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortPropertyValue(String string, Object object) throws JMSException {
        String string2;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "getShortPropertyValue");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "longPropertyName: " + string);
                SibTr.debug(tcInt, "         propVal: " + object);
            }
            String string3 = null;
            string3 = this.shortenValueEncoding(string, object);
            if (string3 == null) {
                string3 = this.getDefaultValueEncoding(string, object);
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "returns: " + string3);
            }
            string2 = string3;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var6_6 = null;
                if (!tcInt.isEntryEnabled()) break block7;
                SibTr.exit(tcInt, "getShortPropertyValue");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getShortPropertyValue");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLongPropertyValue(String string, String string2) throws JMSException {
        Object object;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "getLongPropertyValue");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "longPropertyName: " + string);
                SibTr.debug(tcInt, "  shortPropValue: " + string2);
            }
            Object object2 = null;
            object2 = string2.startsWith(DEFAULT_ENCODING_PREFIX) ? this.getDefaultValueDecoding(string, string2) : this.lengthenValueEncoding(string, string2);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "returns: " + object2);
            }
            object = object2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                if (!tcInt.isEntryEnabled()) break block6;
                SibTr.exit(tcInt, "getLongPropertyValue");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getLongPropertyValue");
        }
        return object;
    }

    public Object getDefaultPropertyValue(String string) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getDefaultPropertyValue");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "longPropertyName: " + string);
        }
        Object object = null;
        object = this.propertyNames.getDefaultFromLongKey(string);
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + object);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getDefaultPropertyValue");
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadAndValidate() throws JMSException {
        try {
            try {
                if (tcInt.isEntryEnabled()) {
                    SibTr.entry(tcInt, "loadAndValidate");
                }
                this.propertyNames = new BiDirectionalMapping();
                this.propertyValues = new HashMap();
                this.propertyTypes = new HashMap();
                this.loadPropertyInfo("priority", "pr", new Integer(4), null, null);
                this.loadPropertyInfo("deliveryMode", "dm", "Application", null, null);
                this.loadPropertyInfo("timeToLive", "tl", new Long(0L), null, null);
                this.loadPropertyInfo("readAhead", "ra", "AsConnection", new Object[]{"AlwaysOff", "AlwaysOn"}, new String[]{"F", "N"});
                this.loadPropertyInfo("topicName", "tn", null, ANY_STRING, null);
                this.loadPropertyInfo("topicSpace", "ts", "Default.Topic.Space", ANY_STRING, null);
                this.loadPropertyInfo("queueName", "qn", null, ANY_STRING, null);
            }
            catch (JMSException jMSException) {
                if (!tcInt.isDebugEnabled()) throw jMSException;
                SibTr.debug(tcInt, "passing on exception: ", (Object)jMSException);
                throw jMSException;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!tcInt.isEntryEnabled()) throw throwable;
            SibTr.exit(tcInt, "loadAndValidate");
            throw throwable;
        }
        if (!tcInt.isEntryEnabled()) return;
        SibTr.exit(tcInt, "loadAndValidate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String shortenValueEncoding(String string, Object object) throws JMSException {
        String string2;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "shortenValueEncoding");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "longPropertyName: " + string);
                SibTr.debug(tcInt, "         propVal: " + object);
            }
            String string3 = null;
            BiDirectionalMapping biDirectionalMapping = (BiDirectionalMapping)this.propertyValues.get(string);
            if (biDirectionalMapping != null) {
                if (biDirectionalMapping.containsLongKey(ANY_STRING)) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "ANY_STRING is allowed for this property.");
                    }
                    string3 = object.toString();
                } else if (biDirectionalMapping.containsLongKey(object)) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "The mapping contains " + object);
                    }
                    string3 = (String)biDirectionalMapping.getShortKeyFromLong(object);
                } else {
                    JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"MsgDestEncodingUtilsImpl.shortenValueEncoding#1", string, object}, tcInt);
                    JmsErrorUtils.processThrowable(jMSException, "MsgDestEncodingUtilsImpl.shortenValueEncoding#1", this, tcInt);
                    throw jMSException;
                }
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "returns: " + string3);
            }
            string2 = string3;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            block13: {
                Object var7_8 = null;
                if (!tcInt.isEntryEnabled()) break block13;
                SibTr.exit(tcInt, "shortenValueEncoding");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "shortenValueEncoding");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lengthenValueEncoding(String string, String string2) throws JMSException {
        String string3;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "lengthenValueEncoding");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "longPropertyName: " + string);
                SibTr.debug(tcInt, "       shortForm: " + string2);
            }
            Object object = null;
            BiDirectionalMapping biDirectionalMapping = (BiDirectionalMapping)this.propertyValues.get(string);
            if (biDirectionalMapping != null) {
                if (biDirectionalMapping.containsShortKey(ANY_STRING)) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "This property can be set to ANY_STRING");
                    }
                    object = string2;
                } else if (biDirectionalMapping.containsShortKey(string2)) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Mapping contains the shortform.");
                    }
                    object = biDirectionalMapping.getLongKeyFromShort(string2);
                } else {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"MsgDestEncodingUtilsImpl.lengthenValueEncoding#1", string, string2}, tcInt);
                }
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "returns: " + object);
            }
            string3 = object;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block13: {
                Object var7_7 = null;
                if (!tcInt.isEntryEnabled()) break block13;
                SibTr.exit(tcInt, "lengthenValueEncoding");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "lengthenValueEncoding");
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertyInfo(String string, String string2, Object object, Object[] objectArray, String[] stringArray) throws JMSException {
        try {
            Class clazz;
            int n;
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "loadPropertyInfo");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "longKey: " + string);
                SibTr.debug(tcInt, "shortKey: " + string2);
                SibTr.debug(tcInt, "defaultValue: " + object);
                if (objectArray != null) {
                    for (n = 0; n < objectArray.length; ++n) {
                        SibTr.debug(tcInt, "permittedValue[" + n + "]: " + objectArray[n]);
                    }
                } else {
                    SibTr.debug(tcInt, "permitedValues: null");
                }
                if (stringArray != null) {
                    for (n = 0; n < stringArray.length; ++n) {
                        SibTr.debug(tcInt, "shortForm[" + n + "]: " + stringArray[n]);
                    }
                } else {
                    SibTr.debug(tcInt, "shortForms: null");
                }
            }
            if (string2.startsWith(DEFAULT_ENCODING_PREFIX)) {
                JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"MsgDestEncodingUtilsImpl.loadPropertyInfo#1", string, string2}, tcInt);
                JmsErrorUtils.processThrowable(jMSException, "MsgDestEncodingUtilsImpl.loadPropertyInfo#1", this, tcInt);
                throw jMSException;
            }
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].startsWith(DEFAULT_ENCODING_PREFIX)) continue;
                    JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"MsgDestEncodingUtilsImpl.loadPropertyInfo#2", string + " shortForm[" + n + "]", stringArray[n]}, tcInt);
                    JmsErrorUtils.processThrowable(jMSException, "MsgDestEncodingUtilsImpl.loadPropertyInfo#2", this, tcInt);
                    throw jMSException;
                }
            }
            if ((clazz = this.getPropertyType(string)) == null) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Property " + string + " does not have a setter!");
                }
                JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"MsgDestEncodingUtilsImpl.loadPropertyInfo#3", string, null}, tcInt);
                throw jMSException;
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Add the property association [" + string + ", " + string2 + ", " + object + "]");
            }
            this.propertyNames.putEntry(string, string2, object);
            if (objectArray == ANY_STRING) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "This property takes ANY_STRING as a value");
                }
                BiDirectionalMapping biDirectionalMapping = new BiDirectionalMapping();
                biDirectionalMapping.putEntry(ANY_STRING, ANY_STRING, null);
                this.propertyValues.put(string, biDirectionalMapping);
            } else if (objectArray != null) {
                BiDirectionalMapping biDirectionalMapping = new BiDirectionalMapping();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Add value association [" + objectArray[i] + ", " + stringArray[i] + "]");
                    }
                    biDirectionalMapping.putEntry(objectArray[i], stringArray[i], null);
                }
                this.propertyValues.put(string, biDirectionalMapping);
            }
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "loadPropertyInfo");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "loadPropertyInfo");
        }
    }

    protected String getDefaultValueEncoding(String string, Object object) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getDefaultValueEncoding");
        }
        String string2 = DEFAULT_ENCODING_PREFIX + object.toString();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "longName: " + string + ", returns: " + string2);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getDefaultValueEncoding");
        }
        return string2;
    }

    protected Object getDefaultValueDecoding(String string, String string2) throws JMSException {
        String string3;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "getDefaultValueDecoding");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "longPropertyName: " + string);
                SibTr.debug(tcInt, "    shortPropVal: " + string2);
            }
            Object object = null;
            Class clazz = this.getPropertyType(string);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Property type: " + clazz);
            }
            if (clazz == null) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Property " + string + " does not have a setter!");
                }
                JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"MsgDestEncodingUtilsImpl.getDefaultValueDecoding#1", string, null}, tcInt);
                throw jMSException;
            }
            String string4 = string2;
            if (string2.startsWith(DEFAULT_ENCODING_PREFIX)) {
                string4 = string2.substring(DEFAULT_ENCODING_PREFIX.length());
            }
            if (clazz == String.class) {
                object = string4;
            } else if (clazz == Integer.class) {
                object = Integer.valueOf(string4);
            } else if (clazz == Long.class) {
                object = Long.valueOf(string4);
            } else if (clazz == Boolean.class) {
                object = Boolean.valueOf(string4);
            } else if (clazz == Byte.class) {
                object = Byte.valueOf(string4);
            } else if (clazz == Float.class) {
                object = Float.valueOf(string4);
            } else if (clazz == Double.class) {
                object = Double.valueOf(string4);
            } else if (clazz == Short.class) {
                object = Short.valueOf(string4);
            } else {
                JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"MsgDestEncodingUtilsImpl.getDefaultValueDecoding#2", string, clazz}, tcInt);
                JmsErrorUtils.processThrowable(jMSException, "MsgDestEncodingUtilsImpl.getDefaultValueDecoding#2", this, tcInt);
                throw jMSException;
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "returns: " + object);
            }
            string3 = object;
            Object var8_10 = null;
        }
        catch (JMSException jMSException) {
            try {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "passing on exception: ", (Object)jMSException);
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                block29: {
                    Object var8_11 = null;
                    if (!tcInt.isEntryEnabled()) break block29;
                    SibTr.exit(tcInt, "getDefaultValueDecoding");
                }
                throw throwable;
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getDefaultValueDecoding");
        }
        return string3;
    }

    protected Class getPropertyType(String string) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getPropertyType");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "longPropertyName: " + string);
        }
        Class<?> clazz = null;
        String string2 = null;
        if (this.propertyTypes.containsKey(string)) {
            clazz = (Class<?>)this.propertyTypes.get(string);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Retrieved cached type: " + clazz);
            }
        }
        if (clazz == null) {
            Class[] classArray = new Class[]{JmsDestinationImpl.class, JmsQueueImpl.class, JmsTopicImpl.class};
            string2 = this.getSetMethodName(string);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Setter name: " + string2);
            }
            block0: for (int i = 0; i < classArray.length; ++i) {
                Class clazz2 = classArray[i];
                Method[] methodArray = clazz2.getDeclaredMethods();
                for (int j = 0; j < methodArray.length; ++j) {
                    Method method = methodArray[j];
                    if (!string2.equals(method.getName())) continue;
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Setter " + string2 + " found on " + clazz2);
                    }
                    clazz = method.getParameterTypes()[0];
                    this.propertyTypes.put(string, clazz);
                    break block0;
                }
                if (!tcInt.isDebugEnabled()) continue;
                SibTr.debug(tcInt, "Setter " + string2 + " was not found on " + clazz2);
            }
        }
        if (clazz == null && tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Setter " + string2 + " was not found at all.");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + clazz);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getPropertyType");
        }
        return clazz;
    }

    private byte[] getEncodedBasicInfo(Map map, boolean bl) {
        int n;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getEncodedBasicInfo");
        }
        int n2 = 0;
        if (bl) {
            n2 = 16;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "destTypeByte: " + n2 + " (isTopic=" + bl + ")");
        }
        String string = (String)map.remove("deliveryMode");
        Integer n3 = (Integer)map.remove("priority");
        Long l = (Long)map.remove("timeToLive");
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "dm: " + string);
            SibTr.debug(tcInt, "pri: " + n3);
            SibTr.debug(tcInt, "ttl: " + l);
        }
        byte[] byArray = null;
        int n4 = 0;
        if (l != null) {
            n4 = 1;
            byArray = new byte[10];
            long l2 = l;
            for (n = 0; n < 8; ++n) {
                int n5 = (7 - n) * 8;
                long l3 = 255 << n5;
                byArray[2 + n] = (byte)((l2 & l3) >> n5);
            }
        } else {
            byArray = new byte[2];
        }
        int n6 = 0;
        if (string != null && !"Application".equals(string)) {
            if ("Persistent".equals(string)) {
                n6 = 1;
            } else if ("NonPersistent".equals(string)) {
                n6 = 2;
            }
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "deliveryModeByte: " + n6);
        }
        int n7 = -16;
        if (n3 != null) {
            n = n3.byteValue();
            n7 = (byte)(n << 4);
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "priorityByte: " + n7);
        }
        byArray[0] = (byte)(n2 | n6);
        byArray[1] = (byte)(n7 | n4);
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Basic data portion");
            SibTr.bytes(tcInt, byArray);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getEncodedBasicInfo");
        }
        return byArray;
    }

    private void decodeDestProperties(byte[] byArray, JmsDestination jmsDestination) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "decodeDestProperties");
        }
        int n = this.decodeBasicInfo(byArray, jmsDestination);
        while (n < byArray.length) {
            Object object;
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "nextStart offset: " + n);
            }
            if (byArray[n] == (byte)DEFAULT_ENCODING_PREFIX.charAt(0)) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Default encoded property found");
                }
                try {
                    int n2 = this.convertBytesToInt(byArray, n + 1);
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "name length: " + n2);
                    }
                    String string = new String(byArray, n + 3, n2, ENCODING);
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "name string: " + string);
                    }
                    int n3 = n + 3 + n2;
                    int n4 = this.convertBytesToInt(byArray, n3);
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "value length: " + n4);
                    }
                    object = new String(byArray, n3 + 2, n4, ENCODING);
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "value string: " + (String)object);
                    }
                    Object object2 = this.getLongPropertyValue(string, (String)object);
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "long value: " + object2);
                    }
                    this.setDestinationProperty(jmsDestination, string, object2);
                    n += 3 + n2 + 2 + n4;
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_ENCODING_CWSIA0360", new Object[]{ENCODING}, unsupportedEncodingException, "MsgDestEncodingUtilsImpl.decodeDestProperties#1", this, tcInt);
                }
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "shortform property found");
            }
            try {
                String string = new String(byArray, n, 2, ENCODING);
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "shortName: " + string);
                }
                int n5 = this.convertBytesToInt(byArray, n + 2);
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "value length: " + n5);
                }
                String string2 = new String(byArray, n + 4, n5, ENCODING);
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "value string: " + string2);
                }
                String string3 = this.getLongPropertyName(string);
                object = this.getLongPropertyValue(string3, string2);
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "longName: " + string3);
                    SibTr.debug(tcInt, "longValue: " + object);
                }
                this.setDestinationProperty(jmsDestination, string3, object);
                n += 4 + n5;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_ENCODING_CWSIA0360", new Object[]{ENCODING}, unsupportedEncodingException, "MsgDestEncodingUtilsImpl.decodeDestProperties#2", this, tcInt);
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "decodeDestProperties");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDestinationProperty(JmsDestination jmsDestination, String string, Object object) throws JMSException {
        String string2 = null;
        try {
            try {
                if (tcInt.isEntryEnabled()) {
                    SibTr.entry(tcInt, "setDestinationProperty");
                }
                Class<?> clazz = jmsDestination.getClass();
                Class<?> clazz2 = object.getClass();
                string2 = this.getSetMethodName(string);
                Method method = clazz.getMethod(string2, clazz2);
                method.invoke((Object)jmsDestination, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (!(throwable instanceof JMSException)) throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"MsgDestEncodingUtilsImpl.setDestinationProperty#1", string2, ""}, invocationTargetException, "MsgDestEncodingUtilsImpl.setDestinationProperty#2", this, tcInt);
                if (!tcInt.isDebugEnabled()) throw (JMSException)throwable;
                SibTr.debug(tcInt, "passing on exception: ", throwable);
                throw (JMSException)throwable;
            }
            catch (Exception exception) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"MsgDestEncodingUtilsImpl.setDestinationProperty#3", "see linked exception", ""}, exception, "MsgDestEncodingUtilsImpl.setDestinationProperty#3", this, tcInt);
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!tcInt.isEntryEnabled()) throw throwable;
            SibTr.exit(tcInt, "setDestinationProperty");
            throw throwable;
        }
        if (!tcInt.isEntryEnabled()) return;
        SibTr.exit(tcInt, "setDestinationProperty");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decodeBasicInfo(byte[] byArray, JmsDestination jmsDestination) throws JMSException {
        int n;
        try {
            int n2;
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "decodeBasicInfo");
            }
            byte by = byArray[0];
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "DM byte: " + (by & 0xF));
            }
            if ((by & 0xF) == 0) {
                jmsDestination.setDeliveryMode("Application");
            } else if ((by & 0xF) == 1) {
                jmsDestination.setDeliveryMode("Persistent");
            } else if ((by & 0xF) == 2) {
                jmsDestination.setDeliveryMode("NonPersistent");
            }
            byte by2 = byArray[1];
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Priority byte: " + (by2 & 0xF0));
            }
            if ((by2 & 0xF0) != -16 && (n2 = (by2 & 0xF0) >> 4) != 15) {
                jmsDestination.setPriority(new Integer(n2));
            }
            n2 = 2;
            if ((by2 & 0xF) == 1) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "TTL has been stored in the byte[]");
                }
                long l = 0L;
                for (int i = 0; i < 8; ++i) {
                    byte by3 = byArray[2 + i];
                    char c = (char)by3;
                    if (by3 < 0) {
                        c = (char)(c + 256);
                    }
                    long l2 = c << (7 - i) * 8;
                    l |= l2;
                }
                jmsDestination.setTimeToLive(new Long(l));
                n2 = 10;
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "next offset is " + n2);
            }
            n = n2;
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            block17: {
                Object var14_13 = null;
                if (!tcInt.isEntryEnabled()) break block17;
                SibTr.exit(tcInt, "decodeBasicInfo");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "decodeBasicInfo");
        }
        return n;
    }

    private String getSetMethodName(String string) {
        String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        return string2;
    }

    protected byte[] convertIntToBytes(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        return byArray;
    }

    protected int convertBytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        byte by = byArray[0 + n];
        int n3 = by & 0xFF;
        int n4 = n3 << 8;
        byte by2 = byArray[1 + n];
        int n5 = by2 & 0xFF;
        n2 = n4 | n5;
        return n2;
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/MsgDestEncodingUtilsImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.25");
        }
        DEFAULT_ENCODING_BYTES = new byte[]{(byte)DEFAULT_ENCODING_PREFIX.charAt(0)};
        ANY_STRING = new Object[0];
    }

    private class BiDirectionalMapping {
        private Vector shortKeys = new Vector();
        private Vector longKeys = new Vector();
        private Vector defaults = new Vector();

        public void putEntry(Object object, Object object2, Object object3) {
            this.longKeys.add(object);
            this.shortKeys.add(object2);
            this.defaults.add(object3);
        }

        public Object getShortKeyFromLong(Object object) {
            Object var2_2 = null;
            int n = this.longKeys.indexOf(object);
            if (n != -1) {
                var2_2 = this.shortKeys.get(n);
            }
            return var2_2;
        }

        public Object getLongKeyFromShort(Object object) {
            Object var2_2 = null;
            int n = this.shortKeys.indexOf(object);
            if (n != -1) {
                var2_2 = this.longKeys.get(n);
            }
            return var2_2;
        }

        public Object getDefaultFromLongKey(Object object) {
            Object var2_2 = null;
            int n = this.longKeys.indexOf(object);
            if (n != -1) {
                var2_2 = this.defaults.get(n);
            }
            return var2_2;
        }

        public boolean containsLongKey(Object object) {
            return this.longKeys.contains(object);
        }

        public boolean containsShortKey(Object object) {
            return this.shortKeys.contains(object);
        }
    }
}

