/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.api.jms.JmsTemporaryDestinationInternal;
import com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;

public class JmsTemporaryTopicImpl
extends JmsTopicImpl
implements TemporaryTopic,
JmsTemporaryDestinationInternal {
    private static final long serialVersionUID = 6712385077680173545L;
    private static TraceComponent tc = SibTr.register(JmsConnectionImpl.class, "SIBJms_External", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = SibTr.register(JmsConnectionImpl.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    JmsSessionImpl session;
    boolean deleted = false;

    public JmsTemporaryTopicImpl(SIDestinationAddress sIDestinationAddress, JmsSessionImpl jmsSessionImpl) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsTemporaryTopicImpl");
        }
        this.setDestName(sIDestinationAddress.getDestinationName());
        this.setBusName(sIDestinationAddress.getBusName());
        this.setDestDiscrim(sIDestinationAddress.getDestinationName());
        this.session = jmsSessionImpl;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsTemporaryTopicImpl");
        }
    }

    public void delete() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "delete");
        }
        if (!this.deleted) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "About to delete temp dest: " + this.getDestName());
            }
            this.session.deleteTemporaryDestination(this.getConsumerSIDestinationAddress());
            this.deleted = true;
            ((JmsConnectionImpl)this.session.getConnection()).removeTemporaryDestination(this);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Dest is already marked as deleted - shortcut.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "delete");
        }
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsTemporaryTopicImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.14");
        }
    }
}

