/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.api.jms.JmsTemporaryDestinationInternal;
import com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;

public class JmsTemporaryQueueImpl
extends JmsQueueImpl
implements TemporaryQueue,
JmsTemporaryDestinationInternal {
    private static final long serialVersionUID = 8936845633815526385L;
    private static TraceComponent tc = SibTr.register(JmsConnectionImpl.class, "SIBJms_External", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = SibTr.register(JmsConnectionImpl.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    JmsSessionImpl session;
    boolean deleted = false;

    public JmsTemporaryQueueImpl(SIDestinationAddress sIDestinationAddress, JmsSessionImpl jmsSessionImpl) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsTemporaryQueueImpl");
        }
        this.setDestName(sIDestinationAddress.getDestinationName());
        this.setBusName(sIDestinationAddress.getBusName());
        this.session = jmsSessionImpl;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsTemporaryQueueImpl");
        }
    }

    public void delete() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "delete");
        }
        if (!this.deleted) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "About to delete temp dest: " + this.getDestName());
            }
            this.session.deleteTemporaryDestination(this.getConsumerSIDestinationAddress());
            this.deleted = true;
            ((JmsConnectionImpl)this.session.getConnection()).removeTemporaryDestination(this);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Dest is already marked as deleted - shortcut.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "delete");
        }
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsTemporaryQueueImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.16");
        }
    }
}

