/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.StreamMessage;

public class JmsStreamMessageImpl
extends JmsMessageImpl
implements StreamMessage {
    private static final long serialVersionUID = 3222131330774615635L;
    private JsJmsStreamMessage streamMsg;
    private boolean partReadBytesElement = false;
    private byte[] bytesElement = null;
    private int bytesElementOffset;
    private static TraceComponent tc = Tr.register((Class)JmsStreamMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = Tr.register((Class)JmsStreamMessageImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    public JmsStreamMessageImpl() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsStreamMessageImpl");
        }
        this.messageClass = "jms_stream";
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsStreamMessageImpl");
        }
    }

    JmsStreamMessageImpl(JsJmsStreamMessage jsJmsStreamMessage, JmsSessionImpl jmsSessionImpl) {
        super(jsJmsStreamMessage, jmsSessionImpl);
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsStreamMessageImpl(JsJmsStreamMessage, JmsSessionImpl)");
        }
        this.streamMsg = jsJmsStreamMessage;
        this.messageClass = "jms_stream";
        this.streamMsg.reset();
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsStreamMessageImpl(JsJmsStreamMessage, JmsSessionImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsStreamMessageImpl(StreamMessage streamMessage) throws JMSException {
        super((Message)streamMessage);
        this.messageClass = "jms_stream";
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "JmsStreamMessageImpl(StreamMessage)");
            }
            streamMessage.reset();
            try {
                while (true) {
                    this.writeObject(streamMessage.readObject());
                }
            }
            catch (JMSException jMSException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "exception caught: ", (Object)jMSException);
                }
                Object var4_3 = null;
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "JmsStreamMessageImpl(StreamMessage)");
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "JmsStreamMessageImpl(StreamMessage)");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readBoolean() throws JMSException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readBoolean()");
        }
        Object object = this.getNextField("readBoolean");
        try {
            try {
                bl = JmsMessageImpl.parseBoolean(object, "");
            }
            catch (JMSException jMSException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw jMSException;
                SibTr.debug(tc, "exception caught: ", (Object)jMSException);
                throw jMSException;
            }
            catch (RuntimeException runtimeException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw runtimeException;
                SibTr.debug(tc, "exception caught: ", runtimeException);
                throw runtimeException;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "readBoolean()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return bl;
        SibTr.exit(tc, "readBoolean()");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte readByte() throws JMSException {
        byte by;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readByte()");
        }
        Object object = this.getNextField("readByte");
        try {
            try {
                by = JmsMessageImpl.parseByte(object, "");
            }
            catch (RuntimeException runtimeException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw runtimeException;
                SibTr.debug(tc, "exception caught: ", runtimeException);
                throw runtimeException;
            }
            catch (JMSException jMSException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw jMSException;
                SibTr.debug(tc, "exception caught: ", (Object)jMSException);
                throw jMSException;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "readByte()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return by;
        SibTr.exit(tc, "readByte()");
        return by;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short readShort() throws JMSException {
        short s;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readShort()");
        }
        Object object = this.getNextField("readShort");
        try {
            try {
                s = JmsMessageImpl.parseShort(object, "");
            }
            catch (JMSException jMSException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw jMSException;
                SibTr.debug(tc, "exception caught: ", (Object)jMSException);
                throw jMSException;
            }
            catch (RuntimeException runtimeException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw runtimeException;
                SibTr.debug(tc, "exception caught: ", runtimeException);
                throw runtimeException;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "readShort()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return s;
        SibTr.exit(tc, "readShort()");
        return s;
    }

    public char readChar() throws JMSException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readChar()");
        }
        if ((object = this.getNextField("readChar")) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readChar()");
            }
            throw (NullPointerException)JmsErrorUtils.newThrowable(NullPointerException.class, "NULL_CHAR_CWSIA0164", null, tc);
        }
        if (!(object instanceof Character)) {
            this.streamMsg.stepBack();
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readChar()");
            }
            throw JmsStreamMessageImpl.newBadConvertException(object, "", "Character", tc);
        }
        char c = ((Character)object).charValue();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readChar()");
        }
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readInt() throws JMSException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readInt()");
        }
        Object object = this.getNextField("readInt");
        try {
            try {
                n = JmsMessageImpl.parseInt(object, "");
            }
            catch (JMSException jMSException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw jMSException;
                SibTr.debug(tc, "exception caught: ", (Object)jMSException);
                throw jMSException;
            }
            catch (RuntimeException runtimeException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw runtimeException;
                SibTr.debug(tc, "exception caught: ", runtimeException);
                throw runtimeException;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "readInt()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return n;
        SibTr.exit(tc, "readInt()");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long readLong() throws JMSException {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readLong()");
        }
        Object object = this.getNextField("readLong");
        try {
            try {
                l = JmsMessageImpl.parseLong(object, "");
            }
            catch (JMSException jMSException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw jMSException;
                SibTr.debug(tc, "exception caught: ", (Object)jMSException);
                throw jMSException;
            }
            catch (RuntimeException runtimeException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw runtimeException;
                SibTr.debug(tc, "exception caught: ", runtimeException);
                throw runtimeException;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "readLong()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return l;
        SibTr.exit(tc, "readLong()");
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float readFloat() throws JMSException {
        float f;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readFloat()");
        }
        Object object = this.getNextField("readFloat");
        try {
            try {
                f = JmsMessageImpl.parseFloat(object, "");
            }
            catch (JMSException jMSException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw jMSException;
                SibTr.debug(tc, "exception caught: ", (Object)jMSException);
                throw jMSException;
            }
            catch (RuntimeException runtimeException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw runtimeException;
                SibTr.debug(tc, "exception caught: ", runtimeException);
                throw runtimeException;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "readFloat()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return f;
        SibTr.exit(tc, "readFloat()");
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double readDouble() throws JMSException {
        double d;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readDouble()");
        }
        Object object = this.getNextField("readDouble");
        try {
            try {
                d = JmsMessageImpl.parseDouble(object, "");
            }
            catch (JMSException jMSException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw jMSException;
                SibTr.debug(tc, "exception caught: ", (Object)jMSException);
                throw jMSException;
            }
            catch (RuntimeException runtimeException) {
                this.streamMsg.stepBack();
                if (!tc.isDebugEnabled()) throw runtimeException;
                SibTr.debug(tc, "exception caught: ", runtimeException);
                throw runtimeException;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "readDouble()");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return d;
        SibTr.exit(tc, "readDouble()");
        return d;
    }

    public String readString() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readString");
        }
        Object object = this.getNextField("readString");
        String string = null;
        if (object instanceof String || object == null) {
            string = (String)object;
        } else {
            if (object instanceof byte[]) {
                this.streamMsg.stepBack();
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "readString");
                }
                throw JmsStreamMessageImpl.newBadConvertException(object, "", "String", tc);
            }
            string = object.toString();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readString");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readBytes(byte[] byArray) throws JMSException {
        int n;
        block13: {
            int n2;
            block12: {
                int n3;
                block11: {
                    int n4;
                    block10: {
                        if (tc.isEntryEnabled()) {
                            SibTr.entry(tc, "readBytes");
                        }
                        try {
                            this.checkBodyReadable("readBytes");
                            if (!this.partReadBytesElement) {
                                Object object = this.getNextField("readBytes");
                                if (object == null) {
                                    n4 = -1;
                                    Object var6_8 = null;
                                    break block10;
                                }
                                if (!(object instanceof byte[])) {
                                    this.streamMsg.stepBack();
                                    throw JmsStreamMessageImpl.newBadConvertException(object, "", "byte[]", tc);
                                }
                                this.bytesElement = (byte[])object;
                                this.bytesElementOffset = 0;
                                if (this.bytesElement.length == 0) {
                                    n3 = 0;
                                    break block11;
                                }
                            }
                            if (byArray == null) {
                                Class clazz;
                                if (class$java$lang$NullPointerException == null) {
                                    clazz = class$java$lang$NullPointerException = JmsStreamMessageImpl.class$("java.lang.NullPointerException");
                                    throw (NullPointerException)JmsErrorUtils.newThrowable(clazz, "NULL_BUFFER_CWSIA0161", null, tc);
                                }
                                clazz = class$java$lang$NullPointerException;
                                throw (NullPointerException)JmsErrorUtils.newThrowable(clazz, "NULL_BUFFER_CWSIA0161", null, tc);
                            }
                            int n5 = this.bytesElement.length - this.bytesElementOffset;
                            int n6 = n5 > byArray.length ? byArray.length : n5;
                            this.partReadBytesElement = n6 == byArray.length;
                            if (n6 == 0) {
                                n2 = -1;
                                break block12;
                            }
                            System.arraycopy(this.bytesElement, this.bytesElementOffset, byArray, 0, n6);
                            this.bytesElementOffset += n6;
                            n = n6;
                            break block13;
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            if (!tc.isEntryEnabled()) throw throwable;
                            SibTr.exit(tc, "readBytes");
                            throw throwable;
                        }
                    }
                    if (!tc.isEntryEnabled()) return n4;
                    SibTr.exit(tc, "readBytes");
                    return n4;
                }
                Object var6_9 = null;
                if (!tc.isEntryEnabled()) return n3;
                SibTr.exit(tc, "readBytes");
                return n3;
            }
            Object var6_10 = null;
            if (!tc.isEntryEnabled()) return n2;
            SibTr.exit(tc, "readBytes");
            return n2;
        }
        Object var6_11 = null;
        if (!tc.isEntryEnabled()) return n;
        SibTr.exit(tc, "readBytes");
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject() throws JMSException {
        Object object;
        try {
            Object object2;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "readObject");
            }
            if ((object2 = this.getNextField("readObject")) instanceof byte[]) {
                int n = ((byte[])object2).length;
                object = new byte[n];
                System.arraycopy(object2, 0, object, 0, n);
            } else {
                object = object2;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readObject");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readObject");
        }
        return object;
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeBoolean");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params " + bl);
        }
        this.checkBodyWriteable("writeBoolean");
        this.streamMsg.writeBoolean(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeBoolean");
        }
    }

    public void writeByte(byte by) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeByte");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + by);
        }
        this.checkBodyWriteable("writeByte");
        this.streamMsg.writeByte(by);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeByte");
        }
    }

    public void writeShort(short s) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeShort");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + s);
        }
        this.checkBodyWriteable("writeShort");
        this.streamMsg.writeShort(s);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeShort");
        }
    }

    public void writeChar(char c) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeChar");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + c);
        }
        this.checkBodyWriteable("writeChar");
        this.streamMsg.writeChar(c);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeChar");
        }
    }

    public void writeInt(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeInt");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + n);
        }
        this.checkBodyWriteable("writeInt");
        this.streamMsg.writeInt(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeInt");
        }
    }

    public void writeLong(long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeLong");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + l);
        }
        this.checkBodyWriteable("writeLong");
        this.streamMsg.writeLong(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeLong");
        }
    }

    public void writeFloat(float f) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeFloat");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + f);
        }
        this.checkBodyWriteable("writeFloat");
        this.streamMsg.writeFloat(f);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeFloat");
        }
    }

    public void writeDouble(double d) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeDouble");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + d);
        }
        this.checkBodyWriteable("writeDouble");
        this.streamMsg.writeDouble(d);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeDouble");
        }
    }

    public void writeString(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeString");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + string);
        }
        this.checkBodyWriteable("writeString");
        this.streamMsg.writeString(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeString");
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeBytes");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + byArray);
        }
        this.checkBodyWriteable("writeBytes");
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        this.streamMsg.writeBytes(byArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeBytes");
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeBytes");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + byArray + ", " + n + ", " + n2);
        }
        this.checkBodyWriteable("writeBytes");
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.streamMsg.writeBytes(byArray2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeBytes");
        }
    }

    public void writeObject(Object object) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeObject");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + object);
        }
        this.checkBodyWriteable("writeObject");
        if (!(object == null || object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof byte[])) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "value is bad type: " + object.getClass().getName());
            }
            throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "BAD_OBJECT_CWSIA0189", new Object[]{object.getClass().getName()}, tc);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            object = byArray2;
        }
        this.streamMsg.writeObject(object);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeObject");
        }
    }

    public void reset() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "reset");
        }
        this.setBodyReadOnly();
        this.streamMsg.reset();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "reset");
        }
    }

    protected JsJmsMessage instantiateMessage() throws Exception {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "instantiateMessage");
        }
        JsJmsStreamMessage jsJmsStreamMessage = null;
        try {
            jsJmsStreamMessage = jmfact.createJmsStreamMessage();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "exception caught: ", messageCreateFailedException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "instantiateMessage");
            }
            throw messageCreateFailedException;
        }
        this.streamMsg = jsJmsStreamMessage;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "instantiateMessage");
        }
        return jsJmsStreamMessage;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        if (this.streamMsg == null) {
            return 0;
        }
        return this.streamMsg.hashCode();
    }

    private Object getNextField(String string) throws MessageEOFException, MessageNotReadableException, MessageFormatException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getNextField");
        }
        this.checkBodyReadable(string);
        if (this.partReadBytesElement) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getNextField");
            }
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INCOMPLETE_BYTE_ARRAY_CWSIA0163", null, tc);
        }
        Object object = this.streamMsg.readObject();
        if (object == JsJmsStreamMessage.END_OF_STREAM) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getNextField");
            }
            throw (MessageEOFException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_STREAM_CWSIA0162", null, tc);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getNextField");
        }
        return object;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsStreamMessageImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.32.1.3");
        }
    }
}

