/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;

public class JmsMetaDataImpl
implements ConnectionMetaData {
    private static TraceComponent tcInt = Tr.register((Class)JmsMetaDataImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static final int jmsMajorVersion = 1;
    private static final int jmsMinorVersion = 1;
    private static String provName = null;
    private static String provVersion = null;
    private static int provMajorVersion = -1;
    private static int provMinorVersion = -1;
    private static final String[] supportedJMSXProps = new String[]{"JMSXUserID", "JMSXDeliveryCount", "JMSXAppID", "JMSXGroupID", "JMSXGroupSeq"};
    private static final String packageName = "com.ibm.ws.sib.api.jms.impl";

    public String getJMSVersion() throws JMSException {
        return this.getJMSMajorVersion() + "." + this.getJMSMinorVersion();
    }

    public int getJMSMajorVersion() throws JMSException {
        return 1;
    }

    public int getJMSMinorVersion() throws JMSException {
        return 1;
    }

    public String getJMSProviderName() throws JMSException {
        if (provName == null) {
            JmsMetaDataImpl.retrieveManifestData();
        }
        return provName;
    }

    public String getProviderVersion() throws JMSException {
        if (provVersion == null) {
            JmsMetaDataImpl.retrieveManifestData();
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Provider version: " + provVersion);
        }
        return provVersion;
    }

    public int getProviderMajorVersion() throws JMSException {
        if (provMajorVersion == -1) {
            JmsMetaDataImpl.retrieveManifestData();
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Provider major version: " + provMajorVersion);
        }
        return provMajorVersion;
    }

    public int getProviderMinorVersion() throws JMSException {
        if (provMinorVersion == -1) {
            JmsMetaDataImpl.retrieveManifestData();
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Provider minor version: " + provMinorVersion);
        }
        return provMinorVersion;
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        Vector<String> vector = new Vector<String>(supportedJMSXProps.length);
        for (int i = 0; i < supportedJMSXProps.length; ++i) {
            vector.add(supportedJMSXProps[i]);
        }
        return vector.elements();
    }

    private static void retrieveManifestData() {
        block19: {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "retrieveManifestData");
            }
            try {
                JmsMetaDataImpl.setProblemDefaults();
                Package package_ = Package.getPackage(packageName);
                if (package_ != null) {
                    String string;
                    String string2 = package_.getImplementationVendor();
                    if (string2 != null) {
                        provName = string2;
                    }
                    if ((string = package_.getImplementationVersion()) != null) {
                        String string3 = null;
                        int n = -1;
                        n = string.lastIndexOf(" ");
                        string3 = n != -1 ? string.substring(n + 1) : string;
                        provVersion = string3;
                        n = string3.indexOf(".");
                        if (n != -1) {
                            block18: {
                                String string4 = string3.substring(n + 1);
                                try {
                                    provMinorVersion = Integer.valueOf(string4);
                                }
                                catch (RuntimeException runtimeException) {
                                    if (!tcInt.isDebugEnabled()) break block18;
                                    SibTr.debug(tcInt, "Unable to convert minor version to int", runtimeException);
                                }
                            }
                            int n2 = n - 4;
                            if (n2 < 0) {
                                n2 = 0;
                            }
                            String string5 = string3.substring(n2, n);
                            try {
                                provMajorVersion = Integer.valueOf(string5);
                            }
                            catch (RuntimeException runtimeException) {
                                if (tcInt.isDebugEnabled()) {
                                    SibTr.debug(tcInt, "Unable to convert major version to int", runtimeException);
                                }
                                break block19;
                            }
                        }
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "Build level did not contain '.'");
                        }
                        break block19;
                    }
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Implementation version from manifest was null");
                    }
                    break block19;
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "The package was null - unable to retrieve information");
                }
            }
            catch (RuntimeException runtimeException) {
                JmsErrorUtils.processThrowable(runtimeException, "JmsMetaDataImpl.retrieveManifestData#1", JmsMetaDataImpl.class, tcInt);
                if (!tcInt.isDebugEnabled()) break block19;
                SibTr.debug(tcInt, "Error retrieving manifest information", runtimeException);
            }
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Provider version: " + provVersion);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "retrieveManifestData");
        }
    }

    private static void setProblemDefaults() {
        provName = "IBM";
        provVersion = "???";
        provMajorVersion = 0;
        provMinorVersion = 0;
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsMetaDataImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.17");
        }
    }
}

