/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.api.jms.JmsManagedConnectionFactory;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnection;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnectionFactory;
import com.ibm.ws.sib.utils.BuildInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.resource.ResourceException;

public class JmsManagedConnectionFactoryImpl
implements JmsManagedConnectionFactory,
ApiJmsConstants {
    private static final long serialVersionUID = 2796080016458361701L;
    private static TraceComponent tc = SibTr.register(JmsManagedConnectionFactoryImpl.class, "SIBJms_External", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = SibTr.register(JmsManagedConnectionFactoryImpl.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static ConnectionMetaData connectionMetaData;
    JmsJcaConnectionFactory jcaConnectionFactory = null;

    JmsManagedConnectionFactoryImpl(JmsJcaConnectionFactory jmsJcaConnectionFactory) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsManagedConnectionFactoryImpl(JmsJcaConnectionFactory)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "jcaConnectionFactory : " + jmsJcaConnectionFactory);
        }
        this.jcaConnectionFactory = jmsJcaConnectionFactory;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsManagedConnectionFactoryImpl(JmsJcaConnectionFactory)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws JMSException {
        Connection connection;
        Connection connection2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createConnection()");
            }
            connection = connection2 = this.createConnection(null, null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return Connection : " + connection2);
                }
                if (!tc.isEntryEnabled()) break block6;
                SibTr.exit(tc, "createConnection()");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return Connection : " + connection2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createConnection()");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection(String string, String string2) throws JMSException {
        JmsConnectionImpl jmsConnectionImpl;
        JmsConnectionImpl jmsConnectionImpl2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createConnection(String, String)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "userName : " + string);
                if (string2 == null) {
                    SibTr.debug(tc, "password : <null>");
                } else {
                    SibTr.debug(tc, "password : <non-null>");
                }
                BuildInfo.traceBuildInfo();
                if (connectionMetaData == null) {
                    connectionMetaData = JmsFactoryFactory.getInstance().getMetaData();
                }
                SibTr.debug(tc, "JMS build version : " + connectionMetaData.getProviderVersion());
            }
            JmsJcaConnection jmsJcaConnection = null;
            try {
                jmsJcaConnection = string == null && string2 == null ? this.jcaConnectionFactory.createConnection() : this.jcaConnectionFactory.createConnection(string, string2);
            }
            catch (SIAuthenticationException sIAuthenticationException) {
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHENTICATION_FAILED_CWSIA0004", null, sIAuthenticationException, null, this, tcInt);
            }
            catch (SINotAuthorizedException sINotAuthorizedException) {
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0006", null, sINotAuthorizedException, null, this, tcInt);
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0241", new Object[]{sIException, "JmsManagedConnectionFactoryImpl.createConnection"}, sIException, "JmsManagedConnectionFactoryImpl.createConnection#3", this, tcInt);
            }
            catch (ResourceException resourceException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JCA_RESOURCE_EXC_CWSIA0005", null, resourceException, null, this, tcInt);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("clientID", this.getClientID());
            hashMap.put("nonPersistentMapping", this.getNonPersistentMapping());
            hashMap.put("persistentMapping", this.getPersistentMapping());
            hashMap.put("readAhead", this.getReadAhead());
            hashMap.put("durableSubscriptionHome", this.getDurableSubscriptionHome());
            hashMap.put("tempQueueNamePrefix", this.getTemporaryQueueNamePrefix());
            hashMap.put("tempTopicNamePrefix", this.getTemporaryTopicNamePrefix());
            hashMap.put("shareDurableSubscriptions", this.getShareDurableSubscriptions());
            hashMap.put("busName", this.getBusName());
            jmsConnectionImpl = jmsConnectionImpl2 = this.instantiateConnection(jmsJcaConnection, hashMap);
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            block15: {
                Object var8_12 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return Connection : " + jmsConnectionImpl2);
                }
                if (!tc.isEntryEnabled()) break block15;
                SibTr.exit(tc, "createConnection(String, String)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return Connection : " + jmsConnectionImpl2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createConnection(String, String)");
        }
        return jmsConnectionImpl;
    }

    public String getClientID() {
        String string;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getClientID()");
        }
        if ((string = this.jcaConnectionFactory.getClientID()) != null && "".equals(string)) {
            string = null;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getClientID()");
        }
        return string;
    }

    public String getNonPersistentMapping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getNonPersistentMapping()");
        }
        String string = this.jcaConnectionFactory.getNonPersistentMapping();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return String : " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getNonPersistentMapping()");
        }
        return string;
    }

    public boolean isManaged() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isManaged()");
        }
        String string = null;
        try {
            string = System.getProperty("com.ibm.ws.sib.api.isManaged");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            bl = this.jcaConnectionFactory.isManaged();
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "isManaged being overridden by system property: " + string);
            }
            bl = (string = string.toUpperCase()).equals("TRUE") || string.equals("YES");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return boolean : " + bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isManaged()");
        }
        return bl;
    }

    public String getReadAhead() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getReadAhead()");
        }
        String string = this.jcaConnectionFactory.getReadAhead();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return string : " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getReadAhead()");
        }
        return string;
    }

    public String getDurableSubscriptionHome() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getDurableSubscriptionHome()");
        }
        String string = this.jcaConnectionFactory.getDurableSubscriptionHome();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return string : " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDurableSubscriptionHome()");
        }
        return string;
    }

    public String getTemporaryQueueNamePrefix() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getTemporaryQueueNamePrefix");
        }
        String string = this.jcaConnectionFactory.getTemporaryQueueNamePrefix();
        if (tcInt.isEntryEnabled()) {
            SibTr.debug(tcInt, "Returning queue prefix: " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getTemporaryQueueNamePrefix");
        }
        return string;
    }

    public String getTemporaryTopicNamePrefix() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getTemporaryTopicNamePrefix");
        }
        String string = this.jcaConnectionFactory.getTemporaryTopicNamePrefix();
        if (tcInt.isEntryEnabled()) {
            SibTr.debug(tcInt, "Returning topic prefix: " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getTemporaryTopicNamePrefix");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsConnectionImpl instantiateConnection(JmsJcaConnection jmsJcaConnection, Map map) throws JMSException {
        JmsConnectionImpl jmsConnectionImpl;
        JmsConnectionImpl jmsConnectionImpl2 = null;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "instantiateConnection(JmsJcaConnection, Map)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "jcaConnection : " + jmsJcaConnection);
            }
            jmsConnectionImpl = jmsConnectionImpl2 = new JmsConnectionImpl(jmsJcaConnection, this.isManaged(), map);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var6_6 = null;
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "return JmsConnectionImpl : " + jmsConnectionImpl2);
                }
                if (!tcInt.isEntryEnabled()) break block7;
                SibTr.exit(tcInt, "instantiateConnection(JmsJcaConnection, Map)");
            }
            throw throwable;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return JmsConnectionImpl : " + jmsConnectionImpl2);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "instantiateConnection(JmsJcaConnection, Map)");
        }
        return jmsConnectionImpl;
    }

    public String getPersistentMapping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getPersistentMapping()");
        }
        String string = this.jcaConnectionFactory.getPersistentMapping();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return String : " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getNonPersistentMapping()");
        }
        return string;
    }

    public String getBusName() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getBusName()");
        }
        String string = this.jcaConnectionFactory.getBusName();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getBusName()");
        }
        return string;
    }

    public String getUserName() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getUserName()");
        }
        String string = this.jcaConnectionFactory.getUserName();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getUserName()");
        }
        return string;
    }

    public String getConnectionProximity() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getConnectionProximity");
        }
        String string = this.jcaConnectionFactory.getConnectionProximity();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getConnectionProximity");
        }
        return string;
    }

    public String getProviderEndpoints() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getProviderEndpoints");
        }
        String string = this.jcaConnectionFactory.getProviderEndpoints();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getProviderEndpoints");
        }
        return string;
    }

    public String getTargetTransportChain() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getTargetTransportChain");
        }
        String string = this.jcaConnectionFactory.getTargetTransportChain();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getTargetTransportChain");
        }
        return string;
    }

    public String getTarget() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getTarget");
        }
        String string = this.jcaConnectionFactory.getTarget();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getTarget");
        }
        return string;
    }

    public String getTargetType() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getTargetType");
        }
        String string = this.jcaConnectionFactory.getTargetType();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getTargetType");
        }
        return string;
    }

    public String getShareDurableSubscriptions() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getShareDurableSubscriptions");
        }
        String string = null;
        string = this.jcaConnectionFactory.getShareDurableSubscriptions();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getShareDurableSubscriptions");
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JmsJcaConnectionFactory jmsJcaConnectionFactory = ((JmsManagedConnectionFactoryImpl)object).jcaConnectionFactory;
        if (this.jcaConnectionFactory == jmsJcaConnectionFactory) {
            return true;
        }
        if (this.jcaConnectionFactory != null) {
            return this.jcaConnectionFactory.equals(jmsJcaConnectionFactory);
        }
        return false;
    }

    public int hashCode() {
        return this.jcaConnectionFactory.hashCode();
    }

    public String getTargetSignificance() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTargetSignificance");
        }
        String string = this.jcaConnectionFactory.getTargetSignificance();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returning " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTargetSignificance");
        }
        return string;
    }

    public String getMulticastInterface() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMulticastInterface");
        }
        String string = this.jcaConnectionFactory.getMulticastInterface();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returning " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMulticastInterface");
        }
        return string;
    }

    public String getSubscriptionProtocol() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSubscriptionProtocol");
        }
        String string = this.jcaConnectionFactory.getSubscriptionProtocol();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returning " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSubscriptionProtocol");
        }
        return string;
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsManagedConnectionFactoryImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.45");
        }
        connectionMetaData = null;
    }
}

