/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.impl.ConsumerProperties;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicSubscriberImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;

public class JmsDurableSubscriberImpl
extends JmsTopicSubscriberImpl {
    private static TraceComponent tcInt = SibTr.register(JmsDurableSubscriberImpl.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static byte NOT_TRIED;
    private static byte COMPLETE;
    private static byte REQUEST_ALTER;
    private static byte TRY_CREATE;
    static final boolean DEVT_DEBUG = false;

    public JmsDurableSubscriberImpl(SICoreConnection sICoreConnection, JmsSessionImpl jmsSessionImpl, ConsumerProperties consumerProperties) throws JMSException {
        super(sICoreConnection, jmsSessionImpl, consumerProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConsumerSession createCoreConsumer(SICoreConnection sICoreConnection, ConsumerProperties consumerProperties) throws JMSException {
        ConsumerSession consumerSession;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "createCoreConsumer(SICoreConnection, ConsumerProperties)");
            }
            ConsumerSession consumerSession2 = null;
            String string = consumerProperties.getClientID();
            String string2 = consumerProperties.getSubName();
            String string3 = consumerProperties.getDurableSubscriptionHome();
            String string4 = JmsInternalsFactory.getSharedUtils().getCoreDurableSubName(string, string2);
            JmsDestinationImpl jmsDestinationImpl = (JmsDestinationImpl)consumerProperties.getJmsDestination();
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "subscriptionName: " + string4);
                SibTr.debug(tcInt, "        destName: " + jmsDestinationImpl.getDestName());
                SibTr.debug(tcInt, "         discrim: " + jmsDestinationImpl.getDestDiscrim());
                SibTr.debug(tcInt, "        selector: " + consumerProperties.getSelector());
                SibTr.debug(tcInt, "       readAhead: " + consumerProperties.readAhead());
                SibTr.debug(tcInt, "supportsMultiple: " + consumerProperties.supportsMultipleConsumers());
                SibTr.debug(tcInt, "         noLocal: " + consumerProperties.noLocal());
                SibTr.debug(tcInt, "  durableSubHome: " + consumerProperties.getDurableSubscriptionHome());
                if (!(consumerProperties.supportsMultipleConsumers() ^ consumerProperties.readAhead())) {
                    if (consumerProperties.supportsMultipleConsumers()) {
                        SibTr.debug(tcInt, "WARNING: shareDurableSubs and readAhead are both ON.");
                        SibTr.debug(tcInt, "  This could lead to all messages being streamed to a single consumer.");
                        SibTr.debug(tcInt, "  which is inefficient.");
                    } else {
                        SibTr.debug(tcInt, "WARNING: shareDurableSubs and readAhead are both OFF.");
                        SibTr.debug(tcInt, "  This prevents the readAhead optimisation from taking place");
                        SibTr.debug(tcInt, "  to pass messages pre-emptively to the single consumer.");
                        SibTr.debug(tcInt, "  Performance would be improved if readAhead was DEFAULT or ON");
                    }
                }
            }
            byte by = NOT_TRIED;
            SIDestinationAddress sIDestinationAddress = jmsDestinationImpl.getConsumerSIDestinationAddress();
            SelectionCriteria selectionCriteria = null;
            try {
                selectionCriteria = this.selectionCriteriaFactory.createSelectionCriteria(jmsDestinationImpl.getDestDiscrim(), consumerProperties.getSelector(), SelectorDomain.JMS);
            }
            catch (SIErrorException sIErrorException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0221", new Object[]{sIErrorException, "JmsDurableSubscriberImpl.createCoreConsumer (#10)"}, sIErrorException, "JmsDurableSubscriberImpl.createCoreConsumer#10", this, tcInt);
            }
            do {
                try {
                    if (by == REQUEST_ALTER) {
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "Try to delete subscription: " + string4);
                        }
                        sICoreConnection.deleteDurableSubscription(string4, string3);
                        by = TRY_CREATE;
                    }
                    if (by == TRY_CREATE) {
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "Try to create subscription: " + string4);
                        }
                        sICoreConnection.createDurableSubscription(string4, string3, sIDestinationAddress, selectionCriteria, consumerProperties.supportsMultipleConsumers(), consumerProperties.noLocal(), null);
                    }
                    consumerSession2 = sICoreConnection.createConsumerSessionForDurableSubscription(string4, string3, sIDestinationAddress, selectionCriteria, consumerProperties.supportsMultipleConsumers(), consumerProperties.noLocal(), null, consumerProperties.readAhead(), Reliability.NONE, false, null);
                    by = COMPLETE;
                }
                catch (SIDurableSubscriptionMismatchException sIDurableSubscriptionMismatchException) {
                    if (by != REQUEST_ALTER) {
                        by = REQUEST_ALTER;
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "Exception received from createDurableSubscription", sIDurableSubscriptionMismatchException);
                        }
                        if (!tcInt.isDebugEnabled()) continue;
                        SibTr.debug(tcInt, "Now try to alter the subscription");
                        continue;
                    }
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "SHOULDN'T HAVE GOT HERE, PLEASE REPORT/INVESTIGATE");
                    }
                    throw (JMSException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "EXCEPTION_RECEIVED_CWSIA0221", new Object[]{sIDurableSubscriptionMismatchException, "JmsDurableSubscriberImpl.createCoreConsumer (#1)"}, sIDurableSubscriptionMismatchException, "JmsDurableSubscriberImpl.createCoreConsumer#1", this, tcInt);
                }
                catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "CONN_CLOSED_CWSIA0222", null, sIConnectionUnavailableException, null, this, tcInt);
                }
                catch (SIDestinationLockedException sIDestinationLockedException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "DEST_LOCKED_CWSIA0223", null, sIDestinationLockedException, null, this, tcInt);
                }
                catch (SIDurableSubscriptionNotFoundException sIDurableSubscriptionNotFoundException) {
                    if (by != TRY_CREATE) {
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "The durable subscription could not be found - create it");
                        }
                        by = TRY_CREATE;
                        continue;
                    }
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "The durable subscription was not found after create. Resetting to NOT_TRIED");
                    }
                    by = NOT_TRIED;
                }
                catch (SINotAuthorizedException sINotAuthorizedException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "NOT_AUTH_CWSIA0224", null, sINotAuthorizedException, null, this, tcInt);
                }
                catch (SISelectorSyntaxException sISelectorSyntaxException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(InvalidSelectorException.class, "BAD_SELECT_CWSIA0225", null, sISelectorSyntaxException, null, this, tcInt);
                }
                catch (SIDurableSubscriptionAlreadyExistsException sIDurableSubscriptionAlreadyExistsException) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Subscription already exists - this may be a timing issue with multiple clients");
                        SibTr.debug(tcInt, "since the first time we tried to connect to it, it didn't exist!");
                        SibTr.debug(tcInt, "resetting create_state to NOT_TRIED");
                    }
                    by = NOT_TRIED;
                }
                catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "The topicSpace is non-permanent or does not exist.");
                    }
                    throw (JMSException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "BAD_TOPICSPACE_CWSIA0226", null, sINotPossibleInCurrentConfigurationException, null, this, tcInt);
                }
                catch (SIException sIException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0221", new Object[]{sIException, "JmsDurableSubscriberImpl.createCoreConsumer (#9)"}, sIException, "JmsDurableSubscriberImpl.createCoreConsumer#9", this, tcInt);
                }
            } while (by != COMPLETE);
            consumerSession = consumerSession2;
            Object var14_23 = null;
        }
        catch (Throwable throwable) {
            block33: {
                Object var14_24 = null;
                if (!tcInt.isEntryEnabled()) break block33;
                SibTr.exit(tcInt, "createCoreConsumer(SICoreConnection, ConsumerProperties)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "createCoreConsumer(SICoreConnection, ConsumerProperties)");
        }
        return consumerSession;
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsDurableSubscriberImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.36");
        }
        NOT_TRIED = 1;
        COMPLETE = (byte)2;
        REQUEST_ALTER = (byte)3;
        TRY_CREATE = (byte)4;
    }
}

