/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsDestInternals;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.StringArrayWrapper;
import com.ibm.ws.sib.api.jms._FRPHelper;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsFactoryFactoryImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.MsgDestEncodingUtilsImpl;
import com.ibm.ws.sib.api.jms.impl.URIDestinationCreator;
import com.ibm.ws.sib.api.jmsra.JmsJcaReferenceUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;

public class JmsDestinationImpl
implements JmsDestination,
ApiJmsConstants,
JmsInternalConstants,
_FRPHelper,
JmsDestInternals {
    private static final long serialVersionUID = 1503547629070926432L;
    private static TraceComponent tc;
    private static TraceComponent tcInt;
    static final String NAME_SEPARATOR = "://";
    public static final String DEST_STEM = "dest";
    public static final String DEST_PREFIX = "dest://";
    private Map properties = null;
    private transient String cachedEncodedString = null;
    private transient byte[] cachedEncodedBytes = null;
    private transient String cachedPartialEncodedString = null;
    private transient byte[] cachedPartialEncodedBytes = null;
    private transient SIDestinationAddress producerDestinationAddress = null;
    private transient SIDestinationAddress consumerDestinationAddress = null;
    protected static JmsJcaReferenceUtils refUtils;
    private static MsgDestEncodingUtilsImpl destEncoder;

    JmsDestinationImpl() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsDestinationImpl");
        }
        this.properties = new HashMap();
        this.properties.put("readAhead", "AsConnection");
        this.properties.put("deliveryMode", "Application");
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsDestinationImpl");
        }
    }

    JmsDestinationImpl(Reference reference) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsDestinationImpl(Reference)");
        }
        this.properties = refUtils.getMapFromReference(reference);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsDestinationImpl(Reference)");
        }
    }

    public String getDestName() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getDestName()");
        }
        String string = (String)this.properties.get("DEST_NAME");
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getDestName()");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDestName(String string) throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "setDestName(String)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "destName : " + string);
            }
            if (null == string || "".equals(string)) {
                throw (JMSException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"destName", string}, tcInt);
            }
            this.updateProperty("DEST_NAME", string);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "setDestName(String)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setDestName(String)");
        }
    }

    public String getDestDiscrim() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getDestDiscrim()");
        }
        String string = (String)this.properties.get("DEST_DISCRIM");
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getDestDiscrim()");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDestDiscrim(String string) throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "setDestDiscrim(String)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "destDiscrim : " + string);
            }
            this.updateProperty("DEST_DISCRIM", string);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "setDestDiscrim(String)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setDestDiscrim(String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference getReference() throws NamingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getReference");
        }
        Reference reference = new Reference(this.getClass().getName(), JmsFactoryFactoryImpl.class.getName(), null);
        Map map = this.properties;
        synchronized (map) {
            refUtils.populateReference(reference, this.properties);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returns reference: " + reference);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getReference");
        }
        return reference;
    }

    protected boolean isProducerTypeCheck() {
        List list;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "isProducerTypeCheck");
        }
        boolean bl = true;
        StringArrayWrapper stringArrayWrapper = (StringArrayWrapper)this.properties.get("forwardRP");
        if (stringArrayWrapper != null && (list = stringArrayWrapper.getMsgForwardRoutingPath()) != null && list.size() > 0) {
            bl = false;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + bl);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "isProducerTypeCheck");
        }
        return bl;
    }

    protected String getProducerDestName() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getProducerDestName");
        }
        String string = null;
        StringArrayWrapper stringArrayWrapper = (StringArrayWrapper)this.properties.get("forwardRP");
        if (stringArrayWrapper == null) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "No forward routing path to examine");
            }
            string = this.getDestName();
        } else {
            SIDestinationAddress sIDestinationAddress;
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "There is a forward routing path to examine.");
            }
            if ((sIDestinationAddress = stringArrayWrapper.getProducerSIDestAddress()) != null) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Using first element of FRP as producer dest name");
                }
                string = sIDestinationAddress.getDestinationName();
            } else {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "FRP is empty - use original dest name");
                }
                string = this.getDestName();
            }
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getProducerDestName");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getConsumerDestName() throws JMSException {
        String string;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "getConsumerDestName");
            }
            String string2 = this.getDestName();
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "returns: " + string2);
            }
            string = string2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!tcInt.isEntryEnabled()) break block5;
                SibTr.exit(tcInt, "getConsumerDestName");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getConsumerDestName");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkNativeInstance(Destination destination) throws InvalidDestinationException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "checkNativeInstance(Destination)");
            }
            if (destination == null) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"Destination", destination}, tcInt);
            }
            if (!(destination instanceof JmsDestinationImpl)) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "FOREIGN_IMPLEMENTATION_CWSIA0046", new Object[]{destination}, tcInt);
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "checkNativeInstance(Destination)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "checkNativeInstance(Destination)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getCopyOfProperties() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getCopyOfProperties");
        }
        HashMap hashMap = new HashMap();
        Map map = this.properties;
        synchronized (map) {
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this.properties.get(string);
                hashMap.put(string, v);
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getCopyOfProperties");
        }
        return hashMap;
    }

    protected void invalidateCache() {
        this.cachedEncodedString = null;
        this.cachedPartialEncodedString = null;
        this.cachedPartialEncodedBytes = null;
        this.cachedEncodedBytes = null;
        this.producerDestinationAddress = null;
        this.consumerDestinationAddress = null;
    }

    String fullEncode() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "fullEncode()");
        }
        String string = null;
        if (this.cachedEncodedString != null) {
            string = this.cachedEncodedString;
        } else {
            Map map = this.getCopyOfProperties();
            this.cachedEncodedString = string = this.encodeMap(map);
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "encoded : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "fullEncode()");
        }
        return string;
    }

    byte[] fullEncodeToBytes() throws JMSException {
        if (this.cachedEncodedBytes == null) {
            this.cachedEncodedBytes = JmsInternalsFactory.getMessageDestEncodingUtils().getMessageRepresentationFromDest(this, true);
        }
        return this.cachedEncodedBytes;
    }

    private String encodeMap(Map map) {
        Object object;
        String string;
        String string2;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "encodeMap");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = (String)objectArray[i];
            string = map.get(string2);
            if (string instanceof String) {
                string = URIDestinationCreator.escapeValueString(string);
            }
            if ((object = destEncoder.getDefaultPropertyValue(string2)) == null && object == string || object != null && object.equals(string)) {
                map.remove(string2);
                continue;
            }
            if (this instanceof JmsQueue && !string2.equals("DEST_NAME")) {
                hashMap.put(string2, string);
                continue;
            }
            if (!(this instanceof JmsTopic) || "DEST_DISCRIM".equals(string2) || "DEST_NAME".equals(string2) || "Default.Topic.Space".equals(string) || string == null) continue;
            hashMap.put(string2, string);
        }
        Iterator iterator = hashMap.keySet().iterator();
        string2 = "";
        string = "";
        if (this instanceof JmsQueue) {
            stringBuffer.append("queue://");
            string2 = (String)map.remove("DEST_NAME");
            if (string2 == null) {
                string2 = "";
            }
            string2 = URIDestinationCreator.escapeDestName(string2);
            if (iterator.hasNext()) {
                stringBuffer.append(string2);
                stringBuffer.append("?");
            } else {
                stringBuffer.append(string2);
            }
        } else if (this instanceof JmsTopic) {
            stringBuffer.append("topic://");
            string2 = (String)map.remove("DEST_DISCRIM");
            string = (String)map.remove("DEST_NAME");
            if (string2 == null) {
                string2 = "";
            }
            if (string == null) {
                string = "";
            }
            string2 = URIDestinationCreator.escapeDestName(string2);
            string = URIDestinationCreator.escapeValueString(string);
            stringBuffer.append(string2);
            if (!"Default.Topic.Space".equals(string)) {
                stringBuffer.append("?topicSpace=");
                stringBuffer.append(string);
                if (iterator.hasNext()) {
                    stringBuffer.append("&");
                }
            } else if (iterator.hasNext()) {
                stringBuffer.append("?");
            }
        } else if (tcInt.isEntryEnabled()) {
            SibTr.debug(tcInt, "Destination in question is neither a JmsQueue of JmsTopic");
        }
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Object v = hashMap.get(object);
            stringBuffer.append((String)object);
            stringBuffer.append("=");
            stringBuffer.append(v);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("&");
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "encodeMap");
        }
        return stringBuffer.toString();
    }

    String partialEncode() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "partialEncode()");
        }
        String string = null;
        if (this.cachedPartialEncodedString != null) {
            string = this.cachedPartialEncodedString;
        } else {
            Map map = this.getCopyOfProperties();
            map.remove("DEST_NAME");
            map.remove("DEST_DISCRIM");
            map.remove("priority");
            map.remove("timeToLive");
            map.remove("forwardRP");
            map.remove("reverseRP");
            this.cachedPartialEncodedString = string = this.encodeMap(map);
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "encoded : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "partialEncode()");
        }
        return string;
    }

    byte[] partialEncodeToBytes() throws JMSException {
        if (this.cachedPartialEncodedBytes == null) {
            this.cachedPartialEncodedBytes = JmsInternalsFactory.getMessageDestEncodingUtils().getMessageRepresentationFromDest(this, false);
        }
        return this.cachedPartialEncodedBytes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Map map = this.properties;
        Map map2 = ((JmsDestinationImpl)object).properties;
        if (map == map2) {
            return true;
        }
        if (map != null) {
            return ((Object)map).equals(map2);
        }
        return false;
    }

    public int hashCode() {
        if (this.properties != null) {
            return ((Object)this.properties).hashCode();
        }
        return 0;
    }

    public void setDeliveryMode(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setDeliveryMode");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "dm: " + string);
        }
        if (!("Application".equals(string) || "NonPersistent".equals(string) || "Persistent".equals(string))) {
            String string2 = "INVALID_VALUE_CWSIA0281";
            Object[] objectArray = new Object[]{"deliveryMode", string};
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setDeliveryMode");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, string2, objectArray, tc);
        }
        this.updateProperty("deliveryMode", string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setDeliveryMode");
        }
    }

    public String getDeliveryMode() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getDeliveryMode");
        }
        String string = (String)this.properties.get("deliveryMode");
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returns String: " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDeliveryMode");
        }
        return string;
    }

    public void setTimeToLive(Long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setTimeToLive");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "timeToLive: " + l);
        }
        if (l == null) {
            this.updateProperty("timeToLive", null);
        } else if (l == -2L) {
            this.updateProperty("timeToLive", null);
        } else if (l >= 0L && l <= 9191815209357175807L) {
            this.updateProperty("timeToLive", l);
        } else {
            String string = "INVALID_VALUE_CWSIA0281";
            Object[] objectArray = new Object[]{"timeToLive", l};
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setTimeToLive");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, string, objectArray, tc);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setTimeToLive");
        }
    }

    public Long getTimeToLive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTimeToLive");
        }
        Long l = (Long)this.properties.get("timeToLive");
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returns Long: " + l);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTimeToLive");
        }
        return l;
    }

    public void setPriority(Integer n) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setPriority");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "priority: " + n);
        }
        if (n == null) {
            this.updateProperty("priority", null);
        } else if (n == -2) {
            this.updateProperty("priority", null);
        } else if (0 <= n && n <= 9) {
            this.updateProperty("priority", n);
        } else {
            String string = "INVALID_VALUE_CWSIA0281";
            Object[] objectArray = new Object[]{"priority", n};
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setPriority");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, string, objectArray, tc);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setPriority");
        }
    }

    public Integer getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getPriority");
        }
        Integer n = (Integer)this.properties.get("priority");
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returns Integer: " + n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getPriority");
        }
        return n;
    }

    public String getReadAhead() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getReadAhead");
        }
        String string = (String)this.properties.get("readAhead");
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "readAhead: " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getReadAhead");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadAhead(String string) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setReadAhead(String)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "new readAhead: " + string);
            }
            if (string == null || "".equals(string) || !"AsConnection".equals(string) && !"AlwaysOn".equals(string) && !"AlwaysOff".equals(string)) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"readAhead", string}, tc);
            }
            this.updateProperty("readAhead", string);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setReadAhead(String)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setReadAhead(String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForwardRoutingPath(String[] stringArray) throws JMSException {
        try {
            int n;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setForwardRoutingPath");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "param: " + stringArray);
                if (stringArray != null) {
                    SibTr.debug(tcInt, " size: " + stringArray.length);
                    for (n = 0; n < stringArray.length; ++n) {
                        SibTr.debug(tcInt, "  elt[" + n + "]: " + stringArray[n]);
                    }
                }
            }
            if (stringArray != null && stringArray.length == 0) {
                stringArray = null;
            }
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n] != null) continue;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Element " + n + " of the array is null.");
                    }
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"forwardPath[" + n + "]", "null"}, tc);
                }
            }
            this.invalidateCache();
            if (stringArray != null) {
                this.properties.put("forwardRP", StringArrayWrapper.create(stringArray, this.getDestName()));
            } else {
                this.properties.remove("forwardRP");
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setForwardRoutingPath");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setForwardRoutingPath");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureDestinationFromRoutingPath(List list) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setForwardRoutingPath(List)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "param: " + list);
            }
            this.invalidateCache();
            if (list != null && list.size() > 0) {
                int n = list.size() - 1;
                SIDestinationAddress sIDestinationAddress = (SIDestinationAddress)list.get(n);
                String string = sIDestinationAddress.getDestinationName();
                this.setDestName(string);
                String string2 = sIDestinationAddress.getBusName();
                this.setBusName(string2);
                if (list.size() > 1) {
                    this.properties.put("forwardRP", new StringArrayWrapper(list));
                }
            } else {
                this.properties.remove("forwardRP");
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setForwardRoutingPath(List)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setForwardRoutingPath(List)");
        }
    }

    protected List getConvertedFRP() {
        StringArrayWrapper stringArrayWrapper = (StringArrayWrapper)this.properties.get("forwardRP");
        List list = null;
        if (stringArrayWrapper != null) {
            list = stringArrayWrapper.getMsgForwardRoutingPath();
        }
        return list;
    }

    protected List getConvertedRRP() {
        StringArrayWrapper stringArrayWrapper = (StringArrayWrapper)this.properties.get("reverseRP");
        List list = null;
        if (stringArrayWrapper != null) {
            list = stringArrayWrapper.getCorePath();
        }
        return list;
    }

    public String[] getForwardRoutingPath() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getForwardRoutingPath");
        }
        StringArrayWrapper stringArrayWrapper = (StringArrayWrapper)this.properties.get("forwardRP");
        String[] stringArray = null;
        if (stringArrayWrapper != null) {
            stringArray = stringArrayWrapper.getArray();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returns String[]: " + stringArray);
            if (stringArray != null) {
                SibTr.debug(tc, "          length: " + stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    SibTr.debug(tc, "          elt[" + i + "]: " + stringArray[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getForwardRoutingPath");
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReverseRoutingPath(String[] stringArray) throws JMSException {
        try {
            int n;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setReverseRoutingPath");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "param: " + stringArray);
                if (stringArray != null) {
                    SibTr.debug(tcInt, " size: " + stringArray.length);
                    for (n = 0; n < stringArray.length; ++n) {
                        SibTr.debug(tcInt, "  elt[" + n + "]: " + stringArray[n]);
                    }
                }
            }
            if (stringArray != null && stringArray.length == 0) {
                stringArray = null;
            }
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n] != null) continue;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Element " + n + " of the array is null.");
                    }
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"reversePath[" + n + "]", "null"}, tc);
                }
            }
            this.invalidateCache();
            if (stringArray != null) {
                this.properties.put("reverseRP", StringArrayWrapper.create(stringArray, this.getDestName()));
            } else {
                this.properties.remove("reverseRP");
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setReverseRoutingPath");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setReverseRoutingPath");
        }
    }

    public String[] getReverseRoutingPath() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getReverseRoutingPath");
        }
        StringArrayWrapper stringArrayWrapper = (StringArrayWrapper)this.properties.get("reverseRP");
        String[] stringArray = null;
        if (stringArrayWrapper != null) {
            stringArray = stringArrayWrapper.getArray();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returns String[]: " + stringArray);
            if (stringArray != null) {
                SibTr.debug(tc, "          length: " + stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    SibTr.debug(tc, "          elt[" + i + "]: " + stringArray[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getReverseRoutingPath");
        }
        return stringArray;
    }

    public boolean _getInhibitJMSDestination() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "_getInhibitJMSDestination");
        }
        boolean bl = false;
        if (this.properties.get("inhibitJMSDest") != null) {
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "inhibit state: " + bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "_getInhibitJMSDestination");
        }
        return bl;
    }

    public void _setInhibitJMSDestination(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "_setInhibitJMSDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "inhibit state: " + bl);
        }
        if (bl) {
            this.properties.put("inhibitJMSDest", "yes");
        } else {
            this.properties.remove("inhibitJMSDest");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "_setInhibitJMSDestination");
        }
    }

    protected SIDestinationAddress getProducerSIDestinationAddress() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getProducerSIDestinationAddress");
        }
        if (this.producerDestinationAddress == null) {
            StringArrayWrapper stringArrayWrapper;
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "No cached value");
            }
            if ((stringArrayWrapper = (StringArrayWrapper)this.properties.get("forwardRP")) != null) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Obtain from the frp data.");
                }
                this.producerDestinationAddress = stringArrayWrapper.getProducerSIDestAddress();
            }
            if (this.producerDestinationAddress == null) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Either FRP was empty, or no FRP at all - create from big dest info.");
                }
                this.producerDestinationAddress = JmsMessageImpl.destAddressFactory.createSIDestinationAddress(this.getProducerDestName(), this.getBusName());
            }
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + this.producerDestinationAddress);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getProducerSIDestinationAddress");
        }
        return this.producerDestinationAddress;
    }

    protected SIDestinationAddress getConsumerSIDestinationAddress() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getConsumerSIDestinationAddress");
        }
        if (this.consumerDestinationAddress == null) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "No cached value - create a new one.");
            }
            this.consumerDestinationAddress = JmsMessageImpl.destAddressFactory.createSIDestinationAddress(this.getConsumerDestName(), this.getBusName());
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + this.consumerDestinationAddress);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getConsumerSIDestinationAddress");
        }
        return this.consumerDestinationAddress;
    }

    public String getBusName() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getBusName()");
        }
        String string = (String)this.properties.get("busName");
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getBusName()");
        }
        return string;
    }

    public void setBusName(String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "setBusName(String)");
        }
        if (string != null && string.equals("")) {
            string = null;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "busName : " + string);
        }
        this.updateProperty("busName", string);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setBusName(String)");
        }
    }

    public void setBlockedDestinationCode(Integer n) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "setBlockedDestinationCode");
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.debug(tcInt, "blocked destination code = " + n);
        }
        this.updateProperty("blockedDestinationCode", n);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setBlockedDestinationCode");
        }
    }

    private boolean isDifferent(String string, Object object) {
        Object v = this.properties.get(string);
        if (v == null) {
            return object != null;
        }
        return !v.equals(object);
    }

    private void updateProperty(String string, Object object) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "updateProperty");
        }
        if (this.isDifferent(string, object)) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "new value for " + string + ": " + object);
            }
            this.invalidateCache();
            this.properties.put(string, object);
        } else if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "value for " + string + " same as existing");
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "updateProperty");
        }
    }

    public Integer getBlockedDestinationCode() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getBlockedDestinationCode");
        }
        Integer n = (Integer)this.properties.get("blockedDestinationCode");
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "blockedDestinationCode : " + n);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getBlockedDestinationCode");
        }
        return n;
    }

    public static void checkBlockedStatus(JmsDestinationImpl jmsDestinationImpl) throws JMSException {
        Integer n;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "checkBlockedStatus");
        }
        if ((n = jmsDestinationImpl.getBlockedDestinationCode()) != null) {
            if (n.equals(JmsInternalConstants.PSB_REPLY_DATA_MISSING)) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "DESTINATION_BLOCKED_PSBREPLY_CWSIA0284", new Object[]{jmsDestinationImpl.toString()}, tc);
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "DESTINATION_BLOCKED_CWSIA0283", new Object[]{n}, tc);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "checkBlockedStatus");
        }
    }

    public String toString() {
        return this.fullEncode();
    }

    static {
        block6: {
            tc = Tr.register((Class)JmsDestinationImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
            tcInt = Tr.register((Class)JmsDestinationImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsDestinationImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.68.1.15");
            }
            try {
                Class.forName("com.ibm.ws.sib.api.jmsra.JmsJcaReferenceUtils");
                refUtils = JmsJcaReferenceUtils.getInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                JmsErrorUtils.processThrowable(classNotFoundException, "JmsDestinationImpl.<clinit>#1", JmsDestinationImpl.class, tc);
            }
            try {
                destEncoder = (MsgDestEncodingUtilsImpl)JmsInternalsFactory.getMessageDestEncodingUtils();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"JmsDestinationImpl.<clinit>", (String)"JmsDestinationImpl.<clinit>#1");
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Exception caught creating MsgDestEncodingUtilsImpl");
                }
                if (!tcInt.isDebugEnabled()) break block6;
                SibTr.exception(tcInt, (Exception)((Object)jMSException));
            }
        }
    }
}

