/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JMS390FloatSupport;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.ResourceAllocationException;

public class JmsBytesMessageImpl
extends JmsMessageImpl
implements BytesMessage {
    private static final long serialVersionUID = 1691954622519522063L;
    private JsJmsBytesMessage jsBytesMsg;
    private boolean bodySetInJsMsg = false;
    private int lastEncoding;
    private boolean requiresInit = false;
    private transient ByteArrayOutputStream _writeBytes;
    private transient DataOutputStream writeStream;
    private static final int ARRAY_SIZE = 20;
    private int integer_count;
    private int[] integer_offsets;
    private int[] integer_sizes;
    private Vector integers;
    private Vector float_offsets;
    private Vector float_values;
    private boolean populated_by_client = true;
    private byte[] dataBuffer;
    private int dataStart;
    private int integerEncoding = 1;
    private int floatEncoding = 256;
    private transient ByteArrayInputStream readStream;
    private int streamOffset;
    private boolean markInUse = false;
    private transient String cachedBytesToString = null;
    private static TraceComponent tc = Tr.register((Class)JmsBytesMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = Tr.register((Class)JmsBytesMessageImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    public JmsBytesMessageImpl() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsBytesMessageImpl");
        }
        this.clearBody();
        this.messageClass = "jms_bytes";
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsBytesMessageImpl");
        }
    }

    JmsBytesMessageImpl(JsJmsBytesMessage jsJmsBytesMessage, JmsSessionImpl jmsSessionImpl) {
        super(jsJmsBytesMessage, jmsSessionImpl);
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsBytesMessageImpl(JsJmsBytesMessage, JmsSessionImpl)");
        }
        this.jsBytesMsg = jsJmsBytesMessage;
        this.requiresInit = true;
        this.setBodyReadOnly();
        this.messageClass = "jms_bytes";
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsBytesMessageImpl(JsJmsBytesMessage, JmsSessionImpl)");
        }
    }

    private void lazyInit() {
        block6: {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "lazyInit");
            }
            this.requiresInit = false;
            this.dataBuffer = this.jsBytesMsg.getBytes();
            if (this.dataBuffer == null) {
                this.dataBuffer = new byte[0];
            }
            this.readStream = new ByteArrayInputStream(this.dataBuffer);
            this.dataStart = 0;
            try {
                if (this.propertyExists("JMS_IBM_Encoding")) {
                    int n = this.getIntProperty("JMS_IBM_Encoding");
                    this.integerEncoding = n & 0xF;
                    this.floatEncoding = n & 0xF00;
                }
            }
            catch (JMSException jMSException) {
                if (!tcInt.isDebugEnabled()) break block6;
                SibTr.debug(tcInt, "ignoring exception whilst getting encoding " + (Object)((Object)jMSException));
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "lazyInit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsBytesMessageImpl(BytesMessage bytesMessage) throws JMSException {
        super((Message)bytesMessage);
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "JmsBytesMessageImpl(BytesMessage)");
            }
            this.clearBody();
            bytesMessage.reset();
            int n = 0;
            long l = bytesMessage.getBodyLength();
            n = l > 32768L ? 32768 : (int)l;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while ((n2 = bytesMessage.readBytes(byArray)) > 0) {
                this.writeBytes(byArray, 0, n2);
            }
            this.messageClass = "jms_bytes";
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "JmsBytesMessageImpl(BytesMessage)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsBytesMessageImpl(BytesMessage)");
        }
    }

    protected JsJmsMessage instantiateMessage() throws Exception {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "instantiateMessage");
        }
        JsJmsBytesMessage jsJmsBytesMessage = null;
        try {
            jsJmsBytesMessage = jmfact.createJmsBytesMessage();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Error occurred creating message", messageCreateFailedException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "instantiateMessage");
            }
            throw messageCreateFailedException;
        }
        this.jsBytesMsg = jsJmsBytesMessage;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "instantiateMessage");
        }
        return jsJmsBytesMessage;
    }

    protected JsJmsMessage getMsgReference() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getMsgReference");
        }
        if (!this.isBodyReadOnly()) {
            int n = this.integerEncoding | this.floatEncoding;
            if (this.propertyExists("JMS_IBM_Encoding")) {
                n = this.getIntProperty("JMS_IBM_Encoding");
            }
            if (this.bodySetInJsMsg && n == this.lastEncoding) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "body cached");
                }
            } else {
                byte[] byArray = this._exportBody(n);
                this.jsBytesMsg.setBytes(byArray);
                this.lastEncoding = n;
                this.bodySetInJsMsg = true;
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getMsgReference");
        }
        return this.jsBytesMsg;
    }

    private byte[] _exportBody(int n) throws JMSException {
        byte[] byArray;
        block28: {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "_exportBody");
            }
            this.dataBuffer = this._writeBytes.toByteArray();
            this.dataStart = 0;
            if (this.populated_by_client) {
                int n2;
                Object object;
                Object object2;
                int n3 = n & 0xF;
                int n4 = n & 0xF00;
                if (this.integerEncoding <= 1 && n3 == 2 || this.integerEncoding == 2 && n3 <= 1) {
                    int n5;
                    if (this.integers != null) {
                        for (n5 = 0; n5 < this.integers.size(); n5 += 2) {
                            object2 = (int[])this.integers.elementAt(n5);
                            object = (int[])this.integers.elementAt(n5 + 1);
                            for (n2 = 0; n2 < 20; ++n2) {
                                this.reverse(this.dataBuffer, (int)object2[n2], (int)object[n2]);
                            }
                        }
                    }
                    for (n5 = 0; n5 < this.integer_count; ++n5) {
                        this.reverse(this.dataBuffer, this.integer_offsets[n5], this.integer_sizes[n5]);
                    }
                }
                if (this.floatEncoding != n4) {
                    object2 = new ByteArrayOutputStream(8);
                    object = new DataOutputStream((OutputStream)object2);
                    if (this.float_offsets != null && this.float_values != null) {
                        for (n2 = 0; n2 < this.float_offsets.size(); ++n2) {
                            ((ByteArrayOutputStream)object2).reset();
                            Object e = this.float_values.elementAt(n2);
                            int n6 = (Integer)this.float_offsets.elementAt(n2);
                            if (e instanceof Float) {
                                float f = ((Float)e).floatValue();
                                switch (n4) {
                                    case 256: 
                                    case 512: {
                                        ((DataOutputStream)object).writeInt(Float.floatToIntBits(f));
                                        break;
                                    }
                                    case 768: {
                                        ((DataOutputStream)object).writeInt(JMS390FloatSupport.floatToS390IntBits(f));
                                        break;
                                    }
                                    default: {
                                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BAD_ENCODING_CWSIA0181", new Object[]{Integer.toHexString(n4)}, tcInt);
                                    }
                                }
                                byte[] byArray2 = ((ByteArrayOutputStream)object2).toByteArray();
                                if (n4 == 512) {
                                    this.reverse(byArray2, 0, 4);
                                }
                                System.arraycopy(byArray2, 0, this.dataBuffer, n6, 4);
                                continue;
                            }
                            if (!(e instanceof Double)) continue;
                            double d = (Double)e;
                            switch (n4) {
                                case 256: 
                                case 512: {
                                    ((DataOutputStream)object).writeLong(Double.doubleToLongBits(d));
                                    break;
                                }
                                case 768: {
                                    ((DataOutputStream)object).writeLong(JMS390FloatSupport.doubleToS390LongBits(d));
                                    break;
                                }
                                default: {
                                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BAD_ENCODING_CWSIA0181", new Object[]{Integer.toHexString(n4)}, tcInt);
                                }
                            }
                            byte[] byArray3 = ((ByteArrayOutputStream)object2).toByteArray();
                            if (n4 == 512) {
                                this.reverse(byArray3, 0, 8);
                            }
                            System.arraycopy(byArray3, 0, this.dataBuffer, n6, 8);
                        }
                    }
                }
                break block28;
            }
            byte[] byArray4 = new byte[this.dataBuffer.length - this.dataStart];
            System.arraycopy(this.dataBuffer, this.dataStart, byArray4, 0, this.dataBuffer.length - this.dataStart);
            byte[] byArray5 = byArray4;
            Object var13_18 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "_exportBody");
            }
            return byArray5;
        }
        try {
            byArray = this.dataBuffer;
            Object var13_19 = null;
        }
        catch (IOException iOException) {
            try {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "DATA_STREAM_PROBLEM_CWSIA0182", null, iOException, "JmsBytesMessageImpl._exportBody#1", this, tcInt);
            }
            catch (Throwable throwable) {
                block29: {
                    Object var13_20 = null;
                    if (!tcInt.isEntryEnabled()) break block29;
                    SibTr.exit(tcInt, "_exportBody");
                }
                throw throwable;
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "_exportBody");
        }
        return byArray;
    }

    public void clearBody() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clearBody");
        }
        super.clearBody();
        this.dataBuffer = null;
        this.dataStart = 0;
        this.readStream = null;
        this._writeBytes = new ByteArrayOutputStream();
        this.writeStream = new DataOutputStream(this._writeBytes);
        this.populated_by_client = true;
        if (this.jsBytesMsg != null) {
            this.jsBytesMsg.setObjectProperty("JMS_IBM_Encoding", null);
            this.jsBytesMsg.setObjectProperty("JMS_IBM_Character_Set", null);
        }
        this.integerEncoding = 1;
        this.floatEncoding = 256;
        this.integer_count = 0;
        this.integer_offsets = new int[20];
        this.integer_sizes = new int[20];
        if (this.integers != null) {
            this.integers.removeAllElements();
        }
        if (this.float_offsets != null) {
            this.float_offsets.removeAllElements();
        }
        if (this.float_values != null) {
            this.float_values.removeAllElements();
        }
        this.cachedBytesToString = null;
        this.bodySetInJsMsg = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clearBody");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readBoolean() throws JMSException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readBoolean");
        }
        try {
            int n;
            this.checkBodyReadable("readBoolean");
            if (this.requiresInit) {
                this.lazyInit();
            }
            if ((n = this.readStream.read()) < 0) {
                throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
            }
            bl = n != 0;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (!tc.isEntryEnabled()) break block6;
                SibTr.exit(tc, "readBoolean");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readBoolean");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws JMSException {
        byte by;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readByte");
        }
        try {
            int n;
            this.checkBodyReadable("readByte");
            if (this.requiresInit) {
                this.lazyInit();
            }
            if ((n = this.readStream.read()) < 0) {
                throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
            }
            by = (byte)n;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (!tc.isEntryEnabled()) break block6;
                SibTr.exit(tc, "readByte");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readByte");
        }
        return by;
    }

    public int readBytes(byte[] byArray) throws JMSException {
        return this.readBytes(byArray, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray, int n) throws JMSException {
        int n2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readBytes");
        }
        try {
            this.checkBodyReadable("readBytes");
            if (this.requiresInit) {
                this.lazyInit();
            }
            if (byArray.length < n || n < 0) {
                throw new IndexOutOfBoundsException();
            }
            n2 = this.readStream.read(byArray, 0, n);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_5 = null;
                if (!tcInt.isEntryEnabled()) break block6;
                SibTr.exit(tcInt, "readBytes");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "readBytes");
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char readChar() throws JMSException {
        int n;
        int n2;
        block9: {
            char c;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "readChar");
            }
            try {
                this.checkBodyReadable("readChar");
                if (this.requiresInit) {
                    this.lazyInit();
                }
                if (!this.markInUse) {
                    this.readStream.mark(2);
                }
                n2 = this.readStream.read();
                n = this.readStream.read();
                if (n < 0) {
                    this.readStream.reset();
                    throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
                }
                if (this.integerEncoding != 2) break block9;
                c = (char)((n << 8) + n2);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var5_7 = null;
                    if (!tc.isEntryEnabled()) break block10;
                    SibTr.exit(tc, "readChar");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readChar");
            }
            return c;
        }
        char c = (char)((n2 << 8) + n);
        Object var5_6 = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readChar");
        }
        return c;
    }

    /*
     * Exception decompiling
     */
    public double readDouble() throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float readFloat() throws JMSException {
        float f;
        int n;
        block12: {
            float f2;
            block11: {
                float f3;
                if (tc.isEntryEnabled()) {
                    SibTr.entry(tc, "readFloat");
                }
                n = this.integerEncoding;
                try {
                    try {
                        switch (this.floatEncoding) {
                            case 256: {
                                this.integerEncoding = 1;
                                f3 = Float.intBitsToFloat(this.readInt());
                                Object var4_6 = null;
                                this.integerEncoding = n;
                                break;
                            }
                            case 512: {
                                this.integerEncoding = 2;
                                f2 = Float.intBitsToFloat(this.readInt());
                                break block11;
                            }
                            case 768: {
                                this.integerEncoding = 1;
                                f = JMS390FloatSupport.intS390BitsToFloat(this.readInt());
                                break block12;
                            }
                            default: {
                                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BAD_ENCODING_CWSIA0181", new Object[]{Integer.toHexString(this.floatEncoding)}, tc);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0190", new Object[]{iOException, "JmsBytesMessageImpl.readFloat"}, iOException, "JmsBytesMessageImpl.readFloat#1", this, tc);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    this.integerEncoding = n;
                    if (!tc.isEntryEnabled()) throw throwable;
                    SibTr.exit(tc, "readFloat");
                    throw throwable;
                }
                if (!tc.isEntryEnabled()) return f3;
                SibTr.exit(tc, "readFloat");
                return f3;
            }
            Object var4_7 = null;
            this.integerEncoding = n;
            if (!tc.isEntryEnabled()) return f2;
            SibTr.exit(tc, "readFloat");
            return f2;
        }
        Object var4_8 = null;
        this.integerEncoding = n;
        if (!tc.isEntryEnabled()) return f;
        SibTr.exit(tc, "readFloat");
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws JMSException {
        int n;
        int n2;
        int n3;
        int n4;
        block9: {
            int n5;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "readInt");
            }
            try {
                this.checkBodyReadable("readInt");
                if (this.requiresInit) {
                    this.lazyInit();
                }
                if (!this.markInUse) {
                    this.readStream.mark(4);
                }
                n4 = this.readStream.read();
                n3 = this.readStream.read();
                n2 = this.readStream.read();
                n = this.readStream.read();
                if (n < 0) {
                    this.readStream.reset();
                    throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
                }
                if (this.integerEncoding != 2) break block9;
                n5 = (n << 24) + (n2 << 16) + (n3 << 8) + n4;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var7_9 = null;
                    if (!tc.isEntryEnabled()) break block10;
                    SibTr.exit(tc, "readInt");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readInt");
            }
            return n5;
        }
        int n6 = (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        Object var7_8 = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readInt");
        }
        return n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws JMSException {
        long l;
        long l2;
        block7: {
            long l3;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "readLong");
            }
            try {
                this.checkBodyReadable("readLong");
                if (this.requiresInit) {
                    this.lazyInit();
                }
                this.readStream.mark(8);
                this.markInUse = true;
                l2 = (long)this.readInt() & 0xFFFFFFFFL;
                l = (long)this.readInt() & 0xFFFFFFFFL;
                if (this.integerEncoding != 2) break block7;
                l3 = (l << 32) + l2;
                Object var8_5 = null;
                this.markInUse = false;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var8_7 = null;
                    this.markInUse = false;
                    if (!tc.isEntryEnabled()) break block8;
                    SibTr.exit(tc, "readLong");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readLong");
            }
            return l3;
        }
        long l4 = (l2 << 32) + l;
        Object var8_6 = null;
        this.markInUse = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readLong");
        }
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort() throws JMSException {
        int n;
        int n2;
        block9: {
            short s;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "readShort");
            }
            try {
                this.checkBodyReadable("readShort");
                if (this.requiresInit) {
                    this.lazyInit();
                }
                if (!this.markInUse) {
                    this.readStream.mark(2);
                }
                n2 = this.readStream.read();
                n = this.readStream.read();
                if (n < 0) {
                    this.readStream.reset();
                    throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
                }
                if (this.integerEncoding != 2) break block9;
                s = (short)((n << 8) + n2);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var5_7 = null;
                    if (!tc.isEntryEnabled()) break block10;
                    SibTr.exit(tc, "readShort");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readShort");
            }
            return s;
        }
        short s = (short)((n2 << 8) + n);
        Object var5_6 = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readShort");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readUnsignedByte() throws JMSException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readUnsignedByte");
        }
        try {
            int n2;
            this.checkBodyReadable("readUnsignedByte");
            if (this.requiresInit) {
                this.lazyInit();
            }
            if ((n2 = this.readStream.read()) < 0) {
                throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
            }
            n = n2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (!tc.isEntryEnabled()) break block6;
                SibTr.exit(tc, "readUnsignedByte");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readUnsignedByte");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readUnsignedShort() throws JMSException {
        int n;
        int n2;
        block9: {
            int n3;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "readUnsignedShort");
            }
            try {
                this.checkBodyReadable("readUnsignedShort");
                if (this.requiresInit) {
                    this.lazyInit();
                }
                if (!this.markInUse) {
                    this.readStream.mark(2);
                }
                n2 = this.readStream.read();
                n = this.readStream.read();
                if (n < 0) {
                    this.readStream.reset();
                    throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
                }
                if (this.integerEncoding != 2) break block9;
                n3 = (n << 8) + n2;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var5_7 = null;
                    if (!tc.isEntryEnabled()) break block10;
                    SibTr.exit(tc, "readUnsignedShort");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readUnsignedShort");
            }
            return n3;
        }
        int n4 = (n2 << 8) + n;
        Object var5_6 = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readUnsignedShort");
        }
        return n4;
    }

    public String readUTF() throws JMSException {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readUTF");
        }
        int n = this.integerEncoding;
        try {
            this.checkBodyReadable("readUTF");
            if (this.requiresInit) {
                this.lazyInit();
            }
            this.readStream.mark(8);
            this.markInUse = true;
            this.integerEncoding = 1;
            int n2 = this.readUnsignedShort();
            byte[] byArray = new byte[n2];
            if (this.readBytes(byArray, n2) != n2) {
                this.readStream.reset();
                throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
            }
            string = new String(byArray, 0, n2, "UTF8");
            Object var6_6 = null;
            this.integerEncoding = n;
            this.markInUse = false;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "UTF8_CONV_CWSIA0184", null, unsupportedEncodingException, "JmsBytesMessage.readUTF#1", this, tc);
            }
            catch (Throwable throwable) {
                block8: {
                    Object var6_7 = null;
                    this.integerEncoding = n;
                    this.markInUse = false;
                    if (!tc.isEntryEnabled()) break block8;
                    SibTr.exit(tc, "readUTF");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readUTF");
        }
        return string;
    }

    private void recordInteger(int n, int n2) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "recordInteger");
        }
        if (this.integer_count == 20) {
            if (this.integers == null) {
                this.integers = new Vector();
            }
            this.integers.addElement(this.integer_offsets);
            this.integers.addElement(this.integer_sizes);
            this.integer_offsets = new int[20];
            this.integer_sizes = new int[20];
            this.integer_count = 0;
        }
        this.integer_offsets[this.integer_count] = n;
        this.integer_sizes[this.integer_count++] = n2;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "recordInteger");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "reset");
        }
        try {
            if (!this.isBodyReadOnly()) {
                this.dataBuffer = this._writeBytes.toByteArray();
                this.dataStart = 0;
                this.lastEncoding = this.integerEncoding | this.floatEncoding;
                this.jsBytesMsg.setBytes(this._exportBody(this.lastEncoding));
                this.bodySetInJsMsg = true;
                this.writeStream = null;
                this._writeBytes = null;
                this.setBodyReadOnly();
            }
            if (this.dataBuffer == null) {
                this.dataBuffer = new byte[0];
            }
            this.readStream = new ByteArrayInputStream(this.dataBuffer);
            this.readStream.skip(this.dataStart);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "reset");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "reset");
        }
    }

    private void reverse(byte[] byArray, int n, int n2) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "reverse");
        }
        for (int i = 0; i < n2 / 2; ++i) {
            byte by = byArray[n + i];
            byArray[n + i] = byArray[n + (n2 - 1) - i];
            byArray[n + (n2 - 1) - i] = by;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "reverse");
        }
    }

    public String toString() {
        if (this.cachedBytesToString == null) {
            StringBuffer stringBuffer;
            int n;
            int n2;
            block9: {
                n2 = 10;
                n = 40;
                stringBuffer = new StringBuffer();
                if (!this.isBodyReadOnly()) {
                    try {
                        this.getMsgReference();
                    }
                    catch (JMSException jMSException) {
                        if (!tcInt.isDebugEnabled()) break block9;
                        SibTr.debug(tcInt, "getMsgReference failed with " + (Object)((Object)jMSException));
                    }
                }
            }
            if (this.requiresInit) {
                this.lazyInit();
            }
            if (this.dataBuffer != null) {
                int n3 = this.dataStart;
                for (int i = 0; i < n2; ++i) {
                    if (this.dataBuffer.length <= n3 + n) {
                        JmsBytesMessageImpl.binToHex(this.dataBuffer, n3, this.dataBuffer.length - n3, stringBuffer);
                        n3 = this.dataBuffer.length;
                        stringBuffer.append("\n");
                        break;
                    }
                    JmsBytesMessageImpl.binToHex(this.dataBuffer, n3, n, stringBuffer);
                    stringBuffer.append("\n");
                    n3 += n;
                }
                if (n3 != this.dataBuffer.length) {
                    stringBuffer.append("...\n");
                }
            }
            this.cachedBytesToString = stringBuffer.toString();
        }
        String string = super.toString() + "\n" + this.cachedBytesToString;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBoolean(boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeBoolean");
        }
        try {
            this.checkBodyWriteable("writeBoolean");
            this.writeByte((byte)(bl ? 1 : 0));
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "writeBoolean");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeBoolean");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeByte(byte by) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeByte");
        }
        try {
            try {
                this.checkBodyWriteable("writeByte");
                this.writeStream.writeByte(by);
                this.cachedBytesToString = null;
                this.bodySetInJsMsg = false;
            }
            catch (IOException iOException) {
                throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, iOException, "JmsBytesMessageImpl.writeByte#1", this, tc);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeByte");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeByte");
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        this.writeBytes(byArray, 0, byArray.length);
        this.cachedBytesToString = null;
        this.bodySetInJsMsg = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeBytes");
        }
        try {
            try {
                this.checkBodyWriteable("writeBytes");
                this.writeStream.write(byArray, n, n2);
                this.cachedBytesToString = null;
                this.bodySetInJsMsg = false;
            }
            catch (IOException iOException) {
                throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, iOException, "JmsBytesMessageImpl.writeBytes#1", this, tc);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeBytes");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeBytes");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeChar(char c) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeChar");
        }
        try {
            try {
                this.checkBodyWriteable("writeChar");
                this.writeStream.writeChar(c);
                this.recordInteger(this.writeStream.size() - 2, 2);
                this.cachedBytesToString = null;
                this.bodySetInJsMsg = false;
            }
            catch (IOException iOException) {
                throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, iOException, "JmsBytesMessageImpl.writeChar#1", this, tc);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeChar");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeChar");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeDouble(double d) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeDouble");
        }
        try {
            try {
                this.checkBodyWriteable("writeDouble");
                this.writeStream.writeLong(Double.doubleToLongBits(d));
                if (this.float_values == null) {
                    this.float_values = new Vector();
                }
                this.float_values.addElement(new Double(d));
                if (this.float_offsets == null) {
                    this.float_offsets = new Vector();
                }
                this.float_offsets.addElement(new Integer(this.writeStream.size() - 8));
                this.cachedBytesToString = null;
                this.bodySetInJsMsg = false;
            }
            catch (IOException iOException) {
                throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, iOException, "JmsBytesMessageImpl.writeDouble#1", this, tc);
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeDouble");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeDouble");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFloat(float f) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeFloat");
        }
        try {
            try {
                this.checkBodyWriteable("writeFloat");
                this.writeStream.writeInt(Float.floatToIntBits(f));
                if (this.float_values == null) {
                    this.float_values = new Vector();
                }
                this.float_values.addElement(new Float(f));
                if (this.float_offsets == null) {
                    this.float_offsets = new Vector();
                }
                this.float_offsets.addElement(new Integer(this.writeStream.size() - 4));
                this.cachedBytesToString = null;
                this.bodySetInJsMsg = false;
            }
            catch (IOException iOException) {
                throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, iOException, "JmsBytesMessageImpl.writeFloat#1", this, tc);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeFloat");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeFloat");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeInt(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeInt");
        }
        try {
            try {
                this.checkBodyWriteable("writeInt");
                this.writeStream.writeInt(n);
                this.recordInteger(this.writeStream.size() - 4, 4);
                this.cachedBytesToString = null;
                this.bodySetInJsMsg = false;
            }
            catch (IOException iOException) {
                throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, iOException, "JmsBytesMessageImpl.writeInt#1", this, tc);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeInt");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeInt");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeLong(long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeLong");
        }
        try {
            try {
                this.checkBodyWriteable("writeLong");
                this.writeStream.writeLong(l);
                this.recordInteger(this.writeStream.size() - 8, 8);
                this.cachedBytesToString = null;
                this.bodySetInJsMsg = false;
            }
            catch (IOException iOException) {
                throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, iOException, "JmsBytesMessageImpl.writeLong#1", this, tc);
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeLong");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeLong");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object object) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeObject");
        }
        this.checkBodyWriteable("writeObject");
        try {
            if (object instanceof byte[]) {
                this.writeBytes((byte[])object);
            } else if (object instanceof String) {
                this.writeUTF((String)object);
            } else if (object instanceof Integer) {
                this.writeInt((Integer)object);
            } else if (object instanceof Byte) {
                this.writeByte((Byte)object);
            } else if (object instanceof Short) {
                this.writeShort((Short)object);
            } else if (object instanceof Long) {
                this.writeLong((Long)object);
            } else if (object instanceof Float) {
                this.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Double) {
                this.writeDouble((Double)object);
            } else if (object instanceof Character) {
                this.writeChar(((Character)object).charValue());
            } else if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
            } else {
                if (object == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "given null, throwing NPE");
                    }
                    throw new NullPointerException();
                }
                throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "BAD_OBJECT_CWSIA0185", new Object[]{object.getClass().getName()}, tc);
            }
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "writeObject");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeObject");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeShort(short s) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeShort");
        }
        try {
            try {
                this.checkBodyWriteable("writeShort");
                this.writeStream.writeShort(s);
                this.recordInteger(this.writeStream.size() - 2, 2);
                this.cachedBytesToString = null;
                this.bodySetInJsMsg = false;
            }
            catch (IOException iOException) {
                throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, iOException, "JmsBytesMessageImpl.writeShort#1", this, tc);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeShort");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeShort");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeUTF(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeUTF");
        }
        try {
            try {
                this.checkBodyWriteable("writeUTF");
                this.writeStream.writeUTF(string);
                this.cachedBytesToString = null;
                this.bodySetInJsMsg = false;
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "UTF8_CONV_CWSIA0184", null, uTFDataFormatException, null, this, tc);
            }
            catch (IOException iOException) {
                throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, iOException, "JmsBytesMessageImpl.writeUTF#2", this, tc);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeUTF");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeUTF");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry(tc, "writeObject");
                }
                if (this.requiresInit) {
                    this.lazyInit();
                }
                if (this.isBodyReadOnly()) {
                    this.streamOffset = this.dataBuffer.length - this.readStream.available();
                } else if (this._writeBytes != null) {
                    this.dataBuffer = this._writeBytes.toByteArray();
                }
                objectOutputStream.defaultWriteObject();
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) throw iOException;
                SibTr.debug(tc, "Error during writeObject", iOException);
                throw iOException;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "writeObject");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "writeObject");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry(tc, "readObject");
                }
                objectInputStream.defaultReadObject();
                if (this.isBodyReadOnly()) {
                    this.readStream = new ByteArrayInputStream(this.dataBuffer);
                    this.readStream.skip(this.streamOffset);
                }
                this._writeBytes = new ByteArrayOutputStream();
                this.writeStream = new DataOutputStream(this._writeBytes);
                this.writeStream.write(this.dataBuffer);
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) throw iOException;
                SibTr.debug(tc, "Error during readObject", iOException);
                throw iOException;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "readObject");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "readObject");
    }

    public long getBodyLength() throws JMSException {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBodyLength");
        }
        this.checkBodyReadable("getBodyLength");
        if (this.requiresInit) {
            this.lazyInit();
        }
        if (this.isBodyReadOnly()) {
            if (this.dataBuffer == null) {
                l = 0L;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "read mode, buffer null");
                }
            } else {
                l = this.dataBuffer.length - this.dataStart;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "read mode, bLen=" + l);
                }
            }
        } else if (this._writeBytes == null) {
            l = 0L;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "write mode, _writeBytes null");
            }
        } else {
            l = this._writeBytes.size();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "write mode, bLen=" + l);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBodyLength");
        }
        return l;
    }

    static int binToHex(byte[] byArray, int n, int n2, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            int n4 = byArray[i];
            if (n4 < 0) {
                n4 += 256;
            }
            n3 += n4;
            stringBuffer.append(cArray[n4 / 16]);
            stringBuffer.append(cArray[n4 % 16]);
        }
        return n3;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsBytesMessageImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.45.1.1");
        }
    }
}

