/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin;

import com.ibm.ejs.util.Util;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Random;

public class SIBUuid {
    private static Object lock = new Object();
    private static long lastTime = 0L;
    private static int clockSeq = new Random().nextInt() & 0x1FFF;
    private static final int _PID = 0;
    private static final int _IP_ADDRESS = SIBUuid.getIPAddress();
    private static final long _OLD_VERSION_ID = 0x2000000000000000L;
    private static final long _CURRENT_VERSION_ID = 0x3000000000000000L;
    private static final long _VERSION_MASK = -1152921504606846976L;
    private static final char[] _NIBBLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private long _uuidHigh;
    private long _uuidLow;
    private transient String _cachedString = null;
    private transient byte[] _cachedBytes = null;
    private boolean _unexpectedFormat = false;
    private boolean _hashed = false;
    private int _hashCode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBUuid() {
        int n;
        long l = System.currentTimeMillis();
        Object object = lock;
        synchronized (object) {
            if (lastTime == l) {
                n = ++clockSeq;
                if (clockSeq == 8192) {
                    clockSeq = 0;
                }
            } else {
                n = clockSeq;
                lastTime = l;
            }
        }
        this._uuidHigh = 0x3000000000000000L + (l & 0xFFFFFFFFFFFFFFFL);
        this._uuidLow = 0xE000000000000000L | ((long)n & 0x1FFFL) << 48 | 0L;
        this._uuidLow |= (long)_IP_ADDRESS;
    }

    public SIBUuid(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length != 16) {
            this._cachedBytes = new byte[byArray.length];
            System.arraycopy(byArray, 0, this._cachedBytes, 0, this._cachedBytes.length);
            this._cachedString = Util.toHexString((byte[])byArray);
            this._unexpectedFormat = true;
        } else {
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, 0, 16);
            this.fillFromBytes(byArray2);
        }
    }

    public SIBUuid(String string) {
        this.setUuid(string);
    }

    public void fillFromBytes(byte[] byArray) {
        this._uuidHigh = ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | ((long)byArray[7] & 0xFFL) << 0;
        this._uuidLow = ((long)byArray[8] & 0xFFL) << 56 | ((long)byArray[9] & 0xFFL) << 48 | ((long)byArray[10] & 0xFFL) << 40 | ((long)byArray[11] & 0xFFL) << 32 | ((long)byArray[12] & 0xFFL) << 24 | ((long)byArray[13] & 0xFFL) << 16 | ((long)byArray[14] & 0xFFL) << 8 | ((long)byArray[15] & 0xFFL) << 0;
        this._cachedBytes = byArray;
    }

    public String toString() {
        if (this._cachedString == null) {
            char[] cArray = new char[]{_NIBBLE[(int)((this._uuidHigh & 0xF0000000L) >>> 28)], _NIBBLE[(int)((this._uuidHigh & 0xF000000L) >>> 24)], _NIBBLE[(int)((this._uuidHigh & 0xF00000L) >>> 20)], _NIBBLE[(int)((this._uuidHigh & 0xF0000L) >>> 16)], _NIBBLE[(int)((this._uuidHigh & 0xF000L) >>> 12)], _NIBBLE[(int)((this._uuidHigh & 0xF00L) >>> 8)], _NIBBLE[(int)((this._uuidHigh & 0xF0L) >>> 4)], _NIBBLE[(int)((this._uuidHigh & 0xFL) >>> 0)], '-', _NIBBLE[(int)((this._uuidHigh & 0xF00000000000L) >>> 44)], _NIBBLE[(int)((this._uuidHigh & 0xF0000000000L) >>> 40)], _NIBBLE[(int)((this._uuidHigh & 0xF000000000L) >>> 36)], _NIBBLE[(int)((this._uuidHigh & 0xF00000000L) >>> 32)], '-', _NIBBLE[(int)((this._uuidHigh & 0xF000000000000000L) >>> 60)], _NIBBLE[(int)((this._uuidHigh & 0xF00000000000000L) >>> 56)], _NIBBLE[(int)((this._uuidHigh & 0xF0000000000000L) >>> 52)], _NIBBLE[(int)((this._uuidHigh & 0xF000000000000L) >>> 48)], '-', _NIBBLE[(int)((this._uuidLow & 0xF000000000000000L) >>> 60)], _NIBBLE[(int)((this._uuidLow & 0xF00000000000000L) >>> 56)], _NIBBLE[(int)((this._uuidLow & 0xF0000000000000L) >>> 52)], _NIBBLE[(int)((this._uuidLow & 0xF000000000000L) >>> 48)], '-', _NIBBLE[(int)((this._uuidLow & 0xF00000000000L) >>> 44)], _NIBBLE[(int)((this._uuidLow & 0xF0000000000L) >>> 40)], _NIBBLE[(int)((this._uuidLow & 0xF000000000L) >>> 36)], _NIBBLE[(int)((this._uuidLow & 0xF00000000L) >>> 32)], _NIBBLE[(int)((this._uuidLow & 0xF0000000L) >>> 28)], _NIBBLE[(int)((this._uuidLow & 0xF000000L) >>> 24)], _NIBBLE[(int)((this._uuidLow & 0xF00000L) >>> 20)], _NIBBLE[(int)((this._uuidLow & 0xF0000L) >>> 16)], _NIBBLE[(int)((this._uuidLow & 0xF000L) >>> 12)], _NIBBLE[(int)((this._uuidLow & 0xF00L) >>> 8)], _NIBBLE[(int)((this._uuidLow & 0xF0L) >>> 4)], _NIBBLE[(int)((this._uuidLow & 0xFL) >>> 0)]};
            this._cachedString = new String(cArray);
        }
        return this._cachedString;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        SIBUuid sIBUuid = (SIBUuid)object;
        if (this._unexpectedFormat) {
            return Arrays.equals(this._cachedBytes, sIBUuid.toByteArray());
        }
        if (this._uuidHigh != sIBUuid._uuidHigh) {
            return false;
        }
        return this._uuidLow == sIBUuid._uuidLow;
    }

    public int hashCode() {
        if (this._unexpectedFormat) {
            if (!this._hashed) {
                for (int i = 0; i < this._cachedBytes.length; ++i) {
                    this._hashCode += this._cachedBytes[i];
                }
            }
            return this._hashCode;
        }
        return (int)this._uuidHigh;
    }

    public byte[] toByteArray() {
        if (this._cachedBytes == null) {
            this._cachedBytes = new byte[16];
            this._cachedBytes[0] = (byte)((this._uuidHigh & 0xFF00000000000000L) >>> 56);
            this._cachedBytes[1] = (byte)((this._uuidHigh & 0xFF000000000000L) >>> 48);
            this._cachedBytes[2] = (byte)((this._uuidHigh & 0xFF0000000000L) >>> 40);
            this._cachedBytes[3] = (byte)((this._uuidHigh & 0xFF00000000L) >>> 32);
            this._cachedBytes[4] = (byte)((this._uuidHigh & 0xFF000000L) >>> 24);
            this._cachedBytes[5] = (byte)((this._uuidHigh & 0xFF0000L) >>> 16);
            this._cachedBytes[6] = (byte)((this._uuidHigh & 0xFF00L) >>> 8);
            this._cachedBytes[7] = (byte)((this._uuidHigh & 0xFFL) >>> 0);
            this._cachedBytes[8] = (byte)((this._uuidLow & 0xFF00000000000000L) >>> 56);
            this._cachedBytes[9] = (byte)((this._uuidLow & 0xFF000000000000L) >>> 48);
            this._cachedBytes[10] = (byte)((this._uuidLow & 0xFF0000000000L) >>> 40);
            this._cachedBytes[11] = (byte)((this._uuidLow & 0xFF00000000L) >>> 32);
            this._cachedBytes[12] = (byte)((this._uuidLow & 0xFF000000L) >>> 24);
            this._cachedBytes[13] = (byte)((this._uuidLow & 0xFF0000L) >>> 16);
            this._cachedBytes[14] = (byte)((this._uuidLow & 0xFF00L) >>> 8);
            this._cachedBytes[15] = (byte)((this._uuidLow & 0xFFL) >>> 0);
        }
        return this._cachedBytes;
    }

    public int compareTo(Object object) {
        SIBUuid sIBUuid = (SIBUuid)object;
        int n = 0;
        if (this.equals(sIBUuid)) {
            n = 0;
        } else if (this._unexpectedFormat) {
            n = new Integer(this.hashCode()).compareTo(new Integer(sIBUuid.hashCode()));
        } else {
            n = new Long(this._uuidHigh).compareTo(new Long(sIBUuid._uuidHigh));
            if (n == 0) {
                n = new Long(this._uuidLow).compareTo(new Long(sIBUuid._uuidLow));
            }
        }
        return n;
    }

    public Object clone() {
        return this;
    }

    public boolean isCurrentVersion() {
        if (this._unexpectedFormat) {
            return false;
        }
        return (this._uuidHigh & 0xF000000000000000L) == 0x3000000000000000L;
    }

    public boolean isOldVersion() {
        if (this._unexpectedFormat) {
            return false;
        }
        return (this._uuidHigh & 0xF000000000000000L) == 0x2000000000000000L;
    }

    private static int getPID() {
        short s = 0;
        int n = 0;
        s = (short)(new Random().nextInt() & 0xFFFF);
        n = s & 0xFFFF;
        return n;
    }

    private static int getIPAddress() {
        int n = 0;
        try {
            byte[] byArray = InetAddress.getLocalHost().getAddress();
            n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | (byArray[3] & 0xFF) << 0;
        }
        catch (Exception exception) {
            n = new Random().nextInt();
        }
        return n;
    }

    public void setUuid(String string) {
        byte[] byArray = new byte[]{(byte)Integer.parseInt(string.substring(14, 16), 16), (byte)Integer.parseInt(string.substring(16, 18), 16), (byte)Integer.parseInt(string.substring(9, 11), 16), (byte)Integer.parseInt(string.substring(11, 13), 16), (byte)Integer.parseInt(string.substring(0, 2), 16), (byte)Integer.parseInt(string.substring(2, 4), 16), (byte)Integer.parseInt(string.substring(4, 6), 16), (byte)Integer.parseInt(string.substring(6, 8), 16), (byte)Integer.parseInt(string.substring(19, 21), 16), (byte)Integer.parseInt(string.substring(21, 23), 16), (byte)Integer.parseInt(string.substring(24, 26), 16), (byte)Integer.parseInt(string.substring(26, 28), 16), (byte)Integer.parseInt(string.substring(28, 30), 16), (byte)Integer.parseInt(string.substring(30, 32), 16), (byte)Integer.parseInt(string.substring(32, 34), 16), (byte)Integer.parseInt(string.substring(34, 36), 16)};
        this.fillFromBytes(byArray);
    }

    public String getUuid() {
        return this.toString();
    }
}

