/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.security.commands.sib.SIBSecurityAdminHelper;
import com.ibm.ws.security.commands.sib.SIBSecurityCommandException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SIBSecurityTopicCommandProvider
extends SimpleCommandProvider {
    private static final TraceComponent tc = SibTr.register(SIBSecurityTopicCommandProvider.class, "CWSJD", "com.ibm.ws.security.commands.sib.CWSJDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.security.commands.sib.CWSJDMessages");
    private ConfigService configService = ConfigServiceFactory.getConfigService();

    public ObjectName addUserToTopicSpaceRootRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Serializable serializable;
        String string = "addUserToTopicSpaceRootRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        String string5 = (String)abstractAdminCommand.getParameter("user");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createUserIfRequired(session, string5, objectName3);
        ObjectName objectName5 = SIBSecurityAdminHelper.createTopicSpaceIfRequired(session, string3, objectName3);
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceRoot", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        ObjectName objectName7 = null;
        if (objectNameArray.length == 0) {
            serializable = new AttributeList();
            objectName7 = this.configService.createConfigData(session, objectName5, "topicSpaceRoot", "SIBAuthTopicSpaceRoot", serializable);
        } else {
            objectName7 = objectNameArray[0];
        }
        serializable = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName8 = null;
        AttributeList attributeList = new AttributeList();
        if (string4.equalsIgnoreCase("sender")) {
            serializable = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName7, (ObjectName)serializable, null);
            objectName8 = objectNameArray2.length == 0 ? this.configService.createConfigData(session, objectName7, "sender", "SIBAuthSender", attributeList) : objectNameArray2[0];
        } else if (string4.equalsIgnoreCase("receiver")) {
            serializable = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName7, (ObjectName)serializable, null);
            objectName8 = objectNameArray2.length == 0 ? this.configService.createConfigData(session, objectName7, "receiver", "SIBAuthReceiver", attributeList) : objectNameArray2[0];
        } else if (string4.equalsIgnoreCase("identityAdopter")) {
            serializable = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName7, (ObjectName)serializable, null);
            objectName8 = objectNameArray2.length == 0 ? this.configService.createConfigData(session, objectName7, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray2[0];
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "addUserToTopicSpaceRootRole", (Object)("SIBSecurityCommandException - Invalid role name " + string4));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string4}, null));
        }
        ArrayList arrayList = (ArrayList)this.configService.getAttribute(session, objectName8, "user");
        arrayList.add(objectName4);
        AttributeList attributeList2 = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList2, (String)"user", (Object)arrayList);
        this.configService.setAttributes(session, objectName8, attributeList2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName4;
    }

    public ObjectName addGroupToTopicSpaceRootRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Serializable serializable;
        String string = "addGroupToTopicSpaceRootRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        String string5 = (String)abstractAdminCommand.getParameter("group");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createGroupIfRequired(session, string5, objectName3);
        ObjectName objectName5 = SIBSecurityAdminHelper.createTopicSpaceIfRequired(session, string3, objectName3);
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceRoot", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        ObjectName objectName7 = null;
        if (objectNameArray.length == 0) {
            serializable = new AttributeList();
            objectName7 = this.configService.createConfigData(session, objectName5, "topicSpaceRoot", "SIBAuthTopicSpaceRoot", serializable);
        } else {
            objectName7 = objectNameArray[0];
        }
        serializable = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName8 = null;
        AttributeList attributeList = new AttributeList();
        if (string4.equalsIgnoreCase("sender")) {
            serializable = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName7, (ObjectName)serializable, null);
            objectName8 = objectNameArray2.length == 0 ? this.configService.createConfigData(session, objectName7, "sender", "SIBAuthSender", attributeList) : objectNameArray2[0];
        } else if (string4.equalsIgnoreCase("receiver")) {
            serializable = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName7, (ObjectName)serializable, null);
            objectName8 = objectNameArray2.length == 0 ? this.configService.createConfigData(session, objectName7, "receiver", "SIBAuthReceiver", attributeList) : objectNameArray2[0];
        } else if (string4.equalsIgnoreCase("identityAdopter")) {
            serializable = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName7, (ObjectName)serializable, null);
            objectName8 = objectNameArray2.length == 0 ? this.configService.createConfigData(session, objectName7, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray2[0];
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string4));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string4}, null));
        }
        ArrayList arrayList = (ArrayList)this.configService.getAttribute(session, objectName8, "group");
        arrayList.add(objectName4);
        AttributeList attributeList2 = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList2, (String)"group", (Object)arrayList);
        this.configService.setAttributes(session, objectName8, attributeList2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName4;
    }

    public void removeUserFromTopicSpaceRootRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Serializable serializable;
        ObjectName[] objectNameArray;
        String string = "removeUserFromTopicSpaceRootRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        String string5 = (String)abstractAdminCommand.getParameter("user");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.checkTopicspaceExists(session, objectName, string2);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - user not found as ts has no root auth" + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("USER_NOT_FOUND_CWSJD0503", new Object[]{string5, objectName5}, null));
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceRoot", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        if (objectNameArray.length == 0) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - user not found as ts has no root auth" + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("USER_NOT_FOUND_CWSJD0503", new Object[]{string5, objectName5}, null));
        }
        ObjectName objectName7 = objectNameArray[0];
        ObjectName objectName8 = null;
        if (string4.equalsIgnoreCase("sender")) {
            objectName8 = SIBSecurityAdminHelper.getSenderRole(session, objectName7, string4);
        } else if (string4.equalsIgnoreCase("receiver")) {
            objectName8 = SIBSecurityAdminHelper.getReceiverRole(session, objectName7, string4);
        } else if (string4.equalsIgnoreCase("identityAdopter")) {
            objectName8 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName7, string4);
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string4));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string4}, null));
        }
        ArrayList arrayList = (ArrayList)this.configService.getAttribute(session, objectName8, "user");
        Iterator iterator = arrayList.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            serializable = (ObjectName)iterator.next();
            String string6 = (String)this.configService.getAttribute(session, serializable, "identifier");
            if (!string6.equalsIgnoreCase(string5)) continue;
            bl2 = true;
            arrayList.remove(serializable);
            break;
        }
        if (!bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - user not found " + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("USER_NOT_FOUND_CWSJD0503", new Object[]{string5, objectName5}, null));
        }
        serializable = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"user", (Object)arrayList);
        this.configService.setAttributes(session, objectName8, (AttributeList)serializable);
        SIBSecurityAdminHelper.removeUserIfOrphaned(string5, session, objectName3);
        SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName8);
        if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName7)) {
            this.configService.deleteConfigData(session, objectName7);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public void removeGroupFromTopicSpaceRootRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Serializable serializable;
        ObjectName[] objectNameArray;
        String string = "removeGroupFromTopicSpaceRootRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        String string5 = (String)abstractAdminCommand.getParameter("group");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.checkTopicspaceExists(session, objectName, string2);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - group not found as ts has no root auth" + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("GROUP_NOT_FOUND_CWSJD0504", new Object[]{string5, objectName5}, null));
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceRoot", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        if (objectNameArray.length == 0) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - group not found as ts has no root auth" + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("GROUP_NOT_FOUND_CWSJD0504", new Object[]{string5, objectName5}, null));
        }
        ObjectName objectName7 = objectNameArray[0];
        ObjectName objectName8 = null;
        if (string4.equalsIgnoreCase("sender")) {
            objectName8 = SIBSecurityAdminHelper.getSenderRole(session, objectName7, string4);
        } else if (string4.equalsIgnoreCase("receiver")) {
            objectName8 = SIBSecurityAdminHelper.getReceiverRole(session, objectName7, string4);
        } else if (string4.equalsIgnoreCase("identityAdopter")) {
            objectName8 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName7, string4);
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string4));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string4}, null));
        }
        ArrayList arrayList = (ArrayList)this.configService.getAttribute(session, objectName8, "group");
        Iterator iterator = arrayList.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            serializable = (ObjectName)iterator.next();
            String string6 = (String)this.configService.getAttribute(session, serializable, "identifier");
            if (!string6.equalsIgnoreCase(string5)) continue;
            bl2 = true;
            arrayList.remove(serializable);
            break;
        }
        if (!bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - group not found " + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("GROUP_NOT_FOUND_CWSJD0504", new Object[]{string5, objectName5}, null));
        }
        serializable = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"group", (Object)arrayList);
        this.configService.setAttributes(session, objectName8, (AttributeList)serializable);
        SIBSecurityAdminHelper.removeGroupIfOrphaned(string5, session, objectName3);
        SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName8);
        if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName7)) {
            this.configService.deleteConfigData(session, objectName7);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public String[] listUsersInTopicSpaceRootRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName[] objectNameArray;
        String string = "listUsersInTopicSpaceRootRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.checkTopicspaceExists(session, objectName, string2);
            String[] stringArray = new String[]{};
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, stringArray);
            }
            return stringArray;
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceRoot", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        if (objectNameArray.length == 0) {
            String[] stringArray = new String[]{};
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, stringArray);
            }
            return stringArray;
        }
        ObjectName objectName7 = objectNameArray[0];
        ObjectName objectName8 = null;
        if (string4.equalsIgnoreCase("sender")) {
            objectName8 = SIBSecurityAdminHelper.getSenderRole(session, objectName7, string4);
        } else if (string4.equalsIgnoreCase("receiver")) {
            objectName8 = SIBSecurityAdminHelper.getReceiverRole(session, objectName7, string4);
        } else if (string4.equalsIgnoreCase("identityAdopter")) {
            objectName8 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName7, string4);
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string4));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string4}, null));
        }
        List list = (List)this.configService.getAttribute(session, objectName8, "user");
        ObjectName[] objectNameArray3 = new ObjectName[list.size()];
        objectNameArray3 = list.toArray(objectNameArray3);
        String[] stringArray = SIBSecurityAdminHelper.convertToStringArray(session, objectNameArray3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public String[] listGroupsInTopicSpaceRootRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName[] objectNameArray;
        String string = "listGroupsInTopicSpaceRootRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.checkTopicspaceExists(session, objectName, string2);
            String[] stringArray = new String[]{};
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, stringArray);
            }
            return stringArray;
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceRoot", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        if (objectNameArray.length == 0) {
            String[] stringArray = new String[]{};
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "listGroupsInTopicSpaceRootRole", stringArray);
            }
            return stringArray;
        }
        ObjectName objectName7 = objectNameArray[0];
        ObjectName objectName8 = null;
        if (string4.equalsIgnoreCase("sender")) {
            objectName8 = SIBSecurityAdminHelper.getSenderRole(session, objectName7, string4);
        } else if (string4.equalsIgnoreCase("receiver")) {
            objectName8 = SIBSecurityAdminHelper.getReceiverRole(session, objectName7, string4);
        } else if (string4.equalsIgnoreCase("identityAdopter")) {
            objectName8 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName7, string4);
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string4));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string4}, null));
        }
        List list = (List)this.configService.getAttribute(session, objectName8, "group");
        ObjectName[] objectNameArray3 = new ObjectName[list.size()];
        objectNameArray3 = list.toArray(objectNameArray3);
        String[] stringArray = SIBSecurityAdminHelper.convertToStringArray(session, objectNameArray3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public ObjectName addUserToTopicRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "addUserToTopicRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        String string5 = (String)abstractAdminCommand.getParameter("role");
        String string6 = (String)abstractAdminCommand.getParameter("user");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createUserIfRequired(session, string6, objectName3);
        ObjectName objectName5 = SIBSecurityAdminHelper.createTopicSpaceIfRequired(session, string3, objectName3);
        ObjectName objectName6 = SIBSecurityAdminHelper.createTopicIfRequired(session, string4, objectName5);
        ObjectName objectName7 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName8 = null;
        AttributeList attributeList = new AttributeList();
        if (string5.equalsIgnoreCase("sender")) {
            objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName6, objectName7, null);
            objectName8 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName6, "sender", "SIBAuthSender", attributeList) : objectNameArray[0];
        } else if (string5.equalsIgnoreCase("receiver")) {
            objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName6, objectName7, null);
            objectName8 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName6, "receiver", "SIBAuthReceiver", attributeList) : objectNameArray[0];
        } else if (string5.equalsIgnoreCase("identityAdopter")) {
            objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName6, objectName7, null);
            objectName8 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName6, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray[0];
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string5}, null));
        }
        ArrayList arrayList = (ArrayList)this.configService.getAttribute(session, objectName8, "user");
        arrayList.add(objectName4);
        AttributeList attributeList2 = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList2, (String)"user", (Object)arrayList);
        this.configService.setAttributes(session, objectName8, attributeList2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName4;
    }

    public ObjectName addGroupToTopicRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "addGroupToTopicRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        String string5 = (String)abstractAdminCommand.getParameter("role");
        String string6 = (String)abstractAdminCommand.getParameter("group");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createGroupIfRequired(session, string6, objectName3);
        ObjectName objectName5 = SIBSecurityAdminHelper.createTopicSpaceIfRequired(session, string3, objectName3);
        ObjectName objectName6 = SIBSecurityAdminHelper.createTopicIfRequired(session, string4, objectName5);
        ObjectName objectName7 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName8 = null;
        AttributeList attributeList = new AttributeList();
        if (string5.equalsIgnoreCase("sender")) {
            objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName6, objectName7, null);
            objectName8 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName6, "sender", "SIBAuthSender", attributeList) : objectNameArray[0];
        } else if (string5.equalsIgnoreCase("receiver")) {
            objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName6, objectName7, null);
            objectName8 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName6, "receiver", "SIBAuthReceiver", attributeList) : objectNameArray[0];
        } else if (string5.equalsIgnoreCase("identityAdopter")) {
            objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName6, objectName7, null);
            objectName8 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName6, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray[0];
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string5}, null));
        }
        ArrayList arrayList = (ArrayList)this.configService.getAttribute(session, objectName8, "group");
        arrayList.add(objectName4);
        AttributeList attributeList2 = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList2, (String)"group", (Object)arrayList);
        this.configService.setAttributes(session, objectName8, attributeList2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName4;
    }

    public void removeUserFromTopicRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Serializable serializable;
        Object object;
        ObjectName[] objectNameArray;
        String string = "removeUserFromTopicRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        String string5 = (String)abstractAdminCommand.getParameter("role");
        String string6 = (String)abstractAdminCommand.getParameter("user");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.checkTopicspaceExists(session, objectName, string2);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - user not found as ts has no root auth" + string6));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("GROUP_NOT_FOUND_CWSJD0504", new Object[]{string6, objectName5}, null));
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        ObjectName objectName7 = null;
        boolean bl2 = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            object = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!((String)object).equals(string4)) continue;
            objectName7 = objectNameArray[i];
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)"SIBSecurityCommandException");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_NOT_FOUND_CWSJD0502", new Object[]{string4, objectName5}, null));
        }
        ObjectName objectName8 = null;
        if (string5.equalsIgnoreCase("sender")) {
            objectName8 = SIBSecurityAdminHelper.getSenderRole(session, objectName7, string5);
        } else if (string5.equalsIgnoreCase("receiver")) {
            objectName8 = SIBSecurityAdminHelper.getReceiverRole(session, objectName7, string5);
        } else if (string5.equalsIgnoreCase("identityAdopter")) {
            objectName8 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName7, string5);
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string5}, null));
        }
        object = (ArrayList)this.configService.getAttribute(session, objectName8, "user");
        Iterator iterator = ((ArrayList)object).iterator();
        boolean bl3 = false;
        while (iterator.hasNext()) {
            serializable = (ObjectName)iterator.next();
            String string7 = (String)this.configService.getAttribute(session, serializable, "identifier");
            if (!string7.equalsIgnoreCase(string6)) continue;
            bl3 = true;
            ((ArrayList)object).remove(serializable);
            break;
        }
        if (!bl3) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - user not found " + string6));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("USER_NOT_FOUND_CWSJD0503", new Object[]{string6, objectName5}, null));
        }
        serializable = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"user", (Object)object);
        this.configService.setAttributes(session, objectName8, (AttributeList)serializable);
        SIBSecurityAdminHelper.removeUserIfOrphaned(string6, session, objectName3);
        SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName8);
        if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName7)) {
            this.configService.deleteConfigData(session, objectName7);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public void removeGroupFromTopicRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Serializable serializable;
        Object object;
        ObjectName[] objectNameArray;
        String string = "removeGroupFromTopicRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        String string5 = (String)abstractAdminCommand.getParameter("role");
        String string6 = (String)abstractAdminCommand.getParameter("group");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.checkTopicspaceExists(session, objectName, string2);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - group not found as ts has no root auth" + string6));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("GROUP_NOT_FOUND_CWSJD0504", new Object[]{string6, objectName5}, null));
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        ObjectName objectName7 = null;
        boolean bl2 = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            object = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!((String)object).equals(string4)) continue;
            objectName7 = objectNameArray[i];
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)"SIBSecurityCommandException");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_NOT_FOUND_CWSJD0502", new Object[]{string4, objectName5}, null));
        }
        ObjectName objectName8 = null;
        if (string5.equalsIgnoreCase("sender")) {
            objectName8 = SIBSecurityAdminHelper.getSenderRole(session, objectName7, string5);
        } else if (string5.equalsIgnoreCase("receiver")) {
            objectName8 = SIBSecurityAdminHelper.getReceiverRole(session, objectName7, string5);
        } else if (string5.equalsIgnoreCase("identityAdopter")) {
            objectName8 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName7, string5);
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string5}, null));
        }
        object = (ArrayList)this.configService.getAttribute(session, objectName8, "group");
        Iterator iterator = ((ArrayList)object).iterator();
        boolean bl3 = false;
        while (iterator.hasNext()) {
            serializable = (ObjectName)iterator.next();
            String string7 = (String)this.configService.getAttribute(session, serializable, "identifier");
            if (!string7.equalsIgnoreCase(string6)) continue;
            bl3 = true;
            ((ArrayList)object).remove(serializable);
            break;
        }
        if (!bl3) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - group not found " + string6));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("GROUP_NOT_FOUND_CWSJD0504", new Object[]{string6, objectName5}, null));
        }
        serializable = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"group", (Object)object);
        this.configService.setAttributes(session, objectName8, (AttributeList)serializable);
        SIBSecurityAdminHelper.removeGroupIfOrphaned(string6, session, objectName3);
        SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName8);
        if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName7)) {
            this.configService.deleteConfigData(session, objectName7);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public String[] listUsersInTopicRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        ObjectName[] objectNameArray;
        String string = "listUsersInTopicRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        String string5 = (String)abstractAdminCommand.getParameter("role");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.checkTopicspaceExists(session, objectName, string2);
            String[] stringArray = new String[]{};
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, stringArray);
            }
            return stringArray;
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        ObjectName objectName7 = null;
        boolean bl2 = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            object = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!((String)object).equals(string4)) continue;
            objectName7 = objectNameArray[i];
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)"SIBSecurityCommandException");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_NOT_FOUND_CWSJD0502", new Object[]{string4, objectName5}, null));
        }
        ObjectName objectName8 = null;
        if (string5.equalsIgnoreCase("sender")) {
            objectName8 = SIBSecurityAdminHelper.getSenderRole(session, objectName7, string5);
        } else if (string5.equalsIgnoreCase("receiver")) {
            objectName8 = SIBSecurityAdminHelper.getReceiverRole(session, objectName7, string5);
        } else if (string5.equalsIgnoreCase("identityAdopter")) {
            objectName8 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName7, string5);
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string5}, null));
        }
        object = (List)this.configService.getAttribute(session, objectName8, "user");
        ObjectName[] objectNameArray3 = new ObjectName[object.size()];
        objectNameArray3 = object.toArray(objectNameArray3);
        String[] stringArray = SIBSecurityAdminHelper.convertToStringArray(session, objectNameArray3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public String[] listGroupsInTopicRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        ObjectName[] objectNameArray;
        String string = "listGroupsInTopicRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        String string5 = (String)abstractAdminCommand.getParameter("role");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.checkTopicspaceExists(session, objectName, string2);
            String[] stringArray = new String[]{};
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, stringArray);
            }
            return stringArray;
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        ObjectName objectName7 = null;
        boolean bl2 = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            object = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!((String)object).equals(string4)) continue;
            objectName7 = objectNameArray[i];
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)"SIBSecurityCommandException");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_NOT_FOUND_CWSJD0502", new Object[]{string4, objectName5}, null));
        }
        ObjectName objectName8 = null;
        if (string5.equalsIgnoreCase("sender")) {
            objectName8 = SIBSecurityAdminHelper.getSenderRole(session, objectName7, string5);
        } else if (string5.equalsIgnoreCase("receiver")) {
            objectName8 = SIBSecurityAdminHelper.getReceiverRole(session, objectName7, string5);
        } else if (string5.equalsIgnoreCase("identityAdopter")) {
            objectName8 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName7, string5);
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - Invalid role name " + string5));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string5}, null));
        }
        object = (List)this.configService.getAttribute(session, objectName8, "group");
        ObjectName[] objectNameArray3 = new ObjectName[object.size()];
        objectNameArray3 = object.toArray(objectNameArray3);
        String[] stringArray = SIBSecurityAdminHelper.convertToStringArray(session, objectNameArray3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public ObjectName setInheritReceiverForTopic(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "setInheritReceiverForTopic";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("inherit");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createTopicSpaceIfRequired(session, string3, objectName3);
        ObjectName objectName5 = SIBSecurityAdminHelper.createTopicIfRequired(session, string4, objectName4);
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"inheritReceiver", (Object)bl);
        this.configService.setAttributes(session, objectName5, attributeList);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName5;
    }

    public ObjectName setInheritSenderForTopic(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "setInheritSenderForTopic";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("inherit");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createTopicSpaceIfRequired(session, string3, objectName3);
        ObjectName objectName5 = SIBSecurityAdminHelper.createTopicIfRequired(session, string4, objectName4);
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"inheritSender", (Object)bl);
        this.configService.setAttributes(session, objectName5, attributeList);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName5;
    }

    public String listInheritReceiverForTopic(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName[] objectNameArray;
        String string = "listInheritReceiverForTopic";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.checkTopicspaceExists(session, objectName, string2);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)"SIBSecurityCommandException - not found as no security permissions defined");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_NOT_FOUND_CWSJD0502", new Object[]{string4, objectName5}, null));
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        ObjectName objectName7 = null;
        boolean bl2 = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string5 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string5.equals(string4)) continue;
            objectName7 = objectNameArray[i];
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)"SIBSecurityCommandException");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_NOT_FOUND_CWSJD0502", new Object[]{string4, objectName5}, null));
        }
        Boolean bl3 = (Boolean)this.configService.getAttribute(session, objectName7, "inheritReceiver");
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return "Inherit Receiver Defaults are set to: " + bl3.toString().toUpperCase();
    }

    public String listInheritSenderForTopic(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName[] objectNameArray;
        String string = "listInheritSenderForTopic";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string4 = (String)abstractAdminCommand.getParameter("topic");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)("SIBSecurityCommandException - topicspace not found " + string3));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_SPACE_NOT_FOUND_CWSJD0500", new Object[]{string3}, null));
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        ObjectName objectName7 = null;
        boolean bl2 = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string5 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string5.equals(string4)) continue;
            objectName7 = objectNameArray[i];
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, string, (Object)"SIBSecurityCommandException");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_NOT_FOUND_CWSJD0502", new Object[]{string4, objectName5}, null));
        }
        Boolean bl3 = (Boolean)this.configService.getAttribute(session, objectName7, "inheritSender");
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return "Inherit Receiver Defaults are set to: " + bl3.toString().toUpperCase();
    }

    private void checkTopicspaceExists(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException, SIBSecurityCommandException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkTopicspaceExists");
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBTopicSpace", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "checkTopicspaceExists", (Object)("SIBSecurityCommandException - topicspace not found " + string));
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_SPACE_NOT_FOUND_CWSJD0500", new Object[]{string}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkTopicspaceExists");
        }
    }
}

