/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.commands.sib.SIBSecurityAdminHelper;
import com.ibm.ws.security.commands.sib.SIBSecurityBusCommandProvider;
import com.ibm.ws.security.commands.sib.SIBSecurityCommandException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import javax.management.ObjectName;

public class SIBSecurityRoleCommandProvider
extends SimpleCommandProvider {
    private static final TraceComponent tc = SibTr.register(SIBSecurityBusCommandProvider.class, "CWSJD", "com.ibm.ws.security.commands.sib.CWSJDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.security.commands.sib.CWSJDMessages");
    private ConfigService configService = ConfigServiceFactory.getConfigService();

    public String[] listAllDestinationsWithRoles(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "listAllDestinationsWithRoles";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("type");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
        ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
        ObjectName objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
        ObjectName objectName8 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
        ObjectName[] objectNameArray = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName[] objectNameArray3 = null;
        ObjectName[] objectNameArray4 = null;
        ObjectName[] objectNameArray5 = null;
        ObjectName objectName9 = null;
        ObjectName[] objectNameArray6 = null;
        if (string3.equalsIgnoreCase("topicSpace")) {
            objectName9 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
            objectNameArray6 = this.configService.queryConfigObjects(session, objectName3, objectName9, null);
        } else if (string3.equalsIgnoreCase("queue")) {
            objectName9 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
            objectNameArray6 = this.configService.queryConfigObjects(session, objectName3, objectName9, null);
        } else if (string3.equalsIgnoreCase("port")) {
            objectName9 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
            objectNameArray6 = this.configService.queryConfigObjects(session, objectName3, objectName9, null);
        } else if (string3.equalsIgnoreCase("webService")) {
            objectName9 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
            objectNameArray6 = this.configService.queryConfigObjects(session, objectName3, objectName9, null);
        } else if (string3.equalsIgnoreCase("alias")) {
            objectName9 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
            objectNameArray6 = this.configService.queryConfigObjects(session, objectName3, objectName9, null);
        } else if (string3.equalsIgnoreCase("foreignDestination")) {
            objectName9 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
            objectNameArray6 = this.configService.queryConfigObjects(session, objectName3, objectName9, null);
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string3}, null));
        }
        for (int i = 0; i < objectNameArray6.length; ++i) {
            objectNameArray = this.configService.queryConfigObjects(session, objectNameArray6[i], objectName4, null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectNameArray6[i], objectName5, null);
            objectNameArray3 = this.configService.queryConfigObjects(session, objectNameArray6[i], objectName6, null);
            objectNameArray4 = this.configService.queryConfigObjects(session, objectNameArray6[i], objectName7, null);
            objectNameArray5 = this.configService.queryConfigObjects(session, objectNameArray6[i], objectName8, null);
            if (objectNameArray.length <= 0 && objectNameArray2.length <= 0 && objectNameArray3.length <= 0 && objectNameArray4.length <= 0 && objectNameArray5.length <= 0) continue;
            arrayList.add(objectNameArray6[i]);
        }
        ObjectName[] objectNameArray7 = new ObjectName[arrayList.size()];
        objectNameArray7 = arrayList.toArray(objectNameArray7);
        String[] stringArray = new String[objectNameArray7.length];
        for (int i = 0; i < objectNameArray7.length; ++i) {
            String string4 = null;
            string4 = string3.equalsIgnoreCase("foreignDestination") ? (String)this.configService.getAttribute(session, objectNameArray7[i], "destinationName") : (String)this.configService.getAttribute(session, objectNameArray7[i], "identifier");
            stringArray[i] = string4;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public String[] listAllForeignBusesWithRoles(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "listAllForeignBusesWithRoles";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
        ObjectName[] objectNameArray2 = null;
        ObjectName[] objectNameArray3 = null;
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectNameArray2 = this.configService.queryConfigObjects(session, objectNameArray[i], objectName5, null);
            objectNameArray3 = this.configService.queryConfigObjects(session, objectNameArray[i], objectName6, null);
            if (objectNameArray2.length <= 0 && objectNameArray3.length <= 0) continue;
            arrayList.add(objectNameArray[i]);
        }
        ObjectName[] objectNameArray4 = new ObjectName[arrayList.size()];
        objectNameArray4 = arrayList.toArray(objectNameArray4);
        String[] stringArray = new String[objectNameArray4.length];
        for (int i = 0; i < objectNameArray4.length; ++i) {
            String string3;
            stringArray[i] = string3 = (String)this.configService.getAttribute(session, objectNameArray4[i], "busName");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public String[] listAllTopicsWithRoles(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName[] objectNameArray;
        String string = "listAllTopicsWithRoles";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("topicSpace");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_SPACE_NOT_FOUND_CWSJD0500", new Object[]{string3}, null));
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        ObjectName objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
        ObjectName objectName8 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
        ObjectName objectName9 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
        ObjectName[] objectNameArray3 = null;
        ObjectName[] objectNameArray4 = null;
        ObjectName[] objectNameArray5 = null;
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectNameArray3 = this.configService.queryConfigObjects(session, objectNameArray[i], objectName7, null);
            objectNameArray4 = this.configService.queryConfigObjects(session, objectNameArray[i], objectName8, null);
            objectNameArray5 = this.configService.queryConfigObjects(session, objectNameArray[i], objectName9, null);
            if (objectNameArray3.length <= 0 && objectNameArray4.length <= 0 && objectNameArray5.length <= 0) continue;
            arrayList.add(objectNameArray[i]);
        }
        ObjectName[] objectNameArray6 = new ObjectName[arrayList.size()];
        objectNameArray6 = arrayList.toArray(objectNameArray6);
        String[] stringArray = new String[objectNameArray6.length];
        for (int i = 0; i < objectNameArray6.length; ++i) {
            String string4;
            stringArray[i] = string4 = (String)this.configService.getAttribute(session, objectNameArray6[i], "identifier");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public String[] listAllRolesForUser(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        int n;
        ObjectName[] objectNameArray;
        String string = "listAllRolesForUser";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("user");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        ArrayList arrayList4 = null;
        ArrayList arrayList5 = null;
        ArrayList arrayList6 = null;
        ArrayList arrayList7 = null;
        ArrayList arrayList8 = null;
        ArrayList arrayList9 = null;
        ArrayList arrayList10 = null;
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            arrayList10 = this.getRolesForUserInDestination(session, objectNameArray2[i], string3, (String)objectNameArray);
            arrayList.addAll(arrayList10);
        }
        ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName5, null);
        for (n = 0; n < objectNameArray.length; ++n) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectNameArray[n], objectName4, null);
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                arrayList9 = this.getRolesForUserInDestination(session, objectNameArray2[i], string3, (String)object);
                arrayList.addAll(arrayList9);
            }
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string4 = (String)this.configService.getAttribute(session, objectNameArray2[n], "identifier");
            arrayList2 = this.getRolesForUserInDestination(session, objectNameArray2[n], string3, string4);
            arrayList.addAll(arrayList2);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string5 = (String)this.configService.getAttribute(session, objectNameArray2[n], "identifier");
            arrayList3 = this.getRolesForUserInDestination(session, objectNameArray2[n], string3, string5);
            arrayList.addAll(arrayList3);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string6 = (String)this.configService.getAttribute(session, objectNameArray2[n], "identifier");
            arrayList4 = this.getRolesForUserInDestination(session, objectNameArray2[n], string3, string6);
            arrayList.addAll(arrayList4);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string7 = (String)this.configService.getAttribute(session, objectNameArray2[n], "identifier");
            arrayList6 = this.getRolesForUserInDestination(session, objectNameArray2[n], string3, string7);
            arrayList.addAll(arrayList6);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string8 = (String)this.configService.getAttribute(session, objectNameArray2[n], "busName");
            arrayList7 = this.getRolesForUserInDestination(session, objectNameArray2[n], string3, string8);
            arrayList.addAll(arrayList7);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string9 = (String)this.configService.getAttribute(session, objectNameArray2[n], "destinationName");
            arrayList8 = this.getRolesForUserInDestination(session, objectNameArray2[n], string3, string9);
            arrayList.addAll(arrayList8);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthDefault", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string10 = "default";
            arrayList5 = this.getRolesForUserInDestination(session, objectNameArray2[n], string3, string10);
            arrayList.addAll(arrayList5);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBusConnect", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            ArrayList arrayList11 = (ArrayList)this.configService.getAttribute(session, objectNameArray2[n], "user");
            object = arrayList11.iterator();
            while (object.hasNext()) {
                ObjectName objectName6 = (ObjectName)object.next();
                String string11 = (String)this.configService.getAttribute(session, objectName6, "identifier");
                if (!string11.equalsIgnoreCase(string3)) continue;
                arrayList.add("busConnect");
            }
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = object = (String)arrayList.get(i);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public String[] listAllRolesForGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        int n;
        ObjectName[] objectNameArray;
        String string = "listAllRolesForGroup";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("group");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        ArrayList arrayList4 = null;
        ArrayList arrayList5 = null;
        ArrayList arrayList6 = null;
        ArrayList arrayList7 = null;
        ArrayList arrayList8 = null;
        ArrayList arrayList9 = null;
        ArrayList arrayList10 = null;
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "identifier");
            arrayList10 = this.getRolesForGroupInDestination(session, objectNameArray2[i], string3, (String)objectNameArray);
            arrayList.addAll(arrayList10);
        }
        ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName5, null);
        for (n = 0; n < objectNameArray.length; ++n) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectNameArray[n], objectName4, null);
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                arrayList9 = this.getRolesForGroupInDestination(session, objectNameArray2[i], string3, (String)object);
                arrayList.addAll(arrayList9);
            }
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string4 = (String)this.configService.getAttribute(session, objectNameArray2[n], "identifier");
            arrayList2 = this.getRolesForGroupInDestination(session, objectNameArray2[n], string3, string4);
            arrayList.addAll(arrayList2);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string5 = (String)this.configService.getAttribute(session, objectNameArray2[n], "identifier");
            arrayList3 = this.getRolesForGroupInDestination(session, objectNameArray2[n], string3, string5);
            arrayList.addAll(arrayList3);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string6 = (String)this.configService.getAttribute(session, objectNameArray2[n], "identifier");
            arrayList4 = this.getRolesForGroupInDestination(session, objectNameArray2[n], string3, string6);
            arrayList.addAll(arrayList4);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string7 = (String)this.configService.getAttribute(session, objectNameArray2[n], "identifier");
            arrayList6 = this.getRolesForGroupInDestination(session, objectNameArray2[n], string3, string7);
            arrayList.addAll(arrayList6);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string8 = (String)this.configService.getAttribute(session, objectNameArray2[n], "busName");
            arrayList7 = this.getRolesForGroupInDestination(session, objectNameArray2[n], string3, string8);
            arrayList.addAll(arrayList7);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string9 = (String)this.configService.getAttribute(session, objectNameArray2[n], "destinationName");
            arrayList8 = this.getRolesForGroupInDestination(session, objectNameArray2[n], string3, string9);
            arrayList.addAll(arrayList8);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthDefault", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            String string10 = "default";
            arrayList5 = this.getRolesForGroupInDestination(session, objectNameArray2[n], string3, string10);
            arrayList.addAll(arrayList5);
        }
        objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBusConnect", null);
        objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        for (n = 0; n < objectNameArray2.length; ++n) {
            ArrayList arrayList11 = (ArrayList)this.configService.getAttribute(session, objectNameArray2[n], "group");
            object = arrayList11.iterator();
            while (object.hasNext()) {
                ObjectName objectName6 = (ObjectName)object.next();
                String string11 = (String)this.configService.getAttribute(session, objectName6, "identifier");
                if (!string11.equalsIgnoreCase(string3)) continue;
                arrayList.add("busConnect");
            }
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = object = (String)arrayList.get(i);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public void removeUserFromAllRoles(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "removeUserFromAllRoles";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("user");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthUser", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string4 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string3.equalsIgnoreCase(string4)) continue;
            bl = true;
            this.configService.deleteConfigData(session, objectNameArray[i]);
            break;
        }
        if (!bl) {
            throw new SIBSecurityCommandException("CWSJD0102: User name '" + string3 + "' is unknown.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public void removeGroupFromAllRoles(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "removeGroupFromAllRoles";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("group");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthGroup", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string4 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string3.equalsIgnoreCase(string4)) continue;
            bl = true;
            this.configService.deleteConfigData(session, objectNameArray[i]);
            break;
        }
        if (!bl) {
            throw new SIBSecurityCommandException("CWSJD0103: Group name '" + string3 + "' is unknown.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public void removeDefaultRoles(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "removeDefaultRoles";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthDefault", null);
        ObjectName objectName5 = this.configService.queryConfigObjects(session, objectName3, objectName4, null)[0];
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            this.configService.deleteConfigData(session, objectNameArray[i]);
        }
        ObjectName objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName5, objectName7, null);
        for (int i = 0; i < objectNameArray2.length; ++i) {
            this.configService.deleteConfigData(session, objectNameArray2[i]);
        }
        ObjectName objectName8 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
        ObjectName[] objectNameArray3 = this.configService.queryConfigObjects(session, objectName5, objectName8, null);
        for (int i = 0; i < objectNameArray3.length; ++i) {
            this.configService.deleteConfigData(session, objectNameArray3[i]);
        }
        ObjectName objectName9 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
        ObjectName[] objectNameArray4 = this.configService.queryConfigObjects(session, objectName5, objectName9, null);
        for (int i = 0; i < objectNameArray4.length; ++i) {
            this.configService.deleteConfigData(session, objectNameArray4[i]);
        }
        ObjectName objectName10 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
        ObjectName[] objectNameArray5 = this.configService.queryConfigObjects(session, objectName5, objectName10, null);
        for (int i = 0; i < objectNameArray5.length; ++i) {
            this.configService.deleteConfigData(session, objectNameArray5[i]);
        }
        SIBSecurityAdminHelper.checkAllUsersForOrphans(session, objectName3);
        SIBSecurityAdminHelper.checkAllGroupsForOrphans(session, objectName3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public void removeDestinationRoles(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "removeDestinationRoles";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string5 = (String)abstractAdminCommand.getParameter("destination");
        if (string2.equalsIgnoreCase("foreignDestination") && (string4 == null || "".equals(string4))) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NOT_SPECIFIED_CWSJD0206", null, null));
        }
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray = null;
        if (string2.equalsIgnoreCase("topicSpace")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName5 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string6 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string6.equals(string5)) continue;
                objectName5 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_SPACE_NOT_FOUND_CWSJD0500", new Object[]{string5}, null));
            }
            this.configService.deleteConfigData(session, objectName5);
        } else if (string2.equalsIgnoreCase("queue")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName6 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string7 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string7.equals(string5)) continue;
                objectName6 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("QUEUE_NOT_FOUND_CWSJD0201", new Object[]{string5}, null));
            }
            this.configService.deleteConfigData(session, objectName6);
        } else if (string2.equalsIgnoreCase("webService")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName7 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string8 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string8.equals(string5)) continue;
                objectName7 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("WEB_SERVICE_NOT_FOUND_CWSJD0202", new Object[]{string5}, null));
            }
            this.configService.deleteConfigData(session, objectName7);
        } else if (string2.equalsIgnoreCase("port")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName8 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string9 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string9.equals(string5)) continue;
                objectName8 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("PORT_NOT_FOUND_CWSJD0203", new Object[]{string5}, null));
            }
            this.configService.deleteConfigData(session, objectName8);
        } else if (string2.equalsIgnoreCase("alias")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName9 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string10 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                String string11 = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
                if (!string10.equals(string5) || !string11.equals(string3)) continue;
                objectName9 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("ALIAS_NOT_FOUND_CWSJD0204", new Object[]{string5}, null));
            }
            this.configService.deleteConfigData(session, objectName9);
        } else if (string2.equalsIgnoreCase("foreignDestination")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName10 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string12 = (String)this.configService.getAttribute(session, objectNameArray[i], "destinationName");
                String string13 = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
                if (!string12.equals(string5) || !string13.equals(string4)) continue;
                objectName10 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_DEST_NOT_FOUND_CWSJD0207", new Object[]{string3, string5}, null));
            }
            this.configService.deleteConfigData(session, objectName10);
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string2}, null));
        }
        SIBSecurityAdminHelper.checkAllUsersForOrphans(session, objectName3);
        SIBSecurityAdminHelper.checkAllGroupsForOrphans(session, objectName3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public void removeForeignBusRoles(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName[] objectNameArray;
        String string = "removeForeignBusRoles";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("foreignBus");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectNameArray2[i], "busName");
            if (!objectNameArray.equals(string3)) continue;
            objectName5 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NAME_NOT_FOUND_CWSJD0301", new Object[]{string3}, null));
        }
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
        objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            this.configService.deleteConfigData(session, objectNameArray[i]);
        }
        ObjectName objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
        ObjectName[] objectNameArray3 = this.configService.queryConfigObjects(session, objectName5, objectName7, null);
        for (int i = 0; i < objectNameArray3.length; ++i) {
            this.configService.deleteConfigData(session, objectNameArray3[i]);
        }
        this.configService.deleteConfigData(session, objectName5);
        SIBSecurityAdminHelper.checkAllUsersForOrphans(session, objectName3);
        SIBSecurityAdminHelper.checkAllGroupsForOrphans(session, objectName3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    private ArrayList getRolesForUserInDestination(Session session, ObjectName objectName, String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
        ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName, objectName3, null);
        ObjectName[] objectNameArray3 = this.configService.queryConfigObjects(session, objectName, objectName4, null);
        ObjectName[] objectNameArray4 = this.configService.queryConfigObjects(session, objectName, objectName5, null);
        ObjectName[] objectNameArray5 = this.configService.queryConfigObjects(session, objectName, objectName6, null);
        ObjectName objectName7 = null;
        ObjectName objectName8 = null;
        ObjectName objectName9 = null;
        ObjectName objectName10 = null;
        ObjectName objectName11 = null;
        if (objectNameArray.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName7 = objectNameArray[0])) {
            arrayList.add(string2 + ":" + "sender");
        }
        if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName8 = objectNameArray2[0])) {
            arrayList.add(string2 + ":" + "receiver");
        }
        if (objectNameArray3.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName9 = objectNameArray3[0])) {
            arrayList.add(string2 + ":" + "browser");
        }
        if (objectNameArray4.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName10 = objectNameArray4[0])) {
            arrayList.add(string2 + ":" + "creator");
        }
        if (objectNameArray5.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName11 = objectNameArray5[0])) {
            arrayList.add(string2 + ":" + "identityAdopter");
        }
        return arrayList;
    }

    private ArrayList getRolesForGroupInDestination(Session session, ObjectName objectName, String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
        ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName, objectName3, null);
        ObjectName[] objectNameArray3 = this.configService.queryConfigObjects(session, objectName, objectName4, null);
        ObjectName[] objectNameArray4 = this.configService.queryConfigObjects(session, objectName, objectName5, null);
        ObjectName[] objectNameArray5 = this.configService.queryConfigObjects(session, objectName, objectName6, null);
        ObjectName objectName7 = null;
        ObjectName objectName8 = null;
        ObjectName objectName9 = null;
        ObjectName objectName10 = null;
        ObjectName objectName11 = null;
        if (objectNameArray.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName7 = objectNameArray[0])) {
            arrayList.add(string2 + ":" + "sender");
        }
        if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName8 = objectNameArray2[0])) {
            arrayList.add(string2 + ":" + "receiver");
        }
        if (objectNameArray3.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName9 = objectNameArray3[0])) {
            arrayList.add(string2 + ":" + "browser");
        }
        if (objectNameArray4.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName10 = objectNameArray4[0])) {
            arrayList.add(string2 + ":" + "creator");
        }
        if (objectNameArray5.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName11 = objectNameArray5[0])) {
            arrayList.add(string2 + ":" + "identityAdopter");
        }
        return arrayList;
    }
}

