/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.config.repository.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.config.repository.impl.DBRepository;
import com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl;
import com.ibm.ws.sdo.config.repository.impl.RepositoryRuntimeException;
import com.ibm.ws.sdo.config.repository.impl.URLRepository;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.sdo.config.repository.RepositoryException;
import com.ibm.wsspi.sdo.config.repository.RepositoryResourceNotFoundException;
import com.ibm.wsspi.sib.sdo.SystemSDORepository;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class SDORepositoryImpl
extends SystemSDORepository {
    static final TraceComponent tc = SibTr.register(SDORepositoryImpl.class, "SIBSdoRepository", "com.ibm.wsspi.sdo.config.CWSJOMessages");
    private URLRepository urlRepository;
    private DBRepository dbRepository;
    private final ResourceResolver emfEnvResourceResolver = new ResourceResolver(){

        public Resource resolveResource(URI uRI, EObject eObject) {
            ResourceSet resourceSet;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "emfEnvResourceResolver.resolveResource", new Object[]{uRI, eObject});
            }
            Resource resource = null;
            Resource resource2 = eObject.eResource();
            if (resource2 != null && (resourceSet = resource2.getResourceSet()) != null) {
                resource = resourceSet.getResource(uRI, false);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "emfEnvResourceResolver.resolveResource", resource);
            }
            return resource;
        }
    };
    private final ResourceResolver repositoryResourceResolver = new ResourceResolver(){

        public Resource resolveResource(URI uRI, EObject eObject) throws IOException {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "repositoryResourceResolver.resolveResource", new Object[]{uRI, eObject});
            }
            Resource resource = SDORepositoryImpl.this.getResourceOrNull(uRI.toString());
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "repositoryResourceResolver.resolveResource", resource);
            }
            return resource;
        }
    };

    public SDORepositoryImpl() throws NamingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "SDORepositoryImpl");
        }
        this.setURLRepository(URLRepository.DEFAULT_INSTANCE);
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper == null || !platformHelper.isCRAJvm()) {
            this.setDBRepository(new DBRepositoryImpl());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "SDORepositoryImpl");
        }
    }

    private InputStream getInputStreamOrNull(String string) {
        DBRepository dBRepository;
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInputStreamOrNull", (Object)string);
        }
        if ((inputStream = this.urlRepository.getInputStream(string = this.convertNameToUriString(string))) == null && (dBRepository = this.getDBRepository()) != null) {
            inputStream = dBRepository.getInputStream(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInputStreamOrNull", inputStream);
        }
        return inputStream;
    }

    public OutputStream getOutputStream(String string, boolean bl) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getOutputStream", new Object[]{string, new Boolean(bl)});
        }
        this.nullCheck(string);
        this.checkForReservedName(string);
        OutputStream outputStream = null;
        DBRepository dBRepository = this.getDBRepository();
        if (dBRepository == null) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            FFDCFilter.processException((Throwable)unsupportedOperationException, (String)"com.ibm.ws.sdo.config.repository.impl.SDORepositoryImpl.getOutputStream", (String)"167", (Object)this);
            throw unsupportedOperationException;
        }
        outputStream = dBRepository.getOutputStream(string, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getOutputStream", outputStream);
        }
        return outputStream;
    }

    private Resource getResourceOrNull(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getResource", (Object)string);
        }
        string = this.convertNameToUriString(string);
        Resource resource = null;
        InputStream inputStream = this.getInputStreamOrNull(string);
        if (inputStream != null) {
            resource = this.createResource(URI.createURI((String)string));
            resource.load(inputStream, null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getResource", resource);
        }
        return resource;
    }

    public void putResource(Resource resource, String string, boolean bl) throws RepositoryException, IOException {
        String string2;
        Object object;
        URI uRI;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "putResource", new Object[]{resource, string, new Boolean(bl)});
        }
        if (resource == null) {
            throw new NullPointerException("CANNOT_REGISTER_NULL_VALUE_CWSJO0003");
        }
        if (string == null) {
            uRI = resource.getURI();
            object = resource.getResourceSet();
            if (object != null) {
                uRI = object.getURIConverter().normalize(uRI);
            }
            string2 = uRI.toString();
        } else {
            string2 = this.convertNameToUriString(string);
        }
        uRI = this.createResource(resource.getURI());
        object = EcoreUtil.copyAll((Collection)resource.getContents());
        uRI.getContents().clear();
        uRI.getContents().addAll((Collection)object);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            uRI.save((OutputStream)byteArrayOutputStream, null);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.checkForReservedName(string);
            DBRepository dBRepository = this.getDBRepository();
            if (dBRepository == null) {
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                FFDCFilter.processException((Throwable)unsupportedOperationException, (String)"com.ibm.ws.sdo.config.repository.impl.SDORepositoryImpl.putResource", (String)"240", (Object)this);
                throw unsupportedOperationException;
            }
            dBRepository.register(string2, byArray, bl);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sdo.config.repository.impl.SDORepositoryImpl.putResource", (String)"222", (Object)this);
            throw new RepositoryRuntimeException(iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "putResource");
        }
    }

    public void putResource(Resource resource, String string, boolean bl, boolean bl2) throws RepositoryException, IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "putResource", new Object[]{resource, string, new Boolean(bl), new Boolean(bl2)});
        }
        if (bl2) {
            HashSet hashSet = new HashSet();
            this.identifyExternalResources(resource, hashSet, this.emfEnvResourceResolver);
            hashSet.remove(resource);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Resource resource2 = (Resource)iterator.next();
                this.putResource(resource2, null, bl);
            }
        }
        this.putResource(resource, string, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "putResource");
        }
    }

    private void remove(String string) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "remove", (Object)string);
        }
        this.nullCheck(string);
        this.checkForReservedName(string);
        DBRepository dBRepository = this.getDBRepository();
        if (dBRepository == null) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            FFDCFilter.processException((Throwable)unsupportedOperationException, (String)"com.ibm.ws.sdo.config.repository.impl.SDORepositoryImpl.remove", (String)"289", (Object)this);
            throw unsupportedOperationException;
        }
        dBRepository.remove(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "remove");
        }
    }

    public void remove(String string, boolean bl) throws IOException, RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "remove", new Object[]{string, new Boolean(bl)});
        }
        HashSet hashSet = new HashSet();
        if (bl) {
            Resource resource = this.getResourceOrNull(string);
            if (resource != null) {
                this.identifyExternalResources(resource, hashSet, this.repositoryResourceResolver);
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    resource = (Resource)iterator.next();
                    this.remove(resource.getURI().toString());
                }
            }
        } else {
            this.remove(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "remove");
        }
    }

    public List listResources() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "listResources");
        }
        List list = this.urlRepository.listResources();
        DBRepository dBRepository = this.getDBRepository();
        if (dBRepository != null) {
            list.addAll(dBRepository.listResources());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "listResources", list);
        }
        return list;
    }

    public Long getTimestamp(String string) {
        DBRepository dBRepository;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTimestamp", (Object)string);
        }
        this.nullCheck(string);
        Long l = this.urlRepository.getTimestamp(string);
        if (l == null && (dBRepository = this.getDBRepository()) != null) {
            l = dBRepository.getTimestamp(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTimestamp", l);
        }
        return l;
    }

    private void nullCheck(String string) {
        if (string == null) {
            throw new NullPointerException("NULL_NAME_CWSJO0001");
        }
    }

    private String convertNameToUriString(String string) {
        return string;
    }

    private Resource createResource(URI uRI) {
        return new XMIResourceFactoryImpl().createResource(uRI);
    }

    private void identifyExternalResources(Resource resource, Set set, ResourceResolver resourceResolver) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "identifyExternalResources", new Object[]{resource, set, resourceResolver});
        }
        set.add(resource);
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            Iterator iterator2 = eObject.eCrossReferences().iterator();
            while (iterator2.hasNext()) {
                EObject eObject2 = (EObject)iterator2.next();
                URI uRI = EcoreUtil.getURI((EObject)eObject2).trimFragment();
                Resource resource2 = resourceResolver.resolveResource(uRI, eObject2);
                if (resource2 == null || set.contains(resource2)) continue;
                this.identifyExternalResources(resource2, set, resourceResolver);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "identifyExternalResources");
        }
    }

    protected void setURLRepository(URLRepository uRLRepository) {
        this.urlRepository = uRLRepository;
    }

    protected URLRepository getURLRepository() {
        return this.urlRepository;
    }

    protected void setDBRepository(DBRepository dBRepository) {
        this.dbRepository = dBRepository;
    }

    public DBRepository getDBRepository() {
        return this.dbRepository;
    }

    public void registerEphemeralResource(URL uRL, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "registerEphemeralResource", new Object[]{uRL, string});
        }
        this.urlRepository.registerResource(uRL, string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "registerEphemeralResource");
        }
    }

    private void checkForReservedName(String string) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkForReservedName", (Object)string);
        }
        if (this.urlRepository.listResources().contains(string)) {
            throw new RepositoryException("RESERVED_NAME_CWSJO0007E", new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkForReservedName");
        }
    }

    public InputStream getInputStream(String string) throws RepositoryResourceNotFoundException {
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInputStream", (Object)string);
        }
        if ((inputStream = this.getInputStreamOrNull(string)) == null) {
            throw new RepositoryResourceNotFoundException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInputStream", inputStream);
        }
        return inputStream;
    }

    public Resource getResource(String string) throws IOException, RepositoryResourceNotFoundException {
        Resource resource;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getResource", (Object)string);
        }
        if ((resource = this.getResourceOrNull(string)) == null) {
            throw new RepositoryResourceNotFoundException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getResource", resource);
        }
        return resource;
    }

    private static interface ResourceResolver {
        public Resource resolveResource(URI var1, EObject var2) throws IOException;
    }
}

