/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.config.repository.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.config.repository.impl.ByteStoreLocal;
import com.ibm.ws.sdo.config.repository.impl.ByteStoreLocalHome;
import com.ibm.ws.sdo.config.repository.impl.CheckedNullPointerException;
import com.ibm.ws.sdo.config.repository.impl.RepositoryRuntimeException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sdo.config.repository.RepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class RepositoryBean
implements SessionBean {
    private static final long serialVersionUID = 8457736769452479948L;
    private static final TraceComponent tc = SibTr.register(RepositoryBean.class, "SIBSdoRepository", "com.ibm.wsspi.sdo.config.CWSJOMessages");
    private final String REPOSITORY_JNDI_NAME = "java:comp/env/ejb/ByteStore";
    private final String ENV_VAR_PREFIX = "java:comp/env/";
    private final String MAX_NAME_SIZE_JNDI_NAME = "java:comp/env/maxNameSize";
    private final String MAX_VALUE_SIZE_JNDI_NAME = "java:comp/env/maxValueSize";
    private SessionContext mySessionCtx;

    public SessionContext getSessionContext() {
        return this.mySessionCtx;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.mySessionCtx = sessionContext;
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void register(String string, byte[] byArray, boolean bl) throws CheckedNullPointerException, RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "register", new Object[]{string, byArray, new Boolean(bl)});
        }
        this.nullCheck(string);
        if (byArray == null) {
            throw new CheckedNullPointerException("CANNOT_REGISTER_NULL_VALUE_CWSJO0003");
        }
        if (byArray.length == 0) {
            throw new CheckedNullPointerException("CANNOT_REGISTER_EMPTY_VALUE_CWSJO0002");
        }
        if (bl) {
            this.unregister(string);
        }
        this.createByteStoreEntry(string, byArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "register");
        }
    }

    public void registerWithOptimisticUpdate(String string, byte[] byArray, byte[] byArray2) throws CheckedNullPointerException, RepositoryException {
        byte[] byArray3 = this.getBytes(string, true);
        if (!Arrays.equals(byArray3, byArray2)) {
            throw new RepositoryException("OPTIMISTIC_UPDATE_FAILED_CWSJO0005E", new Object[]{string});
        }
        if (byArray == null || byArray.length == 0) {
            this.unregister(string);
        } else {
            this.register(string, byArray, true);
        }
    }

    protected Context getInitialContext() throws NamingException {
        return new InitialContext();
    }

    private ByteStoreLocalHome getByteStoreHome() {
        try {
            Context context = this.getInitialContext();
            Object object = context.lookup("java:comp/env/ejb/ByteStore");
            ByteStoreLocalHome byteStoreLocalHome = (ByteStoreLocalHome)object;
            return byteStoreLocalHome;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.getByteStoreHome", (String)"154", (Object)this);
            throw new RepositoryRuntimeException(namingException);
        }
    }

    public byte[] getBytes(String string) throws CheckedNullPointerException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBytes", (Object)string);
        }
        byte[] byArray = this.getBytes(string, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBytes", byArray);
        }
        return byArray;
    }

    public byte[] getBytes(String string, boolean bl) throws CheckedNullPointerException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBytes", (Object)string);
        }
        this.nullCheck(string);
        int n = this.getEnvironmentVariable_Integer("java:comp/env/maxNameSize");
        if (string.length() > n) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getBytes", null);
            }
            return null;
        }
        byte[] byArray = null;
        try {
            ByteStoreLocalHome byteStoreLocalHome = this.getByteStoreHome();
            ByteStoreLocal byteStoreLocal = bl ? byteStoreLocalHome.findByPrimaryKeyForUpdate(string) : byteStoreLocalHome.findByPrimaryKey(string);
            byArray = byteStoreLocal.getBytes();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "byteStoreHome.findByPrimaryKey did not find a result for name: " + string);
            }
        }
        catch (FinderException finderException) {
            FFDCFilter.processException((Throwable)finderException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.getBytes", (String)"179", (Object)this);
            throw new RepositoryRuntimeException(finderException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBytes", byArray);
        }
        return byArray;
    }

    private void createByteStoreEntry(String string, byte[] byArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createByteStoreEntry", new Object[]{string, byArray});
        }
        int n = this.getEnvironmentVariable_Integer("java:comp/env/maxNameSize");
        int n2 = this.getEnvironmentVariable_Integer("java:comp/env/maxValueSize");
        if (string.length() > n) {
            throw new RepositoryException("NAME_TOO_LONG_CWSJO0045", new Object[]{new Integer(n), string});
        }
        if (byArray.length > n2) {
            throw new RepositoryException("VALUE_TOO_LONG_CWSJO0046", new Object[]{new Integer(n2), string, new Integer(byArray.length)});
        }
        ByteStoreLocalHome byteStoreLocalHome = this.getByteStoreHome();
        ByteStoreLocal byteStoreLocal = null;
        try {
            byteStoreLocal = byteStoreLocalHome.create(string);
            byteStoreLocal.setBytes(byArray);
            long l = System.currentTimeMillis();
            byteStoreLocal.setTimestamp(l);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            FFDCFilter.processException((Throwable)duplicateKeyException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.createByteStoreEntry", (String)"210", (Object)this);
            throw new RepositoryException("NAME_ALREADY_USED_CWSJO0004", new Object[]{string});
        }
        catch (CreateException createException) {
            FFDCFilter.processException((Throwable)createException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.createByteStoreEntry", (String)"215", (Object)this);
            throw new RepositoryRuntimeException(createException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createByteStoreEntry");
        }
    }

    public void unregister(String string) throws CheckedNullPointerException, RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unregister", (Object)string);
        }
        this.nullCheck(string);
        this.removeByteStoreEntry(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unregister");
        }
    }

    private void removeByteStoreEntry(String string) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "removeByteStoreEntry", (Object)string);
        }
        int n = this.getEnvironmentVariable_Integer("java:comp/env/maxNameSize");
        if (string.length() > n) {
            throw new RepositoryException("NAME_TOO_LONG_CWSJO0045", new Object[]{new Integer(n), string});
        }
        try {
            ByteStoreLocalHome byteStoreLocalHome = this.getByteStoreHome();
            byteStoreLocalHome.remove(string);
        }
        catch (NoSuchObjectLocalException noSuchObjectLocalException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "byteStoreHome.remove did not find a result to remove for name: " + string);
            }
        }
        catch (EJBException eJBException) {
            FFDCFilter.processException((Throwable)eJBException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.removeByteStoreEntry", (String)"253", (Object)this);
            throw new RepositoryRuntimeException(eJBException);
        }
        catch (RemoveException removeException) {
            FFDCFilter.processException((Throwable)removeException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.removeByteStoreEntry", (String)"258", (Object)this);
            throw new RepositoryRuntimeException(removeException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "removeByteStoreEntry");
        }
    }

    private void nullCheck(String string) throws CheckedNullPointerException {
        if (string == null) {
            throw new CheckedNullPointerException("NULL_NAME_CWSJO0001");
        }
    }

    public ArrayList getAllNames() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getAllNames");
        }
        ArrayList<String> arrayList = null;
        try {
            ByteStoreLocalHome byteStoreLocalHome = this.getByteStoreHome();
            Collection collection = byteStoreLocalHome.findAllKeys();
            arrayList = new ArrayList<String>();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ByteStoreLocal byteStoreLocal = (ByteStoreLocal)iterator.next();
                arrayList.add(byteStoreLocal.getName());
            }
        }
        catch (FinderException finderException) {
            FFDCFilter.processException((Throwable)finderException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.getAllNames", (String)"299", (Object)this);
            throw new RepositoryRuntimeException(finderException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getAllNames", arrayList);
        }
        return arrayList;
    }

    public Long getTimestamp(String string) throws CheckedNullPointerException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTimestamp", (Object)string);
        }
        this.nullCheck(string);
        int n = this.getEnvironmentVariable_Integer("java:comp/env/maxNameSize");
        if (string.length() > n) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getTimestamp", null);
            }
            return null;
        }
        Long l = null;
        try {
            ByteStoreLocalHome byteStoreLocalHome = this.getByteStoreHome();
            ByteStoreLocal byteStoreLocal = byteStoreLocalHome.findByPrimaryKey(string);
            long l2 = byteStoreLocal.getTimestamp();
            l = new Long(l2);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            FFDCFilter.processException((Throwable)objectNotFoundException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.getTimestamp", (String)"320", (Object)this);
            return null;
        }
        catch (FinderException finderException) {
            FFDCFilter.processException((Throwable)finderException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.getTimestamp", (String)"326", (Object)this);
            throw new RepositoryRuntimeException(finderException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTimestamp", l);
        }
        return l;
    }

    private int getEnvironmentVariable_Integer(String string) {
        try {
            Context context = this.getInitialContext();
            Object object = context.lookup(string);
            Integer n = (Integer)object;
            return n;
        }
        catch (NameNotFoundException nameNotFoundException) {
            FFDCFilter.processException((Throwable)nameNotFoundException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.getEnvironmentVariable_Integer", (String)"394", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "getEnvironmentVariable_Integer did not find a result for name: " + string);
            }
            throw new RepositoryRuntimeException(nameNotFoundException);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.getEnvironmentVariable_Integer", (String)"400", (Object)this);
            throw new RepositoryRuntimeException(namingException);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryBean.getEnvironmentVariable_Integer", (String)"406", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "getEnvironmentVariable_Integer found a non-Integer result for name: " + string);
            }
            throw new RepositoryRuntimeException(classCastException);
        }
    }
}

