/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.config.repository.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.config.repository.impl.CheckedNullPointerException;
import com.ibm.ws.sdo.config.repository.impl.DBRepository;
import com.ibm.ws.sdo.config.repository.impl.Repository;
import com.ibm.ws.sdo.config.repository.impl.RepositoryHome;
import com.ibm.ws.sdo.config.repository.impl.RepositoryOutputStream;
import com.ibm.ws.sdo.config.repository.impl.RepositoryRuntimeException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sdo.config.repository.RepositoryException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class DBRepositoryImpl
extends DBRepository {
    private static final TraceComponent tc = SibTr.register(DBRepositoryImpl.class, "SIBSdoRepository", "com.ibm.wsspi.sdo.config.CWSJOMessages");
    private Context context;
    private static final byte[] COMPRESSED_HEADER_FLAG = "SDOREP-COMPRESSED".getBytes();
    private static final String REPOSITORY_JNDI_NAME = "ejb/com/ibm/ws/sdo/config/repository/RepositoryHome";
    private RepositoryHome repositoryHome = null;

    public DBRepositoryImpl() throws NamingException {
        this.setContext(new InitialContext());
    }

    public InputStream getInputStream(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInputStream", (Object)string);
        }
        InputStream inputStream = null;
        try {
            Repository repository = this.getRepository();
            byte[] byArray = repository.getBytes(string);
            if (byArray != null) {
                inputStream = DBRepositoryImpl.uncompressToStream(byArray);
            }
        }
        catch (CheckedNullPointerException checkedNullPointerException) {
            FFDCFilter.processException((Throwable)checkedNullPointerException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.getInputStream", (String)"79", (Object)this);
            throw checkedNullPointerException.getOriginalException();
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.getInputStream", (String)"84", (Object)this);
            throw new RepositoryRuntimeException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInputStream", inputStream);
        }
        return inputStream;
    }

    private RepositoryHome getRepositoryHome() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getRepositoryHome");
        }
        try {
            if (this.repositoryHome == null) {
                Context context = this.getContext();
                Object object = context.lookup(REPOSITORY_JNDI_NAME);
                this.repositoryHome = (RepositoryHome)PortableRemoteObject.narrow((Object)object, (Class)RepositoryHome.class);
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.getRepositoryHome", (String)"106", (Object)this);
            throw new RepositoryRuntimeException("APP_NOT_FOUND_CWSJO0054", namingException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getRepositoryHome", this.repositoryHome);
        }
        return this.repositoryHome;
    }

    private Repository getRepository() {
        try {
            return this.getRepositoryHome().create();
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.getRepository", (String)"124", (Object)this);
            throw new RepositoryRuntimeException(remoteException);
        }
        catch (CreateException createException) {
            FFDCFilter.processException((Throwable)createException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.getRepository", (String)"129", (Object)this);
            throw new RepositoryRuntimeException(createException);
        }
    }

    protected void setContext(Context context) {
        this.context = context;
    }

    protected Context getContext() {
        return this.context;
    }

    public OutputStream getOutputStream(String string, boolean bl) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getOutputStream", new Object[]{string, new Boolean(bl)});
        }
        RepositoryHome repositoryHome = this.getRepositoryHome();
        RepositoryOutputStream repositoryOutputStream = new RepositoryOutputStream(string, bl, repositoryHome);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getOutputStream", repositoryOutputStream);
        }
        return repositoryOutputStream;
    }

    public void remove(String string) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "remove", (Object)string);
        }
        try {
            Repository repository = this.getRepository();
            repository.unregister(string);
        }
        catch (CheckedNullPointerException checkedNullPointerException) {
            FFDCFilter.processException((Throwable)checkedNullPointerException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.remove", (String)"179", (Object)this);
            throw checkedNullPointerException.getOriginalException();
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.remove", (String)"184", (Object)this);
            throw new RepositoryRuntimeException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "remove");
        }
    }

    public List listResources() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "listResources");
        }
        ArrayList arrayList = null;
        try {
            Repository repository = this.getRepository();
            arrayList = repository.getAllNames();
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.listResources", (String)"202", (Object)this);
            throw new RepositoryRuntimeException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "listResources", arrayList);
        }
        return arrayList;
    }

    public Long getTimestamp(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTimestamp", (Object)string);
        }
        Long l = null;
        try {
            Repository repository = this.getRepository();
            l = repository.getTimestamp(string);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.getTimestamp", (String)"219", (Object)this);
            throw new RepositoryRuntimeException(remoteException);
        }
        catch (CheckedNullPointerException checkedNullPointerException) {
            FFDCFilter.processException((Throwable)checkedNullPointerException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.getTimestamp", (String)"224", (Object)this);
            throw checkedNullPointerException.getOriginalException();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTimestamp", l);
        }
        return l;
    }

    public void register(String string, byte[] byArray, boolean bl) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "register", new Object[]{string, byArray, new Boolean(bl)});
        }
        byte[] byArray2 = DBRepositoryImpl.compress(byArray);
        try {
            Repository repository = this.getRepository();
            repository.register(string, byArray2, bl);
        }
        catch (CheckedNullPointerException checkedNullPointerException) {
            FFDCFilter.processException((Throwable)checkedNullPointerException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.register", (String)"238", (Object)this);
            throw checkedNullPointerException.getOriginalException();
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.register", (String)"243", (Object)this);
            throw new RepositoryRuntimeException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "register");
        }
    }

    public static byte[] compress(byte[] byArray) throws RepositoryRuntimeException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "compress", byArray);
        }
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        try {
            byteArrayOutputStream.write(COMPRESSED_HEADER_FLAG);
            deflaterOutputStream.write(byArray);
            deflaterOutputStream.flush();
            deflaterOutputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl.compress", (String)"300");
            throw new RepositoryRuntimeException(iOException);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length >= byArray.length) {
            byArray2 = byArray;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "compress", byArray2);
        }
        return byArray2;
    }

    public static InputStream uncompressToStream(byte[] byArray) {
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "uncompressToStream", byArray);
        }
        if (DBRepositoryImpl.beginsWith(byArray, COMPRESSED_HEADER_FLAG)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, COMPRESSED_HEADER_FLAG.length, byArray.length);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
            inputStream = new BufferedInputStream(inflaterInputStream, byArray.length * 5);
        } else {
            inputStream = new ByteArrayInputStream(byArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "uncompressToStream", inputStream);
        }
        return inputStream;
    }

    private static boolean beginsWith(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

