/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.sib.SIBAdminCommandException;
import com.ibm.ws.management.commands.sib.SIBAdminCommandHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SIBMediationCommandProvider
extends SimpleCommandProvider {
    private static final String CLASS_NAME = "com.ibm.ws.management.commands.sib.SIBMediationCommandProvider";
    private CommandProviderHelper helper = this.getCommandProviderHelper();
    private ConfigService configService = this.helper.getConfigService();
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");
    private static final TraceComponent tc = SibTr.register(SIBMediationCommandProvider.class, "SIBAdmin", "com.ibm.ws.sib.admin.impl.CWSIDMessages");

    public ObjectName createSIBMediation(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "createSIBMediation";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("mediationName");
        String string4 = (String)abstractAdminCommand.getParameter("description");
        String string5 = (String)abstractAdminCommand.getParameter("handlerListName");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("globalTransaction");
        Boolean bl2 = (Boolean)abstractAdminCommand.getParameter("allowConcurrentMediation");
        String string6 = (String)abstractAdminCommand.getParameter("selector");
        String string7 = (String)abstractAdminCommand.getParameter("discriminator");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (string3 == null || string3.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "mediationName"}, null));
        }
        if (string5 == null || string5.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "handlerListname"}, null));
        }
        if (!SIBAdminCommandHelper.nameOkForCreate(string3)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_CREATE_MEDIATION_NAME_CWSJA0609", new Object[]{string3}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.resolve(session, "SIBus=" + string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediation", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            if (!this.configService.getAttribute(session, objectNameArray[i], "mediationName").equals(string3)) continue;
            throw new SIBAdminCommandException(nls.getFormattedMessage("MEDIATION_ALREADY_EXISTS_CWSJA0600", new Object[]{string3}, null));
        }
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"mediationName", (Object)string3);
        if (string4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string4);
        }
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"handlerListName", (Object)string5);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"globalTransaction", (Object)bl);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"allowConcurrentMediation", (Object)bl2);
        if (string6 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"selector", (Object)string6);
        }
        if (string7 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"discriminator", (Object)string7);
        }
        ObjectName objectName3 = this.configService.createConfigData(session, objectName, "SIBDestinationMediation", "SIBDestinationMediation", attributeList);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string);
        }
        return objectName3;
    }

    public String deleteSIBMediation(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteSIBMediation";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("mediationName");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (string3 == null || string3.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "mediationName"}, null));
        }
        if (!SIBAdminCommandHelper.nameOkForCreate(string3)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_DELETE_MEDIATION_NAME_CWSJA0610", new Object[]{string3}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.resolve(session, "SIBus=" + string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediation", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            if (!this.configService.getAttribute(session, objectNameArray[i], "mediationName").equals(string3)) continue;
            objectName3 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MEDIATION_NOT_FOUND_CWSJA0601", new Object[]{string3}, null));
        }
        String string4 = (String)this.configService.getAttribute(session, objectName3, "uuid");
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestination", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName, objectName4, null);
        for (int i = 0; i < objectNameArray2.length; ++i) {
            ObjectName objectName5 = objectNameArray2[i];
            ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediationRef", null);
            ObjectName[] objectNameArray3 = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
            for (int j = 0; j < objectNameArray3.length; ++j) {
                ObjectName objectName7 = objectNameArray3[j];
                String string5 = (String)this.configService.getAttribute(session, objectName7, "mediationUuid");
                if (!string5.equals(string4)) continue;
                String string6 = (String)this.configService.getAttribute(session, objectName5, "identifier");
                throw new SIBAdminCommandException(nls.getFormattedMessage("MEDIATION_IN_USE_CWSJA0602", new Object[]{string3, string6}, null));
            }
        }
        this.configService.deleteConfigData(session, objectName3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string);
        }
        return "";
    }

    public ObjectName[] listSIBMediations(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "listSIBMediations";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.resolve(session, "SIBus=" + string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediation", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string);
        }
        return objectNameArray;
    }

    public ObjectName modifySIBMediation(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "modifySIBMediation";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("mediationName");
        String string4 = (String)abstractAdminCommand.getParameter("description");
        String string5 = (String)abstractAdminCommand.getParameter("handlerListName");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("globalTransaction");
        Boolean bl2 = (Boolean)abstractAdminCommand.getParameter("allowConcurrentMediation");
        String string6 = (String)abstractAdminCommand.getParameter("selector");
        String string7 = (String)abstractAdminCommand.getParameter("discriminator");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (string3 == null || string3.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "mediationName"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.resolve(session, "SIBus=" + string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediation", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        boolean bl3 = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            if (!this.configService.getAttribute(session, objectNameArray[i], "mediationName").equals(string3)) continue;
            objectName3 = objectNameArray[i];
            bl3 = true;
            break;
        }
        if (!bl3) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MEDIATION_NOT_FOUND_CWSJA0601", new Object[]{string3}, null));
        }
        AttributeList attributeList = new AttributeList();
        if (string4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string4);
        }
        if (string5 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"handlerListName", (Object)string5);
        }
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"globalTransaction", (Object)bl);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"allowConcurrentMediation", (Object)bl2);
        if (string6 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"selector", (Object)string6);
        }
        if (string7 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"discriminator", (Object)string7);
        }
        this.configService.setAttributes(session, objectName3, attributeList);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string);
        }
        return objectName3;
    }

    public AttributeList showSIBMediation(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "showSIBMediation";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("mediationName");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (string3 == null || string3.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "mediationName"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.resolve(session, "SIBus=" + string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediation", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            if (!this.configService.getAttribute(session, objectNameArray[i], "mediationName").equals(string3)) continue;
            objectName3 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MEDIATION_NOT_FOUND_CWSJA0601", new Object[]{string3}, null));
        }
        AttributeList attributeList = this.configService.getAttributes(session, objectName3, null, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string);
        }
        return attributeList;
    }

    public String mediateSIBDestination(AbstractAdminCommand abstractAdminCommand) throws Exception {
        int n;
        ObjectName[] objectNameArray;
        ObjectName objectName;
        Object object;
        Object object2;
        String string;
        String string2 = "mediateSIBDestination";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("destinationName");
        String string5 = (String)abstractAdminCommand.getParameter("mediationName");
        String string6 = (String)abstractAdminCommand.getParameter("node");
        String string7 = (String)abstractAdminCommand.getParameter("server");
        String string8 = (String)abstractAdminCommand.getParameter("cluster");
        if (string3 == null || string3.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string2, "bus"}, null));
        }
        if (string4 == null || string4.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string2, "destinationName"}, null));
        }
        if (string5 == null || string5.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string2, "mediationName"}, null));
        }
        if (!SIBAdminCommandHelper.isScopeValid(string6, string7, string8)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MEDIATE_DESTINATION_PARAMETERS_INCORRECT_CWSJA0605", null, null));
        }
        ObjectName objectName2 = SIBAdminCommandHelper.resolve(session, "SIBus=" + string3);
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestination", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
        ObjectName objectName4 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            if (!this.configService.getAttribute(session, objectNameArray2[i], "identifier").equals(string4)) continue;
            objectName4 = objectNameArray2[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("DESTINATION_NOT_FOUND_CWSJA0603", new Object[]{string4}, null));
        }
        ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediation", null);
        ObjectName[] objectNameArray3 = this.configService.queryConfigObjects(session, objectName2, objectName5, null);
        ObjectName objectName6 = null;
        bl = false;
        for (int i = 0; i < objectNameArray3.length; ++i) {
            if (!this.configService.getAttribute(session, objectNameArray3[i], "mediationName").equals(string5)) continue;
            objectName6 = objectNameArray3[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MEDIATION_NOT_FOUND_CWSJA0601", new Object[]{string5}, null));
        }
        ObjectName objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediationRef", null);
        ObjectName[] objectNameArray4 = this.configService.queryConfigObjects(session, objectName4, objectName7, null);
        if (objectNameArray4.length > 0) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("DESTINATION_ALREADY_MEDIATED_CWSJA0604", new Object[]{string4}, null));
        }
        ObjectName objectName8 = ConfigServiceHelper.createObjectName(null, (String)"SIBusMember", null);
        ObjectName[] objectNameArray5 = this.configService.queryConfigObjects(session, objectName2, objectName8, null);
        ObjectName objectName9 = null;
        bl = false;
        for (int i = 0; i < objectNameArray5.length; ++i) {
            if (string7 != null) {
                try {
                    string = (String)this.configService.getAttribute(session, objectNameArray5[i], "node");
                    object2 = (String)this.configService.getAttribute(session, objectNameArray5[i], "server");
                    if (!string.equals(string6) || !((String)object2).equals(string7)) continue;
                    objectName9 = objectNameArray5[i];
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (string8 == null) continue;
            try {
                string = (String)this.configService.getAttribute(session, objectNameArray5[i], "cluster");
                if (!string.equals(string8)) continue;
                objectName9 = objectNameArray5[i];
                bl = true;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            String string9 = "";
            if (string7 != null) {
                string9 = string6 + ":" + string7;
            } else if (string8 != null) {
                string9 = string8;
            }
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_MEMBER_NOT_FOUND_CWSJA0606", new Object[]{string9}, null));
        }
        ObjectName objectName10 = null;
        if (string7 != null) {
            objectName10 = SIBAdminCommandHelper.resolve(session, "Node=" + string6 + ":Server=" + string7);
        } else if (string8 != null) {
            objectName10 = SIBAdminCommandHelper.resolve(session, "ServerCluster=" + string8);
        }
        string = (String)this.configService.getAttribute(session, objectName2, "uuid");
        object2 = ConfigServiceHelper.createObjectName(null, (String)"SIBMessagingEngine", null);
        ObjectName[] objectNameArray6 = this.configService.queryConfigObjects(session, objectName10, (ObjectName)object2, null);
        for (int i = 0; i < objectNameArray6.length; ++i) {
            if (!this.configService.getAttribute(session, objectNameArray6[i], "busUuid").equals(string)) continue;
            object = (String)this.configService.getAttribute(session, objectNameArray6[i], "name");
            objectName = ConfigServiceHelper.createObjectName(null, (String)"SIBMediationLocalizationPoint", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectNameArray6[i], objectName, null);
            for (int j = 0; j < objectNameArray.length; ++j) {
                String string10 = (String)this.configService.getAttribute(session, objectNameArray[j], "identifier");
                if (!(string4 + "@" + (String)object).equals(string10)) continue;
                throw new SIBAdminCommandException(nls.getFormattedMessage("INCONSISTENT_CONFIG_DETECTED_CWSJA0607", new Object[]{string4}, null));
            }
        }
        String string11 = (String)this.configService.getAttribute(session, objectName6, "uuid");
        object = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"mediationUuid", (Object)string11);
        objectName = this.configService.createConfigData(session, objectName4, "destinationMediationRef", "SIBDestinationMediationRef", (AttributeList)object);
        objectNameArray = (ObjectName[])this.configService.getAttribute(session, objectName4, "uuid");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < objectNameArray6.length; ++n) {
            if (!this.configService.getAttribute(session, objectNameArray6[n], "busUuid").equals(string)) continue;
            String string12 = (String)this.configService.getAttribute(session, objectNameArray6[n], "name");
            String string13 = (String)this.configService.getAttribute(session, objectNameArray6[n], "uuid");
            ((ArrayList)object).clear();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"identifier", (Object)(string4 + "@" + string12));
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"targetUuid", (Object)objectNameArray);
            ObjectName objectName11 = this.configService.createConfigData(session, objectNameArray6[n], "localizationPoints", "SIBMediationLocalizationPoint", (AttributeList)object);
            ((ArrayList)object).clear();
            String string14 = (String)this.configService.getAttribute(session, objectName, "uuid");
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"mediationRefUuid", (Object)string14);
            this.configService.createConfigData(session, objectName11, "mediationInstance", "SIBMediationInstance", (AttributeList)object);
            arrayList.add(string13);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((ArrayList)object).clear();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"engineUuid", arrayList.get(n));
            if (string7 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"node", (Object)string6);
                ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"server", (Object)string7);
            } else if (string8 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"cluster", (Object)string8);
            }
            this.configService.createConfigData(session, objectName, "localizationPointRefs", "SIBLocalizationPointRef", (AttributeList)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2);
        }
        return "";
    }

    public String unmediateSIBDestination(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "unmediateSIBDestination";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("destinationName");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (string3 == null || string3.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "destinationName"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.resolve(session, "SIBus=" + string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestination", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            if (!this.configService.getAttribute(session, objectNameArray[i], "identifier").equals(string3)) continue;
            objectName3 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("DESTINATION_NOT_FOUND_CWSJA0603", new Object[]{string3}, null));
        }
        ObjectName objectName4 = null;
        ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediationRef", null);
        ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName5, null);
        if (objectNameArray2.length == 0) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("DESTINATION_NOT_MEDIATED_CWSJA0608", new Object[]{string3}, null));
        }
        objectName4 = objectNameArray2[0];
        String string4 = (String)this.configService.getAttribute(session, objectName3, "uuid");
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBLocalizationPointRef", null);
        ObjectName[] objectNameArray3 = this.configService.queryConfigObjects(session, objectName4, objectName6, null);
        for (int i = 0; i < objectNameArray3.length; ++i) {
            String string5 = (String)this.configService.getAttribute(session, objectNameArray3[i], "node");
            String string6 = (String)this.configService.getAttribute(session, objectNameArray3[i], "server");
            String string7 = (String)this.configService.getAttribute(session, objectNameArray3[i], "cluster");
            String string8 = (String)this.configService.getAttribute(session, objectNameArray3[i], "engineUuid");
            ObjectName objectName7 = null;
            if (string6 != null) {
                objectName7 = SIBAdminCommandHelper.resolve(session, "Node=" + string5 + ":Server=" + string6);
            } else if (string7 != null) {
                objectName7 = SIBAdminCommandHelper.resolve(session, "ServerCluster=" + string7);
            }
            ObjectName objectName8 = ConfigServiceHelper.createObjectName(null, (String)"SIBMessagingEngine", null);
            ObjectName[] objectNameArray4 = this.configService.queryConfigObjects(session, objectName7, objectName8, null);
            for (int j = 0; j < objectNameArray4.length; ++j) {
                String string9 = (String)this.configService.getAttribute(session, objectNameArray4[j], "uuid");
                if (!string9.equals(string8)) continue;
                ObjectName objectName9 = ConfigServiceHelper.createObjectName(null, (String)"SIBMediationLocalizationPoint", null);
                ObjectName[] objectNameArray5 = this.configService.queryConfigObjects(session, objectNameArray4[j], objectName9, null);
                for (int k = 0; k < objectNameArray5.length; ++k) {
                    String string10 = (String)this.configService.getAttribute(session, objectNameArray5[k], "targetUuid");
                    if (!string10.equals(string4)) continue;
                    this.configService.deleteConfigData(session, objectNameArray5[k]);
                }
            }
        }
        this.configService.deleteConfigData(session, objectName4);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string);
        }
        return "";
    }
}

