/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.sib.SIBAdminCommandException;
import com.ibm.ws.management.commands.sib.SIBAdminCommandHelper;
import com.ibm.ws.management.commands.sib.SIBAdminCommandProvider;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;
import java.util.Locale;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifySIBDestinationCommand
extends AbstractTaskCommand {
    private static final String CLASS_NAME = "com.ibm.ws.management.commands.sib.ModifySIBDestinationCommand";
    private Session configSession = this.getConfigSession();
    private String busName = null;
    private String destName = null;
    private String description = null;
    private String reliability = null;
    private String maxReliability = null;
    private String exceptionDestination = null;
    private Integer defaultPriority = null;
    private Integer maxFailedDeliveries = null;
    private String allowOverride = null;
    private String sendAllowed = null;
    private String receiveAllowed = null;
    private Boolean receiveExclusive = null;
    private Boolean topicAccessCheckRequired = null;
    private Boolean delegateAuthorizationCheckToTarget = null;
    private String replyDestinationBusName = null;
    private String replyDestinationName = null;
    private String ucType = null;
    ObjectName destination = null;
    private String[][] defaultForwardRoutingPathArray = null;
    private String taskName = null;
    private static final TraceComponent tc = SibTr.register(SIBAdminCommandProvider.class, "SIBAdmin", "com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");
    private static final Locale rootLocale = new Locale("", "");

    public ModifySIBDestinationCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.resetValues();
        this.taskName = taskCommandMetadata.getName();
    }

    public ModifySIBDestinationCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.resetValues();
        this.taskName = commandData.getName();
    }

    protected void beforeStepsExecuted() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getCommandResult();
        this.configSession = this.getConfigSession();
        try {
            this.busName = (String)this.getParameter("bus");
            this.destName = (String)this.getParameter("name");
            this.description = (String)this.getParameter("description");
            this.reliability = (String)this.getParameter("reliability");
            this.maxReliability = (String)this.getParameter("maxReliability");
            this.exceptionDestination = (String)this.getParameter("exceptionDestination");
            this.defaultPriority = (Integer)this.getParameter("defaultPriority");
            this.maxFailedDeliveries = (Integer)this.getParameter("maxFailedDeliveries");
            this.allowOverride = (String)this.getParameter("overrideOfQOSByProducerAllowed");
            this.sendAllowed = (String)this.getParameter("sendAllowed");
            this.receiveAllowed = (String)this.getParameter("receiveAllowed");
            this.receiveExclusive = (Boolean)this.getParameter("receiveExclusive");
            this.replyDestinationBusName = (String)this.getParameter("replyDestinationBus");
            this.replyDestinationName = (String)this.getParameter("replyDestination");
            this.topicAccessCheckRequired = (Boolean)this.getParameter("topicAccessCheckRequired");
            this.delegateAuthorizationCheckToTarget = (Boolean)this.getParameter("delegateAuthorizationCheckToTarget");
            if (this.busName == null || this.busName.length() < 1) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{this.getName(), "bus"}, null));
            }
            if (this.destName == null || this.destName.length() < 1) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{this.getName(), "name"}, null));
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException((Throwable)exception);
            return;
        }
        ObjectName objectName = null;
        List list = null;
        try {
            objectName = SIBAdminCommandHelper.getBusByName(this.configSession, this.busName);
            list = SIBAdminCommandHelper.getDestinationList(this.configSession, objectName);
            list = SIBAdminCommandHelper.filterList(this.configSession, list, "identifier", this.destName);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.ModifySIBDestinationCommand.beforeStepsExecuted", (String)"175", (Object)((Object)this));
            taskCommandResultImpl.setException((Throwable)exception);
            return;
        }
        if (list.size() < 1) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("DEST_NOT_FOUND_CWSJA0027", null, null)));
            return;
        }
        if (list.size() > 1) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_DESTS_FOUND_CWSJA0028", null, null)));
            return;
        }
        this.destination = (ObjectName)list.get(0);
        String string = ConfigServiceHelper.getConfigDataType((ObjectName)this.destination);
        string = SIBAdminCommandHelper.convertConfigType(string);
        this.ucType = string.toUpperCase(rootLocale);
        if (this.topicAccessCheckRequired != null && !this.ucType.equals("TOPICSPACE")) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{this.ucType, "topicAccessCheckRequired", this.topicAccessCheckRequired}, null)));
            return;
        }
        if (!(this.receiveExclusive == null || this.ucType.equals("QUEUE") || this.ucType.equals("PORT") || this.ucType.equals("WEBSERVICE"))) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{this.ucType, "receiveExclusive", this.receiveExclusive}, null)));
            return;
        }
        if (this.delegateAuthorizationCheckToTarget != null && !this.ucType.equals("ALIAS")) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{this.ucType, "delegateAuthorizationCheckToTarget", this.delegateAuthorizationCheckToTarget}, null)));
            return;
        }
        if (this.allowOverride != null && !this.allowOverride.equals("") && !SIBAdminCommandHelper.validBooleanEnumValue(string, this.allowOverride)) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{string, "allowOverride", this.allowOverride}, null)));
            return;
        }
        if (this.sendAllowed != null && !this.sendAllowed.equals("") && !SIBAdminCommandHelper.validBooleanEnumValue(string, this.sendAllowed)) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{string, "sendAllowed", this.sendAllowed}, null)));
            return;
        }
        if (!(this.ucType.equals("FOREIGN") || this.receiveAllowed == null || this.receiveAllowed.equals("") || SIBAdminCommandHelper.validBooleanEnumValue(string, this.receiveAllowed))) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{string, "receiveAllowed", this.receiveAllowed}, null)));
            return;
        }
        if (this.reliability != null) {
            this.reliability = this.reliability.toUpperCase(rootLocale);
        }
        if (this.maxReliability != null) {
            this.maxReliability = this.maxReliability.toUpperCase(rootLocale);
        }
        try {
            AttributeList attributeList = ConfigServiceFactory.getConfigService().getAttributes(this.configSession, this.destination, null, true);
            if (!SIBAdminCommandHelper.isReliabilityValid(this.reliability, this.maxReliability, attributeList, this.ucType)) {
                taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_RELIABILITY_VALUE_CWSJA0040", null, null)));
                return;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.ModifySIBDestinationCommand.beforeStepsExecuted", (String)"238", (Object)((Object)this));
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("ERROR_VALIDATING_RELIABILITY_CWSJA0045", null, null)));
            return;
        }
    }

    protected void afterStepsExecuted() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getCommandResult();
        Boolean bl = this.allowOverride == null ? null : new Boolean(this.allowOverride);
        Boolean bl2 = this.sendAllowed == null ? null : new Boolean(this.sendAllowed);
        Boolean bl3 = this.receiveAllowed == null ? null : new Boolean(this.receiveAllowed);
        try {
            if (this.ucType.equals("QUEUE") || this.ucType.equals("WEBSERVICE") || this.ucType.equals("PORT")) {
                this.destination = SIBAdminCommandHelper.modifyDestinationQueue(this.configSession, this.destination, this.description, this.reliability, this.maxReliability, this.exceptionDestination, this.defaultPriority, this.maxFailedDeliveries, bl, bl2, bl3, this.receiveExclusive, this.topicAccessCheckRequired, this.replyDestinationBusName, this.replyDestinationName, this.defaultForwardRoutingPathArray);
            } else if (this.ucType.equals("TOPICSPACE")) {
                this.destination = SIBAdminCommandHelper.modifyDestinationTopicSpace(this.configSession, this.destination, this.description, this.reliability, this.maxReliability, this.exceptionDestination, this.defaultPriority, this.maxFailedDeliveries, bl, bl2, bl3, this.topicAccessCheckRequired, this.replyDestinationBusName, this.replyDestinationName);
            } else if (this.ucType.equals("ALIAS")) {
                this.destination = SIBAdminCommandHelper.modifyDestinationAlias(this.configSession, this.destination, this.description, this.reliability, this.defaultPriority, this.maxReliability, this.allowOverride, this.sendAllowed, this.receiveAllowed, this.replyDestinationBusName, this.replyDestinationName, this.defaultForwardRoutingPathArray, this.delegateAuthorizationCheckToTarget);
            } else if (this.ucType.equals("FOREIGN")) {
                this.destination = SIBAdminCommandHelper.modifyDestinationForeign(this.configSession, this.destination, this.description, this.reliability, this.maxReliability, this.defaultPriority, bl, bl2);
            }
            taskCommandResultImpl.setResult((Object)this.destination);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.ModifySIBDestinationCommand.afterStepsExecuted", (String)"303", (Object)((Object)this));
            taskCommandResultImpl.setException((Throwable)exception);
        }
    }

    private void resetValues() {
        this.busName = null;
        this.destName = null;
        this.description = null;
        this.reliability = null;
        this.maxReliability = null;
        this.exceptionDestination = null;
        this.defaultPriority = null;
        this.maxFailedDeliveries = null;
        this.allowOverride = null;
        this.sendAllowed = null;
        this.receiveAllowed = null;
        this.receiveExclusive = null;
        this.replyDestinationBusName = null;
        this.replyDestinationName = null;
        this.defaultForwardRoutingPathArray = null;
        this.topicAccessCheckRequired = null;
        this.ucType = null;
        this.delegateAuthorizationCheckToTarget = null;
    }

    static /* synthetic */ String[][] access$302(ModifySIBDestinationCommand modifySIBDestinationCommand, String[][] stringArray) {
        modifySIBDestinationCommand.defaultForwardRoutingPathArray = stringArray;
        return stringArray;
    }

    public class DefaultForwardRoutingPathStep
    extends AbstractCommandStep {
        private String stepName;

        public DefaultForwardRoutingPathStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, (CommandMetadata)commandStepMetadata);
            this.stepName = null;
            this.stepName = commandStepMetadata.getName();
        }

        public DefaultForwardRoutingPathStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, (CommandData)commandStepData);
            this.stepName = null;
            this.stepName = commandStepData.getName();
        }

        public void validate() throws CommandValidationException {
            int n = this.getNumberOfRows();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getParameter("destination", i);
                if (string != null && string.length() >= 1) continue;
                throw new CommandValidationException(nls.getFormattedMessage("NO_STEP_PARAM_VALUE_CWSJA0038", new Object[]{ModifySIBDestinationCommand.this.taskName, this.stepName, "destination"}, null));
            }
        }

        protected void executeStep() {
            if (ModifySIBDestinationCommand.this.ucType.equals("QUEUE") || ModifySIBDestinationCommand.this.ucType.equals("WEBSERVICE") || ModifySIBDestinationCommand.this.ucType.equals("PORT") || ModifySIBDestinationCommand.this.ucType.equals("ALIAS")) {
                Session session = this.getConfigSession();
                String string = null;
                String string2 = null;
                int n = this.getNumberOfRows();
                ModifySIBDestinationCommand.access$302(ModifySIBDestinationCommand.this, new String[2][n]);
                for (int i = 0; i < n; ++i) {
                    try {
                        string = (String)this.getParameter("bus", i);
                        string2 = (String)this.getParameter("destination", i);
                        ((ModifySIBDestinationCommand)ModifySIBDestinationCommand.this).defaultForwardRoutingPathArray[0][i] = string;
                        ((ModifySIBDestinationCommand)ModifySIBDestinationCommand.this).defaultForwardRoutingPathArray[1][i] = string2;
                        continue;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.ModifySIBDestinationCommand.DefaultForwardRoutingPathStep.executeStep", (String)"403", (Object)((Object)this));
                        CommandResultImpl commandResultImpl = new CommandResultImpl();
                        commandResultImpl.setException((Throwable)exception);
                        this.setCommandResult((CommandResult)commandResultImpl);
                        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getCommandResult();
                        taskCommandResultImpl.setException((Throwable)exception);
                    }
                }
            }
        }
    }
}

