/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class Reliability
implements Comparable {
    private static TraceComponent tc = SibTr.register(Reliability.class, "SIBMfpApi", "com.ibm.websphere.sib.CWSIEMessages");
    private static final String NONE_STRING = "None";
    public static final String BEST_EFFORT_NONPERSISTENT_STRING = "BestEffortNonPersistent";
    public static final String EXPRESS_NONPERSISTENT_STRING = "ExpressNonPersistent";
    public static final String RELIABLE_NONPERSISTENT_STRING = "ReliableNonPersistent";
    public static final String RELIABLE_PERSISTENT_STRING = "ReliablePersistent";
    public static final String ASSURED_PERSISTENT_STRING = "AssuredPersistent";
    public static final Reliability NONE;
    public static final Reliability BEST_EFFORT_NONPERSISTENT;
    public static final Reliability EXPRESS_NONPERSISTENT;
    public static final Reliability RELIABLE_NONPERSISTENT;
    public static final Reliability RELIABLE_PERSISTENT;
    public static final Reliability ASSURED_PERSISTENT;
    private static final Reliability[] set;
    private static final Reliability[] indexSet;
    private static final String[] nameSet;
    public static final int MAX_INDEX;
    private String name;
    private Byte value;
    private int intValue;
    private int index;
    private Byte persistence;

    private Reliability(String string, byte by, int n, byte by2) {
        this.name = string;
        this.value = new Byte(by);
        this.intValue = by;
        this.index = n;
        this.persistence = new Byte(by2);
    }

    public final String toString() {
        return this.name;
    }

    public final int compareTo(Object object) {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "this: " + this + ", other: " + object.toString() + ", result: " + (this.intValue - ((Reliability)object).intValue));
        }
        return this.intValue - ((Reliability)object).intValue;
    }

    public static final Reliability getReliability(int n) {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Value = " + n);
        }
        return set[n];
    }

    public final int toInt() {
        return this.intValue;
    }

    public static final Reliability getReliabilityByName(String string) throws NullPointerException, IllegalArgumentException {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Name = " + string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i <= MAX_INDEX + 1; ++i) {
            if (!string.equals(nameSet[i])) continue;
            return indexSet[i];
        }
        throw new IllegalArgumentException();
    }

    public static final Reliability getReliabilityByIndex(int n) {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Index = " + n);
        }
        return indexSet[n + 1];
    }

    public final int getIndex() {
        return this.index;
    }

    public static final Reliability getReliability(Byte by) {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Value = " + by);
        }
        return set[by.intValue()];
    }

    public final Byte toByte() {
        return this.value;
    }

    public final Byte getPersistence() {
        return this.persistence;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.api/src/com/ibm/websphere/sib/Reliability.java, SIB.mfp.core, WAS602.SIB, o0610.11 1.18");
        }
        NONE = new Reliability(NONE_STRING, 0, -1, 0);
        BEST_EFFORT_NONPERSISTENT = new Reliability(BEST_EFFORT_NONPERSISTENT_STRING, 5, 0, 1);
        EXPRESS_NONPERSISTENT = new Reliability(EXPRESS_NONPERSISTENT_STRING, 15, 1, 1);
        RELIABLE_NONPERSISTENT = new Reliability(RELIABLE_NONPERSISTENT_STRING, 25, 2, 1);
        RELIABLE_PERSISTENT = new Reliability(RELIABLE_PERSISTENT_STRING, 35, 3, 2);
        ASSURED_PERSISTENT = new Reliability(ASSURED_PERSISTENT_STRING, 45, 4, 2);
        set = new Reliability[]{NONE, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT};
        indexSet = new Reliability[]{NONE, BEST_EFFORT_NONPERSISTENT, EXPRESS_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_PERSISTENT, ASSURED_PERSISTENT};
        nameSet = new String[]{NONE_STRING, BEST_EFFORT_NONPERSISTENT_STRING, EXPRESS_NONPERSISTENT_STRING, RELIABLE_NONPERSISTENT_STRING, RELIABLE_PERSISTENT_STRING, ASSURED_PERSISTENT_STRING};
        MAX_INDEX = ASSURED_PERSISTENT.getIndex();
    }
}

