/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.ibm.xml.b2b.scan.DocumentEventHandler;
import com.ibm.xml.b2b.scan.DocumentImplementationHandler;
import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.scan.ExternalEntityHandler;
import com.ibm.xml.b2b.scan.ExternalEntityState;
import com.ibm.xml.b2b.util.SymbolTable;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;

public abstract class DocumentEntityParserBase
implements ExternalEntityHandler,
DocumentEventHandler,
DocumentImplementationHandler {
    protected SymbolTable fSymbolTable = new SymbolTable();
    protected ExternalEntityState fExternalEntityState = new ExternalEntityState();
    protected ParsedEntityFactory fEntityFactory;
    protected DocumentScannerSupport fDocumentScannerSupport;

    public abstract boolean scanXMLDecl(ParsedEntity var1);

    public abstract boolean scanDocument(ParsedEntity var1);

    public abstract void reportFatalError(String var1, int var2, Object[] var3);

    protected abstract ParsedEntityFactory createParsedEntityFactory();

    protected abstract DocumentScannerSupport createDocumentScannerSupport();

    protected boolean skipDoctypeDecl(ParsedEntity parsedEntity) {
        throw new RuntimeException("DocumentEntityParserBase#skipDoctypeDecl()");
    }

    protected DocumentEntityParserBase() {
    }

    protected void initialize() {
        this.fEntityFactory = this.createParsedEntityFactory();
        this.fDocumentScannerSupport = this.createDocumentScannerSupport();
    }

    protected void reset(boolean bl) {
        this.fSymbolTable.reset(bl);
        this.fExternalEntityState.reset();
        this.fEntityFactory.reset(bl);
        this.fDocumentScannerSupport.reset(bl);
    }

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public ParsedEntityFactory getParsedEntityFactory() {
        return this.fEntityFactory;
    }

    protected void parse(EntityInputSource entityInputSource) {
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(entityInputSource, true);
        if (this.scanXMLDecl(parsedEntity)) {
            this.scanDocument(parsedEntity);
        }
        parsedEntity.release();
    }

    public void xmlDeclEvent() {
    }

    public void textDeclEvent() {
    }

    public void startElementEvent(boolean bl) {
        this.fDocumentScannerSupport.resolveNamespaceURIs();
        this.startElementAction(bl);
    }

    protected void startElementAction(boolean bl) {
    }

    public void endElementEvent() {
        this.endElementAction();
    }

    protected void endElementAction() {
    }

    protected void startPrefixMappings() {
        DocumentScannerSupport documentScannerSupport = this.fDocumentScannerSupport;
        int n = documentScannerSupport.firstMapping;
        int n2 = documentScannerSupport.lastMapping - n;
        int n3 = 0;
        while (n3 < n2) {
            String string = documentScannerSupport.prefixes[n + n3];
            String string2 = documentScannerSupport.namespaceURIs[n + n3];
            this.startPrefixMapping(string, string2);
            ++n3;
        }
    }

    protected void startPrefixMapping(String string, String string2) {
    }

    protected void endPrefixMappings() {
        DocumentScannerSupport documentScannerSupport = this.fDocumentScannerSupport;
        int n = documentScannerSupport.firstMapping;
        int n2 = documentScannerSupport.lastMapping - n;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            String string = documentScannerSupport.prefixes[n + n3];
            this.endPrefixMapping(string);
            --n3;
        }
    }

    protected void endPrefixMapping(String string) {
    }

    public void characters(XMLString xMLString) {
    }

    public void character(int n, boolean bl) {
    }

    public void processingInstruction(XMLName xMLName, XMLString xMLString) {
    }

    public boolean scanDoctypeDecl(ParsedEntity parsedEntity) {
        return this.skipDoctypeDecl(parsedEntity);
    }

    public boolean scanExternalSubset() {
        return true;
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void comment(XMLString xMLString) {
    }

    public boolean entityReferenceInContent(XMLName xMLName) {
        int n = this.fDocumentScannerSupport.checkPredefinedEntities(xMLName);
        if (n != -1) {
            this.character(n, true);
            return true;
        }
        this.fDocumentScannerSupport.undeclaredEntityInContent(xMLName);
        return false;
    }

    public boolean entityReferenceInAttValue(XMLName xMLName) {
        int n = this.fDocumentScannerSupport.checkPredefinedEntities(xMLName);
        if (n != -1) {
            this.fDocumentScannerSupport.attributeValueCharacter(n, true);
            return true;
        }
        this.fDocumentScannerSupport.undeclaredEntityInAttValue(xMLName);
        return false;
    }
}

