/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.xml;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter {
    protected PrintWriter out;
    protected int indent = 0;
    protected String encodingTag;
    protected String docTypeString;

    public DOMWriter() {
    }

    public DOMWriter(Document document, String string, String string2, String string3, String string4) {
        this.encodingTag = string3;
        this.docTypeString = string4;
        try {
            OutputStreamWriter outputStreamWriter = string2 != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2) : new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF8");
            this.out = new PrintWriter(new BufferedWriter(outputStreamWriter));
            this.print(document);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.xml.DOMWriter.DOMWriter", (String)"69", (Object)this);
        }
    }

    public void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(" ");
        }
    }

    public void print(Node node) {
        if (node != null) {
            XMLVisitor xMLVisitor = new XMLVisitor();
            xMLVisitor.visitNode(node);
        }
        this.out.flush();
    }

    protected String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = (string = string.trim()) != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public class XMLVisitor {
        public void visitNode(Node node) {
            switch (node.getNodeType()) {
                case 2: {
                    this.visitAttr((Attr)node);
                    break;
                }
                case 4: {
                    this.visitCDATASection((CDATASection)node);
                    break;
                }
                case 8: {
                    this.visitComment((Comment)node);
                    break;
                }
                case 9: {
                    this.visitDocument((Document)node);
                    break;
                }
                case 1: {
                    this.visitElement((Element)node);
                    break;
                }
                case 7: {
                    this.visitProcessingInstruction((ProcessingInstruction)node);
                    break;
                }
                case 3: {
                    this.visitText((Text)node);
                }
            }
        }

        public void visitDocument(Document document) {
            if (DOMWriter.this.encodingTag != null && !DOMWriter.this.encodingTag.equals("")) {
                DOMWriter.this.out.println("<?xml version=\"1.0\" encoding=\"" + DOMWriter.this.encodingTag + "\"?>");
            }
            if (DOMWriter.this.docTypeString != null && !DOMWriter.this.docTypeString.equals("")) {
                DOMWriter.this.out.println(DOMWriter.this.docTypeString);
            }
            this.visitChildNodesHelper(document);
        }

        public void visitElement(Element element) {
            boolean bl = this.hasChildElements(element);
            DOMWriter.this.printIndent();
            DOMWriter.this.out.print('<' + element.getNodeName());
            this.visitAttributesHelper(element);
            DOMWriter.this.out.print(">");
            if (bl) {
                DOMWriter.this.out.print("\n");
            }
            DOMWriter.this.indent += 2;
            this.visitChildNodesHelper(element);
            DOMWriter.this.indent -= 2;
            if (bl) {
                DOMWriter.this.printIndent();
            }
            DOMWriter.this.out.println("</" + element.getNodeName() + ">");
        }

        public void visitAttr(Attr attr) {
            DOMWriter.this.out.print(" ");
            DOMWriter.this.out.print(attr.getNodeName() + "=\"" + attr.getValue() + '\"');
        }

        public void visitText(Text text) {
            DOMWriter.this.out.print(DOMWriter.this.normalize(text.getNodeValue()));
        }

        public void visitCDATASection(CDATASection cDATASection) {
        }

        public void visitComment(Comment comment) {
            DOMWriter.this.printIndent();
            DOMWriter.this.out.print("<!--");
            DOMWriter.this.out.print(DOMWriter.this.normalize(comment.getNodeValue()));
            DOMWriter.this.out.println("-->");
        }

        public void visitProcessingInstruction(ProcessingInstruction processingInstruction) {
            DOMWriter.this.printIndent();
            DOMWriter.this.out.print("<?");
            DOMWriter.this.out.print(processingInstruction.getNodeName());
            DOMWriter.this.out.print(" ");
            DOMWriter.this.out.print(DOMWriter.this.normalize(processingInstruction.getNodeValue()));
            DOMWriter.this.out.println("?>");
        }

        public boolean hasChildElements(Node node) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1) continue;
                return true;
            }
            return false;
        }

        public void visitChildNodesHelper(Node node) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                this.visitNode(node2);
            }
        }

        public void visitAttributesHelper(Node node) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                this.visitNode(namedNodeMap.item(i));
            }
        }
    }
}

