/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Input;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;

public class JavaServiceImplWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaServiceImplWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry.getName() + "Locator", "service");
        this.sEntry = serviceEntry;
        this.symbolTable = symbolTable;
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        return "extends com.ibm.ws.webservices.multiprotocol.AgnosticService ";
    }

    protected String getImplementsText() {
        return "implements com.ibm.ws.webservices.multiprotocol.GeneratedService, " + this.sEntry.getName() + ' ';
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        Service service = this.sEntry.getService();
        this.writeComment(printWriter, service.getDocumentationElement());
        this.writeConstructor(printWriter, this.className, service.getQName());
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        boolean bl = false;
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            Object object;
            String string;
            PortEntry portEntry = this.sEntry.getPort(i);
            Port port2 = portEntry.getPort();
            Binding binding = port2.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{port2.getName()}));
            }
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (portTypeEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            String string2 = portEntry.getQName().getLocalPart();
            String string3 = JavaUtils.xmlNameToJava(string2);
            String string4 = bindingEntry.getName() + "Stub";
            String string5 = (String)bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
            if (vector.contains(string5)) {
                bl = true;
            }
            if ((string = portEntry.getAddress()) == null && ((object = (Boolean)this.sEntry.getDynamicVar(SymbolTable.NON_BOUND_WSDL)) == null || !((Boolean)object).booleanValue())) continue;
            vector.add(string5);
            vector2.add(string4);
            vector3.add(string3);
            vector4.add(port2.getName());
            this.writeAddressInfo(printWriter, string3, string, port2);
            object = JavaUtils.xmlNameToJava(string2) + "PortName";
            this.writePortNameInfo(printWriter, (String)object, string2);
            String string6 = string3 + "WSDDPortName";
            this.writeWSDDPortNameInfo(printWriter, string6, string2);
            this.writeGetPortName(printWriter, string5, string3);
            this.writeGetPortNameURL(printWriter, string5, string3, string4, string6, (String)object);
        }
        this.writeGetPortClass(printWriter, vector, vector2, vector3, bl);
        this.writeGetPortQNameClass(printWriter, vector3, vector4);
        this.writeSetPortNamePrefix(printWriter, vector3, vector4);
        this.writeGetServiceName(printWriter, this.sEntry.getQName());
        this.writeGetPort2NamespaceMap(printWriter, this.sEntry);
        this.writeGetPorts(printWriter);
        this.writeGetCalls(printWriter);
    }

    protected void writeConstructor(PrintWriter printWriter, String string, QName qName) {
        printWriter.println();
        printWriter.println("    public " + string + "() {");
        printWriter.println("        super(com.ibm.ws.webservices.engine.utils.QNameTable.createQName(");
        printWriter.println("           \"" + qName.getNamespaceURI() + "\",");
        printWriter.println("           \"" + qName.getLocalPart() + "\"));");
        printWriter.println();
        printWriter.println("        context.setLocatorName(\"" + this.packageName + "." + string + "\");");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public " + string + "(com.ibm.ws.webservices.multiprotocol.ServiceContext ctx) {");
        printWriter.println("        super(ctx);");
        printWriter.println("        context.setLocatorName(\"" + this.packageName + "." + string + "\");");
        printWriter.println("    }");
    }

    protected void writeAddressInfo(PrintWriter printWriter, String string, String string2, Port port2) {
        boolean bl = true;
        try {
            new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            bl = false;
        }
        printWriter.println();
        printWriter.println("    // " + Messages.getMessage("getProxy00", string));
        this.writeComment(printWriter, port2.getDocumentationElement());
        if (!bl) {
            printWriter.println("    // NOTE: The following address is INVALID.  It MUST be overridden by either specifying a URL on the getPort calls");
            printWriter.println("    //       or by specifing an overriddenEndpointURI on a portQnameBindings element in the webservices client binding file");
        }
        printWriter.println("    private final java.lang.String " + string + "_address = \"" + string2 + "\";");
        printWriter.println();
        printWriter.println("    public java.lang.String get" + JavaUtils.capitalizeFirstChar(string) + "Address() {");
        printWriter.println("        if (context.getOverriddingEndpointURIs() == null) {");
        printWriter.println("            return " + string + "_address;");
        printWriter.println("        }");
        printWriter.println("        String overriddingEndpoint = (String) context.getOverriddingEndpointURIs().get(\"" + port2.getName() + "\");");
        printWriter.println("        if (overriddingEndpoint != null) {");
        printWriter.println("            return overriddingEndpoint;");
        printWriter.println("        }");
        printWriter.println("        else {");
        printWriter.println("            return " + string + "_address;");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writePortNameInfo(PrintWriter printWriter, String string, String string2) {
        printWriter.println("    private java.lang.String " + string + " = \"" + string2 + "\";");
        printWriter.println();
    }

    protected void writeWSDDPortNameInfo(PrintWriter printWriter, String string, String string2) {
        printWriter.println("    // " + Messages.getMessage("wsddPortName00"));
        printWriter.println("    private java.lang.String " + string + " = \"" + string2 + "\";");
        printWriter.println();
        String string3 = JavaUtils.capitalizeFirstChar(string);
        printWriter.println("    public java.lang.String get" + string3 + "() {");
        printWriter.println("        return " + string + ";");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public void set" + string3 + "(java.lang.String name) {");
        printWriter.println("        " + string + " = name;");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeSetPortNamePrefix(PrintWriter printWriter, Vector vector, Vector vector2) {
        printWriter.println("    public void setPortNamePrefix(java.lang.String prefix) {");
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            String string2 = string + "WSDDPortName";
            String string3 = string + "PortName";
            printWriter.println("        " + string2 + " = prefix + \"/\" + " + string3 + ";");
        }
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetPortName(PrintWriter printWriter, String string, String string2) {
        String string3 = JavaUtils.capitalizeFirstChar(string2);
        printWriter.println("    public " + string + " get" + string3 + "() throws " + ServiceException.class.getName() + " {");
        printWriter.println("       java.net.URL endpoint;");
        printWriter.println("        try {");
        printWriter.println("            endpoint = new java.net.URL(get" + JavaUtils.capitalizeFirstChar(string2) + "Address());");
        printWriter.println("        }");
        printWriter.println("        catch (java.net.MalformedURLException e) {");
        printWriter.println("            return null; // " + Messages.getMessage("unlikely00"));
        printWriter.println("        }");
        printWriter.println("        return get" + string3 + "(endpoint);");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetPortNameURL(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5) {
        string2 = JavaUtils.capitalizeFirstChar(string2);
        printWriter.println("    public " + string + " get" + string2 + "(java.net.URL portAddress) throws " + ServiceException.class.getName() + " {");
        printWriter.println("        " + string + " _stub =");
        printWriter.println("            (" + string + ") getStub(");
        printWriter.println("                " + string5 + ",");
        printWriter.println("                (String) getPort2NamespaceMap().get(" + string5 + "),");
        printWriter.println("                " + string + ".class,");
        printWriter.println("                \"" + string3 + "\",");
        printWriter.println("                portAddress.toString());");
        printWriter.println("        if (_stub instanceof com.ibm.ws.webservices.engine.client.Stub) {");
        printWriter.println("            ((com.ibm.ws.webservices.engine.client.Stub) _stub).setPortName(" + string4 + ");");
        printWriter.println("        }");
        printWriter.println("        return _stub;");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetPortClass(PrintWriter printWriter, Vector vector, Vector vector2, Vector vector3, boolean bl) {
        printWriter.println("    /**");
        printWriter.println("     * " + Messages.getMessage("getPortDoc00"));
        printWriter.println("     * " + Messages.getMessage("getPortDoc01"));
        printWriter.println("     * " + Messages.getMessage("getPortDoc02"));
        if (bl) {
            printWriter.println("     * " + Messages.getMessage("getPortDoc03"));
            printWriter.println("     * " + Messages.getMessage("getPortDoc04"));
        }
        printWriter.println("     */");
        printWriter.println("    public java.rmi.Remote getPort(Class serviceEndpointInterface) throws " + ServiceException.class.getName() + " {");
        if (vector.size() == 0) {
            printWriter.println("        throw new " + ServiceException.class.getName() + "(\"" + Messages.getMessage("noStub") + "  \" + (serviceEndpointInterface == null ? \"null\" : serviceEndpointInterface.getName()));");
        } else {
            printWriter.println("        try {");
            HashSet hashSet = new HashSet(vector);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n;
                String string = (String)iterator.next();
                printWriter.println("            if (" + string + ".class.isAssignableFrom(serviceEndpointInterface)) {");
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (n = 0; n < vector.size(); ++n) {
                    if (!vector.elementAt(n).equals(string)) continue;
                    arrayList.add(new Integer(n));
                }
                if (arrayList.size() == 1) {
                    n = (Integer)arrayList.get(0);
                    String string2 = (String)vector3.get(n);
                    printWriter.println("                return get" + JavaUtils.capitalizeFirstChar(string2) + "();");
                } else {
                    if (arrayList.size() == vector.size()) {
                        printWriter.println("                javax.xml.namespace.QName portName = getDefaultPortQName(serviceEndpointInterface, getPort2NamespaceMap());");
                    } else {
                        printWriter.println("                java.util.Map m = new java.util.HashMap();");
                        Iterator iterator2 = arrayList.iterator();
                        while (iterator2.hasNext()) {
                            int n2 = (Integer)iterator2.next();
                            String string3 = (String)vector3.elementAt(n2);
                            printWriter.println("                m.put(\"" + string3 + "\", getPort2NamespaceMap().get(\"" + string3 + "\"));");
                        }
                        printWriter.println("                javax.xml.namespace.QName portName = getDefaultPortQName(serviceEndpointInterface, m);");
                    }
                    printWriter.println("                return getPort(portName, serviceEndpointInterface);");
                }
                printWriter.println("            }");
            }
            printWriter.println("        }");
            printWriter.println("        catch (java.lang.Throwable t) {");
            printWriter.println("            throw new " + ServiceException.class.getName() + "(t);");
            printWriter.println("        }");
            printWriter.println("        throw new " + ServiceException.class.getName() + "(\"" + Messages.getMessage("noStub") + "  \" + (serviceEndpointInterface == null ? \"null\" : serviceEndpointInterface.getName()));");
        }
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetPortQNameClass(PrintWriter printWriter, Vector vector, Vector vector2) {
        printWriter.println("    /**");
        printWriter.println("     * " + Messages.getMessage("getPortDoc00"));
        printWriter.println("     * " + Messages.getMessage("getPortDoc01"));
        printWriter.println("     * " + Messages.getMessage("getPortDoc02"));
        printWriter.println("     */");
        printWriter.println("    public java.rmi.Remote getPort(javax.xml.namespace.QName portName, Class serviceEndpointInterface) throws javax.xml.rpc.ServiceException {");
        printWriter.println("        String inputPortName = portName.getLocalPart();");
        printWriter.print("        ");
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector2.get(i);
            String string2 = (String)vector.get(i);
            printWriter.println("if (\"" + string + "\".equals(inputPortName)) {");
            printWriter.println("            return get" + JavaUtils.capitalizeFirstChar(string2) + "();");
            printWriter.println("        }");
            printWriter.print("        else ");
        }
        printWriter.println(" {");
        printWriter.println("            throw new javax.xml.rpc.ServiceException();");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetServiceName(PrintWriter printWriter, QName qName) {
        printWriter.println("    public javax.xml.namespace.QName getServiceName() {");
        printWriter.println("        return " + Utils.getNewQName(qName) + ";");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetPort2NamespaceMap(PrintWriter printWriter, ServiceEntry serviceEntry) {
        printWriter.println("    private java.util.Map port2NamespaceMap = null;");
        printWriter.println();
        printWriter.println("    protected synchronized java.util.Map getPort2NamespaceMap() {");
        printWriter.println("        if (port2NamespaceMap == null) {");
        printWriter.println("            port2NamespaceMap = new java.util.HashMap();");
        for (int i = 0; i < serviceEntry.numPorts(); ++i) {
            PortEntry portEntry = serviceEntry.getPort(i);
            Boolean bl = (Boolean)serviceEntry.getDynamicVar(SymbolTable.NON_BOUND_WSDL);
            if (portEntry.getAddress() == null && (bl == null || !bl.booleanValue())) continue;
            Port port2 = portEntry.getPort();
            Binding binding = port2.getBinding();
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            String string = null;
            if (bindingEntry != null) {
                string = (String)bindingEntry.getDynamicVar(BindingEntry.BINDING_NAMESPACE);
            }
            printWriter.println("            port2NamespaceMap.put(");
            printWriter.println("               \"" + portEntry.getQName().getLocalPart() + "\",");
            printWriter.println("               \"" + string + "\");");
        }
        printWriter.println("        }");
        printWriter.println("        return port2NamespaceMap;");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetPorts(PrintWriter printWriter) {
        printWriter.println("    private java.util.HashSet ports = null;");
        printWriter.println();
        printWriter.println("    public java.util.Iterator getPorts() {");
        printWriter.println("        if (ports == null) {");
        printWriter.println("            ports = new java.util.HashSet();");
        printWriter.println("            String serviceNamespace = getServiceName().getNamespaceURI();");
        printWriter.println("            for (java.util.Iterator i = getPort2NamespaceMap().keySet().iterator(); i.hasNext(); ) {");
        printWriter.println("                ports.add(");
        printWriter.println("                    com.ibm.ws.webservices.engine.utils.QNameTable.createQName(");
        printWriter.println("                        serviceNamespace,");
        printWriter.println("                        (String) i.next()));");
        printWriter.println("            }");
        printWriter.println("        }");
        printWriter.println("        return ports.iterator();");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetCalls(PrintWriter printWriter) {
        printWriter.println("    public javax.xml.rpc.Call[] getCalls(javax.xml.namespace.QName portName) throws javax.xml.rpc.ServiceException {");
        printWriter.println("        if (portName == null) {");
        printWriter.println("            throw new javax.xml.rpc.ServiceException(\"" + Messages.getMessage("badPort00") + "\");");
        printWriter.println("        }");
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            Object object;
            PortEntry portEntry = this.sEntry.getPort(i);
            if (portEntry.getAddress() == null && ((object = (Boolean)this.sEntry.getDynamicVar(SymbolTable.NON_BOUND_WSDL)) == null || !((Boolean)object).booleanValue())) continue;
            object = portEntry.getPort();
            if (i == 0) {
                printWriter.print("        if ");
            } else {
                printWriter.print("        else if ");
            }
            printWriter.println(" (portName.getLocalPart().equals(\"" + object.getName() + "\")) {");
            printWriter.println("            return new javax.xml.rpc.Call[] {");
            Iterator iterator = object.getBinding().getBindingOperations().iterator();
            while (iterator.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)iterator.next();
                Input input = bindingOperation.getOperation().getInput();
                if (input == null) {
                    printWriter.println("                createCall(portName, \"" + bindingOperation.getName() + "\"),");
                    continue;
                }
                printWriter.println("                createCall(portName, \"" + bindingOperation.getName() + "\", \"" + input.getName() + "\"),");
            }
            printWriter.println("            };");
            printWriter.println("        }");
        }
        printWriter.println("        else {");
        printWriter.println("            throw new javax.xml.rpc.ServiceException(\"" + Messages.getMessage("badPort00") + "\");");
        printWriter.println("        }");
        printWriter.println("    }");
    }
}

