/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enum.Use;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaEJBImplWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Scenario;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.rpc.holders.BooleanHolder;

public class JavaImplWriter
extends JavaClassWriter {
    protected Binding binding;
    protected SymbolTable symbolTable;
    protected BindingEntry bEntry;

    protected JavaImplWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, (String)symbolTable.getPortTypeEntry(bindingEntry.getBinding().getPortType().getQName()).getDynamicVar(JavaGeneratorFactory.IMPL_NAME), "templateImpl");
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
        this.bEntry = bindingEntry;
    }

    public void generate() throws IOException {
        if (this.emitter.getScenario() == Scenario.WRD_BOTTOM_UP_SERVER) {
            return;
        }
        if (!this.isFileGenerated(this.getFileName())) {
            super.generate();
        }
    }

    protected void writeHeaderComments(PrintWriter printWriter) throws IOException {
        super.writeHeaderComments(printWriter);
        if (this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER) {
            Binding binding = this.bEntry.getBinding();
            Definition definition = this.emitter.getCurrentDefinition();
            printWriter.println("/**");
            printWriter.print(" * @WebSphere.WebService wsdlLocation=\"" + this.emitter.getWSDLURI() + "\"");
            printWriter.print(" targetNamespace=\"" + definition.getTargetNamespace() + "\"");
            printWriter.print(" name=\"" + binding.getPortType().getQName().getLocalPart() + "\"");
            Map map = this.symbolTable.getServices();
            boolean bl = false;
            Iterator iterator = map.values().iterator();
            block0: while (iterator.hasNext() && !bl) {
                Port port2;
                Service service = (Service)iterator.next();
                Map map2 = service.getPorts();
                Iterator iterator2 = map2.values().iterator();
                while (iterator2.hasNext()) {
                    port2 = (Port)iterator2.next();
                    if (port2.getBinding() != binding) continue;
                    printWriter.println(" serviceName=\"" + service.getQName().getLocalPart() + "\"");
                    bl = true;
                    break;
                }
                if (!bl) continue;
                boolean bl2 = false;
                port2 = binding.getPortType();
                Iterator iterator3 = map2.values().iterator();
                while (iterator3.hasNext()) {
                    Port port3 = (Port)iterator3.next();
                    if (port3.getBinding().getPortType() == port2) {
                        bl2 = this.writeBindingAnnotation(printWriter, port3);
                    }
                    if (!bl2) continue;
                    continue block0;
                }
            }
            if (this instanceof JavaEJBImplWriter) {
                printWriter.print(" * @ejb.bean name=\"");
                printWriter.print(binding.getPortType().getQName().getLocalPart());
                printWriter.print('\"');
                printWriter.println(" type=StateLess");
            }
            printWriter.println(" */");
            printWriter.println();
        }
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        List list = this.binding.getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            BindingOperationEntry bindingOperationEntry = this.bEntry.getOperation(operation);
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                printWriter.println(bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE));
                printWriter.println();
                continue;
            }
            this.writeOperation(printWriter, bindingOperationEntry);
        }
    }

    protected String getImplementsText() {
        if (this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER) {
            return "";
        }
        String string = (String)this.bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        String string2 = "implements " + string;
        return string2;
    }

    protected void writeOperation(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry) throws IOException {
        String string;
        Object object;
        String string2 = (String)bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
        if (this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER) {
            printWriter.println("    /**");
            printWriter.println("     * @WebSphere.WebMethod");
            printWriter.println("     */");
            String string3 = " throws java.rmi.RemoteException";
            if (string2.endsWith(string3)) {
                string2 = string2.substring(0, string2.length() - string3.length());
            } else {
                int n;
                object = "throws ";
                string = "java.rmi.RemoteException, ";
                int n2 = string2.lastIndexOf((String)object);
                if (n2 != -1 && (n = string2.lastIndexOf(string)) > n2) {
                    string2 = string2.substring(0, n2 += ((String)object).length()) + string2.substring(n += string.length());
                }
            }
        }
        printWriter.println(string2 + " {");
        for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
            object = bindingOperationEntry.getParameter(i);
            if (((BindingParamEntry)object).getMode() != 2) continue;
            string = new BooleanHolder(false);
            String string4 = Utils.getConstructorForParam((BindingParamEntry)object, this.symbolTable, (BooleanHolder)string);
            if (((BooleanHolder)string).value) {
                printWriter.println("        try {");
            }
            printWriter.println("        " + ((Entry)object).getName() + ".value = " + string4 + ";");
            if (!((BooleanHolder)string).value) continue;
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("        }");
        }
        if (bindingOperationEntry.getReturn() != null) {
            printWriter.print("        return ");
            if (bindingOperationEntry.getReturn().getMIMEType() != null) {
                printWriter.println("null;");
            } else {
                String string5 = (String)bindingOperationEntry.getReturn().getDynamicVar("parameterType");
                if (Utils.isPrimitiveType(string5)) {
                    if ("boolean".equals(string5)) {
                        printWriter.println("false;");
                    } else if ("byte".equals(string5)) {
                        printWriter.println("(byte)-3;");
                    } else if ("short".equals(string5)) {
                        printWriter.println("(short)-3;");
                    } else {
                        printWriter.println("-3;");
                    }
                } else {
                    printWriter.println("null;");
                }
            }
        }
        printWriter.println("    }");
        printWriter.println();
    }

    protected boolean writeBindingAnnotation(PrintWriter printWriter, Port port2) {
        Binding binding = port2.getBinding();
        BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
        int n = bindingEntry.getBindingType();
        if (n == 0) {
            String string = binding.getQName().getLocalPart();
            printWriter.print(" * @WebSphere.SOAPBinding");
            printWriter.print(" bindingName=\"" + string + "\"");
            if (port2 != null) {
                printWriter.print(" portName=\"" + port2.getName() + "\"");
            }
            BindingOperationEntry bindingOperationEntry = this.findRepresentativeOperation(bindingEntry);
            printWriter.print(" style=");
            if (bindingEntry.getBindingStyle() == Style.DOCUMENT) {
                printWriter.print("DOCUMENT");
                if (bindingOperationEntry != null && !bindingOperationEntry.isWrapped()) {
                    printWriter.print(" parameterStyle=BARE");
                }
            } else {
                printWriter.print("RPC");
                if (bindingOperationEntry != null) {
                    printWriter.print(" use=");
                    if (bindingOperationEntry.getInputBodyUse() == Use.ENCODED) {
                        printWriter.print("ENCODED");
                    } else {
                        printWriter.print("LITERAL");
                    }
                }
            }
            printWriter.println();
            return true;
        }
        return false;
    }

    protected BindingOperationEntry findRepresentativeOperation(BindingEntry bindingEntry) {
        List list = this.binding.getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(operation);
            if (operationType != OperationType.REQUEST_RESPONSE && operationType != OperationType.ONE_WAY) continue;
            return bindingOperationEntry;
        }
        return null;
    }
}

