/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;

public final class BufferedWriter
extends Writer {
    protected static Log log = LogFactory.getLog(BufferedWriter.class.getName());
    private Writer out;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private OutputStream os;
    private String outEnc;
    private static int defaultCharBufferSize = 8192;

    public BufferedWriter(Writer writer) {
        this(writer, null, null, defaultCharBufferSize);
    }

    public BufferedWriter(Writer writer, OutputStream outputStream, String string) {
        this(writer, outputStream, string, defaultCharBufferSize);
    }

    public BufferedWriter(Writer writer, int n) {
        this(writer, null, null, n);
    }

    public BufferedWriter(Writer writer, OutputStream outputStream, String string, int n) {
        super((Object)writer);
        this.os = outputStream;
        this.outEnc = string;
        if (n <= 0) {
            throw new IllegalArgumentException(Messages.getMessage("bufferSize00"));
        }
        this.out = writer;
        this.cb = new char[n];
        this.nChars = n;
        this.nextChar = 0;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException(Messages.getMessage("streamClosed00"));
        }
    }

    public void flushBuffer() throws IOException {
        this.ensureOpen();
        if (this.nextChar == 0) {
            return;
        }
        this.out.write(this.cb, 0, this.nextChar);
        if (log.isDebugEnabled()) {
            String string = new String(this.cb, 0, this.nextChar);
            log.debug((Object)("flushBuffer:(" + string + ")"));
        }
        this.nextChar = 0;
    }

    public final void write(int n) throws IOException {
        if (this.nextChar >= this.nChars) {
            this.flushBuffer();
        }
        this.cb[this.nextChar++] = (char)n;
    }

    public final void write(int n, int n2) throws IOException {
        if (this.nextChar + 1 >= this.nChars) {
            this.flushBuffer();
        }
        this.cb[this.nextChar++] = (char)n;
        this.cb[this.nextChar++] = (char)n2;
    }

    private int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException(Messages.getMessage("buffedWriterOutOfBounds00"));
        }
        if (n2 == 0) {
            return;
        }
        if (n2 >= this.nChars) {
            this.flushBuffer();
            this.out.write(cArray, n, n2);
            return;
        }
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = this.min(this.nChars - this.nextChar, n4 - n3);
            System.arraycopy(cArray, n3, this.cb, this.nextChar, n5);
            n3 += n5;
            this.nextChar += n5;
            if (this.nextChar < this.nChars) continue;
            this.flushBuffer();
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        if (n2 >= this.nChars) {
            this.flushBuffer();
            this.out.write(string, n, n2);
            return;
        }
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = this.min(this.nChars - this.nextChar, n4 - n3);
            string.getChars(n3, n3 + n5, this.cb, this.nextChar);
            n3 += n5;
            this.nextChar += n5;
            if (this.nextChar < this.nChars) continue;
            this.flushBuffer();
        }
    }

    public final void write(String string) throws IOException {
        int n = string.length();
        if (n >= this.nChars - this.nextChar) {
            this.write(string, 0, n);
            return;
        }
        string.getChars(0, n, this.cb, this.nextChar);
        this.nextChar += n;
    }

    public final void write(String string, int n) throws IOException {
        int n2 = string.length();
        if (n2 + 1 >= this.nChars - this.nextChar) {
            this.write(string, 0, n2);
            this.write(n);
            return;
        }
        string.getChars(0, n2, this.cb, this.nextChar);
        this.nextChar += n2;
        this.cb[this.nextChar++] = (char)n;
    }

    public final void write(int n, String string) throws IOException {
        int n2 = string.length();
        if (n2 + 1 >= this.nChars - this.nextChar) {
            this.write(n);
            this.write(string, 0, n2);
            return;
        }
        this.cb[this.nextChar++] = (char)n;
        string.getChars(0, n2, this.cb, this.nextChar);
        this.nextChar += n2;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.flushBuffer();
        this.out.close();
        this.out = null;
        this.cb = null;
    }

    public void write(byte[] byArray, int n, int n2, String string) throws IOException {
        if (this.os != null && (string == this.outEnc || string != null && string.equals(this.outEnc) || string == null && this.outEnc.equals("utf-8"))) {
            this.flush();
            this.os.write(byArray, n, n2);
        } else {
            if (string == null) {
                string = "utf-8";
            }
            String string2 = new String(byArray, n, n2, string);
            this.write(string2);
        }
    }

    public void write(byte[] byArray, String string) throws IOException {
        this.write(byArray, 0, byArray.length, string);
    }
}

