/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.base.DefaultlInvocationHandler;
import com.ibm.ws.webservices.multiprotocol.encoding.AgnosticTypeMappingRegistry;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.models.ModelCall;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public abstract class ModelService
implements Service {
    protected ServiceContext context;
    protected Transport transport;
    protected AgnosticTypeMappingRegistry typeMappingRegistry;

    public ModelService(ServiceContext serviceContext) {
        this.context = serviceContext;
    }

    public Remote getPort(Class clazz) throws ServiceException {
        if (!clazz.isInterface()) {
            throw new ServiceException(Messages.getMessage("badSEI4", clazz.getName()));
        }
        if (!this.context.hasWSDL()) {
            throw new ServiceException(Messages.getMessage("badSEI1", clazz.getName()));
        }
        QName qName = this.getDefaultPortQName(clazz, null);
        if (qName == null) {
            throw new ServiceException(Messages.getMessage("badSEI2", clazz.getName()));
        }
        Remote remote = this.getPort(qName, clazz);
        return remote;
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        Remote remote = this.doGetPort(qName, clazz);
        return remote;
    }

    protected Remote doGetPort(QName qName, Class clazz) throws ServiceException {
        if (!this.context.hasWSDL()) {
            throw new ServiceException(Messages.getMessage("proxyError1"));
        }
        if (qName == null) {
            throw new ServiceException(Messages.getMessage("proxyError2"));
        }
        Remote remote = this.makeDynamicProxyStub(qName, clazz);
        return remote;
    }

    protected Remote makeDynamicProxyStub(QName qName, Class clazz) throws ServiceException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class[] classArray = new Class[]{clazz, Stub.class, Remote.class};
        InvocationHandler invocationHandler = this.getInvocationHandler(qName, clazz);
        Remote remote = null;
        try {
            remote = (Remote)Proxy.newProxyInstance(classLoader, classArray, invocationHandler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.webservices.multiprotocol.models.ModelService.makeDynamicProxyStub", (String)"186", (Object)this);
            throw new ServiceException(Messages.getMessage("proxyError3", illegalArgumentException.toString()));
        }
        return remote;
    }

    protected InvocationHandler getInvocationHandler(QName qName, Class clazz) throws ServiceException {
        Call call = this.createCall(qName);
        InvocationContext invocationContext = null;
        invocationContext = call instanceof ModelCall ? ((ModelCall)call).invocationContext : new InvocationContext(this.context);
        invocationContext.setSeiClass(clazz);
        if (!this.context.isManagedEnvironment() && this.context.hasWSDL()) {
            invocationContext.setEndpoint(this.getAddressForPort(qName));
        }
        DefaultlInvocationHandler defaultlInvocationHandler = new DefaultlInvocationHandler(invocationContext, call);
        return defaultlInvocationHandler;
    }

    protected String getAddressForPort(QName qName) throws ServiceException {
        String string = null;
        Definition definition = this.context.getDefinition();
        javax.wsdl.Service service = definition.getService(this.context.getServiceName());
        Port port2 = service.getPort(qName.getLocalPart());
        List list = port2.getExtensibilityElements();
        Object e = list.listIterator().next();
        string = e instanceof SOAPAddressImpl ? ((SOAPAddressImpl)e).getLocationURI() : ((AgnosticAddress)e).getLocationURI();
        return string;
    }

    public Call[] getCalls(QName qName) throws ServiceException {
        if (qName == null) {
            throw new ServiceException(Messages.getMessage("null_argument", "portName"));
        }
        Port port2 = this.context.getPortForQName(qName);
        if (port2 == null) {
            throw new ServiceException(Messages.getMessage("portNotFound", qName.toString()));
        }
        PortType portType = port2.getBinding().getPortType();
        List list = portType.getOperations();
        Call[] callArray = new Call[list.size()];
        for (int i = 0; i < callArray.length; ++i) {
            Operation operation = (Operation)list.get(i);
            String string = operation.getName();
            String string2 = null;
            Input input = operation.getInput();
            if (input != null) {
                string2 = input.getName();
            }
            callArray[i] = this.createCall(qName, QNameTable.createQName("", string), string2);
        }
        return callArray;
    }

    public Call createCall() throws ServiceException {
        Call call = this.createCallInternal(null, null, null, null);
        return call;
    }

    public Call createCall(QName qName) throws ServiceException {
        Call call = this.createCallInternal(qName, null, null, null);
        return call;
    }

    public Call createCall(QName qName, QName qName2) throws ServiceException {
        Call call = this.createCallInternal(qName, qName2, null, null);
        return call;
    }

    public Call createCall(QName qName, String string) throws ServiceException {
        QName qName2 = null;
        if (string != null) {
            qName2 = QNameTable.createQName("", string);
        }
        Call call = this.createCallInternal(qName, qName2, null, null);
        return call;
    }

    public Call createCall(QName qName, QName qName2, String string) throws ServiceException {
        Call call = this.createCallInternal(qName, qName2, string, null);
        return call;
    }

    public Call createCall(QName qName, QName qName2, String string, InvocationContext invocationContext) throws ServiceException {
        Call call = this.createCallInternal(qName, qName2, string, invocationContext);
        return call;
    }

    public Call createCall(QName qName, String string, String string2) throws ServiceException {
        Call call = this.createCallInternal(qName, QNameTable.createQName("", string), string2, null);
        return call;
    }

    protected Call createCallInternal(QName qName, QName qName2, String string, InvocationContext invocationContext) throws ServiceException {
        Class clazz;
        QName qName3;
        String string2 = null;
        if (qName != null) {
            string2 = qName.getLocalPart();
        }
        if (string2 == null && (qName3 = this.getDefaultPortQName(clazz = invocationContext != null ? invocationContext.getSeiClass() : null, null)) != null) {
            string2 = qName3.getLocalPart();
        }
        if (string2 == null) {
            string2 = this.getDefaultPortName();
        }
        if ((clazz = this.context.getWSDLService()) != null && (qName3 = clazz.getPort(string2)) == null) {
            throw new JAXRPCException(Messages.getMessage("portNotFound", string2));
        }
        qName3 = this.doCreateCall(string2, qName2, string, invocationContext);
        return qName3;
    }

    protected abstract Call doCreateCall(String var1, QName var2, String var3, InvocationContext var4) throws ServiceException;

    public Iterator getPorts() throws ServiceException {
        if (!this.context.hasWSDL()) {
            throw new ServiceException(Messages.getMessage("noWSDL"));
        }
        List list = this.getAvailablePortNames();
        String string = this.context.getServiceNamespace();
        ArrayList<QName> arrayList = new ArrayList<QName>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            QName qName = QNameTable.createQName(string, string2);
            arrayList.add(qName);
        }
        return arrayList.iterator();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.typeMappingRegistry == null) {
            this.typeMappingRegistry = new AgnosticTypeMappingRegistry();
        }
        return this.typeMappingRegistry;
    }

    public HandlerRegistry getHandlerRegistry() {
        throw new UnsupportedOperationException(Messages.getMessage("notSupported1", "getHandlerRegistry", this.getClass().getName()));
    }

    public QName getServiceName() {
        QName qName = this.context.getServiceName();
        return qName;
    }

    public URL getWSDLDocumentLocation() {
        URL uRL = this.context.getWSDLDocumentLocation();
        return uRL;
    }

    protected String getDefaultPortName() throws ServiceException {
        List list = this.getAvailablePortNames();
        String string = this.getDefaultPortName(list);
        return string;
    }

    protected QName getDefaultPortQName(Class clazz, Map map) throws ServiceException {
        Object object;
        Object object2;
        if (clazz != null && (object2 = this.getPortTypeForSEI(clazz.getName())) != null && (object = this.getPreferredPortForPortType((QName)object2)) != null) {
            return object;
        }
        object2 = this.getPortsForSEI(clazz);
        object = this.getDefaultPortName((List)object2);
        if (object != null) {
            return QNameTable.createQName(this.context.getServiceNamespace(), (String)object);
        }
        return null;
    }

    protected List getAvailablePortNames() throws ServiceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        javax.wsdl.Service service = this.context.getWSDLService();
        if (service != null) {
            Map map = service.getPorts();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.isPortAvailable(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    protected boolean isPortAvailable(String string) {
        return true;
    }

    protected String getDefaultPortName(List list) throws ServiceException {
        String string = null;
        if (list.size() > 0) {
            string = (String)list.get(0);
        }
        return string;
    }

    protected String getDefaultPortNameForSEI(Class clazz) throws ServiceException {
        String string = null;
        if (clazz != null) {
            Object object;
            QName qName = this.getPortTypeForSEI(clazz.getName());
            if (qName != null && (object = this.getPreferredPortForPortType(qName)) != null) {
                string = ((QName)object).getLocalPart();
            }
            if (string == null) {
                object = this.getPortsForSEI(clazz);
                string = this.getDefaultPortName((List)object);
            }
        }
        return string;
    }

    protected List getPortsForSEI(Class clazz) throws ServiceException {
        javax.wsdl.Service service = this.context.getWSDLService();
        if (service == null || clazz == null) {
            return new ArrayList();
        }
        QName qName = this.getPortTypeForSEI(clazz.getName());
        if (qName == null) {
            throw new ServiceException(Messages.getMessage("badSEI3", clazz.getName()));
        }
        List list = this.context.getPortsForPortType(qName);
        return list;
    }

    protected QName getPortTypeForSEI(String string) {
        QName qName = null;
        Map map = this.context.getSEIToPortTypeMapping();
        if (map != null) {
            qName = (QName)map.get(string);
        }
        if (qName == null) {
            Collection collection = this.context.getServicePorts();
            Iterator iterator = collection.iterator();
            while (qName == null && iterator.hasNext()) {
                Port port2 = (Port)iterator.next();
                QName qName2 = port2.getBinding().getPortType().getQName();
                String string2 = this.guessAtClassName(qName2);
                if (!string.equals(string2)) continue;
                qName = qName2;
            }
        }
        return qName;
    }

    protected QName getPreferredPortForPortType(QName qName) {
        Map map;
        QName qName2 = null;
        if (qName != null && (map = this.context.getPortTypeToPortMapping()) != null) {
            qName2 = (QName)map.get(qName);
        }
        return qName2;
    }

    private String guessAtClassName(QName qName) {
        String string = null;
        String string2 = qName.getNamespaceURI();
        Map map = this.context.getNamespace2PackageMapping();
        if (map != null) {
            string = (String)map.get(string2);
        }
        if (string == null) {
            string = JavaUtils.makePackageName(string2);
        }
        StringBuffer stringBuffer = string != null && string != "" ? new StringBuffer(string).append('.').append(JavaUtils.xmlNameToJavaClass(qName.getLocalPart())) : new StringBuffer(JavaUtils.xmlNameToJavaClass(qName.getLocalPart()));
        return stringBuffer.toString();
    }

    public Transport getTransport() {
        if (this.transport == null) {
            this.transport = this.makeTransport();
        }
        return this.transport;
    }

    protected abstract Transport makeTransport();

    static {
        Protocols.init();
    }
}

