/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.websphere.webservices.rpc.IBMCall;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.attachments.MimeUtils;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.SDOCall;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.models.ModelTransport;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import commonj.sdo.DataGraph;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;

public abstract class ModelCall
implements IBMCall,
SDOCall {
    protected InvocationContext invocationContext;
    protected QName portTypeName;
    protected QName operationName;
    protected String inputMessageName;
    protected ParameterDesc returnParameter;
    protected ArrayList parameters;
    protected boolean parameterAndReturnSpecRequired;
    protected Map outputParams;
    protected boolean invokeOneWayCalled = false;
    protected static ArrayList propertyNames = new ArrayList();
    protected Transport transport;

    protected ModelCall(InvocationContext invocationContext, Transport transport2, QName qName, String string) {
        this.invocationContext = invocationContext;
        this.transport = transport2;
        this.initialize();
        if (qName != null) {
            if (qName.getNamespaceURI().equals("")) {
                String string2 = this.invocationContext.getServiceContext().getServiceName().getNamespaceURI();
                QName qName2 = QNameTable.createQName(string2, qName.getLocalPart());
                this.setOperationName(qName2);
            } else {
                this.setOperationName(qName);
            }
        }
        this.inputMessageName = string;
        if (this.invocationContext.getEndpoint() == null) {
            this.setTargetEndpointAddress(this.getPort());
        }
    }

    protected void initialize() {
        this.returnParameter = null;
        this.parameters = new ArrayList();
        this.parameterAndReturnSpecRequired = true;
        this.invokeOneWayCalled = false;
        this.portTypeName = null;
        this.outputParams = new HashMap();
        this.invocationContext.setInputDataGraph(null);
        this.invocationContext.setOutputDataGraph(null);
        this.invocationContext.setInputParams(null);
        this.invocationContext.setOutputParams(null);
        this.invocationContext.setInputParameterTypes(null);
        this.invocationContext.setOneWay(false);
    }

    public void setProperty(String string, Object object) {
        if (this.isIllegalPropertyNameForCall(string)) {
            throw new JAXRPCException(Messages.getMessage("badCallPropName", string));
        }
        if ("javax.xml.rpc.session.maintain".equals(string)) {
            this.setMaintainSession(object);
        }
        this.doSetProperty(string, object);
    }

    protected void doSetProperty(String string, Object object) {
        this.invocationContext.setProperty(string, object);
    }

    public Object getProperty(String string) {
        if (this.isIllegalPropertyNameForCall(string)) {
            throw new JAXRPCException(Messages.getMessage("badCallPropName", string));
        }
        return this.invocationContext.getProperty(string);
    }

    protected void setMaintainSession(Object object) {
        if (!(object instanceof Boolean) || this.transport == null) {
            return;
        }
        boolean bl = (Boolean)object;
        if (bl) {
            return;
        }
        try {
            ((ModelTransport)this.transport).close(this.getTargetEndpointAddress());
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.webservices.multiprotocol.models.ModelCall.setMaintainSession", (String)"235", (Object)this);
            throw new JAXRPCException(Messages.getMessage("errorClosePort", "RemoteException", remoteException.toString()));
        }
    }

    public boolean isMaintainSession() {
        Boolean bl = (Boolean)this.getProperty("javax.xml.rpc.session.maintain");
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void removeProperty(String string) {
        this.invocationContext.removeProperty(string);
    }

    public static Iterator getDefaultPropertyNames() {
        return propertyNames.iterator();
    }

    public Iterator getPropertyNames() {
        return propertyNames.iterator();
    }

    public boolean isPropertySupported(String string) {
        return propertyNames.contains(string) || !string.startsWith("java.") && !string.startsWith("javax.");
    }

    protected boolean isIllegalPropertyNameForCall(String string) {
        if (string == null) {
            return true;
        }
        if (string.equals("javax.xml.rpc.encodingstyle.namespace.uri") || string.equals("javax.xml.rpc.soap.operation.style") || string.equals("javax.xml.rpc.security.auth.password") || string.equals("javax.xml.rpc.session.maintain") || string.equals("javax.xml.rpc.soap.http.soapaction.uri") || string.equals("javax.xml.rpc.soap.http.soapaction.use") || string.equals("javax.xml.rpc.security.auth.username")) {
            return false;
        }
        return string.startsWith("javax.xml.rpc");
    }

    public boolean isParameterAndReturnSpecRequired(QName qName) {
        return this.parameterAndReturnSpecRequired;
    }

    protected void setParameterAndReturnSpecRequired(boolean bl) {
        this.parameterAndReturnSpecRequired = bl;
    }

    public void addParameter(String string, QName qName, ParameterMode parameterMode) {
        this.addParameter(QNameTable.createQName("", string), qName, null, parameterMode);
    }

    public void addParameter(String string, QName qName, Class clazz, ParameterMode parameterMode) {
        this.addParameter(QNameTable.createQName("", string), qName, clazz, parameterMode);
    }

    public void addParameter(QName qName, QName qName2, Class clazz, ParameterMode parameterMode) {
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setQName(qName);
        parameterDesc.setTypeQName(qName2);
        parameterDesc.setJavaType(clazz);
        byte by = 1;
        if (parameterMode == ParameterMode.INOUT) {
            by = 3;
        } else if (parameterMode == ParameterMode.OUT) {
            by = 2;
        }
        parameterDesc.setMode(by);
        this.parameters.add(parameterDesc);
    }

    public QName getParameterTypeByName(String string) {
        QName qName = null;
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (!parameterDesc.getQName().getLocalPart().equals(string)) continue;
            qName = parameterDesc.getTypeQName();
        }
        return qName;
    }

    public void setReturnType(QName qName) {
        this.setReturnType(qName, null);
    }

    public void setReturnType(QName qName, Class clazz) {
        this.returnParameter = new ParameterDesc();
        this.returnParameter.setTypeQName(qName);
        this.returnParameter.setJavaType(clazz);
    }

    public QName getReturnType() {
        QName qName = null;
        if (this.returnParameter != null) {
            qName = this.returnParameter.getTypeQName();
        }
        return qName;
    }

    public Class getReturnClass() {
        Class clazz = null;
        clazz = this.returnParameter != null ? this.returnParameter.getJavaType() : this.invocationContext.getReturnType();
        return clazz;
    }

    public void removeAllParameters() {
        this.initialize();
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName qName) {
        this.operationName = qName;
    }

    public QName getPortTypeName() {
        return this.portTypeName == null ? QNameTable.createQName("", "") : this.portTypeName;
    }

    public void setPortTypeName(QName qName) {
        this.portTypeName = qName;
        this.invocationContext.setPortName(qName.getLocalPart());
    }

    public Port getPort() {
        Port port2 = null;
        Service service = this.invocationContext.getServiceContext().getWSDLService();
        if (service != null) {
            String string = this.invocationContext.getPortName();
            port2 = service.getPort(string);
        }
        return port2;
    }

    public String getTargetEndpointAddress() {
        return this.invocationContext.getEndpoint();
    }

    public void setTargetEndpointAddress(String string) {
        this.invocationContext.setEndpoint(string);
    }

    protected void setTargetEndpointAddress(Port port2) {
        List list;
        if (port2 != null && (list = port2.getExtensibilityElements()) != null && list.size() > 0) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(0);
            if (extensibilityElement instanceof AgnosticAddress) {
                AgnosticAddress agnosticAddress = (AgnosticAddress)extensibilityElement;
                this.setTargetEndpointAddress(agnosticAddress.getLocationURI());
            } else {
                this.doUnknownPortExtensibilityElement(port2, extensibilityElement);
            }
        }
    }

    protected void doUnknownPortExtensibilityElement(Port port2, ExtensibilityElement extensibilityElement) {
    }

    public void setInputMessageName(String string) {
        this.inputMessageName = string;
    }

    public Object invoke(Object[] objectArray) throws RemoteException {
        QName qName = this.getOperationName();
        Object object = this.invoke(qName, objectArray);
        return object;
    }

    public Object invoke(QName qName, Object[] objectArray) throws RemoteException {
        Object object = this.doInvoke(qName, null, objectArray);
        return object;
    }

    protected abstract Object doInvoke(InvocationContext var1) throws RemoteException;

    public Object invoke(QName qName, String string, Object[] objectArray) throws RemoteException {
        Object object = this.doInvoke(qName, string, objectArray);
        return object;
    }

    public DataGraph invoke(DataGraph dataGraph) throws RemoteException {
        this.invocationContext.setInputDataGraph(dataGraph);
        this.doInvoke(this.invocationContext);
        DataGraph dataGraph2 = this.invocationContext.getOutputDataGraph();
        return dataGraph2;
    }

    public void invokeOneway(DataGraph dataGraph) {
        this.invokeOneWayCalled = true;
        this.invocationContext.setOneWay(true);
        try {
            this.invoke(dataGraph);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        finally {
            this.invocationContext.setOneWay(false);
        }
    }

    protected Object doInvoke(QName qName, String string, Object[] objectArray) throws RemoteException {
        this.invocationContext.setOperationName(qName);
        this.invocationContext.setInputMessageName(string);
        this.invocationContext.setInputParams(objectArray);
        if (this.parameters.size() > 0) {
            boolean bl = true;
            ArrayList<Class> arrayList = new ArrayList<Class>();
            for (int i = 0; i < this.parameters.size(); ++i) {
                ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
                if (parameterDesc.getMode() == 2) continue;
                Class clazz = parameterDesc.getJavaType();
                if (clazz == null) {
                    bl = false;
                    break;
                }
                arrayList.add(clazz);
            }
            if (bl && arrayList.size() == objectArray.length) {
                this.invocationContext.setInputParameterTypes(arrayList.toArray(new Class[arrayList.size()]));
            }
        }
        return this.doInvoke(this.invocationContext);
    }

    protected Object getTarget() throws RemoteException {
        Object object;
        if (this.transport instanceof ModelTransport) {
            ModelTransport modelTransport = (ModelTransport)this.transport;
            object = modelTransport.getTargetObject(this.invocationContext);
        } else {
            object = this.transport.makeTargetObject(this.invocationContext);
        }
        return object;
    }

    protected void closeIfRequired(Object object) throws RemoteException {
        Boolean bl = (Boolean)this.getProperty("javax.xml.rpc.session.maintain");
        if (bl == null || !bl.booleanValue()) {
            if (this.transport instanceof ModelTransport) {
                ((ModelTransport)this.transport).close(this.getTargetEndpointAddress());
            } else {
                this.transport.close(this.invocationContext, object);
            }
        }
    }

    public void invokeOneWay(Object[] objectArray) {
        this.invokeOneWayCalled = true;
        this.invocationContext.setOneWay(true);
        try {
            this.invoke(objectArray);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.webservices.multiprotocol.models.ModelCall.invokeOneWay", (String)"550", (Object)this);
            throw new JAXRPCException(Messages.getMessage("invokeError", "RemoteException", remoteException.toString()));
        }
        finally {
            this.invocationContext.setOneWay(false);
        }
    }

    public Map getOutputParams() {
        return this.outputParams;
    }

    public List getOutputValues() {
        ArrayList<Object> arrayList = this.outputParams != null ? new ArrayList(this.outputParams.values()) : new ArrayList();
        return arrayList;
    }

    public void addAttachmentParameter(QName qName, String string, Class clazz, ParameterMode parameterMode) {
        this.addParameter(qName, MimeUtils.getMIMETypeQName(string), clazz, parameterMode);
    }

    public void setAttachmentReturnType(String string, Class clazz) {
        this.setReturnType(MimeUtils.getMIMETypeQName(string), clazz);
    }

    public void addParameter(QName qName, QName qName2, ParameterMode parameterMode) {
        this.addParameter(qName, qName2, null, parameterMode);
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    static {
        propertyNames.add("javax.xml.rpc.security.auth.username");
        propertyNames.add("javax.xml.rpc.security.auth.password");
        propertyNames.add("javax.xml.rpc.session.maintain");
        propertyNames.add("javax.xml.rpc.service.endpoint.address");
        propertyNames.add("com.ibm.websphere.webservices.protocolNamespace");
    }
}

