/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.extensions.agnostic;

import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.extensions.models.ModelExtensibilityElement;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;

public class AgnosticAddress
extends ModelExtensibilityElement {
    protected String urlProtocol;
    protected String urlHost;
    protected String urlPath;
    protected String urlQuery;
    protected Map urlQueryProperties;
    protected static final String LOCATION_ATTRIBUTE = "location";
    protected static final String URL_QUERY_PROPERTY_DELIMITERS = "|&";
    public static final QName AGNOSTIC_ADDRESS_ELEMENT_QNAME = QNameTable.createQName("http://www.ibm.com/ns/2003/06/wsdl/mp", "address");

    public AgnosticAddress() {
        super(Port.class, AGNOSTIC_ADDRESS_ELEMENT_QNAME);
    }

    protected String[] getAttributeNames() {
        return new String[]{LOCATION_ATTRIBUTE};
    }

    public void setLocationURI(String string) {
        this.setAttribute(LOCATION_ATTRIBUTE, string);
        this.urlProtocol = null;
        this.urlHost = null;
        this.urlPath = null;
        this.urlQuery = null;
        this.urlQueryProperties = null;
    }

    public String getLocationURI() {
        String string = this.getAttribute(LOCATION_ATTRIBUTE);
        return string;
    }

    public String getURLProtocol() throws WSDLException {
        String string = this.getLocationURI();
        if (this.urlProtocol == null && string != null) {
            int n = string.indexOf(58);
            if (n < 1) {
                throw new WSDLException("INVALID_WSDL", Messages.getMessage("invalidUrlProtocol", string));
            }
            this.urlProtocol = string.substring(0, n);
        }
        return this.urlProtocol;
    }

    public String getURLHost() throws WSDLException {
        String string = this.getLocationURI();
        if (this.urlHost == null && string != null) {
            String string2 = this.getURLProtocol();
            int n = string2.length() + 2;
            int n2 = string.indexOf(47, n);
            int n3 = string.indexOf(63);
            if (n2 > -1 && n2 < n3) {
                this.urlHost = string.substring(n, n2);
            } else {
                this.urlHost = string.substring(n);
                n3 = this.urlHost.indexOf(63);
                if (n3 > -1) {
                    this.urlHost = this.urlHost.substring(0, n3);
                }
            }
        }
        return this.urlHost;
    }

    public String getURLPath() throws WSDLException {
        String string = this.getLocationURI();
        if (this.urlPath == null && string != null) {
            int n;
            int n2;
            String string2 = this.getURLHost();
            if (string2.length() == 0) {
                String string3 = this.getURLProtocol();
                n2 = string3.length() + 3;
            } else {
                n2 = string.indexOf(string2) + string2.length() + 1;
            }
            this.urlPath = n2 > string.length() || string.charAt(n2 - 1) == '?' ? "" : ((n = string.indexOf(63, n2)) > -1 ? string.substring(n2, n) : string.substring(n2));
        }
        return this.urlPath;
    }

    public String getURLQuery() throws WSDLException {
        String string = this.getLocationURI();
        if (this.urlQuery == null && string != null) {
            this.getURLPath();
            int n = string.indexOf(63) + 1;
            this.urlQuery = n > 0 ? string.substring(n) : "";
        }
        return this.urlQuery;
    }

    public Map getURLQueryProperties() throws WSDLException {
        if (this.urlQueryProperties == null && this.getLocationURI() != null) {
            this.urlQueryProperties = new HashMap();
            String string = this.getURLQuery();
            if (string.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, URL_QUERY_PROPERTY_DELIMITERS);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n = string2.indexOf(61);
                    if (n < 1) {
                        throw new WSDLException("INVALID_WSDL", Messages.getMessage("missingEquals", this.getLocationURI()));
                    }
                    String string3 = string2.substring(0, n);
                    String string4 = n == string2.length() ? "" : string2.substring(n + 1);
                    this.urlQueryProperties.put(string3, string4);
                }
            }
        }
        return this.urlQueryProperties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        String string = this.getLocationURI();
        if (string != null) {
            stringBuffer.append("\n   url protocol=").append(this.urlProtocol);
            stringBuffer.append("\n   url host=").append(this.urlHost);
            stringBuffer.append("\n   url path=").append(this.urlPath);
            stringBuffer.append("\n   url query=").append(this.urlQuery);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

