/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.Namespaces;
import com.ibm.ws.webservices.multiprotocol.AgnosticService;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;

public class AgnosticServiceFactory
extends ServiceFactory
implements com.ibm.wsspi.webservices.rpc.ServiceFactory {
    protected ServiceProviderManager serviceProviderManager;
    protected static TraceComponent _tc = Tr.register((Class)AgnosticServiceFactory.class, (String)"WebServices", (String)"com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    private String whichGlobalHandlersToUse = "DEFAULT";
    private static final String PACKAGE_SEPERATOR = ".";

    protected TraceComponent getTraceObj() {
        return _tc;
    }

    public Service createService(URL uRL, QName qName) throws ServiceException {
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.entry((TraceComponent)this.getTraceObj(), (String)"createService(URL,QName)");
        }
        if (qName == null) {
            throw new ServiceException(Messages.getMessage("null_argument", "serviceName"));
        }
        Definition definition = this.getDefinitionFromURL(uRL);
        if (definition == null) {
            throw new ServiceException(Messages.getMessage("noWsdlDefn", uRL.toString()));
        }
        javax.wsdl.Service service = definition.getService(qName);
        if (service == null) {
            throw new ServiceException(Messages.getMessage("noWsdlService", uRL.toString(), qName.toString()));
        }
        ServiceProviderManager serviceProviderManager = this.getServiceProviderManager();
        ServiceContext serviceContext = new ServiceContext(uRL, definition, qName);
        AgnosticService agnosticService = new AgnosticService(serviceContext, serviceProviderManager);
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.exit((TraceComponent)this.getTraceObj(), (String)"createService(URL,QName)");
        }
        return agnosticService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service createService(QName qName) throws ServiceException {
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.entry((TraceComponent)this.getTraceObj(), (String)"createService(QName)");
        }
        AgnosticService agnosticService = null;
        try {
            ServiceProviderManager serviceProviderManager = this.getServiceProviderManager();
            ServiceContext serviceContext = new ServiceContext(null, null, qName);
            agnosticService = new AgnosticService(serviceContext, serviceProviderManager);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.getTraceObj().isEntryEnabled()) {
                Tr.exit((TraceComponent)this.getTraceObj(), (String)"createService(QName)");
            }
            throw throwable;
        }
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.exit((TraceComponent)this.getTraceObj(), (String)"createService(QName)");
        }
        return agnosticService;
    }

    protected Service createService(QName qName, ServiceContext serviceContext) {
        ServiceProviderManager serviceProviderManager = this.getServiceProviderManager();
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.entry((TraceComponent)this.getTraceObj(), (String)"createService(QName,ServiceContext)");
        }
        AgnosticService agnosticService = new AgnosticService(serviceContext, serviceProviderManager);
        if (this.getTraceObj().isEntryEnabled()) {
            Tr.exit((TraceComponent)this.getTraceObj(), (String)"createService(QName,ServiceContext)");
        }
        return agnosticService;
    }

    public Service loadService(Class clazz) throws ServiceException {
        return this.findGeneratedServiceLocator(clazz.getName(), clazz);
    }

    public Service loadService(URL uRL, Class clazz, Properties properties) throws ServiceException {
        return this.findGeneratedServiceLocator(clazz.getName(), clazz);
    }

    public Service loadService(URL uRL, QName qName, Properties properties) throws ServiceException {
        Namespaces namespaces = this.getNs2PkgMapping(properties);
        String string = namespaces.getCreate(qName.getNamespaceURI());
        String string2 = string + PACKAGE_SEPERATOR + qName.getLocalPart();
        return this.findGeneratedServiceLocator(string2, null);
    }

    private Namespaces getNs2PkgMapping(Properties properties) {
        Namespaces namespaces = new Namespaces(null, PACKAGE_SEPERATOR.charAt(0));
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)properties.get(string);
                namespaces.put(string, string2);
            }
        }
        return namespaces;
    }

    private Service findGeneratedServiceLocator(String string, Class clazz) throws ServiceException {
        String string2;
        String string3 = string + "Locator";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz2 = null;
        Service service = null;
        try {
            clazz2 = classLoader.loadClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.error((TraceComponent)_tc, (String)"noClassForService00", (Object)string3);
        }
        if (clazz == null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tr.error((TraceComponent)_tc, (String)"noClassForService00", (Object)string);
            }
        }
        if (clazz2 != null) {
            if (!Service.class.isAssignableFrom(clazz)) {
                string2 = Messages.getMessage("mustSubclassService", clazz.getName());
                Tr.error((TraceComponent)_tc, (String)"mustSubclassService", (Object)clazz.getName());
                throw new ServiceException(string2);
            }
            if (!clazz.isAssignableFrom(clazz2)) {
                string2 = Messages.getMessage("mustSubclassServiceInterface", clazz.getName(), clazz2.getName());
                Tr.error((TraceComponent)_tc, (String)"mustSubclassServiceInterface", (Object)new Object[]{clazz.getName(), clazz2.getName()});
                throw new ServiceException(string2);
            }
            try {
                service = this.constructServiceLocator(clazz2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory.findGeneratedServiceLocator", (String)"459", (Object)this);
                String string4 = Messages.getMessage("cantInstantiateClass", clazz2.getName());
                Tr.error((TraceComponent)_tc, (String)"cantInstantiateClass", (Object)clazz2.getName());
                throw new ServiceException(string4, (Throwable)exception);
            }
            return service;
        }
        string2 = Messages.getMessage("noClassForService00", string3);
        Tr.error((TraceComponent)_tc, (String)"noClassForService00", (Object)string3);
        throw new ServiceException(string2);
    }

    public void setServiceProvider(String string, ServiceProvider serviceProvider) {
        ServiceProviderManager serviceProviderManager = this.getServiceProviderManager();
        serviceProviderManager.overrideDefaultServiceProvider(string, serviceProvider);
    }

    protected ServiceProviderManager getServiceProviderManager() {
        if (this.serviceProviderManager == null) {
            this.serviceProviderManager = new ServiceProviderManager();
        }
        return this.serviceProviderManager;
    }

    protected Definition getDefinitionFromURL(URL uRL) throws ServiceException {
        Definition definition;
        WSDLFactory wSDLFactory = this.getServiceProviderManager().getWSDLFactory();
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        try {
            definition = wSDLReader.readWSDL(null, uRL.toString());
        }
        catch (WSDLException wSDLException) {
            FFDCFilter.processException((Throwable)wSDLException, (String)"com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory.getDefinitionFromURL", (String)"281", (Object)this);
            throw new ServiceException(Messages.getMessage("wsdlReadError", uRL.toString()));
        }
        return definition;
    }

    private Service constructServiceLocator(Class clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Service service = null;
        service = (Service)clazz.newInstance();
        if (service instanceof AgnosticService) {
            ((AgnosticService)service).useGlobalHandlers(this.whichGlobalHandlersToUse);
        }
        return service;
    }

    public void useGlobalHandlers(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"useGlobalHandlers");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory.useGlobalHandlers(whichGlobalHandlersToUse): setting handlers-to-use to " + string));
        }
        if ("DEFAULT".equals(string) || "APPLICATION_ENGINE".equals(string) || "SYSTEM_ENGINE".equals(string)) {
            this.whichGlobalHandlersToUse = string;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory.useGlobalHandlers(whichGlobalHandlersToUse): Ignoring invalid parameter value " + string));
            }
            this.whichGlobalHandlersToUse = "DEFAULT";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"useGlobalHandlers");
        }
    }
}

