/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webservices.metadata.ApplicationMetaDataHolder;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientEntityMetaDataHolder;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.metadata.ComponentMetaDataHolder;
import com.ibm.ws.webservices.metadata.ModuleMetaDataHolder;
import com.ibm.ws.webservices.metadata.ServerModuleMetaData;
import java.util.Map;

public class WASWebServicesServerMetaDataImpl {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register((Class)WASWebServicesServerMetaDataImpl.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private MetaDataSlot componentSlot = null;
    private MetaDataSlot moduleSlot = null;
    private MetaDataSlot applicationSlot = null;

    public WASWebServicesServerMetaDataImpl(MetaDataService metaDataService) {
        this.applicationSlot = metaDataService.reserveSlot(ApplicationMetaData.class);
        this.moduleSlot = metaDataService.reserveSlot(ModuleMetaData.class);
        this.componentSlot = metaDataService.reserveSlot(ComponentMetaData.class);
    }

    public void destroy(ApplicationMetaData applicationMetaData) {
        ApplicationMetaDataHolder applicationMetaDataHolder = (ApplicationMetaDataHolder)applicationMetaData.getMetaData(this.applicationSlot);
        if (applicationMetaDataHolder != null) {
            if (_tc.isDebugEnabled()) {
                this.logDebug(applicationMetaData, "Destroying webservices application " + applicationMetaData + " metadata");
            }
            applicationMetaData.setMetaData(this.applicationSlot, null);
            applicationMetaDataHolder.destroy();
        }
    }

    public void destroy(ModuleMetaData moduleMetaData) {
        ModuleMetaDataHolder moduleMetaDataHolder = (ModuleMetaDataHolder)moduleMetaData.getMetaData(this.moduleSlot);
        if (moduleMetaDataHolder != null) {
            if (_tc.isDebugEnabled()) {
                this.logDebug(moduleMetaData, "Destroying webservices module " + moduleMetaData + " metadata");
            }
            moduleMetaData.setMetaData(this.moduleSlot, null);
            moduleMetaDataHolder.destroy();
        }
    }

    public void destroy(ComponentMetaData componentMetaData) {
        ComponentMetaDataHolder componentMetaDataHolder = (ComponentMetaDataHolder)componentMetaData.getMetaData(this.componentSlot);
        if (componentMetaDataHolder != null) {
            if (_tc.isDebugEnabled()) {
                this.logDebug(componentMetaData, "Destroying webservices component " + componentMetaData + " metadata");
            }
            componentMetaData.setMetaData(this.componentSlot, null);
            componentMetaDataHolder.destroy();
        }
    }

    public ServerModuleMetaData getServerModuleMetaData(ModuleMetaData moduleMetaData) {
        ServerModuleMetaData serverModuleMetaData;
        if (moduleMetaData == null) {
            return null;
        }
        ModuleMetaDataHolder moduleMetaDataHolder = (ModuleMetaDataHolder)moduleMetaData.getMetaData(this.moduleSlot);
        ServerModuleMetaData serverModuleMetaData2 = serverModuleMetaData = moduleMetaDataHolder == null ? null : moduleMetaDataHolder.getServerMetaData();
        if (serverModuleMetaData != null) {
            if (_tc.isDebugEnabled()) {
                this.logDebug(moduleMetaData, "Located " + serverModuleMetaData + " in " + moduleMetaData);
            }
        } else {
            serverModuleMetaData = this.getServerModuleMetaData(moduleMetaData.getApplicationMetaData(), moduleMetaData.getName());
            if (serverModuleMetaData != null) {
                if (_tc.isDebugEnabled()) {
                    this.logDebug(moduleMetaData, "Binding " + serverModuleMetaData + " to " + moduleMetaData);
                }
                if (moduleMetaData instanceof WebModuleMetaDataImpl) {
                    serverModuleMetaData.bindRouterURLPatterns(((WebModuleMetaDataImpl)moduleMetaData).getWebAppConfig());
                }
                if (moduleMetaDataHolder == null) {
                    moduleMetaDataHolder = new ModuleMetaDataHolder();
                    moduleMetaData.setMetaData(this.moduleSlot, (Object)moduleMetaDataHolder);
                }
                moduleMetaDataHolder.setServerMetaData(serverModuleMetaData);
            }
        }
        return serverModuleMetaData;
    }

    public ServerModuleMetaData getServerModuleMetaData(ApplicationMetaData applicationMetaData, String string) {
        ServerModuleMetaData serverModuleMetaData;
        if (applicationMetaData == null) {
            return null;
        }
        ApplicationMetaDataHolder applicationMetaDataHolder = (ApplicationMetaDataHolder)applicationMetaData.getMetaData(this.applicationSlot);
        if (applicationMetaDataHolder != null) {
            serverModuleMetaData = applicationMetaDataHolder.getServerModuleMetaData(string);
            if (serverModuleMetaData != null && _tc.isDebugEnabled()) {
                this.logDebug(applicationMetaData, "Located " + serverModuleMetaData + " in " + applicationMetaData + " for module " + string);
            }
        } else {
            serverModuleMetaData = null;
        }
        return serverModuleMetaData;
    }

    public void addServerModuleMetaData(ApplicationMetaData applicationMetaData, ServerModuleMetaData serverModuleMetaData) {
        ApplicationMetaDataHolder applicationMetaDataHolder = (ApplicationMetaDataHolder)applicationMetaData.getMetaData(this.applicationSlot);
        if (applicationMetaDataHolder == null) {
            applicationMetaDataHolder = new ApplicationMetaDataHolder();
            applicationMetaData.setMetaData(this.applicationSlot, (Object)applicationMetaDataHolder);
        }
        if (_tc.isDebugEnabled()) {
            this.logDebug(applicationMetaData, "Binding " + serverModuleMetaData + " to " + applicationMetaData + " for module " + serverModuleMetaData.getRouterModuleName());
        }
        applicationMetaDataHolder.addServerModuleMetaData(serverModuleMetaData);
    }

    public void setServerModuleMetaData(ModuleMetaData moduleMetaData, ServerModuleMetaData serverModuleMetaData) {
        if (_tc.isDebugEnabled()) {
            this.logDebug(moduleMetaData, "Binding " + serverModuleMetaData + " to " + moduleMetaData);
        }
        ModuleMetaDataHolder moduleMetaDataHolder = this.createModuleMetaDataHolder(moduleMetaData);
        moduleMetaDataHolder.setServerMetaData(serverModuleMetaData);
    }

    public ClientModuleMetaData getClientModuleMetaData(ModuleMetaData moduleMetaData) {
        ModuleMetaDataHolder moduleMetaDataHolder = (ModuleMetaDataHolder)moduleMetaData.getMetaData(this.moduleSlot);
        return moduleMetaDataHolder == null ? null : moduleMetaDataHolder.getClientModuleMetaData();
    }

    public void setClientModuleMetaData(ModuleMetaData moduleMetaData, ClientModuleMetaData clientModuleMetaData) {
        ModuleMetaDataHolder moduleMetaDataHolder = this.createModuleMetaDataHolder(moduleMetaData);
        moduleMetaDataHolder.setClientModuleMetaData(clientModuleMetaData);
    }

    public void syncModuleMetaData(ModuleMetaData moduleMetaData, ClientModuleMetaData clientModuleMetaData) {
        ClientEntityMetaData clientEntityMetaData = clientModuleMetaData.getModuleScopedMetaData();
        if (clientEntityMetaData != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Storing clientMetaData " + clientEntityMetaData + " for module"));
            }
            this.setModuleClientEntityMetaData(moduleMetaData, clientEntityMetaData);
        }
    }

    public ClientEntityMetaData getComponentClientEntityMetaData(ComponentMetaData componentMetaData) {
        ClientEntityMetaDataHolder clientEntityMetaDataHolder = (ClientEntityMetaDataHolder)componentMetaData.getMetaData(this.componentSlot);
        return clientEntityMetaDataHolder == null ? null : clientEntityMetaDataHolder.getClientEntityMetaData();
    }

    public void setComponentClientEntityMetaData(ComponentMetaData componentMetaData, ClientEntityMetaData clientEntityMetaData) {
        ComponentMetaDataHolder componentMetaDataHolder = (ComponentMetaDataHolder)componentMetaData.getMetaData(this.componentSlot);
        if (componentMetaDataHolder == null) {
            componentMetaDataHolder = new ComponentMetaDataHolder();
            componentMetaData.setMetaData(this.componentSlot, (Object)componentMetaDataHolder);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("setComponentClientEntityMetaData: cmd=" + componentMetaData.toString() + ", slot=" + this.componentSlot.toString() + ", cmdh=" + componentMetaDataHolder.toString()));
            }
        }
        componentMetaDataHolder.setClientEntityMetaData(clientEntityMetaData);
    }

    public ClientEntityMetaData getModuleClientEntityMetaData(ModuleMetaData moduleMetaData) {
        ClientEntityMetaDataHolder clientEntityMetaDataHolder = (ClientEntityMetaDataHolder)moduleMetaData.getMetaData(this.moduleSlot);
        return clientEntityMetaDataHolder == null ? null : clientEntityMetaDataHolder.getClientEntityMetaData();
    }

    public void setModuleClientEntityMetaData(ModuleMetaData moduleMetaData, ClientEntityMetaData clientEntityMetaData) {
        ModuleMetaDataHolder moduleMetaDataHolder = (ModuleMetaDataHolder)moduleMetaData.getMetaData(this.moduleSlot);
        if (moduleMetaDataHolder == null) {
            moduleMetaDataHolder = new ModuleMetaDataHolder();
            moduleMetaData.setMetaData(this.moduleSlot, (Object)moduleMetaDataHolder);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("setModuleClientEntityMetaData: mmd=" + moduleMetaData.toString() + ", slot=" + this.moduleSlot.toString() + ", mmdh=" + moduleMetaDataHolder.toString()));
            }
        }
        moduleMetaDataHolder.setClientEntityMetaData(clientEntityMetaData);
    }

    private ModuleMetaDataHolder getModuleMetaDataHolder(ModuleMetaData moduleMetaData) {
        return (ModuleMetaDataHolder)moduleMetaData.getMetaData(this.moduleSlot);
    }

    private ModuleMetaDataHolder createModuleMetaDataHolder(ModuleMetaData moduleMetaData) {
        ModuleMetaDataHolder moduleMetaDataHolder = (ModuleMetaDataHolder)moduleMetaData.getMetaData(this.moduleSlot);
        if (moduleMetaDataHolder == null) {
            moduleMetaDataHolder = new ModuleMetaDataHolder();
            moduleMetaData.setMetaData(this.moduleSlot, (Object)moduleMetaDataHolder);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("createModuleMetaDataHolder: mmd=" + moduleMetaData.toString() + ", slot=" + this.moduleSlot.toString() + ", mmdh=" + moduleMetaDataHolder.toString()));
            }
        }
        return moduleMetaDataHolder;
    }

    public synchronized Map getWSDLModuleData() {
        return this.getWSDLModuleData(this.getModuleMetaData());
    }

    public synchronized Map getWSDLModuleData(ModuleMetaData moduleMetaData) {
        Map map = null;
        if (moduleMetaData != null) {
            ApplicationMetaData applicationMetaData = moduleMetaData.getApplicationMetaData();
            ApplicationMetaDataHolder applicationMetaDataHolder = (ApplicationMetaDataHolder)applicationMetaData.getMetaData(this.applicationSlot);
            if (applicationMetaDataHolder == null) {
                applicationMetaDataHolder = new ApplicationMetaDataHolder();
                applicationMetaData.setMetaData(this.applicationSlot, (Object)applicationMetaDataHolder);
            }
            map = applicationMetaDataHolder.getWSDLModuleData();
        } else if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"No ModuleMetaData is found,  null will be returned");
        }
        return map;
    }

    public synchronized void setWSDLModuleData(ModuleMetaData moduleMetaData, Map map) {
        ApplicationMetaData applicationMetaData = moduleMetaData.getApplicationMetaData();
        ApplicationMetaDataHolder applicationMetaDataHolder = (ApplicationMetaDataHolder)applicationMetaData.getMetaData(this.applicationSlot);
        if (applicationMetaDataHolder == null) {
            applicationMetaDataHolder = new ApplicationMetaDataHolder();
            applicationMetaData.setMetaData(this.applicationSlot, (Object)applicationMetaDataHolder);
        }
        applicationMetaDataHolder.setWSDLModuleData(map);
    }

    private ComponentMetaData getComponentMetaData() {
        return ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
    }

    private ModuleMetaData getModuleMetaData() {
        return this.getComponentMetaData().getModuleMetaData();
    }

    public ServerModuleMetaData getServerModuleMetaData() {
        return this.getServerModuleMetaData(this.getModuleMetaData());
    }

    public ClientEntityMetaData getClientEntityMetaData() {
        ModuleMetaData moduleMetaData;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getClientEntityMetaData");
        }
        ComponentMetaData componentMetaData = this.getComponentMetaData();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("cmd: " + componentMetaData.toString()));
        }
        ClientEntityMetaDataHolder clientEntityMetaDataHolder = null;
        Object object = componentMetaData.getMetaData(this.componentSlot);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("metaDataObj: " + (object != null ? object.toString() : "null")));
            Tr.debug((TraceComponent)_tc, (String)("componentSlot: " + this.componentSlot.toString()));
        }
        if (object != null && object instanceof ClientEntityMetaDataHolder) {
            clientEntityMetaDataHolder = (ClientEntityMetaDataHolder)object;
        }
        if ((clientEntityMetaDataHolder == null || clientEntityMetaDataHolder.getClientEntityMetaData() == null) && (moduleMetaData = componentMetaData.getModuleMetaData()) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("mmd: " + moduleMetaData.toString()));
                Tr.debug((TraceComponent)_tc, (String)("moduleSlot: " + this.moduleSlot.toString()));
            }
            clientEntityMetaDataHolder = (ClientEntityMetaDataHolder)moduleMetaData.getMetaData(this.moduleSlot);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getClientEntityMetaData");
        }
        return clientEntityMetaDataHolder != null ? clientEntityMetaDataHolder.getClientEntityMetaData() : null;
    }

    private void logDebug(ApplicationMetaData applicationMetaData, String string) {
        this.logDebug(applicationMetaData.getName(), null, null, string);
    }

    private void logDebug(ModuleMetaData moduleMetaData, String string) {
        this.logDebug(moduleMetaData.getApplicationMetaData().getName(), moduleMetaData.getName(), null, string);
    }

    private void logDebug(ComponentMetaData componentMetaData, String string) {
        ModuleMetaData moduleMetaData = componentMetaData.getModuleMetaData();
        if (moduleMetaData != null) {
            this.logDebug(moduleMetaData.getApplicationMetaData().getName(), moduleMetaData.getName(), componentMetaData.getName(), string);
        } else {
            this.logDebug("null MMD", "null MMD", componentMetaData.getName(), string);
        }
    }

    private void logDebug(String string, String string2, String string3, String string4) {
        String string5 = null;
        if (string != null) {
            string5 = "Application=" + string;
        }
        if (string2 != null) {
            string5 = string5 != null ? string5 + "#" : "";
            string5 = string5 + "Module=" + string2;
        }
        if (string3 != null) {
            string5 = string5 != null ? string5 + "#" : "";
            string5 = string5 + "Component=" + string3;
        }
        Tr.debug((TraceComponent)_tc, (String)(string5 + ": " + string4));
    }
}

