/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webservices.configuration.WASEngineConfigurationProvider;
import com.ibm.ws.webservices.configuration.WebServicesEngineConfigurationGenerator;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.metadata.ServerPortMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ServerModuleMetaData {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static TraceComponent _tc = Tr.register((Class)ServerModuleMetaData.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private final String applicationName;
    private final String moduleName;
    protected WSDDDeployment deployment;
    protected boolean tryLoadDeploy = false;
    private EngineConfiguration configuration;
    private String routerModuleName;
    private WebServicesPerf pmiServicesModule;
    protected Map serverPorts = new HashMap();
    private String binaryURL;

    public ServerModuleMetaData(String string, String string2) {
        this.applicationName = string;
        this.moduleName = string2;
    }

    public void destroy() {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(this.applicationName + "#" + this.moduleName + ": Destroying " + this));
        }
        this.deployment = null;
        this.pmiServicesModule = null;
        if (this.serverPorts != null) {
            Iterator iterator = this.serverPorts.values().iterator();
            while (iterator.hasNext()) {
                ServerPortMetaData serverPortMetaData = (ServerPortMetaData)iterator.next();
                if (serverPortMetaData == null) continue;
                serverPortMetaData.destroy();
            }
            this.serverPorts.clear();
            this.serverPorts = null;
        }
        if (this.configuration != null) {
            this.configuration.destroy();
            this.configuration = null;
            this.deployment = null;
        }
    }

    public Map getPorts() {
        return this.serverPorts;
    }

    public ServerPortMetaData getPort(String string, boolean bl) {
        ServerPortMetaData serverPortMetaData = (ServerPortMetaData)this.serverPorts.get(string);
        if (serverPortMetaData == null && bl) {
            serverPortMetaData = new ServerPortMetaData(string);
            this.serverPorts.put(string, serverPortMetaData);
        }
        return serverPortMetaData;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public synchronized WSDDDeployment getDeployment() {
        if (this.deployment == null && !this.tryLoadDeploy) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Creating engine config");
            }
            this.deployment = WebServicesEngineConfigurationGenerator.createServerDeployment(this.serverPorts.values());
            this.tryLoadDeploy = true;
        }
        if (_tc.isDebugEnabled() && this.deployment != null) {
            Tr.debug((TraceComponent)_tc, (String)("this.hashCode=" + this.hashCode() + "getConfiguration: configuration=" + this.deployment));
        }
        return this.deployment;
    }

    public synchronized EngineConfiguration getConfiguration() {
        if (this.configuration == null) {
            WSDDDeployment wSDDDeployment = this.getDeployment();
            this.configuration = new WASEngineConfigurationProvider(wSDDDeployment);
        }
        return this.configuration;
    }

    public WebServicesPerf getPMIServicesModule() {
        return this.pmiServicesModule;
    }

    public String getRouterModuleName() {
        return this.routerModuleName;
    }

    public void setRouterModuleName(String string) {
        this.routerModuleName = string;
    }

    public String getBinaryURL() {
        return this.binaryURL;
    }

    public void setBinaryURL(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"absolute binary url", (Object)string);
        }
        this.binaryURL = string;
    }

    public void collaboratorStarted() {
        if (this.getDeployment() != null) {
            this.pmiServicesModule = PmiFactory.createWebServicesPerf((String)this.getApplicationName(), (String)this.getModuleName());
            if (this.getPMIServicesModule() != null) {
                WSDDPort[] wSDDPortArray = this.getDeployment().getPorts();
                for (int i = 0; i < wSDDPortArray.length; ++i) {
                    WSDDPort wSDDPort = wSDDPortArray[i];
                    this.getPMIServicesModule().onServiceLoad(wSDDPort.getQName().toString());
                }
            }
        }
    }

    public void collaboratorStopped() {
        if (this.getDeployment() != null && this.getPMIServicesModule() != null) {
            WSDDPort[] wSDDPortArray = this.getDeployment().getPorts();
            for (int i = 0; i < wSDDPortArray.length; ++i) {
                WSDDPort wSDDPort = wSDDPortArray[i];
                this.getPMIServicesModule().onServiceUnload(wSDDPort.getQName().toString());
            }
            PmiFactory.removePmiModule((Object)this.getPMIServicesModule());
            this.pmiServicesModule = null;
        }
    }

    public void bindRouterURLPatterns(WebAppConfiguration webAppConfiguration) {
        Object object;
        Iterator<Object> iterator;
        Object object2;
        HashMap hashMap = webAppConfiguration.getServletMappings();
        Object object3 = hashMap.values().iterator();
        while (object3.hasNext()) {
            object2 = (List)object3.next();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (ServletMapping)iterator.next();
                ServletConfig servletConfig = object.getServletConfig();
                String string = servletConfig.getServletName();
                String string2 = object.getUrlPattern();
                ServerPortMetaData serverPortMetaData = this.getPort(string, true);
                serverPortMetaData.setServletName(servletConfig.getServletName());
                if (string2 != null) {
                    serverPortMetaData.setURLPattern(string2, false);
                    continue;
                }
                serverPortMetaData.setURLPattern("/services/" + string, true);
            }
        }
        if (_tc.isDebugEnabled()) {
            object3 = new StringBuffer();
            object3 = ((StringBuffer)object3).append("warMetaDataCreated for a non Web Services enabled module ");
            object3 = ((StringBuffer)object3).append(this.moduleName);
            object3 = ((StringBuffer)object3).append(", portComponentName info: \n");
            object2 = this.getPorts();
            if (object2 != null) {
                iterator = object2.values().iterator();
                while (iterator.hasNext()) {
                    object = (ServerPortMetaData)iterator.next();
                    ((StringBuffer)object3).append("\t");
                    ((StringBuffer)object3).append(object);
                    ((StringBuffer)object3).append("\n");
                }
            }
            Tr.debug((TraceComponent)_tc, (String)((StringBuffer)object3).toString());
        }
    }
}

