/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.j2ee.commonarchivecore.strategy.LoadStrategy;
import com.ibm.etools.webservice.wscbnd.DefaultMapping;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wsclient.Handler;
import com.ibm.etools.webservice.wscommonbnd.Parameter;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.webservices.WSModels;
import com.ibm.ws.webservices.client.ModuleWSDLLocator;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientPortMetaData;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.naming.ObjectFactoryImpl;
import com.ibm.ws.webservices.security.SecurityHooks;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ClientServiceMetaData
implements Referenceable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register((Class)ClientServiceMetaData.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static final String VERSION = "version: ";
    private static final String VERSION_ID = "1.0";
    private static final String REFSERVICENAME = "refServiceName:";
    private ClientEntityMetaData parent;
    private String name = null;
    private QName qName = null;
    private String serviceInterface = null;
    private boolean wsdlDocLoaded = false;
    private String wsdlFileName;
    private Definition wsdlDoc;
    private Service wsdlServiceElement;
    private String wsdlTargetNamespace;
    private String[] wsdlPortNames;
    private boolean cleanedPortMapping = false;
    private Map defaultPortMapping;
    private boolean mappingMetaDataLoaded = false;
    private String jaxrpcMappingFileName;
    private Map seiToPortTypeMapping;
    private Map namespaceToPackageMapping;
    private Map overriddingEndpointURIs = null;
    private Map overriddingBindingNamespaces = null;
    private boolean jndiBound = false;
    private List globalHandlers = new ArrayList();
    private Map portHandlers = new HashMap();
    private Map clientPorts = new HashMap();

    public ClientServiceMetaData(String string, ClientEntityMetaData clientEntityMetaData) {
        this.name = string.intern();
        this.parent = clientEntityMetaData;
    }

    public void destroy() {
        Object object;
        Iterator iterator;
        this.parent = null;
        this.wsdlDoc = null;
        this.wsdlServiceElement = null;
        this.wsdlPortNames = null;
        if (this.defaultPortMapping != null) {
            this.defaultPortMapping.clear();
            this.defaultPortMapping = null;
        }
        if (this.seiToPortTypeMapping != null) {
            this.seiToPortTypeMapping.clear();
            this.seiToPortTypeMapping = null;
        }
        if (this.namespaceToPackageMapping != null) {
            this.namespaceToPackageMapping.clear();
            this.namespaceToPackageMapping = null;
        }
        if (this.globalHandlers != null) {
            this.globalHandlers.clear();
            this.globalHandlers = null;
        }
        if (this.portHandlers != null) {
            iterator = this.portHandlers.values().iterator();
            while (iterator.hasNext()) {
                object = (List)iterator.next();
                if (object == null) continue;
                object.clear();
            }
            this.portHandlers.clear();
            this.portHandlers = null;
        }
        if (this.clientPorts != null) {
            iterator = this.clientPorts.values().iterator();
            while (iterator.hasNext()) {
                object = (ClientPortMetaData)iterator.next();
                if (object == null) continue;
                ((ClientPortMetaData)object).destroy();
            }
            this.clientPorts.clear();
            this.clientPorts = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName qName) {
        this.qName = qName;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String string) {
        this.serviceInterface = string.intern();
    }

    public LoadStrategy getLoadStrategy() {
        return this.parent.getLoadStrategy();
    }

    protected ClassLoader getClassLoader() {
        return this.parent.getClassLoader();
    }

    public String getWsdlFileName() {
        return this.wsdlFileName;
    }

    public Definition getWsdlDoc() {
        if (!this.wsdlDocLoaded) {
            this.loadWsdlFile(this.getWsdlFileName());
        }
        return this.wsdlDoc;
    }

    private Service getWsdlServiceElement() {
        Definition definition;
        if (this.wsdlServiceElement == null && (definition = this.getWsdlDoc()) != null) {
            this.wsdlServiceElement = definition.getService(this.getQName());
            if (this.wsdlServiceElement == null) {
                String string = "no.wsdl.services.for.qname";
                Object[] objectArray = new Object[]{this.getQName()};
                Tr.error((TraceComponent)_tc, (String)string, (Object)objectArray);
                throw new RuntimeException(nls.getFormattedMessage(string, objectArray, null));
            }
        }
        return this.wsdlServiceElement;
    }

    public String[] getWsdlPortNames() {
        Service service;
        if (this.wsdlPortNames == null && (service = this.getWsdlServiceElement()) != null && service.getPorts() != null) {
            Object[] objectArray = service.getPorts().values().toArray();
            this.wsdlPortNames = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.wsdlPortNames[i] = ((Port)objectArray[i]).getName();
            }
        }
        return this.wsdlPortNames;
    }

    public Map getDefaultPortMapping() {
        if (this.defaultPortMapping != null && !this.cleanedPortMapping) {
            this.defaultPortMapping = this.cleanDefaultPortMappingInformation(this.defaultPortMapping);
        }
        return this.defaultPortMapping;
    }

    public void setDefaultPortMapping(Map map) {
        this.defaultPortMapping = map;
    }

    public void setWsdlFileName(String string) {
        this.wsdlFileName = string.intern();
        this.wsdlDocLoaded = false;
        this.wsdlDoc = null;
        this.wsdlServiceElement = null;
        this.wsdlPortNames = null;
        this.defaultPortMapping = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWsdlFile(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"loadWsdlFile");
        }
        try {
            this.wsdlDocLoaded = true;
            this.wsdlDoc = null;
            if (string != null) {
                LoadStrategy loadStrategy;
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Loading WSDL file \"" + string + "\""));
                }
                if (!(loadStrategy = this.getLoadStrategy()).contains(string)) {
                    RuntimeException runtimeException = new RuntimeException("WSDL File not in EAR " + string);
                    Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)runtimeException);
                    throw runtimeException;
                }
                InputStream inputStream = null;
                try {
                    inputStream = loadStrategy.getResourceInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.webservices.metadata.ClientServiceMetaData.loadWsdlFile", (String)"338", (Object)this);
                    Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)fileNotFoundException);
                    throw new RuntimeException("Caught FileNotFoundException reading wsdl file from EAR " + fileNotFoundException);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.metadata.ClientServiceMetaData.loadWsdlFile", (String)"343", (Object)this);
                    Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)iOException);
                    throw new RuntimeException("Caught IOException reading wsdl file from EAR " + iOException);
                }
                try {
                    ServiceProviderManager serviceProviderManager = new ServiceProviderManager(null);
                    WSDLReader wSDLReader = serviceProviderManager.getWSDLFactory().newWSDLReader();
                    wSDLReader.setFeature("javax.wsdl.verbose", false);
                    this.wsdlDoc = wSDLReader.readWSDL((WSDLLocator)new ModuleWSDLLocator(string, inputStream, loadStrategy));
                }
                catch (WSDLException wSDLException) {
                    FFDCFilter.processException((Throwable)wSDLException, (String)"com.ibm.ws.webservices.metadata.ClientServiceMetaData.loadWsdlFile", (String)"357", (Object)this);
                    Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)((Object)wSDLException));
                    throw new RuntimeException("Caught WSDLException " + (Object)((Object)wSDLException));
                }
                if (this.wsdlDoc != null) {
                    this.wsdlTargetNamespace = this.wsdlDoc.getTargetNamespace();
                    if (this.getQName() == null) {
                        this.setQName(this.getFirstWSDLServiceQName());
                    }
                }
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"loadWsdlFile");
            }
            throw throwable;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"loadWsdlFile");
        }
    }

    private ClientPortMetaData getPort(String string, boolean bl) {
        ClientPortMetaData clientPortMetaData = (ClientPortMetaData)this.clientPorts.get(string);
        if (clientPortMetaData == null && bl) {
            clientPortMetaData = new ClientPortMetaData(string, this);
            this.clientPorts.put(string, clientPortMetaData);
            List list = (List)this.portHandlers.get(string);
            if (list != null) {
                clientPortMetaData.addHandlers(list);
                this.portHandlers.remove(string);
            } else {
                clientPortMetaData.addHandlers(this.globalHandlers);
            }
        }
        return clientPortMetaData;
    }

    public Collection getPorts() {
        return this.clientPorts.values();
    }

    public String getJaxrpcMappingFileName() {
        return this.jaxrpcMappingFileName;
    }

    public Map getNamespaceToPackageMapping() {
        if (!this.mappingMetaDataLoaded) {
            this.loadMappingMetaData(this.getJaxrpcMappingFileName());
        }
        return this.namespaceToPackageMapping;
    }

    public Map getSeiToPortTypeMapping() {
        if (!this.mappingMetaDataLoaded) {
            this.loadMappingMetaData(this.getJaxrpcMappingFileName());
        }
        return this.seiToPortTypeMapping;
    }

    public void setJaxrpcMappingFileName(String string) {
        this.jaxrpcMappingFileName = string;
        this.namespaceToPackageMapping = null;
        this.seiToPortTypeMapping = null;
        this.mappingMetaDataLoaded = false;
    }

    private void loadMappingMetaData(String string) {
        this.mappingMetaDataLoaded = true;
        this.namespaceToPackageMapping = null;
        this.seiToPortTypeMapping = null;
        if (string != null) {
            MappingMetaData mappingMetaData = null;
            try {
                mappingMetaData = WSModels.getJavaWSDLMapping(this.getLoadStrategy(), string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.client.ClientServiceMetaData.loadMappingMetaData", (String)"461", (Object)this);
                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)exception);
                throw new RuntimeException("Caught Exception " + exception);
            }
            if (mappingMetaData == null) {
                Tr.error((TraceComponent)_tc, (String)"client.mappingFile.not.found", (Object)new Object[]{string, this.getName()});
                throw new RuntimeException("Unable to read Client JAX-RPC mapping file");
            }
            this.namespaceToPackageMapping = mappingMetaData.getPackageMappings();
            this.seiToPortTypeMapping = mappingMetaData.getSEIMappings();
        }
    }

    public Map getOverriddingEndpointURIs() {
        return this.overriddingEndpointURIs;
    }

    public void setOverriddingEndpointURIs(Map map) {
        this.overriddingEndpointURIs = map;
    }

    private static Map getOverriddingEndpointURIsInformation(ServiceRef serviceRef) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getOverriddingEndpointURIsInformation");
        }
        HashMap<String, String> hashMap = null;
        if (serviceRef != null && serviceRef.getPortQnameBindings().size() > 0) {
            hashMap = new HashMap<String, String>();
            EList eList = serviceRef.getPortQnameBindings();
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                PortQnameBinding portQnameBinding = (PortQnameBinding)eList.get(i);
                String string = portQnameBinding.getPortQnameLocalNameLink();
                String string2 = portQnameBinding.getOverriddenEndpointURI();
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("portQnameLocal = " + string + " and overrddenEndpoint = " + string2));
                }
                if (string == null || string2 == null) continue;
                hashMap.put(string, string2);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getOverriddingEndpointURIsInformation");
        }
        return hashMap;
    }

    public Map getOverriddingBindingNamespaces() {
        return this.overriddingBindingNamespaces;
    }

    public void setOverriddingBindingNamespaces(Map map) {
        this.overriddingBindingNamespaces = map;
    }

    private static Map getOverriddingBindingNamespacesInformation(ServiceRef serviceRef) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getOverriddingBindingNamespacesInformation");
        }
        HashMap<String, String> hashMap = null;
        if (serviceRef != null && serviceRef.getPortQnameBindings().size() > 0) {
            hashMap = new HashMap<String, String>();
            EList eList = serviceRef.getPortQnameBindings();
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                PortQnameBinding portQnameBinding = (PortQnameBinding)eList.get(i);
                String string = portQnameBinding.getPortQnameLocalNameLink();
                String string2 = portQnameBinding.getOverriddenBindingNamespace();
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("portQnameLocal = " + string + " and overrdden binding namespace = " + string2));
                }
                if (string == null || string2 == null) continue;
                hashMap.put(string, string2);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getOverriddingBindingNamespacesInformation");
        }
        return hashMap;
    }

    private QName getFirstWSDLServiceQName() {
        QName qName = null;
        Map map = this.wsdlDoc.getServices();
        Collection collection = map.values();
        Object[] objectArray = collection.toArray();
        if (objectArray != null && objectArray.length == 1) {
            qName = ((Service)objectArray[0]).getQName();
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"No ServiceQName in 109 DD.  Using first service in WSDL file as default. Note there should only be one.");
            }
        } else {
            if (objectArray != null && objectArray.length > 1) {
                Tr.error((TraceComponent)_tc, (String)"client.invalid.wsdlservice.specification.noqname", (Object)new Object[]{this.getName()});
                throw new RuntimeException("Invalid WSDL Service specification in Client DD");
            }
            Tr.error((TraceComponent)_tc, (String)"client.invalid.wsdlservice.specification.noservices", (Object)new Object[]{this.getName()});
            throw new RuntimeException("No WSDL Services");
        }
        return qName;
    }

    private Map cleanDefaultPortMappingInformation(Map map) {
        Service service;
        HashMap<QName, QName> hashMap = null;
        if (map != null && map.size() > 0 && (service = this.getWsdlServiceElement()) != null) {
            hashMap = new HashMap<QName, QName>();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Object[] objectArray;
                Map.Entry entry = iterator.next();
                QName qName = (QName)entry.getKey();
                QName qName2 = (QName)entry.getValue();
                boolean bl = false;
                Object v = service.getPorts().get(qName2.getLocalPart());
                if (v != null && service.getQName().getNamespaceURI().equals(qName2.getNamespaceURI())) {
                    objectArray = (Object[])v;
                    bl = qName.equals(objectArray.getBinding().getPortType().getQName());
                }
                if (bl) {
                    hashMap.put(qName, qName2);
                    continue;
                }
                objectArray = new Object[]{this.getName(), qName.getLocalPart(), qName.getNamespaceURI(), qName2.getLocalPart(), qName2.getNamespaceURI()};
                Tr.warning((TraceComponent)_tc, (String)"invalid.defaultport.information", (Object)objectArray);
            }
        }
        return hashMap;
    }

    public void addGlobalHandler(Handler handler2) {
        Object object;
        this.globalHandlers.add(handler2);
        Iterator iterator = this.clientPorts.values().iterator();
        while (iterator.hasNext()) {
            object = (ClientPortMetaData)iterator.next();
            ((ClientPortMetaData)object).addHandler(handler2);
        }
        iterator = this.portHandlers.values().iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            object.add(handler2);
        }
    }

    public void addHandlers(EList eList) {
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            Handler handler2 = (Handler)eList.get(i);
            int n2 = handler2.getPortNames().size();
            if (n2 == 0) {
                this.addGlobalHandler(handler2);
                continue;
            }
            for (int j = 0; j < n2; ++j) {
                String string = (String)handler2.getPortNames().get(j);
                ClientPortMetaData clientPortMetaData = this.getPort(string, false);
                if (clientPortMetaData != null) {
                    clientPortMetaData.addHandler(handler2);
                    continue;
                }
                ArrayList<Handler> arrayList = (ArrayList<Handler>)this.portHandlers.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Handler>();
                    this.portHandlers.put(string, arrayList);
                    arrayList.addAll(this.globalHandlers);
                }
                arrayList.add(handler2);
            }
        }
    }

    public void bind(Context context) throws NamingException {
        if (!this.jndiBound) {
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("binding service-ref \"" + this.getName() + "\" to " + (this.parent.getName() == null ? "module" : "compenent " + this.parent.getName()) + " @ " + context));
                }
                JndiHelper.recursiveRebind((Context)context, (String)this.getName(), (Object)this);
                this.jndiBound = true;
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webservices.client.ClientServiceMetaData.bind", (String)"674", (Object)this);
                Tr.error((TraceComponent)_tc, (String)"error.binding.service.ref.named", (Object)new Object[]{"!!", this.getName(), "comp/env"});
                throw namingException;
            }
        }
    }

    static String getServiceName(Reference reference) {
        String string = (String)reference.get(REFSERVICENAME).getContent();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("refServiceName: on java:comp lookup is " + string));
        }
        return string;
    }

    public Reference getReference() throws NamingException {
        CacheableReference cacheableReference = new CacheableReference(this.getClass().getName(), ObjectFactoryImpl.class.getName(), null);
        cacheableReference.add(new StringRefAddr(VERSION, VERSION_ID));
        cacheableReference.add(new StringRefAddr(REFSERVICENAME, this.getName()));
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("getReference(" + this.getName() + ") == " + JavaUtils.getObjectIdentity(cacheableReference)));
        }
        return cacheableReference;
    }

    public static Context getJavaColonCompEnvContext(Context context) throws NamingException {
        Context context2 = null;
        try {
            context2 = (Context)context.lookup("comp/env");
            if (context2 == null) {
                context2 = JndiHelper.recursiveCreateSubcontext((Context)context, (String)"comp/env");
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webservices.client.ClientServiceMetaData.getJavaColonCompEnvContext", (String)"743");
            Tr.error((TraceComponent)_tc, (String)"error.binding.service.refs.in.ns", (Object)new Object[]{"!!", "comp/env"});
            throw namingException;
        }
        return context2;
    }

    public void extendServiceRef(ServiceRef serviceRef, com.ibm.etools.webservice.wscext.ServiceRef serviceRef2) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, ConfigurationError {
        if (this.globalHandlers.size() > 0 || serviceRef != null) {
            int n;
            if (serviceRef != null && serviceRef.getDeployedWSDLFile() != null) {
                this.setWsdlFileName(serviceRef.getDeployedWSDLFile());
            }
            this.setDefaultPortMapping(ClientServiceMetaData.getDefaultPortMappingInformation(serviceRef));
            this.setOverriddingEndpointURIs(ClientServiceMetaData.getOverriddingEndpointURIsInformation(serviceRef));
            this.setOverriddingBindingNamespaces(ClientServiceMetaData.getOverriddingBindingNamespacesInformation(serviceRef));
            String[] stringArray = this.getWsdlPortNames();
            if (stringArray == null || stringArray.length == 0) {
                stringArray = null;
                n = 1;
            } else {
                n = stringArray.length;
            }
            for (int i = 0; i < n; ++i) {
                String string = stringArray == null ? null : stringArray[i];
                WSDDPort wSDDPort = this.getPort(string, true).getWsddPort();
                if (this.wsdlTargetNamespace != null) {
                    wSDDPort.setWSDLPort(QNameTable.createQName(this.wsdlTargetNamespace, string));
                }
                ClientServiceMetaData.addSyncTimeoutToWSDDPort(string, wSDDPort, serviceRef);
                ClientServiceMetaData.addTransportPropertiesToWSDDPort(string, wSDDPort, serviceRef);
                SecurityHooks.addWSSecurityConfigurationToWSDDPort(wSDDPort, string, serviceRef, serviceRef2, this.getClassLoader());
                if (!_tc.isDebugEnabled()) continue;
                ClientServiceMetaData.dumpPort(wSDDPort);
            }
        }
    }

    private static Map getDefaultPortMappingInformation(ServiceRef serviceRef) {
        HashMap<QName, QName> hashMap = null;
        if (serviceRef != null && serviceRef.getDefaultMappings().size() > 0) {
            hashMap = new HashMap<QName, QName>();
            EList eList = serviceRef.getDefaultMappings();
            for (int i = 0; i < eList.size(); ++i) {
                DefaultMapping defaultMapping = (DefaultMapping)eList.get(i);
                QName qName = QNameTable.createQName(defaultMapping.getPortTypeNamespace(), defaultMapping.getPortTypeLocalName());
                QName qName2 = QNameTable.createQName(defaultMapping.getPortNamespace(), defaultMapping.getPortLocalName());
                hashMap.put(qName, qName2);
            }
        }
        return hashMap;
    }

    private static void addSyncTimeoutToWSDDPort(String string, WSDDPort wSDDPort, ServiceRef serviceRef) {
        String string2 = "300";
        if (string != null && serviceRef != null) {
            int n = serviceRef.getPortQnameBindings().size();
            for (int i = 0; i < n; ++i) {
                PortQnameBinding portQnameBinding = (PortQnameBinding)serviceRef.getPortQnameBindings().get(i);
                String string3 = portQnameBinding.getPortQnameLocalNameLink();
                if (string3 == null || !string3.equals(string)) continue;
                String string4 = portQnameBinding.getSyncTimeout();
                if (string4 == null) break;
                string2 = string4;
                break;
            }
        }
        wSDDPort.setObject("SyncTimeout", string2);
    }

    private static void addTransportPropertiesToWSDDPort(String string, WSDDPort wSDDPort, ServiceRef serviceRef) {
        block13: {
            Object object;
            PortQnameBinding portQnameBinding;
            Iterator iterator;
            String string2;
            String string3;
            String string4;
            block15: {
                String string5;
                int n;
                block14: {
                    if (serviceRef == null) break block13;
                    n = serviceRef.getPortQnameBindings().size();
                    string4 = null;
                    string3 = null;
                    string2 = null;
                    string5 = null;
                    iterator = null;
                    if (string != null && string.length() != 0) break block14;
                    portQnameBinding = (PortQnameBinding)serviceRef.getPortQnameBindings().get(0);
                    if (portQnameBinding == null) break block15;
                    if (portQnameBinding.getBasicAuth() != null) {
                        string4 = portQnameBinding.getBasicAuth().getUserid();
                        string3 = portQnameBinding.getBasicAuth().getPassword();
                    }
                    if (portQnameBinding.getSslConfig() != null) {
                        string2 = portQnameBinding.getSslConfig().getName();
                    }
                    if (portQnameBinding.getParameters() != null && portQnameBinding.getParameters().size() > 0) {
                        iterator = portQnameBinding.getParameters().iterator();
                    }
                    break block15;
                }
                for (int i = 0; i < n; ++i) {
                    object = (PortQnameBinding)serviceRef.getPortQnameBindings().get(i);
                    string5 = object != null ? object.getPortQnameLocalNameLink() : null;
                    if (string5 == null || !string5.equals(string)) continue;
                    if (object.getBasicAuth() != null) {
                        string4 = object.getBasicAuth().getUserid();
                        string3 = object.getBasicAuth().getPassword();
                    }
                    if (object.getSslConfig() != null) {
                        string2 = object.getSslConfig().getName();
                    }
                    if (object.getParameters() == null || object.getParameters().size() <= 0) break;
                    iterator = object.getParameters().iterator();
                    break;
                }
            }
            if (JavaUtils.hasValue(string4)) {
                wSDDPort.setObject("javax.xml.rpc.security.auth.username", string4);
            }
            if (JavaUtils.hasValue(string3)) {
                wSDDPort.setObject("javax.xml.rpc.security.auth.password", string3);
            }
            if (JavaUtils.hasValue(string2)) {
                wSDDPort.setObject("ssl.configName", string2);
            }
            if (iterator != null) {
                portQnameBinding = null;
                while (iterator.hasNext()) {
                    portQnameBinding = (Parameter)iterator.next();
                    if (portQnameBinding.getName().indexOf(":") != -1 && portQnameBinding.getValue().indexOf(":") != -1) {
                        object = new StringTokenizer(portQnameBinding.getName(), ":");
                        StringTokenizer stringTokenizer = new StringTokenizer(portQnameBinding.getValue(), ":");
                        for (int i = 0; i < ((StringTokenizer)object).countTokens() - 1; ++i) {
                            wSDDPort.setObject(((StringTokenizer)object).nextToken(), stringTokenizer.nextToken());
                        }
                        break;
                    }
                    wSDDPort.setObject(portQnameBinding.getName(), portQnameBinding.getValue());
                }
            }
        }
    }

    private static void dumpPort(WSDDPort wSDDPort) {
        try {
            StringWriter stringWriter = new StringWriter();
            SerializationContextImpl serializationContextImpl = new SerializationContextImpl(stringWriter, null);
            serializationContextImpl.getSerializationWriter().setPretty(true);
            wSDDPort.writeToContext(serializationContextImpl);
            stringWriter.close();
            Document document = XMLUtils.newDocument(new InputSource(new StringReader(stringWriter.getBuffer().toString())));
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("config is \n" + XMLUtils.DocumentToString(document)));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.client.ClientServiceMetaData.dumpPort", (String)"965", null);
            Tr.warning((TraceComponent)_tc, (String)"dumpService.failed", (Object)exception);
        }
    }
}

