/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.handlers;

import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import org.apache.commons.logging.Log;

class MessagePMIContext {
    protected static Log log = LogFactory.getLog(MessagePMIContext.class.getName());
    public static final String propertyName = MessagePMIContext.class.getName();
    private final WebServicesPerf.ServicePerf pmiServiceModule;
    private final WebServicesPerf wsPerf;
    private long receivedRequestTime = 0L;
    private long sentRequestTime = 0L;
    private long receivedReplyTime = 0L;
    private long sentReplyTime = 0L;
    private final long STATE_RECEIVE_REQUEST = 0L;
    private final long STATE_SEND_REQUEST = 1L;
    private final long STATE_RECEIVE_REPLY = 2L;
    private final long STATE_SEND_REPLY = 3L;
    private final long STATE_DONE = 4L;
    private final long NO_TIME = -1L;
    private long next_state = 0L;

    MessagePMIContext(MessageContext messageContext, WebServicesPerf webServicesPerf, String string) {
        this.wsPerf = webServicesPerf;
        this.pmiServiceModule = this.wsPerf.getService(string);
    }

    void onServerReceiveRequest() {
        this.receivedRequestTime = this.doRequestResponseTime() || this.doResponseTime() ? System.currentTimeMillis() : 0L;
        if (this.doReceivedRequestCount()) {
            this.pmiServiceModule.onServerReceiveRequest();
        }
        this.next_state = 1L;
    }

    void onServerForwardRequestToPort() {
        if (this.doRequestResponseTime() || this.doDispatchResponseTime()) {
            this.sentRequestTime = System.currentTimeMillis();
            if (this.doRequestResponseTime()) {
                this.pmiServiceModule.onServerForwardRequestToPort(this.sentRequestTime - this.receivedRequestTime);
            } else {
                this.pmiServiceModule.onServerForwardRequestToPort(-1L);
            }
        } else {
            this.sentRequestTime = 0L;
            this.pmiServiceModule.onServerForwardRequestToPort(-1L);
        }
        this.next_state = 2L;
    }

    void onServerReceiveReplyFromPort() {
        if (this.doDispatchResponseTime() || this.doReplyResponseTime()) {
            this.receivedReplyTime = System.currentTimeMillis();
            if (this.doDispatchResponseTime()) {
                this.pmiServiceModule.onServerReceiveReplyFromPort(this.receivedReplyTime - this.sentRequestTime);
            }
        } else {
            this.receivedReplyTime = 0L;
        }
        this.next_state = 3L;
    }

    void onServerReturnReply(MessageContext messageContext) {
        this.sentReplyTime = this.doReplyResponseTime() || this.doResponseTime() ? System.currentTimeMillis() : 0L;
        long l = this.getRequestLength(messageContext, "requestMessageMissing00");
        long l2 = this.getResponseLength(messageContext, "responseMessageMissing00");
        this.pmiServiceModule.onServerReturnReply(this.doProcessedRequestCount(), l, l2, this.receivedReplyTime > 0L ? this.sentReplyTime - this.receivedReplyTime : -1L, this.sentReplyTime > 0L ? this.sentReplyTime - this.receivedRequestTime : -1L);
        this.next_state = 4L;
    }

    void close(MessageContext messageContext, String string) {
        this.sentReplyTime = this.doReplyResponseTime() || this.doResponseTime() ? System.currentTimeMillis() : 0L;
        if (this.next_state == 3L && messageContext != null && messageContext.isOneWay()) {
            long l = this.getRequestLength(messageContext, "requestMessageMissing00");
            this.pmiServiceModule.onServerReturnReply(this.doProcessedRequestCount(), l, -1L, -1L, this.sentReplyTime - this.receivedRequestTime);
        } else if (this.next_state != 4L) {
            long l = this.getRequestLength(messageContext, "requestMessageMissing00");
            long l2 = this.getResponseLength(messageContext, string);
            this.pmiServiceModule.onServerReturnReply(false, l, l2, this.receivedReplyTime > 0L ? this.sentReplyTime - this.receivedReplyTime : -1L, this.sentReplyTime - this.receivedRequestTime);
        }
        this.next_state = 4L;
    }

    private long getRequestLength(MessageContext messageContext, String string) {
        long l;
        if (this.doPayloadSize() || this.doRequestPayloadSize()) {
            if (messageContext == null || messageContext.getRequestMessage() == null) {
                l = -1L;
                if (string != null) {
                    log.error((Object)Messages.getMessage(string));
                }
            } else {
                Message message = messageContext.getRequestMessage();
                try {
                    boolean bl = messageContext.getPastPivot();
                    messageContext.setPastPivot(false);
                    l = message.getOriginalContentLength();
                    if (bl) {
                        messageContext.setPastPivot(bl);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    log.debug((Object)"Unable to determine message length.", (Throwable)webServicesFault);
                    l = -1L;
                }
            }
        } else {
            l = 0L;
        }
        return l;
    }

    private long getResponseLength(MessageContext messageContext, String string) {
        long l;
        if (this.doPayloadSize() || this.doReplyPayloadSize()) {
            if (messageContext == null || messageContext.getResponseMessage() == null) {
                l = -1L;
                if (string != null) {
                    log.error((Object)Messages.getMessage(string));
                }
            } else {
                Message message = messageContext.getResponseMessage();
                try {
                    l = message.getContentLength();
                }
                catch (WebServicesFault webServicesFault) {
                    log.debug((Object)"Unable to determine message length.", (Throwable)webServicesFault);
                    l = -1L;
                }
            }
        } else {
            l = 0L;
        }
        return l;
    }

    public final boolean doResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(14);
    }

    public final boolean doRequestResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(15);
    }

    public final boolean doDispatchResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(16);
    }

    public final boolean doReplyResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(17);
    }

    public final boolean doPayloadSize() {
        return this.pmiServiceModule.isStatisticEnabled(18);
    }

    public final boolean doRequestPayloadSize() {
        return this.pmiServiceModule.isStatisticEnabled(19);
    }

    public final boolean doReplyPayloadSize() {
        return this.pmiServiceModule.isStatisticEnabled(20);
    }

    public final boolean doReceivedRequestCount() {
        return this.pmiServiceModule.isStatisticEnabled(11);
    }

    public final boolean doDispatchedRequestCount() {
        return this.pmiServiceModule.isStatisticEnabled(12);
    }

    public final boolean doProcessedRequestCount() {
        return this.pmiServiceModule.isStatisticEnabled(13);
    }
}

