/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.enum.MessageType;
import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.builders.RequestResponseProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPBodyBuilder
extends SOAPBuilder {
    protected static Log log = LogFactory.getLog(SOAPBodyBuilder.class.getName());
    private boolean streaming = false;
    private boolean processingFault = false;

    public void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        QName qName;
        List list;
        super.startElement(string, string2, string3, attributes, mappingScope, deserializationContext);
        MessageContext messageContext = deserializationContext.getMessageContext();
        if (messageContext != null && (list = MCUtils.getLazyParseQNames(messageContext)) != null && list.contains(qName = QNameTable.createQName(string, string2))) {
            try {
                InputStream inputStream = deserializationContext.getLazyParse();
                if (inputStream != null) {
                    WebServicesInputSource webServicesInputSource = WebServicesInputSource.create(inputStream);
                    if (messageContext.getCurrentMessage() != null) {
                        String string4 = messageContext.getCurrentMessage().getCharacterEncoding();
                        webServicesInputSource.setEncoding(string4);
                    }
                    this.myElement.setAlternateContent(XMLInputSourceAlternateContent.createContentOnly(webServicesInputSource));
                }
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.startElement", (String)"178", (Object)this);
                throw new SAXException((Exception)((Object)sOAPException));
            }
        }
        deserializationContext.setSimpleEventOptimization(false);
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        boolean bl;
        boolean bl2;
        this.myChildElement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SOAPBodyBuilder::onStartChild() " + string + " " + string2));
        }
        QName qName = QNameTable.createQName(string, string2);
        MessageContext messageContext = deserializationContext.getMessageContext();
        Message message = null;
        if (messageContext != null) {
            message = messageContext.getCurrentMessage();
        }
        boolean bl3 = messageContext != null && messageContext.getPastPivot() || message != null && MessageType.RESPONSE == message.getMessageType();
        boolean bl4 = true;
        String string4 = attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "root");
        if (string4 != null && string4.equals("0")) {
            bl4 = false;
        }
        boolean bl5 = bl2 = this.streaming || messageContext != null && !messageContext.isHighFidelity() && (messageContext.isClient() && bl3 || messageContext.isServer() && !bl3);
        if (messageContext != null && messageContext.getMessage() != null) {
            boolean bl6 = bl2 = bl2 && messageContext.getMessage().countAttachments() == 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("HighFidelity is:" + (messageContext != null && messageContext.isHighFidelity())));
            log.debug((Object)("tryStreaming is:" + bl2));
        }
        OperationDesc[] operationDescArray = null;
        try {
            if (messageContext != null && messageContext.getOperation() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operation found in MessageContext:" + messageContext.getOperation().toString()));
                }
                operationDescArray = new OperationDesc[]{messageContext.getOperation()};
            }
            if (bl2 && operationDescArray == null && (operationDescArray = RequestResponse.getPossibleOperationsByQName(qName, messageContext)) != null && operationDescArray.length == 1) {
                messageContext.setOperation(operationDescArray[0]);
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.onStartChild", (String)"262", (Object)this);
            throw new SAXException(webServicesFault);
        }
        boolean bl7 = bl = operationDescArray != null && operationDescArray.length == 1 && RequestResponse.isNoDataBindingOperation(operationDescArray[0]);
        if (bl2) {
            boolean bl8;
            boolean bl9 = bl8 = operationDescArray != null && operationDescArray.length == 1 && operationDescArray[0].getName() != null && (!bl3 && operationDescArray[0].getNumInParams(false) == 0 || bl3 && operationDescArray[0].getNumOutParams(false) == 0);
            if (!bl8) {
                bl2 = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("tryStreaming is change to:" + bl2));
                }
            }
        }
        try {
            if (string2.equals("Fault") && string.equals(this.myElement.getNamespaceURI())) {
                deserializationContext.setSimpleEventOptimization(true);
                this.processingFault = true;
                SOAPFaultBuilder sOAPFaultBuilder = new SOAPFaultBuilder();
                this.myChildElement = this.myElement.getSOAPFactory().createSOAPFault(string3, attributes, mappingScope, deserializationContext, (SOAPBody)this.myElement);
                sOAPFaultBuilder.setMyElement(this.myChildElement);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: SOAPBodyBuilder::onStartChild() case: SOAPFault");
                }
                return sOAPFaultBuilder;
            }
            if (bl4 && ((SOAPBody)this.myElement).getRequestResponse() == null && !bl && !this.myElement.isInAsSOAPElement() && bl2) {
                this.streaming = true;
                RequestResponse requestResponse = new RequestResponse(string, string2, (SOAPBody)this.myElement, bl3, operationDescArray, deserializationContext);
                requestResponse.setNeedDeser(false);
                RequestResponseProcessor requestResponseProcessor = new RequestResponseProcessor(requestResponse, bl3);
                requestResponseProcessor.setOperation(operationDescArray[0]);
                messageContext.setOperation(operationDescArray[0]);
                Style style = operationDescArray[0].getStyle();
                if (style != Style.DOCUMENT) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exit: SOAPBodyBuilder::onStartChild() case: normal streaming");
                    }
                    return requestResponseProcessor;
                }
                deserializationContext.getEventConverter().popDEventProcessor();
                deserializationContext.getEventConverter().pushDEventProcessor(requestResponseProcessor);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: SOAPBodyBuilder::onStartChild() case: pure doc/lit streaming");
                }
                return requestResponseProcessor.onStartChild(string, string2, string3, attributes, mappingScope, deserializationContext);
            }
            if (this.streaming) {
                Deserializer deserializer;
                deserializationContext.setSimpleEventOptimization(true);
                String string5 = AttributeUtils.getID(attributes);
                if (string5 != null && (deserializer = deserializationContext.getHrefTable().unregisterFixupByID(string5)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exit: SOAPBodyBuilder::onStartChild() case: streaming multi-ref");
                    }
                    return deserializer;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: SOAPBodyBuilder::onStartChild() case: streaming multi-ref possible error");
                }
                return new DefaultDeserializer();
            }
            this.myChildElement = this.myElement.getSOAPFactory().createSOAPBodyElement(string, string2, string3, attributes, mappingScope, deserializationContext, (SOAPBody)this.myElement);
            if (bl4 && ((SOAPBody)this.myElement).getRequestResponse() == null) {
                RequestResponse requestResponse = new RequestResponse(string, string2, (SOAPBody)this.myElement, bl3, operationDescArray, deserializationContext);
            }
            SOAPBuilder sOAPBuilder = new SOAPBuilder();
            sOAPBuilder.setMyElement(this.myChildElement);
            if (bl) {
                int n = operationDescArray == null || operationDescArray[0].getStyle() == Style.DOCUMENT ? 1 : 2;
                sOAPBuilder.setLazyParseLevel(n);
            } else {
                deserializationContext.setSimpleEventOptimization(true);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SOAPBodyBuilder::onStartChild() case: normal nonstreaming path");
            }
            return sOAPBuilder;
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.onStartChild", (String)"418", (Object)this);
            throw new SAXException((Exception)((Object)sOAPException));
        }
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (this.myElement.getAlternateContent() != null || ((SOAPBody)this.myElement).getRequestResponse() != null) {
            return;
        }
        MessageContext messageContext = deserializationContext.getMessageContext();
        Message message = null;
        SOAPPort sOAPPort = null;
        SOAPBody sOAPBody = (SOAPBody)this.myElement;
        RequestResponse requestResponse = null;
        if (messageContext != null) {
            sOAPPort = messageContext.getPort();
            message = messageContext.getCurrentMessage();
            try {
                if (sOAPBody.getRequestResponse() == null && !this.containsChild) {
                    OperationDesc operationDesc;
                    boolean bl = messageContext != null && messageContext.getPastPivot() || message != null && MessageType.RESPONSE == message.getMessageType();
                    String string3 = "";
                    String string4 = "empty";
                    OperationDesc[] operationDescArray = null;
                    if (messageContext != null && messageContext.getOperation() != null && (operationDesc = messageContext.getOperation()) != null) {
                        operationDescArray = new OperationDesc[]{operationDesc};
                        string3 = operationDesc.getElementQName().getNamespaceURI();
                        string4 = operationDesc.getElementQName().getLocalPart();
                    }
                    requestResponse = new RequestResponse(string3, string4, (SOAPBody)this.myElement, bl, operationDescArray, deserializationContext);
                }
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.endElement", (String)"520", (Object)this);
                throw new SAXException((Exception)((Object)sOAPException));
            }
        }
    }

    public void characters(String string) throws SAXException {
        if (XMLUtils.isXMLWhitespace(string)) {
            if (this.streaming) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Enter: SOAPBodyBuilder::characters() discarding whitespace (" + string + ")"));
                }
            } else {
                super.characters(string);
            }
        } else {
            throw new SAXException(Messages.getMessage("nonWSDetected00", string, this.myElement.getQName().toString()));
        }
    }
}

