/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.util.HashMap;

public final class HrefTable {
    protected HashMap hrefMap = null;
    protected HashMap fixupMap = null;
    protected DeserializationContext context;

    public HrefTable(DeserializationContext deserializationContext) {
        this.context = deserializationContext;
    }

    public SOAPElement getElementByHref(String string) {
        Object v;
        if (string == null) {
            return null;
        }
        if (this.hrefMap != null && (v = this.hrefMap.get(string)) instanceof SOAPElement) {
            return (SOAPElement)v;
        }
        return null;
    }

    public Object getObjectByHref(String string) {
        Attachments attachments;
        Object object;
        if (string == null) {
            return null;
        }
        if (this.hrefMap != null && (object = this.hrefMap.get(string)) != null) {
            return object;
        }
        if (!string.startsWith("#") && (object = this.context.getMessageContext().getCurrentMessage()) != null && (attachments = ((Message)object).getAttachmentsImpl()) != null) {
            try {
                return attachments.getAttachmentByReference(string);
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.utils.HrefTable.getObjectByHref", (String)"117", (Object)this);
                throw new RuntimeException(webServicesFault.toString() + JavaUtils.stackToString(webServicesFault));
            }
        }
        return null;
    }

    public void addObjectByID(String string, Object object) {
        if (string == null) {
            return;
        }
        if (this.hrefMap == null) {
            this.hrefMap = new HashMap();
        }
        String string2 = '#' + string;
        this.hrefMap.put(string2, object);
    }

    public void registerFixupByHref(String string, Deserializer deserializer) {
        Deserializer deserializer2;
        if (this.fixupMap == null) {
            this.fixupMap = new HashMap();
        }
        if ((deserializer2 = this.fixupMap.put(string, deserializer)) != null && deserializer2 != deserializer) {
            deserializer.moveValueTargets(deserializer2);
            if (deserializer.getDefaultType() == null) {
                deserializer.setDefaultType(deserializer2.getDefaultType());
            }
        }
    }

    public Deserializer unregisterFixupByID(String string) {
        if (string == null) {
            return null;
        }
        if (this.fixupMap != null) {
            String string2 = '#' + string;
            return (Deserializer)this.fixupMap.remove(string2);
        }
        return null;
    }
}

