/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Admin {
    protected static Log log = LogFactory.getLog(Admin.class.getName());

    public Element[] AdminService(Element[] elementArray) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Admin::AdminService");
        }
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        Document document = this.process(messageContext, elementArray[0]);
        Element[] elementArray2 = new Element[]{document.getDocumentElement()};
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Admin::AdminService");
        }
        return elementArray2;
    }

    protected static Document processWSDD(MessageContext messageContext, WebServicesEngine webServicesEngine, Element element) throws Exception {
        Document document = null;
        String string = element.getLocalName();
        if (string.equals("quit")) {
            log.error((Object)Messages.getMessage("quitRequest00"));
            if (messageContext != null) {
                messageContext.setProperty(MessageContext.QUIT_REQUESTED, "true");
            }
            document = XMLUtils.newDocument();
            element = document.createElementNS("", "Admin");
            document.appendChild(element);
            element.appendChild(document.createTextNode(Messages.getMessage("quit00", "")));
            return document;
        }
        if (string.equals("list")) {
            return webServicesEngine.getConfigurationDocument();
        }
        if (string.equals("clientdeploy")) {
            webServicesEngine = webServicesEngine.getClientEngine();
        }
        document = XMLUtils.newDocument();
        element = document.createElementNS("", "Admin");
        document.appendChild(element);
        element.appendChild(document.createTextNode(Messages.getMessage("done00")));
        return document;
    }

    public Document process(MessageContext messageContext, Element element) throws Exception {
        Serializable serializable;
        String string;
        SOAPPort sOAPPort = messageContext.getPort();
        if (sOAPPort != null && !JavaUtils.isTrueExplicitly(sOAPPort.getOption("enableRemoteAdmin")) && (string = messageContext.getStrProp("remoteaddr")) != null && !string.equals("127.0.0.1")) {
            try {
                serializable = InetAddress.getLocalHost();
                InetAddress inetAddress = InetAddress.getByName(string);
                if (!((InetAddress)serializable).equals(inetAddress)) {
                    throw new WebServicesFault("Server.Unauthorized", Messages.getMessage("noAdminAccess00"), null, null);
                }
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.webservices.engine.utils.Admin.process", (String)"203", (Object)this);
                throw new WebServicesFault("Server.UnknownHost", Messages.getMessage("unknownHost00"), null, null);
            }
        }
        string = element.getNamespaceURI();
        serializable = messageContext.getEngine();
        if (string != null && string.equals("http://websphere.ibm.com/webservices/wsdd/")) {
            return Admin.processWSDD(messageContext, (WebServicesEngine)serializable, element);
        }
        throw new Exception(Messages.getMessage("adminProcess00"));
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        if (stringArray.length < 2 || !stringArray[0].equals("client") && !stringArray[0].equals("server")) {
            log.error((Object)Messages.getMessage("usage00", "Admin client|server <xml-file>"));
            log.error((Object)Messages.getMessage("where00", "<xml-file>"));
            log.error((Object)"<deploy>");
            log.error((Object)"  <handler name=a class=className/>");
            log.error((Object)"  <chain name=a flow=\"a,b,c\" />");
            log.error((Object)"  <chain name=a request=\"a,b,c\" pivot=\"d\"");
            log.error((Object)"                  response=\"e,f,g\" />");
            log.error((Object)"  <service name=a handler=b />");
            log.error((Object)"</deploy>");
            log.error((Object)"<undeploy>");
            log.error((Object)"  <handler name=a/>");
            log.error((Object)"  <chain name=a/>");
            log.error((Object)"  <service name=a/>");
            log.error((Object)"</undeploy>");
            log.error((Object)"<list/>");
            throw new IllegalArgumentException(Messages.getMessage("usage00", "Admin client|server <xml-file>"));
        }
        Admin admin = new Admin();
        WebServicesEngine webServicesEngine = stringArray[0].equals("client") ? ClientEngineFactory.getUnmanagedEngine() : new ServerEngine();
        MessageContext messageContext = new MessageContext(webServicesEngine);
        try {
            for (n = 1; n < stringArray.length; ++n) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("process00", stringArray[n]));
                }
                Document document = XMLUtils.newDocument(new FileInputStream(stringArray[n]));
                admin.process(messageContext, document.getDocumentElement());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.utils.Admin.main", (String)"278");
            log.error((Object)Messages.getMessage("errorProcess00", stringArray[n]), (Throwable)exception);
            throw exception;
        }
    }
}

