/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionData;
import com.ibm.ws.webservices.engine.transport.jms.JMSURLParser;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;

public class JMSSender
extends BasicHandler {
    private Hashtable icTable = null;
    private static final int CHUNK_SIZE = 4096;
    private static final TraceComponent _tc = Tr.register((Class)JMSSender.class, (String)"WebServices", (String)"com.ibm.ws.webservices.engine.resources.engineMessages");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"invoke");
        }
        JMSConnectionData jMSConnectionData = new JMSConnectionData();
        try {
            try {
                URL uRL = messageContext.getTargetEndpointAddressAsURL();
                if (uRL == null) {
                    throw new WebServicesFault(Messages.getMessage("JMS.noEndpoint"));
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Target URL string is [" + uRL.toString() + "]"));
                }
                this.parseURL(jMSConnectionData, uRL);
                this.getJMSObjects(jMSConnectionData);
                this.sendMessage(jMSConnectionData, messageContext, uRL);
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.invoke", (String)"178", (Object)this);
                throw webServicesFault;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.invoke", (String)"183", (Object)this);
                webServicesFault = WebServicesFault.makeFault(exception);
                throw webServicesFault;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"invoke");
            throw throwable;
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)_tc, (String)"invoke");
    }

    private void parseURL(JMSConnectionData jMSConnectionData, URL uRL) throws WebServicesFault, Exception {
        Integer n;
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"parseURL");
        }
        JMSURLParser jMSURLParser = new JMSURLParser(uRL);
        jMSConnectionData.messageMode = jMSURLParser.getDestinationType();
        jMSConnectionData.connectionFactoryName = jMSURLParser.getConnectionFactory();
        jMSConnectionData.destinationName = jMSURLParser.getDestination();
        jMSConnectionData.targetService = jMSURLParser.getTargetService();
        if (jMSConnectionData.connectionFactoryName == null || jMSConnectionData.connectionFactoryName.length() == 0 || jMSConnectionData.destinationName == null || jMSConnectionData.destinationName.length() == 0 || jMSConnectionData.targetService == null || jMSConnectionData.targetService.length() == 0) {
            Tr.error((TraceComponent)_tc, (String)"JMS.MissingRequiredProperties");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.MissingRequiredProperties"), null, null);
        }
        try {
            string = jMSURLParser.getDeliveryMode();
            if (string != null) {
                n = new Integer(string);
                jMSConnectionData.deliveryMode = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.parseURL", (String)"256", (Object)this);
            Tr.error((TraceComponent)_tc, (String)"JMS.BadPropValue", (Object)"deliveryMode");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "deliveryMode"), numberFormatException);
        }
        try {
            string = jMSURLParser.getPriority();
            if (string != null) {
                n = new Integer(string);
                jMSConnectionData.priority = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.parseURL", (String)"274", (Object)this);
            Tr.error((TraceComponent)_tc, (String)"JMS.BadPropValue", (Object)"priority");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "priority"), numberFormatException);
        }
        try {
            string = jMSURLParser.getTimeToLive();
            if (string != null) {
                n = new Integer(string);
                jMSConnectionData.timeToLive = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.parseURL", (String)"292", (Object)this);
            Tr.error((TraceComponent)_tc, (String)"JMS.BadPropValue", (Object)"timeToLive");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "timeToLive"), numberFormatException);
        }
        string = jMSURLParser.getProperty("enableTransactionalOneWay", null);
        jMSConnectionData.enableTranOneWay = JavaUtils.isTrue(string);
        jMSConnectionData.initialContextFactory = jMSURLParser.getInitialContextFactory();
        jMSConnectionData.jndiProviderURL = jMSURLParser.getJndiProviderURL();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("message mode: [" + jMSConnectionData.messageMode + "], connectionFactoryName: [" + jMSConnectionData.connectionFactoryName + "], destinationName: [" + jMSConnectionData.destinationName + "], targetService: [" + jMSConnectionData.targetService + "]"));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"parseURL");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getJMSObjects(JMSConnectionData jMSConnectionData) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getJMSObjects");
        }
        try {
            try {
                try {
                    jMSConnectionData.jndiContext = this.getInitialContext(jMSConnectionData.initialContextFactory, jMSConnectionData.jndiProviderURL);
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", (String)"357", (Object)this);
                    Tr.error((TraceComponent)_tc, (String)"JMS.JNDIError01", (Object)namingException.toString());
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError01", namingException.toString()), null, null);
                }
                switch (jMSConnectionData.messageMode) {
                    case 1: {
                        try {
                            jMSConnectionData.queueConnectionFactory = (QueueConnectionFactory)jMSConnectionData.jndiContext.lookup(jMSConnectionData.connectionFactoryName);
                            jMSConnectionData.queue = (Queue)jMSConnectionData.jndiContext.lookup(jMSConnectionData.destinationName);
                            break;
                        }
                        catch (NamingException namingException) {
                            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", (String)"385", (Object)this);
                            Tr.error((TraceComponent)_tc, (String)"JMS.JNDIError02", (Object)namingException.toString());
                            throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", namingException.toString()), null, null);
                        }
                    }
                    case 2: {
                        try {
                            jMSConnectionData.topicConnectionFactory = (TopicConnectionFactory)jMSConnectionData.jndiContext.lookup(jMSConnectionData.connectionFactoryName);
                            jMSConnectionData.topic = (Topic)jMSConnectionData.jndiContext.lookup(jMSConnectionData.destinationName);
                            break;
                        }
                        catch (NamingException namingException) {
                            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", (String)"410", (Object)this);
                            Tr.error((TraceComponent)_tc, (String)"JMS.JNDIError02", (Object)namingException.toString());
                            throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", namingException.toString()), null, null);
                        }
                    }
                }
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", (String)"425", (Object)this);
                throw webServicesFault;
            }
            {
            }
            Object var4_6 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)_tc, (String)"getJMSObjects");
            return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"getJMSObjects");
            throw throwable;
        }
    }

    private synchronized InitialContext getInitialContext(String string, String string2) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getInitialContext");
        }
        InitialContext initialContext = null;
        String string3 = (string != null ? string : "<null>") + "#" + (string2 != null ? string2 : "<null>");
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("InitialContext key=[" + string3 + "]."));
        }
        if (this.icTable == null) {
            this.icTable = new Hashtable();
        }
        if ((initialContext = (InitialContext)this.icTable.get(string3)) == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (string != null) {
                hashtable.put("java.naming.factory.initial", string);
            }
            if (string2 != null) {
                hashtable.put("java.naming.provider.url", string2);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("About to create an InitialContext with the following properties:" + hashtable.toString()));
            }
            initialContext = new InitialContext(hashtable);
            this.icTable.put(string3, initialContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Re-using existing InitialContext with key=[" + string3 + "]."));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getInitialContext");
        }
        return initialContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(JMSConnectionData jMSConnectionData) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"closeConnection");
        }
        try {
            try {
                switch (jMSConnectionData.messageMode) {
                    case 1: {
                        if (jMSConnectionData.queueConnection != null) {
                            jMSConnectionData.queueConnection.close();
                        }
                        break;
                    }
                    case 2: {
                        if (jMSConnectionData.topicConnection != null) {
                            jMSConnectionData.topicConnection.close();
                        }
                        break;
                    }
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.closeConnection", (String)"562", (Object)this);
                Tr.error((TraceComponent)_tc, (String)"JMS.JMSError01", (Object)jMSException.toString());
                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", jMSException.toString()), null, null);
            }
            {
            }
            Object var4_2 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)_tc, (String)"closeConnection");
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"closeConnection");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendMessage(JMSConnectionData jMSConnectionData, MessageContext messageContext, URL uRL) throws WebServicesFault, IOException, SOAPException {
        int n;
        Comparable<StringBuffer> comparable;
        Object object;
        Object object2;
        boolean bl2;
        OperationDesc operationDesc;
        Object object3;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"sendMessage");
        }
        if ((object3 = messageContext.getProperty("enableTransactionalOneWay")) != null) {
            jMSConnectionData.enableTranOneWay = JavaUtils.isTrue(object3);
        }
        boolean bl = (operationDesc = messageContext.getOperation()) == null ? true : (bl2 = !operationDesc.isOneway());
        if (bl2 && jMSConnectionData.messageMode == 2) {
            Tr.error((TraceComponent)_tc, (String)"JMS.NoTwoWay");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTwoWay"), null, null);
        }
        TransactionSuspender transactionSuspender = null;
        boolean bl3 = false;
        if (!bl2 && jMSConnectionData.enableTranOneWay) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Bypassing transaction suspension...");
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Initiating transaction suspension...");
            }
            transactionSuspender = new TransactionSuspender();
            transactionSuspender.suspendTransaction();
            bl3 = TransactionSuspender.isTxnServiceEnabled();
        }
        Message message = messageContext.getRequestMessage();
        String string = messageContext.getUsername();
        String string2 = messageContext.getPassword();
        if (_tc.isDebugEnabled()) {
            object2 = string == null || string.length() == 0 ? "<not-specified>" : string;
            if (string2 == null || string2.length() == 0) {
                object = "<not-specified>";
            } else {
                comparable = new StringBuffer();
                for (n = 0; n < string2.length(); ++n) {
                    ((StringBuffer)comparable).append('*');
                }
                object = ((StringBuffer)comparable).toString();
            }
            Tr.debug((TraceComponent)_tc, (String)("Userid: " + (String)object2));
            Tr.debug((TraceComponent)_tc, (String)("Password: " + (String)object));
        }
        if ((object2 = (Integer)messageContext.getProperty("deliveryMode")) != null) {
            jMSConnectionData.deliveryMode = (Integer)object2;
        }
        if ((object = (Integer)messageContext.getProperty("priority")) != null) {
            jMSConnectionData.priority = (Integer)object;
        }
        if ((comparable = (Integer)messageContext.getProperty("timeToLive")) != null) {
            jMSConnectionData.timeToLive = (Integer)comparable;
        }
        if ((n = messageContext.getTimeout()) > 0 && (jMSConnectionData.timeToLive <= 0 || jMSConnectionData.timeToLive > n)) {
            jMSConnectionData.timeToLive = n;
        }
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        TopicSession topicSession = null;
        TopicPublisher topicPublisher = null;
        BytesMessage bytesMessage = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        String string3 = null;
        try {
            try {
                switch (jMSConnectionData.messageMode) {
                    case 1: {
                        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
                            jMSConnectionData.queueConnection = jMSConnectionData.queueConnectionFactory.createQueueConnection(string, string2);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("Created queue connection with user [" + string + "] and password [" + string2 + "]."));
                            }
                        } else {
                            jMSConnectionData.queueConnection = jMSConnectionData.queueConnectionFactory.createQueueConnection();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Created queue connection without user/password");
                            }
                        }
                        queueSession = jMSConnectionData.queueConnection.createQueueSession(bl3, 1);
                        queueSender = queueSession.createSender(jMSConnectionData.queue);
                        bytesMessage = queueSession.createBytesMessage();
                        string3 = message.getContentType(messageContext.getSOAPConstants());
                        bytesMessage.setStringProperty("contentType", string3);
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        message.writeTo(byteArrayOutputStream, string3);
                        message.removeAllAttachments();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("About to write the following request message to the JMS message:\n" + byteArrayOutputStream.toString()));
                        }
                        bytesMessage.writeBytes(byteArrayOutputStream.toByteArray());
                        if (MessageTrace.isTraceEnabled()) {
                            MessageTrace.log(MessageTrace.OUTBOUND_JMS_REQUEST, string3, byteArrayOutputStream.toByteArray());
                        }
                        bytesMessage.setStringProperty("targetService", jMSConnectionData.targetService);
                        bytesMessage.setStringProperty("endpointURL", uRL.toString());
                        bytesMessage.setStringProperty("transportVersion", "1");
                        if (!bl2 && jMSConnectionData.enableTranOneWay) {
                            bytesMessage.setStringProperty("enableTransaction", "true");
                        }
                        this.setSoapAction((javax.jms.Message)bytesMessage, messageContext);
                        TemporaryQueue temporaryQueue = null;
                        QueueReceiver queueReceiver = null;
                        if (bl2) {
                            temporaryQueue = queueSession.createTemporaryQueue();
                            bytesMessage.setJMSReplyTo((Destination)temporaryQueue);
                            queueReceiver = queueSession.createReceiver((Queue)temporaryQueue);
                            jMSConnectionData.queueConnection.start();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Created queue receiver and started the queue connection in preparation for the reply message.");
                            }
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("About to send message:\n" + bytesMessage.toString() + "\n" + "Message send options:\n" + "deliveryMode=" + jMSConnectionData.deliveryMode + ", priority=" + jMSConnectionData.priority + ", timeToLive=" + jMSConnectionData.timeToLive));
                        }
                        queueSender.send((javax.jms.Message)bytesMessage, jMSConnectionData.deliveryMode, jMSConnectionData.priority, (long)jMSConnectionData.timeToLive);
                        String string5 = bytesMessage.getJMSMessageID();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("Sent the message, messageID=" + string5));
                        }
                        if (bl3) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"About to commit QueueSession (send)");
                            }
                            queueSession.commit();
                        }
                        if (temporaryQueue != null) {
                            String string4;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("About to receive response message, requestTimeout=" + n + "ms."));
                            }
                            javax.jms.Message message2 = queueReceiver.receive((long)n);
                            if (_tc.isDebugEnabled()) {
                                if (message2 != null) {
                                    Tr.debug((TraceComponent)_tc, (String)("Received JMS response message:\n" + message2.toString()));
                                } else {
                                    Tr.debug((TraceComponent)_tc, (String)"Received null response message :-(");
                                }
                            }
                            if (message2 == null) {
                                Tr.error((TraceComponent)_tc, (String)"JMS.RequestTimeOut");
                                throw new WebServicesFault(Messages.getMessage("JMS.RequestTimeOut"));
                            }
                            if (bl3) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)_tc, (String)"About to commit QueueSession (receive)");
                                }
                                queueSession.commit();
                            }
                            String string6 = string4 = (string4 = message2.getStringProperty("contentType")) == null ? null : string4.trim();
                            if (message2 instanceof BytesMessage) {
                                String string7 = message2.getJMSCorrelationID();
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)_tc, (String)("Reply message contains correlation id: " + string7));
                                }
                                if (string7 == null || !string7.equals(string5)) {
                                    Tr.error((TraceComponent)_tc, (String)"JMS.MismatchedReply");
                                    throw new WebServicesFault(Messages.getMessage("JMS.MismatchedReply"));
                                }
                                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                                byte[] byArray = new byte[4096];
                                int n2 = 1;
                                while (n2 > 0) {
                                    n2 = ((BytesMessage)message2).readBytes(byArray);
                                    if (n2 <= 0) continue;
                                    byteArrayOutputStream2.write(byArray, 0, n2);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)_tc, (String)("Extracted the following SOAP message from the JMS response message:\n" + byteArrayOutputStream2.toString()));
                                }
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream2.toByteArray());
                                Message message3 = new Message(byteArrayInputStream, string4, null);
                                messageContext.setResponseMessage(message3);
                                break;
                            }
                            if (!(message2 instanceof TextMessage)) {
                                Tr.error((TraceComponent)_tc, (String)"JMS.InvalidReplyMsgType");
                                throw new WebServicesFault(Messages.getMessage("JMS.InvalidReplyMsgType"));
                            }
                            String string8 = ((TextMessage)message2).getText();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("Extracted the following SOAP Text message from the JMS response message:\n" + string8));
                            }
                            Message message4 = new Message(string8, string4, null);
                            messageContext.setResponseMessage(message4);
                        }
                        break;
                    }
                    case 2: {
                        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
                            jMSConnectionData.topicConnection = jMSConnectionData.topicConnectionFactory.createTopicConnection(string, string2);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("Created topic connection with user [" + string + "] and password [" + string2 + "]."));
                            }
                        } else {
                            jMSConnectionData.topicConnection = jMSConnectionData.topicConnectionFactory.createTopicConnection();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Created topic connection without user/password");
                            }
                        }
                        topicSession = jMSConnectionData.topicConnection.createTopicSession(bl3, 1);
                        topicPublisher = topicSession.createPublisher(jMSConnectionData.topic);
                        bytesMessage = topicSession.createBytesMessage();
                        string3 = message.getContentType(messageContext.getSOAPConstants());
                        bytesMessage.setStringProperty("contentType", string3);
                        if (jMSConnectionData.enableTranOneWay) {
                            bytesMessage.setStringProperty("enableTransaction", "true");
                        }
                        this.setSoapAction((javax.jms.Message)bytesMessage, messageContext);
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        message.writeTo(byteArrayOutputStream, string3);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("About to write the following request message to the JMS message: " + byteArrayOutputStream.toString()));
                        }
                        bytesMessage.writeBytes(byteArrayOutputStream.toByteArray());
                        bytesMessage.setStringProperty("targetService", jMSConnectionData.targetService);
                        bytesMessage.setStringProperty("endpointURL", uRL.toString());
                        bytesMessage.setStringProperty("transportVersion", "1");
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("About to publish message:\n" + bytesMessage.toString()));
                        }
                        topicPublisher.publish((javax.jms.Message)bytesMessage);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"Published the message.");
                        }
                        if (bl3) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"About to commit TopicSession (publish)");
                            }
                            topicSession.commit();
                        }
                        break;
                    }
                }
            }
            catch (JMSException jMSException) {
                StringBuffer stringBuffer;
                block74: {
                    FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.sendMessage", (String)"968", (Object)this);
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(Messages.getMessage("JMS.JMSError01", jMSException.toString()));
                    Exception exception = jMSException.getLinkedException();
                    while (exception != null) {
                        stringBuffer.append("\n");
                        stringBuffer.append(Messages.getMessage("JMS.JMSError02", exception.toString()));
                        if (exception instanceof JMSException) {
                            exception = ((JMSException)((Object)exception)).getLinkedException();
                            continue;
                        }
                        exception = null;
                    }
                    if (bl3) {
                        try {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Doing rollback of session due to JMSException.");
                            }
                            if (queueSession != null) {
                                queueSession.rollback();
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)_tc, (String)"Rolled back queue session.");
                                }
                            }
                            if (topicSession == null) break block74;
                            topicSession.rollback();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Rolled back topic session.");
                            }
                        }
                        catch (Throwable throwable) {
                            if (!_tc.isDebugEnabled()) break block74;
                            Tr.debug((TraceComponent)_tc, (String)("Session rollback failed with exception: " + throwable.toString()));
                        }
                    }
                }
                Tr.error((TraceComponent)_tc, (String)stringBuffer.toString());
                if (!_tc.isDebugEnabled()) throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
                Tr.debug((TraceComponent)_tc, (String)stringBuffer.toString());
                throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
            }
            {
            }
            Object var34_40 = null;
            if (transactionSuspender != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"Initiating transaction resumption...");
                }
                transactionSuspender.resumeTransaction();
            }
            this.closeConnection(jMSConnectionData);
            if (!_tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)_tc, (String)"sendMessage");
            return;
        }
        catch (Throwable throwable) {
            Object var34_41 = null;
            if (transactionSuspender != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"Initiating transaction resumption...");
                }
                transactionSuspender.resumeTransaction();
            }
            this.closeConnection(jMSConnectionData);
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"sendMessage");
            throw throwable;
        }
    }

    private void setSoapAction(javax.jms.Message message, MessageContext messageContext) throws JMSException {
        String string = messageContext.getSOAPActionURI();
        if (!messageContext.useSOAPAction() || string == null) {
            message.setStringProperty("soapAction", "");
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Setting soapAction on JMSMessage to: \"\"...");
            }
        } else {
            message.setStringProperty("soapAction", string);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Setting soapAction on MessageContext to: " + string));
            }
        }
    }
}

