/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache;
import com.ibm.ws.webservices.engine.transport.channel.OutboundOutputStream;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSCFEndPointCriteriaImpl;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HttpChannelAddress;
import com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPrompt;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPromptFactory;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class HTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog(HTTPSender.class.getName());
    private static final TraceComponent _tc = Tr.register((Class)HTTPSender.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static boolean HttpRedirectEnabledSysProp = Boolean.getBoolean("com.ibm.ws.webservices.HttpRedirectEnabled");
    private static String IN_PROCESS_ENABLED = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"HTTPSender::invoke");
        }
        WSOutboundConnection wSOutboundConnection = null;
        OutboundConnectionCache outboundConnectionCache = (OutboundConnectionCache)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return OutboundConnectionCache.getInstance();
            }
        });
        WSChannelManager wSChannelManager = WSChannelManager.getInstance();
        Object object = null;
        try {
            try {
                String string;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                block68: {
                    block66: {
                        Identity identity;
                        block67: {
                            WSCFEndPointCriteriaImpl wSCFEndPointCriteriaImpl;
                            URL uRL;
                            block65: {
                                block64: {
                                    block61: {
                                        uRL = messageContext.getTargetEndpointAddressAsURL();
                                        wSCFEndPointCriteriaImpl = null;
                                        wSCFEndPointCriteriaImpl = uRL.getProtocol().equalsIgnoreCase("http") ? new WSCFEndPointCriteriaImpl(1, uRL.getHost()) : new WSCFEndPointCriteriaImpl(2, uRL.getHost());
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)_tc, (String)("javax.xml.rpc.service.endpoint.address: " + uRL.toString()));
                                        }
                                        object = WSAddress.getAddress(uRL);
                                        identity = wSChannelManager.clusterIdenFromEPR();
                                        if (identity != null) break block64;
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("clusterFromWsAddr", String.valueOf(identity)));
                                        }
                                        object5 = TransportClientPropertiesFactory.create(uRL.getProtocol());
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)_tc, (String)("Original " + uRL.getProtocol() + " transport client properties:\n" + object5.toString()));
                                        }
                                        if ((object = HttpChannelAddress.getProxyAddress(uRL, (TransportClientProperties)object5)) == null) {
                                            object = WSAddress.getAddress(uRL);
                                        } else if (_tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("targetAddress01", object.toString()));
                                        }
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)_tc, (String)("Updated " + uRL.getProtocol() + " transport client properties:\n" + object5.toString()));
                                        }
                                        if (wSChannelManager.getRuntime() == 3) break block65;
                                        if (IN_PROCESS_ENABLED == null) {
                                            try {
                                                object4 = log;
                                                synchronized (object4) {
                                                    if (IN_PROCESS_ENABLED == null) {
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                        }
                                                        if ((object3 = ClassUtils.forName("com.ibm.wsspi.webcontainer.WebContainer")) != null) {
                                                            Properties properties;
                                                            if (_tc.isDebugEnabled()) {
                                                                Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("invokeMethod00", "getWebContainerProperties", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                            }
                                                            if ((properties = (Properties)((Method)(object2 = ((Class)object3).getMethod("getWebContainerProperties", null))).invoke(null, null)) != null) {
                                                                IN_PROCESS_ENABLED = properties.getProperty("enableinprocessconnections");
                                                            }
                                                        }
                                                    }
                                                    if (IN_PROCESS_ENABLED == null) {
                                                        IN_PROCESS_ENABLED = "null";
                                                    }
                                                }
                                            }
                                            catch (Exception exception) {
                                                if (IN_PROCESS_ENABLED == null) {
                                                    IN_PROCESS_ENABLED = "null";
                                                }
                                                if (!_tc.isDebugEnabled()) break block61;
                                                Tr.debug((TraceComponent)_tc, (String)(exception.toString() + " is caught. Failed to read WebContainer properties. Proceed with HTTP in-process connection disabled."));
                                            }
                                        }
                                    }
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)_tc, (String)("enableInProcessConnections : " + IN_PROCESS_ENABLED));
                                    }
                                    if (IN_PROCESS_ENABLED != null && IN_PROCESS_ENABLED.equalsIgnoreCase("true") && wSChannelManager.isWLMable()) {
                                        identity = wSChannelManager.clusterIdenFromDWLMClient((WSAddress)object, wSCFEndPointCriteriaImpl);
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("clusterFromRequestMapper", String.valueOf(identity), object.toString()));
                                        }
                                    }
                                    break block65;
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("clusterFromWsAddr", String.valueOf(identity)));
                                }
                            }
                            if (identity == null) break block66;
                            object5 = null;
                            object5 = wSChannelManager.identityToCFEndPoint(identity, wSCFEndPointCriteriaImpl);
                            if (object5 == null) break block67;
                            object4 = uRL.getProtocol() + "://" + object5.getAddress().getHostName() + ":" + object5.getPort() + uRL.getFile();
                            object = WSAddress.getAddress(new URL((String)object4));
                            ((WSAddress)object).setCFEndPoint((CFEndPoint)object5);
                            if (object5.isLocal()) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("usedHttpChannelType", "In-process"));
                                }
                                break block68;
                            } else if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("usedHttpChannelType", "Network"));
                            }
                            break block68;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("cannotConvertCFEndPt", String.valueOf(identity)));
                        }
                        break block68;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("usedHttpChannelType", "Network"));
                    }
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("targetAddress00", object.toString()));
                }
                object5 = MessageContext.getCurrentThreadsContext();
                object4 = ((MessageContext)object5).getRequestMessage();
                object3 = ((Message)object4).getContentType(((MessageContext)object5).getSOAPConstants());
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("HTTP Content-Type: " + (String)object3));
                }
                object2 = new OutboundOutputStream((String)object3);
                ((Message)object4).writeTo((OutputStream)object2);
                ((Message)object4).removeAllAttachments();
                int n = 0;
                Integer n2 = null;
                String string2 = null;
                boolean bl = false;
                while (!bl) {
                    boolean bl2;
                    wSOutboundConnection = ((WSAddress)object).getSchema() == 2 ? outboundConnectionCache.findGroupAndGetConnection("httpclient-https-chain", (WSAddress)object) : outboundConnectionCache.findGroupAndGetConnection("httpclient-http-chain", (WSAddress)object);
                    try {
                        if (wSOutboundConnection == null) throw new WebServicesFault("No WSOutboundConnection object returned from outbound connection pool.");
                        if (MessageTrace.isTraceEnabled() && object3 != null && object2 != null) {
                            MessageTrace.log(MessageTrace.OUTBOUND_HTTP_REQUEST, (String)object3, ((OutboundOutputStream)object2).toByteArray());
                        }
                        wSOutboundConnection.connect();
                        wSOutboundConnection.sendSOAPRequest((OutboundOutputStream)object2);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        FFDCFilter.processException((Throwable)socketTimeoutException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"449", (Object)this);
                        TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(((WSAddress)object).getSchemaInString());
                        bl2 = false;
                        bl2 = ((DefaultHTTPTransportClientProperties)transportClientProperties).isResendEnabled();
                        if (!wSOutboundConnection.hasbeenUsed()) throw WebServicesFault.makeFault(socketTimeoutException);
                        if (wSOutboundConnection.isMessageSent()) throw WebServicesFault.makeFault(socketTimeoutException);
                        if (bl2) throw WebServicesFault.makeFault(socketTimeoutException);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                        }
                        wSOutboundConnection.disconnect(socketTimeoutException);
                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                        continue;
                    }
                    catch (SocketException socketException) {
                        FFDCFilter.processException((Throwable)socketException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"478", (Object)this);
                        TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(((WSAddress)object).getSchemaInString());
                        bl2 = false;
                        bl2 = ((DefaultHTTPTransportClientProperties)transportClientProperties).isResendEnabled();
                        if (!wSOutboundConnection.hasbeenUsed()) throw WebServicesFault.makeFault(socketException);
                        if (wSOutboundConnection.isMessageSent()) throw WebServicesFault.makeFault(socketException);
                        if (bl2) throw WebServicesFault.makeFault(socketException);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                        }
                        wSOutboundConnection.disconnect(socketException);
                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                        continue;
                    }
                    wSOutboundConnection.receiveSOAPResponse();
                    n2 = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                    string2 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    if (n2 != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("httpStatusInResponse00", n2.toString(), string2));
                        }
                        if ((n = n2.intValue()) == HttpConstants.STATUS_FOUND.getIntCode()) {
                            if (!HTTPSender.isHttpRedirectEnabled()) {
                                bl = true;
                                throw new WebServicesFault(Messages.getMessage("http302StatusCode", object.toString()));
                            }
                            string2 = messageContext.getStrProp(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                            if (JavaUtils.hasValue(string2)) {
                                object = WSAddress.getAddress(new URL(string2));
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("http302StatusCode", object.toString()));
                                }
                                wSOutboundConnection.disconnect(null);
                                outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                wSOutboundConnection = null;
                            }
                            messageContext.removeProperty(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                            continue;
                        }
                        if (n == HttpConstants.STATUS_UNAUTHORIZED.getIntCode()) {
                            if (wSChannelManager.getRuntime() != 1) {
                                string = messageContext.getStrProp("WWW-Authenticate");
                                boolean bl3 = (Boolean)messageContext.getProperty("com.ibm.ws.webservices.spnegoUsed");
                                if (bl3 && string != null && string.indexOf("Negotiate") == 0) {
                                    Tr.debug((TraceComponent)_tc, (String)("WWW-Authenticate: " + string));
                                    bl = true;
                                    continue;
                                }
                                if (this.receivedHTTPBasicAuth()) {
                                    Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("challengeStatus01"));
                                    wSOutboundConnection.reset();
                                    outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                    wSOutboundConnection = null;
                                    continue;
                                }
                                Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("challengeStatus02"));
                                bl = true;
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    bl = true;
                }
                if (n == 0) throw new WebServicesFault(Messages.getMessage("httpStatusInResponse01"));
                string = ((HttpOutboundChannelConnection)wSOutboundConnection).getHeaderFromResponse(HttpConstants.HDR_CONTENT_TYPE);
                this.processStatusCode(n, string, (WSAddress)object);
                Object var21_27 = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"608", (Object)this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("exception01", exception.toString()));
                    if (JavaUtils.hasValue(object.toString())) {
                        Tr.debug((TraceComponent)_tc, (String)("URL = " + object.toString()));
                    } else {
                        Tr.debug((TraceComponent)_tc, (String)("URL = " + messageContext.getTargetEndpointAddress()));
                    }
                }
                if (wSOutboundConnection == null) throw WebServicesFault.makeFault(exception);
                wSOutboundConnection.disconnect(exception);
                throw WebServicesFault.makeFault(exception);
            }
        }
        catch (Throwable throwable) {
            Object var21_28 = null;
            try {
                if (wSOutboundConnection != null) {
                    wSOutboundConnection.reset();
                    outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                    wSOutboundConnection = null;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"639", (Object)this);
                if (!_tc.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
                Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("exception01", exception.toString()));
                throw WebServicesFault.makeFault(exception);
            }
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.entry((TraceComponent)_tc, (String)"HTTPSender::invoke");
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"639", (Object)this);
            if (!_tc.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
            Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("exception01", exception.toString()));
            throw WebServicesFault.makeFault(exception);
        }
        if (wSOutboundConnection != null) {
            wSOutboundConnection.reset();
            outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
            wSOutboundConnection = null;
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.entry((TraceComponent)_tc, (String)"HTTPSender::invoke");
    }

    private void processStatusCode(int n, String string, WSAddress wSAddress) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"HTTPSender::processStatusCode");
        }
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        String string2 = string = null == string ? null : string.trim();
        if (!(n > 199 && n < 300 || string != null && !string.startsWith("text/html") && n > 499 && n < 600)) {
            String string3 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            String string4 = wSAddress.getSchemaInString().toLowerCase() + "://" + wSAddress.getHostname() + ":" + wSAddress.getPort();
            WebServicesFault webServicesFault = new WebServicesFault("HTTP", "( " + n + " ) " + string3, string4, null);
            String string5 = messageContext.getResponseMessage() == null ? "" : messageContext.getResponseMessage().getSOAPPartAsString();
            webServicesFault.setFaultDetailString(Messages.getMessage("return01", "( " + n + " ) " + string3, string5));
            throw webServicesFault;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"HTTPSender::processStatusCode");
        }
    }

    public String getCookieFromHeaders(String string, String string2, Hashtable hashtable) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("HTTPSender::getCookieFromHeaders(" + string + ", " + string2 + ", headers)"));
        }
        String string3 = null;
        if (hashtable.containsKey(string2.toLowerCase())) {
            string3 = (String)hashtable.get(string2.toLowerCase());
            int n = (string3 = string3.trim()).indexOf(59);
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"HTTPSender::getCookieFromHeaders");
        }
        return string3;
    }

    public static boolean isHttpRedirectEnabled() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"HTTPSender::isHttpRedirectEnabled()");
        }
        boolean bl = false;
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        Boolean bl2 = (Boolean)messageContext.getProperty("http.redirect.enabled");
        if (bl2 == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("com.ibm.ws.webservices.HttpRedirectEnabled: " + bl2));
            }
            bl = HttpRedirectEnabledSysProp;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("http.redirect.enabled: " + bl2));
            }
            bl = bl2;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("HTTPSender::isHttpRedirectEnabled=" + bl));
        }
        return bl;
    }

    private boolean receivedHTTPBasicAuth() {
        MessageContext messageContext;
        boolean bl;
        block10: {
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)"HTTPSender::receivedHTTPBasicAuth()");
            }
            bl = false;
            messageContext = MessageContext.getCurrentThreadsContext();
            if (!JavaUtils.hasValue(messageContext.getUsername()) && !JavaUtils.hasValue(messageContext.getPassword())) {
                String string = System.getProperty("com.ibm.ws.webservices.loginSource");
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("com.ibm.ws.webservices.loginSource: " + string));
                }
                try {
                    if (!JavaUtils.hasValue(string) || "prompt".compareToIgnoreCase(string) != 0 && "stdin".compareToIgnoreCase(string) != 0) break block10;
                    SecurityDataPrompt securityDataPrompt = SecurityDataPromptFactory.getPrompt(string);
                    String[] stringArray = null;
                    try {
                        final String string2 = messageContext.getStrProp("WWW-Authenticate");
                        final SecurityDataPrompt securityDataPrompt2 = securityDataPrompt;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("challengeRealmInfo", string2));
                        }
                        stringArray = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return securityDataPrompt2.launch(string2 == null ? "" : string2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", (String)"833", (Object)this);
                        Tr.debug((TraceComponent)_tc, (String)privilegedActionException.toString());
                        throw privilegedActionException.getException();
                    }
                    if (stringArray != null && JavaUtils.hasValue(stringArray[0]) && JavaUtils.hasValue(stringArray[1])) {
                        messageContext.setUsername(stringArray[0]);
                        messageContext.setPassword(stringArray[1]);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", (String)"848", (Object)this);
                    if (!_tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("exception01", exception.toString()));
                }
            }
        }
        messageContext.removeProperty("WWW-Authenticate");
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"HTTPSender::receivedHTTPBasicAuth()");
        }
        return bl;
    }
}

