/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends FilterInputStream {
    protected long chunkSize = 0L;
    protected volatile boolean closed = false;
    private static final int maxCharLong = Long.toHexString(Long.MAX_VALUE).toString().length();

    private ChunkedInputStream() {
        super(null);
    }

    public ChunkedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        return n > 0 ? byArray[0] : n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n3 = (int)Math.min(Integer.MAX_VALUE, this.chunkSize);
        int n4 = 0;
        int n5 = 0;
        try {
            do {
                if (this.chunkSize < 1L && 0L == this.getChunked()) {
                    if (n4 == 0) {
                        return -1;
                    }
                    return n4;
                }
                n5 = this.in.read(byArray, n + n4, Math.min(n2 - n4, (int)Math.min(this.chunkSize, Integer.MAX_VALUE)));
                if (n5 <= 0) continue;
                n4 += n5;
                this.chunkSize -= (long)n5;
            } while (n2 - n4 > 0 && n5 > -1);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.transport.http.ChunkedInputStream.read", (String)"119", (Object)this);
            this.closed = true;
            throw iOException;
        }
        return n4;
    }

    public long skip(long l) throws IOException {
        if (this.closed) {
            return 0L;
        }
        long l2 = 0L;
        byte[] byArray = new byte[1024];
        int n = -1;
        do {
            if ((n = this.read(byArray, 0, byArray.length)) <= 0) continue;
            l2 += (long)n;
        } while (n != -1 && l2 < l);
        return l2;
    }

    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        int n = (int)Math.min(this.chunkSize, Integer.MAX_VALUE);
        return Math.min(n, this.in.available());
    }

    protected long getChunked() throws IOException {
        byte[] byArray = new byte[maxCharLong + 2];
        int n = 0;
        this.chunkSize = -1L;
        int n2 = -1;
        do {
            if ((n2 = this.in.read()) <= -1 || n2 == 13 || n2 == 10 || n2 == 32 || n2 == 9) continue;
            byArray[n++] = (byte)n2;
        } while (n2 > -1 && (n2 != 10 || n == 0) && n < byArray.length);
        if (n2 < 0) {
            this.closed = true;
        }
        String string = new String(byArray, 0, n);
        if (n > maxCharLong) {
            this.closed = true;
            throw new IOException("Chunked input stream failed to receive valid chunk size:" + string);
        }
        try {
            this.chunkSize = Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.transport.http.ChunkedInputStream.getChunked", (String)"178", (Object)this);
            this.closed = true;
            throw new IOException("'" + string + "' " + numberFormatException.getMessage());
        }
        if (this.chunkSize < 1L) {
            this.closed = true;
        }
        if (this.chunkSize != 0L && n2 < 0) {
            throw new IOException("HTTP Chunked stream closed in middle of chunk.");
        }
        if (this.chunkSize < 0L) {
            throw new IOException("HTTP Chunk size received " + this.chunkSize + " is less than zero.");
        }
        return this.chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        object = new byte[1024];
        int n = -1;
        while ((n = this.read((byte[])object, 0, ((Object)object).length)) != -1) {
        }
    }

    public void reset() throws IOException {
        throw new IOException("Don't support marked streams");
    }

    public boolean markSupported() {
        return false;
    }
}

