/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.orderedset;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.orderedset.BasicOperableOrderedSet;
import com.ibm.ws.webservices.engine.orderedset.EmptySet;
import com.ibm.ws.webservices.engine.orderedset.OperableOrderedSet;
import com.ibm.ws.webservices.engine.orderedset.Operation;
import com.ibm.ws.webservices.engine.orderedset.OperationException;
import com.ibm.ws.webservices.engine.orderedset.OrderedSet;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.lang.reflect.Array;
import java.util.List;
import org.apache.commons.logging.Log;

public abstract class BasicListSet
extends BasicOperableOrderedSet
implements OrderedSet {
    protected static Log log = LogFactory.getLog(BasicListSet.class.getName());
    private List _list;

    protected BasicListSet(List list) {
        this._list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object object) {
        List list = this._list;
        synchronized (list) {
            if (!this._list.contains(object)) {
                this._list.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        List list = this._list;
        synchronized (list) {
            return this._list.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        List list = this._list;
        synchronized (list) {
            return this._list.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] get() {
        List list = this._list;
        synchronized (list) {
            if (this._list.size() == 0) {
                return null;
            }
            Object[] objectArray = new Object[this._list.size()];
            return this._list.toArray(objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] get(Class clazz) {
        List list = this._list;
        synchronized (list) {
            if (this._list.size() == 0) {
                return null;
            }
            Object[] objectArray = (Object[])Array.newInstance(clazz, this._list.size());
            return this._list.toArray(objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Operation operation) throws OperationException {
        List list = this._list;
        synchronized (list) {
            this.getSet().apply(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyReverse(Operation operation) throws OperationException {
        List list = this._list;
        synchronized (list) {
            this.getSet().applyReverse(operation);
        }
    }

    private OperableOrderedSet getSet() {
        BasicOperableOrderedSet basicOperableOrderedSet = this._list.size() == 0 ? new EmptySet() : new SubSet(0, this._list.size() - 1, 1);
        return basicOperableOrderedSet;
    }

    private class SubSet
    extends BasicOperableOrderedSet {
        private final int _first;
        private final int _last;
        private final int _step;

        public SubSet(int n, int n2, int n3) {
            this.setIgnoreExceptions(super.getIgnoreExceptions());
            this._first = n;
            this._last = n2;
            if (this._first < 0 || this._last < 0 || this._first >= BasicListSet.this._list.size() || this._last >= BasicListSet.this._list.size() || n3 == 0) {
                this._step = 0;
            } else if (n3 < 0 && this._first < this._last || n3 > 0 && this._first > this._last) {
                log.error((Object)Messages.getMessage("invalidSubset00", String.valueOf(this._first), String.valueOf(this._last), String.valueOf(n3)));
                this._step = 0;
            } else {
                int n4 = this._step = n3 > 0 ? 1 : -1;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("SubSet(" + this._first + ", " + this._last + ", " + this._step + ")"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(Operation operation) throws OperationException {
            if (this._step == 0) {
                return;
            }
            List list = BasicListSet.this._list;
            synchronized (list) {
                block13: {
                    int n = this._first;
                    if (this.getIgnoreExceptions()) {
                        while (true) {
                            Object e = BasicListSet.this._list.get(n);
                            try {
                                operation.op(e);
                            }
                            catch (Throwable throwable) {
                                log.info((Object)Messages.getMessage("ignoringException01", e.toString()), throwable);
                            }
                            if (n != this._last) {
                                n += this._step;
                                continue;
                            }
                            break block13;
                            break;
                        }
                    }
                    Object var4_5 = null;
                    try {
                        while (true) {
                            var4_5 = BasicListSet.this._list.get(n);
                            operation.op(var4_5);
                            if (n != this._last) {
                                n += this._step;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.engine.orderedset.BasicListSet.apply", (String)"245", (Object)this);
                        SubSet subSet = new SubSet(n - 1, this._first, -this._step);
                        SubSet subSet2 = new SubSet(n + 1, this._last, this._step);
                        throw new OperationException(throwable, var4_5, subSet, subSet2);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyReverse(Operation operation) throws OperationException {
            if (this._step == 0) {
                return;
            }
            List list = BasicListSet.this._list;
            synchronized (list) {
                block13: {
                    int n = this._last;
                    if (this.getIgnoreExceptions()) {
                        while (true) {
                            Object e = BasicListSet.this._list.get(n);
                            try {
                                operation.op(e);
                            }
                            catch (Throwable throwable) {
                                log.info((Object)Messages.getMessage("ignoringException01", e.toString()), throwable);
                            }
                            if (n != this._first) {
                                n -= this._step;
                                continue;
                            }
                            break block13;
                            break;
                        }
                    }
                    Object var4_5 = null;
                    try {
                        while (true) {
                            var4_5 = BasicListSet.this._list.get(n);
                            operation.op(var4_5);
                            if (n != this._first) {
                                n -= this._step;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.engine.orderedset.BasicListSet.applyReverse", (String)"296", (Object)this);
                        SubSet subSet = new SubSet(n + 1, this._last, this._step);
                        SubSet subSet2 = new SubSet(n - 1, this._first, -this._step);
                        throw new OperationException(throwable, var4_5, subSet, subSet2);
                    }
                }
            }
        }
    }
}

