/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class JAXRPCSOAPHandler
extends JAXRPCHandler {
    protected static Log log = LogFactory.getLog(JAXRPCSOAPHandler.class.getName());
    private static String _CHAIN_AND_OPERATION_ACTORS_HEADERS = "com.ibm.ws.webservices.engine.chain_operation.actors_headers";
    private Collection _handlerChainHeaderQNames;
    private final boolean doMisunderstoodHeaders = true;

    public JAXRPCSOAPHandler() throws ConfigurationException {
        this(null, null, null);
    }

    public JAXRPCSOAPHandler(Handler handler2) {
        this(null, handler2, null);
    }

    public JAXRPCSOAPHandler(Handler handler2, Handler handler3, Handler handler4) {
        super(handler2, handler3, handler4);
    }

    public static Handler factory(Handler handler2, Handler handler3, Handler handler4, HandlerChain handlerChain) {
        if (handler2 == null && handler4 == null && handlerChain == null) {
            return handler3;
        }
        JAXRPCSOAPHandler jAXRPCSOAPHandler = new JAXRPCSOAPHandler(handler2, handler3, handler4);
        if (handlerChain != null) {
            jAXRPCSOAPHandler.setHandlerChain(handlerChain);
        }
        return jAXRPCSOAPHandler;
    }

    protected Handler jaxrpcServerRequestHandler() {
        return this.getHandlerChain() == null ? new BasicHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                JAXRPCSOAPHandler.this.checkSOAPSemantics(messageContext);
            }
        } : super.jaxrpcServerRequestHandler();
    }

    protected Handler jaxrpcClientResponseHandler() {
        return this.getHandlerChain() == null ? new BasicHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                JAXRPCSOAPHandler.this.checkSOAPSemantics(messageContext);
            }
        } : super.jaxrpcClientResponseHandler();
    }

    protected boolean invokeServerRequestHandler(MessageContext messageContext) throws WebServicesFault {
        this.checkSOAPSemantics(messageContext);
        return super.invokeServerRequestHandler(messageContext);
    }

    protected boolean invokeClientResponseHandler(MessageContext messageContext) throws WebServicesFault {
        this.checkSOAPSemantics(messageContext);
        return super.invokeClientResponseHandler(messageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXRPCHandler.ActorHeaderBindings getOperationsActorHeaderBindings(MessageContext messageContext) throws WebServicesFault {
        JAXRPCHandler.ActorHeaderBindings actorHeaderBindings;
        OperationDesc operationDesc;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: getOperationsActorHeaderBindings()");
        }
        try {
            operationDesc = SoapRPCProcessor.getProcessor().getOperation(messageContext);
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.checkMisunderstoodHeader", (String)"222", (Object)this);
            throw webServicesFault;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.getOperationHeaderQNames", (String)"168", (Object)this);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("toWebServicesFault00"), (Throwable)exception);
            }
            throw WebServicesFault.makeFault(exception);
        }
        if (operationDesc != null) {
            OperationDesc operationDesc2 = operationDesc;
            synchronized (operationDesc2) {
                actorHeaderBindings = (JAXRPCHandler.ActorHeaderBindings)operationDesc.getOption(_CHAIN_AND_OPERATION_ACTORS_HEADERS);
                if (actorHeaderBindings == null) {
                    actorHeaderBindings = new JAXRPCHandler.ActorHeaderBindings(this.getAllActorHeaderBindings());
                    Set set = operationDesc.getHeaderParamQNames();
                    if (set.size() > 0) {
                        Iterator iterator = this.getNodeActors();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            actorHeaderBindings.addBinding(string, set);
                        }
                    }
                    set.clear();
                    operationDesc.setOption(_CHAIN_AND_OPERATION_ACTORS_HEADERS, actorHeaderBindings);
                }
            }
        } else {
            actorHeaderBindings = this.getAllActorHeaderBindings();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Actors / Headers: " + actorHeaderBindings));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: getOperationsActorHeaderBindings");
        }
        return actorHeaderBindings;
    }

    private Collection addMisunderstoodHeader(Collection vector, SOAPHeaderElement sOAPHeaderElement) {
        if (vector == null) {
            vector = new Vector<SOAPHeaderElement>();
        }
        vector.add(sOAPHeaderElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Misunderstood Header! " + sOAPHeaderElement));
        }
        return vector;
    }

    private void checkSOAPSemantics(MessageContext messageContext) throws WebServicesFault {
        Object object;
        Object object2;
        Object object3;
        QName qName;
        Serializable serializable;
        Object object4;
        Iterator iterator;
        SOAPHeader sOAPHeader;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("semanticCheck00"));
        }
        Message message = (Message)messageContext.getMessage();
        SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
        try {
            sOAPHeader = (SOAPHeader)sOAPEnvelope.getHeader();
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.checkSOAPSemantics", (String)"174", (Object)this);
            throw WebServicesFault.makeFault(sOAPException);
        }
        Collection collection = null;
        Iterator iterator2 = iterator = sOAPHeader == null ? null : sOAPHeader.getChildElements();
        while (iterator != null && iterator.hasNext()) {
            object4 = iterator.next();
            if (!(object4 instanceof SOAPHeaderElement) || !((SOAPHeaderElement)(serializable = (SOAPHeaderElement)object4)).getMustUnderstand()) continue;
            qName = ((SOAPElement)serializable).getQName();
            object3 = this.getPortOperationHeaders(messageContext);
            object2 = object3.contains(qName) ? this.getOperationsActorHeaderBindings(messageContext) : this.getAllActorHeaderBindings();
            if (!((JAXRPCHandler.ActorHeaderBindings)object2).nodeActorNotBoundToHeader((String)(object = ((SOAPHeaderElement)serializable).getActor()), qName)) continue;
            collection = this.addMisunderstoodHeader(collection, (SOAPHeaderElement)serializable);
        }
        if (collection != null) {
            object4 = messageContext.getSOAPConstants().getEnvelopeURI();
            serializable = new WebServicesFault(QNameTable.createQName(object4, "MustUnderstand"), null, null, null);
            object2 = new StringBuffer(256);
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                qName = iterator.next();
                if (!(qName instanceof SOAPHeaderElement)) continue;
                object3 = (SOAPHeaderElement)((Object)qName);
                if (((StringBuffer)object2).length() != 0) {
                    ((StringBuffer)object2).append(", ");
                }
                ((StringBuffer)object2).append(((SOAPElement)object3).getQName().toString());
                object = null;
                try {
                    object = ((SOAPElement)object3).getSOAPFactory().createSOAPHeaderElement("http://www.w3.org/2002/06/soap-faults", "Misunderstood");
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.checkSOAPSemantics", (String)"252", (Object)this);
                    throw WebServicesFault.makeFault(sOAPException);
                }
                String string = null;
                String string2 = ((SOAPElement)object3).getLocalPart();
                if (((SOAPElement)object3).getNamespaceURI() != null && ((SOAPElement)object3).getNamespaceURI().length() > 0) {
                    string = ((SOAPElement)object3).getPrefix();
                    if (string != null) {
                        ((SOAPElement)object).addNamespaceDeclaration(string, ((SOAPElement)object3).getNamespaceURI());
                        string2 = string + ':' + string2;
                    } else {
                        ((SOAPElement)object).addNamespaceDeclaration("", ((SOAPElement)object3).getNamespaceURI());
                    }
                }
                ((SOAPElement)object).addAttribute("", "qname", string2);
                ((WebServicesFault)serializable).addHeader((SOAPHeaderElement)object);
            }
            ((WebServicesFault)serializable).setFaultString(Messages.getMessage("noUnderstand00", ((StringBuffer)object2).toString()));
            throw serializable;
        }
    }

    private Set getPortOperationHeaders(MessageContext messageContext) {
        Set set;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: getPortOperationHeaders");
        }
        if ((set = messageContext.getPortDesc().getPortOperationHeaders()) == null) {
            set = new JAXRPCHandler.QNameSet();
            ArrayList arrayList = messageContext.getPortDesc().getOperations();
            for (int i = 0; i < arrayList.size(); ++i) {
                OperationDesc operationDesc = (OperationDesc)arrayList.get(i);
                Set set2 = operationDesc.getHeaderParamQNames();
                set.addAll(set2);
                set2.clear();
            }
            messageContext.getPortDesc().setPortOperationHeaders(set);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: getPortOperationHeaders");
        }
        return set;
    }

    public void _destroy() {
        super._destroy();
        if (this._handlerChainHeaderQNames != null) {
            this._handlerChainHeaderQNames.clear();
            this._handlerChainHeaderQNames = null;
        }
    }
}

