/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ClosureHandler;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PreHandler;
import com.ibm.ws.webservices.engine.SimpleChain;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.dispatchers.GreenDispatcher;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class JAXRPCHandler
extends SimpleTargetedChain {
    protected static Log log = LogFactory.getLog(JAXRPCHandler.class.getName());
    public static final int MODE_CS_CLIENT = 1;
    public static final int MODE_CS_SERVER = 2;
    private static Collection _defaultActors = new TreeSet();
    private int _modeClientServer = 0;
    private ActorHeaderBindings _actorHeaderBindings = new ActorHeaderBindings();
    private ActorHeaderBindings _handlerChainActorHeaderBindings = null;
    private ActorHeaderBindings _allActorHeaderBindings = null;
    private Collection _globalHandlerHeaders = null;
    private HandlerChain _handlerChain;
    private static final Set booleanOptions;

    public JAXRPCHandler() throws ConfigurationException {
        this(null, null, null);
    }

    public JAXRPCHandler(Handler handler2) {
        this(null, handler2, null);
    }

    public JAXRPCHandler(Handler handler2, Handler handler3, Handler handler4) {
        super(handler2, handler3, handler4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (this.getPivotHandler() instanceof GreenDispatcher) {
            GreenDispatcher greenDispatcher = (GreenDispatcher)((Object)this.getPivotHandler());
            greenDispatcher.setupEnvironment(messageContext);
            try {
                super.invoke(messageContext);
            }
            finally {
                greenDispatcher.cleanupEnvironment(messageContext);
            }
        } else {
            super.invoke(messageContext);
        }
    }

    public static Handler factory(Handler handler2, Handler handler3, Handler handler4, HandlerChain handlerChain, ActorHeaderBindings actorHeaderBindings, int n) {
        if (handler2 == null && handler4 == null && handlerChain == null && actorHeaderBindings == null) {
            return handler3;
        }
        JAXRPCHandler jAXRPCHandler = new JAXRPCHandler(handler2, handler3, handler4);
        jAXRPCHandler.setModeClientServer(n);
        if (handlerChain != null) {
            jAXRPCHandler.setHandlerChain(handlerChain);
        }
        if (actorHeaderBindings != null) {
            jAXRPCHandler.setActorHeaderBinding(actorHeaderBindings);
        }
        return jAXRPCHandler;
    }

    protected final Handler adjustRequestHandler(Handler handler2) {
        Handler handler3 = super.adjustRequestHandler(handler2);
        if (this.getModeClientServer() == 2) {
            return SimpleChain.mergeHandlers(handler3, this.jaxrpcServerRequestHandler());
        }
        if (this.getModeClientServer() == 1) {
            return SimpleChain.mergeHandlers(this.jaxrpcClientRequestHandler(), handler3);
        }
        throw new InternalException(Messages.getMessage("soapport.csmode.undefined"));
    }

    protected final Handler adjustResponseHandler(Handler handler2) {
        Handler handler3 = super.adjustResponseHandler(handler2);
        if (this.getModeClientServer() == 2) {
            return SimpleChain.mergeHandlers(this.jaxrpcServerResponseHandler(), handler3);
        }
        if (this.getModeClientServer() == 1) {
            return SimpleChain.mergeHandlers(handler3, this.jaxrpcClientResponseHandler());
        }
        throw new InternalException(Messages.getMessage("soapport.csmode.undefined"));
    }

    public HandlerChain getHandlerChain() {
        return this._handlerChain;
    }

    public void setHandlerChain(HandlerChain handlerChain) {
        if (this._handlerChain != null) {
            this._handlerChain.destroy();
            if (this._handlerChainActorHeaderBindings != null) {
                this._handlerChainActorHeaderBindings.clear();
                this._handlerChainActorHeaderBindings = null;
            }
            if (this._allActorHeaderBindings != null) {
                this._allActorHeaderBindings.clear();
                this._allActorHeaderBindings = null;
            }
        }
        this._handlerChain = handlerChain;
        this.resetAdjustedRequestHandler();
        this.resetAdjustedResponseHandler();
    }

    protected Iterator getNodeActors() {
        return _defaultActors.iterator();
    }

    public void setGlobalHeaders(Collection collection) {
        this._globalHandlerHeaders = collection;
    }

    public QName[] getGlobalHeaders() {
        return (QName[])this._globalHandlerHeaders.toArray();
    }

    public void setActorHeaderBinding(ActorHeaderBindings actorHeaderBindings) {
        this._actorHeaderBindings.clear();
        if (actorHeaderBindings != null) {
            this._actorHeaderBindings = actorHeaderBindings;
        }
    }

    public void addActorHeaderBinding(String string, Collection collection) {
        this._actorHeaderBindings.addBinding(string, collection);
    }

    public void addActorHeaderBinding(String string, QName qName) {
        this._actorHeaderBindings.addBinding(string, qName);
    }

    private ActorHeaderBindings getActorHeaderBinding() {
        return this._actorHeaderBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActorHeaderBindings getHandlerChainActorHeaderBindings() {
        if (this._handlerChainActorHeaderBindings == null) {
            this._handlerChainActorHeaderBindings = new ActorHeaderBindings(this.getActorHeaderBinding());
            if (this.getHandlerChain() != null) {
                Collection collection;
                Collection collection2 = collection = this.getHandlerChain().getHeaderQNames();
                synchronized (collection2) {
                    if (this._globalHandlerHeaders != null) {
                        collection.addAll(this._globalHandlerHeaders);
                    }
                    if (collection != null) {
                        Iterator iterator = this.getHandlerChain().getRoles().iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            this._handlerChainActorHeaderBindings.addBinding(string, collection);
                        }
                    }
                }
            }
        }
        return this._handlerChainActorHeaderBindings;
    }

    ActorHeaderBindings getAllActorHeaderBindings() {
        if (this._allActorHeaderBindings == null) {
            this._allActorHeaderBindings = new ActorHeaderBindings(this.getHandlerChainActorHeaderBindings());
            Iterator iterator = this.getNodeActors();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this._allActorHeaderBindings.addActor(string);
            }
        }
        return this._allActorHeaderBindings;
    }

    public Set getOptionsBooleanNames() {
        return booleanOptions;
    }

    protected Handler jaxrpcServerRequestHandler() {
        return this.getHandlerChain() == null ? null : new BasicFullHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeServerRequestHandler(messageContext)) {
                    messageContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext messageContext) {
                try {
                    if (!JAXRPCHandler.this.invokeServerFaultHandler(messageContext)) {
                        messageContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcServerRequestHandler", (String)"249", (Object)this);
                    messageContext.setMessagePath(5);
                    log.error((Object)Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext messageContext) {
                JAXRPCHandler.this.invokeServerClosureHandler(messageContext);
            }

            public void preHandleIncoming(MessageContext messageContext) {
                JAXRPCHandler.this.invokeServerIncomingPreHandler(messageContext);
            }
        };
    }

    protected Handler jaxrpcServerResponseHandler() {
        return this.getHandlerChain() == null ? null : new BasicClosureHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeServerResponseHandler(messageContext)) {
                    messageContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext messageContext) {
                try {
                    if (!JAXRPCHandler.this.invokeServerFaultHandler(messageContext)) {
                        messageContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcServerResponseHandler", (String)"249", (Object)this);
                    messageContext.setMessagePath(5);
                    log.error((Object)Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext messageContext) {
                JAXRPCHandler.this.invokeServerClosureHandler(messageContext);
            }
        };
    }

    protected Handler jaxrpcClientRequestHandler() {
        return this.getHandlerChain() == null ? null : new BasicClosureHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeClientRequestHandler(messageContext)) {
                    messageContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext messageContext) {
                try {
                    if (!JAXRPCHandler.this.invokeClientFaultHandler(messageContext)) {
                        messageContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcClientRequestHandler", (String)"249", (Object)this);
                    messageContext.setMessagePath(5);
                    log.error((Object)Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext messageContext) {
                JAXRPCHandler.this.invokeClientClosureHandler(messageContext);
            }
        };
    }

    protected Handler jaxrpcClientResponseHandler() {
        return this.getHandlerChain() == null ? null : new BasicFullHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeClientResponseHandler(messageContext)) {
                    messageContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext messageContext) {
                try {
                    if (!JAXRPCHandler.this.invokeClientFaultHandler(messageContext)) {
                        messageContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcClientResponseHandler", (String)"249", (Object)this);
                    messageContext.setMessagePath(5);
                    log.error((Object)Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext messageContext) {
                JAXRPCHandler.this.invokeClientClosureHandler(messageContext);
            }

            public void preHandleIncoming(MessageContext messageContext) {
                JAXRPCHandler.this.invokeClientIncomingPreHandler(messageContext);
            }
        };
    }

    protected boolean invokeServerRequestHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleRequest(messageContext);
    }

    protected boolean invokeServerResponseHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleResponse(messageContext);
    }

    protected boolean invokeServerFaultHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleFault(messageContext);
    }

    protected void invokeServerClosureHandler(MessageContext messageContext) {
        this.getHandlerChain().handleClosure(messageContext);
    }

    protected void invokeServerIncomingPreHandler(MessageContext messageContext) {
        this.getHandlerChain().preHandleIncoming(messageContext);
    }

    protected boolean invokeClientRequestHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleRequest(messageContext);
    }

    protected boolean invokeClientResponseHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleResponse(messageContext);
    }

    protected boolean invokeClientFaultHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleFault(messageContext);
    }

    protected void invokeClientClosureHandler(MessageContext messageContext) {
        this.getHandlerChain().handleClosure(messageContext);
    }

    protected void invokeClientIncomingPreHandler(MessageContext messageContext) {
        this.getHandlerChain().preHandleIncoming(messageContext);
    }

    public void _destroy() {
        super._destroy();
        if (this._handlerChain != null) {
            this._handlerChain.destroy();
            this._handlerChain = null;
        }
        if (this._actorHeaderBindings != null) {
            this._actorHeaderBindings.clear();
            this._actorHeaderBindings = null;
        }
        if (this._handlerChainActorHeaderBindings != null) {
            this._handlerChainActorHeaderBindings.clear();
            this._handlerChainActorHeaderBindings = null;
        }
        if (this._allActorHeaderBindings != null) {
            this._allActorHeaderBindings.clear();
            this._allActorHeaderBindings = null;
        }
    }

    public int getModeClientServer() {
        return this._modeClientServer;
    }

    public void setModeClientServer(int n) {
        this._modeClientServer = n;
    }

    static {
        _defaultActors.add("");
        _defaultActors.add("http://schemas.xmlsoap.org/soap/actor/next");
        _defaultActors.add("http://www.w3.org/2002/06/soap-envelope/actor/next");
        booleanOptions = new HashSet<String>(Arrays.asList("sendMultiRefs", "sendXsiTypes", "sendXMLDeclaration"));
    }

    public static class ActorHeaderBindings {
        private Map bindings = new HashMap();
        private static final String emptyActor = "".intern();

        public ActorHeaderBindings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActorHeaderBindings(ActorHeaderBindings actorHeaderBindings) {
            Iterator iterator = actorHeaderBindings.bindings.entrySet().iterator();
            Map map = actorHeaderBindings.bindings;
            synchronized (map) {
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    this.addBinding((String)entry.getKey(), (Set)entry.getValue());
                }
            }
        }

        public boolean actorBoundToHeader(String string, QName qName) {
            Set set;
            boolean bl;
            if (string == null) {
                string = emptyActor;
            }
            boolean bl2 = bl = (set = (Set)this.bindings.get(string)) != null && set.contains(qName);
            if (log.isDebugEnabled()) {
                if (set == null) {
                    log.debug((Object)("actorBoundToHeader: actor \"" + string + "\" is UNDEFINED"));
                } else {
                    log.debug((Object)("actorBoundToHeader: actor \"" + string + "\" " + (set.contains(qName) ? "IS" : "IS NOT") + " bound to header \"" + qName + "\""));
                }
            }
            return bl;
        }

        public boolean nodeActorNotBoundToHeader(String string, QName qName) {
            Set set;
            boolean bl;
            if (string == null) {
                string = emptyActor;
            }
            boolean bl2 = bl = (set = (Set)this.bindings.get(string)) != null && !set.contains(qName);
            if (log.isDebugEnabled()) {
                if (set == null) {
                    log.debug((Object)("nodeActorNotBoundToHeader: actor \"" + string + "\" is UNDEFINED"));
                } else {
                    log.debug((Object)("nodeActorNotBoundToHeader: actor \"" + string + "\" " + (set.contains(qName) ? "IS" : "IS NOT") + " bound to header \"" + qName + "\""));
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBinding(String string, Collection collection) {
            if (string == null) {
                string = emptyActor;
            }
            Map map = this.bindings;
            synchronized (map) {
                Set set = this.newActor(string);
                set.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBinding(String string, QName qName) {
            if (string == null) {
                string = emptyActor;
            }
            Map map = this.bindings;
            synchronized (map) {
                Set set = this.newActor(string);
                set.add(qName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addActor(String string) {
            if (string == null) {
                string = emptyActor;
            }
            Map map = this.bindings;
            synchronized (map) {
                Set set = this.newActor(string);
            }
        }

        private Set newActor(String string) {
            Set set = (Set)this.bindings.get(string);
            if (set == null) {
                set = new QNameSet();
                this.bindings.put(string, set);
            }
            return set;
        }

        public String toString() {
            return "ActorHeaderBindings:" + this.bindings.toString();
        }

        public void clear() {
            Iterator iterator = this.bindings.values().iterator();
            while (iterator.hasNext()) {
                Set set = (Set)iterator.next();
                set.clear();
            }
            this.bindings.clear();
        }
    }

    public static class QNameSet
    extends TreeSet {
        private static final Comparator qnameComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                String string = object == null ? "null" : object.toString();
                String string2 = object2 == null ? "null" : object2.toString();
                return string.compareTo(string2);
            }
        };

        public QNameSet() {
            super(qnameComparator);
        }
    }

    protected static abstract class BasicClosureHandler
    extends BasicHandler
    implements ClosureHandler {
        protected BasicClosureHandler() {
        }
    }

    protected static abstract class BasicFullHandler
    extends BasicHandler
    implements ClosureHandler,
    PreHandler {
        protected BasicFullHandler() {
        }
    }
}

