/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.utils.Target;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class BeanPropertyTarget
implements Target {
    protected static Log log = LogFactory.getLog(BeanPropertyTarget.class.getName());
    private Object object;
    private BeanPropertyDescriptor pd;
    private int index = -1;

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor beanPropertyDescriptor) {
        this.object = object;
        this.pd = beanPropertyDescriptor;
        this.index = -1;
    }

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor beanPropertyDescriptor, int n) {
        this.object = object;
        this.pd = beanPropertyDescriptor;
        this.index = n;
    }

    public void set(Object object) throws SAXException {
        try {
            if (this.index < 0) {
                this.pd.set(this.object, object);
            } else {
                this.pd.set(this.object, this.index, object);
            }
        }
        catch (Exception exception) {
            try {
                Class clazz = this.pd.getType();
                if (JavaUtils.isConvertable(object, clazz)) {
                    object = JavaUtils.convert(object, clazz);
                    if (this.index < 0) {
                        this.pd.set(this.object, object);
                    } else {
                        this.pd.set(this.object, this.index, object);
                    }
                }
                if (this.index == 0 && object.getClass().isArray() && !clazz.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object object2 = JavaUtils.convert(Array.get(object, i), clazz);
                        this.pd.set(this.object, i, object2);
                    }
                }
                throw exception;
            }
            catch (Exception exception2) {
                Object object3;
                FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.webservices.engine.encoding.utils.BeanPropertyTarget.set", (String)"169", (Object)this);
                String string = this.pd.getName();
                if (this.index >= 0) {
                    string = string + "[" + this.index + "]";
                }
                if (log.isErrorEnabled()) {
                    object3 = "null";
                    if (object != null) {
                        object3 = object.getClass().getName();
                    }
                    log.error((Object)Messages.getMessage("cantConvert02", new String[]{object3, string, this.pd.getType().getName()}));
                }
                if (exception2 instanceof InvocationTargetException && (object3 = ((InvocationTargetException)exception2).getTargetException()) != null) {
                    throw new SAXException(((Throwable)object3).getMessage());
                }
                throw new SAXException(exception2);
            }
        }
    }
}

