/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.description;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.ServiceConfig;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.BaseDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor;
import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class PortDesc
extends BaseDesc {
    protected static Log log = LogFactory.getLog(PortDesc.class.getName());
    private String name = null;
    private List allowedMethods = null;
    private List disallowedMethods = null;
    private Class implClass = null;
    private ArrayList operations = new ArrayList();
    private List namespaceMappings = new ArrayList();
    private String wsdlFileName = null;
    private QName wsdlPort = null;
    private String endpointURL = null;
    private ArrayList stopClasses = null;
    private HashMap name2OperationsMap = null;
    private HashMap qname2OperationsMap = null;
    private HashMap method2OperationMap = new HashMap();
    private HashMap method2ParamsMap = new HashMap();
    private ArrayList completedNames = new ArrayList();
    private TypeMapping tm = DefaultTypeMappingImpl.getSingleton();
    private TypeMappingRegistry tmr = null;
    private boolean introspectionComplete = false;
    private boolean introspectionMode = true;
    private boolean highFidelityRecording = false;
    private int sendType = 1;
    private Set portOperationHeaders = null;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    public void disableIntrospection() {
        this.introspectionMode = false;
    }

    public boolean needsHighFidelityRecording() {
        return this.highFidelityRecording;
    }

    public void setHighFidelityRecording(boolean bl) {
        this.highFidelityRecording = bl;
    }

    public int getSendType() {
        return this.sendType;
    }

    public void setSendType(int n) {
        this.sendType = n;
    }

    public String getWSDLFile() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String string) {
        this.wsdlFileName = string;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List list) {
        this.allowedMethods = list;
    }

    public Class getImplClass() {
        return this.implClass;
    }

    public synchronized void setImplClass(Class clazz) {
        if (this.implClass != null) {
            throw new IllegalArgumentException(Messages.getMessage("implAlreadySet"));
        }
        this.implClass = clazz;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setStopClasses(ArrayList arrayList) {
        this.stopClasses = arrayList;
    }

    public List getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setDisallowedMethods(List list) {
        this.disallowedMethods = list;
    }

    public synchronized void addOperationDesc(OperationDesc operationDesc) {
        this.addOperationDesc(operationDesc, true);
    }

    private synchronized void addOperationDesc(OperationDesc operationDesc, boolean bl) {
        String string;
        ArrayList<OperationDesc> arrayList;
        if (this.operations.contains(operationDesc)) {
            return;
        }
        if (bl) {
            this.disableIntrospection();
        }
        this.operations.add(operationDesc);
        operationDesc.setParent(this);
        if (this.name2OperationsMap == null) {
            this.name2OperationsMap = new HashMap();
        }
        if ((arrayList = (ArrayList<OperationDesc>)this.name2OperationsMap.get(string = operationDesc.getName())) == null) {
            arrayList = new ArrayList<OperationDesc>();
            this.name2OperationsMap.put(string, arrayList);
        }
        arrayList.add(operationDesc);
    }

    public synchronized ArrayList getOperations() {
        if (!this.introspectionComplete) {
            this.loadPortDescByIntrospection();
        }
        if (this.implClass != null) {
            for (int i = 0; i < this.operations.size(); ++i) {
                OperationDesc operationDesc = (OperationDesc)this.operations.get(i);
                if (operationDesc.getMethod() != null) continue;
                this.syncOperationToClass(operationDesc, this.implClass);
            }
        }
        return this.operations;
    }

    public synchronized OperationDesc[] getOperationsByName(String string) {
        this.getSyncedOperationsForName(this.implClass, string);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.name2OperationsMap.get(string);
        if (arrayList == null) {
            return null;
        }
        OperationDesc[] operationDescArray = new OperationDesc[arrayList.size()];
        return arrayList.toArray(operationDescArray);
    }

    public synchronized OperationDesc getOperationByName(String string) {
        this.getSyncedOperationsForName(this.implClass, string);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.name2OperationsMap.get(string);
        if (arrayList == null) {
            return null;
        }
        return (OperationDesc)arrayList.get(0);
    }

    public synchronized OperationDesc getOperationByElementQName(QName qName) {
        OperationDesc[] operationDescArray = this.getOperationsByQName(qName);
        if (operationDescArray != null && operationDescArray.length > 0) {
            return operationDescArray[0];
        }
        return null;
    }

    public synchronized OperationDesc[] getOperationsByQName(QName qName) {
        this.initQNameMap();
        ArrayList arrayList = (ArrayList)this.qname2OperationsMap.get(qName);
        if (arrayList == null) {
            if (this.name2OperationsMap != null) {
                arrayList = (ArrayList)this.name2OperationsMap.get(qName.getLocalPart());
            }
            if (arrayList == null) {
                return null;
            }
        }
        this.getSyncedOperationsForName(this.implClass, ((OperationDesc)arrayList.get(0)).getName());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Method method = ((OperationDesc)object).getMethod();
                Method method2 = ((OperationDesc)object2).getMethod();
                return method.getParameterTypes().length - method2.getParameterTypes().length;
            }
        });
        OperationDesc[] operationDescArray = new OperationDesc[arrayList.size()];
        return arrayList.toArray(operationDescArray);
    }

    private synchronized void initQNameMap() {
        if (this.qname2OperationsMap == null) {
            this.loadPortDescByIntrospection();
            this.qname2OperationsMap = new HashMap();
            Iterator iterator = this.operations.iterator();
            while (iterator.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)iterator.next();
                ArrayList<OperationDesc> arrayList = (ArrayList<OperationDesc>)this.qname2OperationsMap.get(operationDesc.getElementQName());
                if (arrayList == null) {
                    arrayList = new ArrayList<OperationDesc>();
                    this.qname2OperationsMap.put(operationDesc.getElementQName(), arrayList);
                }
                arrayList.add(operationDesc);
            }
        }
    }

    private synchronized void syncOperationToClass(OperationDesc operationDesc, Class clazz) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)("SYNC! " + clazz + " " + operationDesc));
        }
        if (operationDesc.getMethod() != null) {
            return;
        }
        Method[] methodArray = this.priviledgedGetDeclaredMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz2;
            int n;
            Class<?>[] classArray;
            object = methodArray[i];
            if (!Modifier.isPublic(((Method)object).getModifiers()) || !((Method)object).getName().equals(operationDesc.getName()) || (classArray = ((Method)object).getParameterTypes()).length != operationDesc.getNumParams()) continue;
            for (n = 0; n < classArray.length; ++n) {
                ParameterDesc parameterDesc;
                QName qName;
                Class<?> clazz3 = clazz2 = classArray[n];
                if ((class$javax$xml$rpc$holders$Holder == null ? PortDesc.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom(clazz2)) {
                    clazz3 = JavaUtils.getHolderValueType(clazz2);
                }
                if ((qName = (parameterDesc = operationDesc.getParameter(n)).getTypeQName()) == null) {
                    qName = this.tm.getTypeQName(clazz3);
                    parameterDesc.setTypeQName(qName);
                } else {
                    Class clazz4 = parameterDesc.getJavaType();
                    if (clazz4 != null && JavaUtils.getHolderValueType(clazz4) != null) {
                        clazz4 = JavaUtils.getHolderValueType(clazz4);
                    }
                    if (clazz4 == null) {
                        clazz4 = this.tm.getClassForQName(parameterDesc.getTypeQName());
                    }
                    if (!JavaUtils.isConvertable(clazz4, clazz3)) break;
                }
                parameterDesc.setJavaSigType(clazz2);
            }
            if (n != classArray.length) continue;
            clazz2 = ((Method)object).getReturnType();
            if (clazz2 != Void.TYPE) {
                operationDesc.setReturnClass(clazz2);
            }
            operationDesc.setMethod((Method)object);
            this.method2OperationMap.put(object, operationDesc);
            return;
        }
        Class clazz5 = clazz.getSuperclass();
        if (!(clazz5 == null || clazz5.getName().startsWith("java.") || clazz5.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(clazz5.getName()))) {
            this.syncOperationToClass(operationDesc, clazz5);
        }
        if (operationDesc.getMethod() == null) {
            object = new InternalException(Messages.getMessage("methodSyncErr00", operationDesc.getName(), clazz.getName(), this.toString()));
            throw object;
        }
    }

    public synchronized void loadPortDescByIntrospection() {
        this.loadPortDescByIntrospection(this.implClass);
        this.completedNames = null;
    }

    private synchronized Method priviledgedGetDeclaredMethod(final Class clazz, final String string, final Class[] classArray) throws Exception {
        return (Method)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return clazz.getDeclaredMethod(string, classArray);
            }
        });
    }

    private synchronized Method[] priviledgedGetDeclaredMethods(final Class clazz) {
        try {
            return (Method[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    return clazz.getDeclaredMethods();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.webservices.engine.description.PortDesc.priviledgedGetDeclaredMethods", (String)"730", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)privilegedActionException);
            return new Method[0];
        }
    }

    public synchronized void loadPortDescByIntrospection(Class clazz) {
        Serializable serializable;
        Iterator iterator;
        if (this.introspectionComplete || clazz == null) {
            return;
        }
        this.implClass = clazz;
        ServiceConfig serviceConfig = null;
        try {
            iterator = this.priviledgedGetDeclaredMethod(clazz, "getServiceConfig", new Class[0]);
            if (iterator != null && Modifier.isStatic(((Method)((Object)iterator)).getModifiers())) {
                serviceConfig = (ServiceConfig)((Method)((Object)iterator)).invoke(null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serviceConfig != null && (iterator = serviceConfig.getAllowedMethods()) != null && !"*".equals(iterator)) {
            serializable = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer((String)((Object)iterator), " ,");
            while (stringTokenizer.hasMoreTokens()) {
                ((ArrayList)serializable).add(stringTokenizer.nextToken());
            }
            this.setAllowedMethods((List)((Object)serializable));
        }
        this.loadPortDescByIntrospectionRecursive(clazz);
        iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            serializable = (OperationDesc)iterator.next();
            if (((OperationDesc)serializable).getMethod() != null) continue;
            throw new InternalException(Messages.getMessage("badWSDDOperation", ((OperationDesc)serializable).getName(), "Debug Info: " + this.toString()));
        }
        this.introspectionComplete = true;
    }

    private synchronized void loadPortDescByIntrospectionRecursive(Class clazz) {
        Method[] methodArray = this.priviledgedGetDeclaredMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            if (!Modifier.isPublic(methodArray[i].getModifiers())) continue;
            this.getSyncedOperationsForName(clazz, methodArray[i].getName());
        }
        if (clazz.isInterface()) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                if (this.stopClasses != null && this.stopClasses.contains(clazz2.getName())) continue;
                this.loadPortDescByIntrospectionRecursive(clazz2);
            }
        } else {
            Class clazz3 = clazz.getSuperclass();
            if (!(clazz3 == null || clazz3.getName().startsWith("java.") || clazz3.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(clazz3.getName()))) {
                this.loadPortDescByIntrospectionRecursive(clazz3);
            }
        }
    }

    public synchronized void loadPortDescByIntrospection(Class clazz, TypeMapping typeMapping) {
        this.implClass = clazz;
        this.tm = typeMapping;
        this.loadPortDescByIntrospection();
    }

    private synchronized void getSyncedOperationsForName(Class clazz, String string) {
        ArrayList arrayList;
        if (clazz == null) {
            return;
        }
        if (this.completedNames == null || this.completedNames.contains(string)) {
            return;
        }
        if (this.allowedMethods != null && !this.allowedMethods.contains(string)) {
            return;
        }
        if (this.disallowedMethods != null && this.disallowedMethods.contains(string)) {
            return;
        }
        if (this.name2OperationsMap != null && (arrayList = (ArrayList)this.name2OperationsMap.get(string)) != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)iterator.next();
                if (operationDesc.getMethod() != null) continue;
                this.syncOperationToClass(operationDesc, clazz);
            }
        }
        if (this.introspectionMode) {
            this.createOperationsForName(clazz, string);
        }
        this.completedNames.add(string);
    }

    private synchronized void createOperationsForName(Class clazz, String string) {
        if (!this.introspectionMode) {
            return;
        }
        Method[] methodArray = this.priviledgedGetDeclaredMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(string)) continue;
            this.createOperationForMethod(method);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && !clazz2.getName().startsWith("java.") && !clazz2.getName().startsWith("javax.")) {
            this.createOperationsForName(clazz2, string);
        }
    }

    private synchronized void createOperationForMethod(Method method) {
        int n;
        Object[] objectArray;
        GenericDeclaration genericDeclaration;
        Object object;
        ArrayList arrayList;
        if (!this.introspectionMode) {
            return;
        }
        if (this.method2OperationMap.get(method) != null) {
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        ArrayList arrayList2 = arrayList = this.name2OperationsMap == null ? null : (ArrayList)this.name2OperationsMap.get(method.getName());
        if (arrayList != null && !arrayList.isEmpty()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (OperationDesc)arrayList.get(i);
                genericDeclaration = ((OperationDesc)object).getMethod();
                if (genericDeclaration == null || classArray.length != (objectArray = genericDeclaration.getParameterTypes()).length) continue;
                for (n = 0; n < objectArray.length && objectArray[n].equals(classArray[n]); ++n) {
                }
                if (n != objectArray.length) continue;
                return;
            }
        }
        OperationDesc operationDesc = new OperationDesc();
        operationDesc.setName(method.getName());
        object = "";
        if (!this.namespaceMappings.isEmpty()) {
            object = (String)this.namespaceMappings.get(0);
        }
        operationDesc.setElementQName(QNameTable.createQName((String)object, method.getName()));
        operationDesc.setMethod(method);
        genericDeclaration = method.getReturnType();
        operationDesc.setReturnClass((Class)genericDeclaration);
        operationDesc.setReturnType(this.tm.getTypeQName(method.getReturnType()));
        objectArray = this.getParamNames(method);
        for (n = 0; n < classArray.length; ++n) {
            Class<?> clazz = classArray[n];
            ParameterDesc parameterDesc = new ParameterDesc();
            if (objectArray != null && objectArray[n] != null && ((String)objectArray[n]).length() > 0) {
                parameterDesc.setName((String)objectArray[n]);
            } else {
                parameterDesc.setName("in" + n);
            }
            Class clazz2 = JavaUtils.getHolderValueType(clazz);
            if (clazz2 != null) {
                parameterDesc.setMode((byte)3);
                parameterDesc.setTypeQName(this.tm.getTypeQName(clazz2));
            } else {
                parameterDesc.setMode((byte)1);
                parameterDesc.setTypeQName(this.tm.getTypeQName(clazz));
            }
            parameterDesc.setJavaType(clazz);
            operationDesc.addParameter(parameterDesc);
        }
        this.addOperationDesc(operationDesc, false);
        this.method2OperationMap.put(method, operationDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getParamNames(Method method) {
        HashMap hashMap = this.method2ParamsMap;
        synchronized (hashMap) {
            String[] stringArray = (String[])this.method2ParamsMap.get(method);
            if (stringArray != null) {
                return stringArray;
            }
            stringArray = ParamNameExtractor.getParameterNamesFromDebugInfo(method);
            this.method2ParamsMap.put(method, stringArray);
            return stringArray;
        }
    }

    public void setNamespaceMappings(List list) {
        this.namespaceMappings = list == null ? new ArrayList() : list;
    }

    public List getNamespaceMappings() {
        return this.namespaceMappings;
    }

    public String getDefaultNamespace() {
        if (this.namespaceMappings.isEmpty()) {
            return null;
        }
        return (String)this.namespaceMappings.get(0);
    }

    public void setDefaultNamespace(String string) {
        this.namespaceMappings.add(0, string);
    }

    public void setProperty(String string, Object object) {
        this.setOption(string, object);
    }

    public Object getProperty(String string) {
        return this.getOption(string);
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String string) {
        this.endpointURL = string;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl();
        }
        return this.tmr;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.tmr = typeMappingRegistry;
    }

    public QName getWSDLPort() {
        return this.wsdlPort;
    }

    public void setWSDLPort(QName qName) {
        this.wsdlPort = qName;
    }

    public Set getPortOperationHeaders() {
        return this.portOperationHeaders;
    }

    public void setPortOperationHeaders(Set set) {
        this.portOperationHeaders = set;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "name:            " + this.getName() + "\n";
        string2 = string2 + string + "implClass:       " + this.getImplClass() + "\n";
        if (this.getImplClass() != null) {
            string2 = string2 + string + "implClassLoader: " + this.getImplClass().getClassLoader() + "\n";
        }
        string2 = string2 + string + "defaultNS:       " + this.getDefaultNamespace() + "\n";
        string2 = string2 + string + "endpointURL:     " + this.getEndpointURL() + "\n";
        if (this.operations != null) {
            for (int i = 0; i < this.operations.size(); ++i) {
                string2 = string2 + string + " OperationDesc[" + i + "]:\n";
                string2 = string2 + string + ((OperationDesc)this.operations.get(i)).toString("  ") + "\n";
            }
        }
        return string2;
    }
}

