/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfo;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPHandlerChain;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleOwner;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleSetImpl;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleSet;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.wsspi.webservices.rpc.handler.Handler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDJAXRPCHandlerInfoChain
extends WSDDElement
implements _LifeCycleObject {
    private static Log log = LogFactory.getLog(WSDDJAXRPCHandlerInfoChain.class.getName());
    private final boolean _reverse;
    private boolean _dirty = false;
    private boolean _specSemantic = true;
    private List _hiList;
    private Collection _roles;
    private List _globalHeaders;
    private _LifeCycleSet _lifeCycleSet;

    public WSDDJAXRPCHandlerInfoChain(boolean bl) {
        this(bl, true);
    }

    public WSDDJAXRPCHandlerInfoChain(boolean bl, boolean bl2) {
        this._reverse = bl;
        this._specSemantic = bl2;
        this._lifeCycleSet = this.lifeCycleSetFactory(this);
    }

    public WSDDJAXRPCHandlerInfoChain(boolean bl, Element element) throws WSDDException {
        super(element);
        int n;
        this._reverse = bl;
        this._lifeCycleSet = this.lifeCycleSetFactory(this);
        Element[] elementArray = this.getChildElements(element, "handlerInfo");
        if (elementArray.length != 0) {
            for (n = 0; n < elementArray.length; ++n) {
                this.addHandlerInfo(new WSDDJAXRPCHandlerInfo(elementArray[n]));
            }
        }
        if ((elementArray = this.getChildElements(element, "role")).length != 0) {
            this._roles = new TreeSet();
            for (n = 0; n < elementArray.length; ++n) {
                String string = elementArray[n].getAttribute("soapActorName");
                this._roles.add(string);
            }
        }
    }

    protected QName getElementName() {
        return WSDDConstants.QNAME_JAXRPC_HANDLERINFOCHAIN;
    }

    public List getHandlerInfoList() {
        this._dirty = true;
        return this._hiList;
    }

    public void setHandlerInfoList(List list) {
        this._dirty = true;
        this._hiList = list;
    }

    public void addHandlerInfoList(List list) {
        if (list != null) {
            if (this._hiList == null) {
                this._hiList = new ArrayList();
            }
            this._dirty = true;
            this._hiList.addAll(list);
        }
    }

    public void addHandlerInfo(WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo) {
        if (wSDDJAXRPCHandlerInfo != null) {
            if (this._hiList == null) {
                this._hiList = new ArrayList();
            }
            this._dirty = true;
            this._hiList.add(wSDDJAXRPCHandlerInfo);
        }
    }

    public List getProtectedHeaders() {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        if (this._hiList != null) {
            Iterator iterator = this._hiList.iterator();
            while (iterator.hasNext()) {
                QName[] qNameArray;
                WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = (WSDDJAXRPCHandlerInfo)iterator.next();
                if (wSDDJAXRPCHandlerInfo == null || (qNameArray = wSDDJAXRPCHandlerInfo.getProtectedHeaders()) == null || qNameArray.length == 0) continue;
                for (int i = 0; i < qNameArray.length; ++i) {
                    arrayList.add(qNameArray[i]);
                }
            }
        }
        return arrayList;
    }

    public List getAllHeaders() {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        if (this._hiList != null) {
            Iterator iterator = this._hiList.iterator();
            while (iterator.hasNext()) {
                QName[] qNameArray;
                WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = (WSDDJAXRPCHandlerInfo)iterator.next();
                if (wSDDJAXRPCHandlerInfo == null || (qNameArray = wSDDJAXRPCHandlerInfo.getHeaders()) == null || qNameArray.length == 0) continue;
                for (int i = 0; i < qNameArray.length; ++i) {
                    arrayList.add(qNameArray[i]);
                }
            }
        }
        return arrayList;
    }

    public void addGlobalHeaders(List list) {
        if (list != null) {
            if (this._globalHeaders == null) {
                this._globalHeaders = new ArrayList();
            }
            this._globalHeaders.addAll(list);
        }
    }

    public List getGlobalHeaders() {
        return this._globalHeaders;
    }

    public Collection getRoles() {
        return this._roles;
    }

    public void setRoles(Collection collection) {
        this._roles = collection;
    }

    public void addRole(String string) {
        if (this._roles == null) {
            this._roles = new TreeSet();
        }
        this._roles.add(string);
    }

    public void addRoles(Collection collection) {
        if (collection != null) {
            if (this._roles == null) {
                this._roles = new TreeSet();
            }
            this._roles.addAll(collection);
        }
    }

    public HandlerChain getHandlerChain() {
        if (this._dirty) {
            this.sort();
        }
        ArrayList<ExtendedHandlerInfo> arrayList = new ArrayList<ExtendedHandlerInfo>();
        if (this._hiList != null) {
            for (int i = 0; i < this._hiList.size(); ++i) {
                WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = (WSDDJAXRPCHandlerInfo)this._hiList.get(i);
                try {
                    ExtendedHandlerInfo extendedHandlerInfo = wSDDJAXRPCHandlerInfo.getHandlerInfo();
                    if (extendedHandlerInfo == null) continue;
                    arrayList.add(extendedHandlerInfo);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain.getHandlerChain", (String)"109", null);
                    log.warn((Object)Messages.getMessage("jaxRpcHandlerLoadFailed00", wSDDJAXRPCHandlerInfo.getHandlerClassName()), (Throwable)classNotFoundException);
                }
            }
        }
        return this._specSemantic ? new SOAPHandlerChain(arrayList, this._roles) : new JAXRPCHandlerChain(arrayList, this._roles);
    }

    public int size() {
        return this._hiList == null ? 0 : this._hiList.size();
    }

    private void sort() {
        if (this._hiList != null) {
            int n;
            if (this._reverse) {
                Collections.sort(this._hiList, Collections.reverseOrder());
                n = this._hiList.size() - 1;
                for (int i = 0; i <= n; ++i) {
                    WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = (WSDDJAXRPCHandlerInfo)this._hiList.get(i);
                    wSDDJAXRPCHandlerInfo.putHandlerMap(Handler.HANDLER_PARAM_POSITION, String.valueOf(n - i));
                }
            } else {
                Collections.sort(this._hiList);
                for (n = 0; n < this._hiList.size(); ++n) {
                    WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = (WSDDJAXRPCHandlerInfo)this._hiList.get(n);
                    wSDDJAXRPCHandlerInfo.putHandlerMap(Handler.HANDLER_PARAM_POSITION, String.valueOf(n));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("HandlerInfoChain: reverse=" + this._reverse));
                for (n = 0; n < this._hiList.size(); ++n) {
                    WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = (WSDDJAXRPCHandlerInfo)this._hiList.get(n);
                    log.debug((Object)("Handler: name=" + wSDDJAXRPCHandlerInfo.getName() + ", class=" + wSDDJAXRPCHandlerInfo.getHandlerClassName() + ", priority=" + wSDDJAXRPCHandlerInfo.getPriority() + ", poolMin=" + wSDDJAXRPCHandlerInfo.getMinPoolSize() + ", poolMax=" + wSDDJAXRPCHandlerInfo.getMaxPoolSize()));
                }
            }
            this._dirty = false;
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        Object object;
        Iterator iterator;
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "reverse", "reverse", "CDATA", String.valueOf(this._reverse));
        attributesImpl.addAttribute("", "specSemantic", "specSemantic", "CDATA", String.valueOf(this._specSemantic));
        serializationContext.getSerializationWriter().startElement(QNAME_JAXRPC_HANDLERINFOCHAIN, attributesImpl);
        if (this._dirty) {
            this.sort();
        }
        if (this._hiList != null) {
            iterator = this._hiList.iterator();
            while (iterator.hasNext()) {
                object = (WSDDJAXRPCHandlerInfo)iterator.next();
                ((WSDDJAXRPCHandlerInfo)object).writeToContext(serializationContext);
            }
        }
        if (this._roles != null && this._roles.size() > 0) {
            iterator = this._roles.iterator();
            while (iterator.hasNext()) {
                object = new AttributesImpl();
                ((AttributesImpl)object).addAttribute("", "soapActorName", "soapActorName", "CDATA", (String)iterator.next());
                serializationContext.getSerializationWriter().simpleElement(QNAME_JAXRPC_ROLE, (Attributes)object, null);
            }
        } else {
            serializationContext.getSerializationWriter().simpleElement(QNAME_JAXRPC_ROLE, null, null);
        }
        serializationContext.getSerializationWriter().endElement();
    }

    protected LifeCycleSetImpl lifeCycleSetFactory(_LifeCycleObject _LifeCycleObject2) {
        return new LifeCycleSetImpl(_LifeCycleObject2, true, false);
    }

    public void setOwner(LifeCycleOwner lifeCycleOwner) throws LifeCycleException {
        this._lifeCycleSet.setOwner(lifeCycleOwner);
    }

    public LifeCycleOwner getOwner() {
        return this._lifeCycleSet.getOwner();
    }

    public final void init() throws LifeCycleException {
        this._lifeCycleSet.init();
    }

    public void _init() throws LifeCycleException {
        this._lifeCycleSet._init();
    }

    public final void destroy() {
        this._lifeCycleSet.destroy();
    }

    public void _destroy() {
        if (this._hiList != null) {
            this._hiList.clear();
            this._hiList = null;
        }
        this._roles = null;
        this._lifeCycleSet._destroy();
    }

    public int getState() {
        return this._lifeCycleSet.getState();
    }

    public boolean isActive() {
        return this._lifeCycleSet.isActive();
    }

    public void verifyActive() throws LifeCycleException {
        this._lifeCycleSet.verifyActive();
    }

    public void verifyInactive() throws LifeCycleException {
        this._lifeCycleSet.verifyInactive();
    }
}

