/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDocumentation;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class WSDDElement
extends WSDDConstants
implements Serializable {
    private static Log log = LogFactory.getLog(WSDDElement.class.getName());
    private WSDDDocumentation documentation = null;

    public WSDDElement() {
    }

    public WSDDElement(Element element) throws WSDDException {
        this.validateCandidateElement(element);
    }

    protected abstract QName getElementName();

    private void validateCandidateElement(Element element) throws WSDDException {
        QName qName = this.getElementName();
        String string = element.getLocalName().equals("requestFlow") || element.getLocalName().equals("responseFlow") ? "chain" : element.getLocalName();
        if (null == element || null == element.getNamespaceURI() || null == string || !element.getNamespaceURI().equals(qName.getNamespaceURI()) || !string.equals(qName.getLocalPart())) {
            throw new WSDDException(Messages.getMessage("invalidWSDD00", element.toString(), qName.toString()));
        }
    }

    public Element getChildElement(Element element, String string) {
        Element[] elementArray = this.getChildElements(element, string);
        if (elementArray.length == 0) {
            return null;
        }
        return elementArray[0];
    }

    public Element[] getChildElements(Element element, String string) {
        Element[] elementArray;
        Vector<Element> vector = new Vector<Element>();
        for (elementArray = element.getFirstChild(); elementArray != null; elementArray = elementArray.getNextSibling()) {
            Element element2;
            if (!(elementArray instanceof Element) || !(element2 = (Element)elementArray).getLocalName().equals(string)) continue;
            vector.add(element2);
        }
        elementArray = new Element[vector.size()];
        vector.toArray(elementArray);
        return elementArray;
    }

    public WSDDDocumentation getDocumentation() {
        return this.documentation;
    }

    public abstract void writeToContext(SerializationContext var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument() throws ConfigurationException {
        StringWriter stringWriter = new StringWriter();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            try {
                SerializationContextImpl serializationContextImpl = new SerializationContextImpl(bufferedWriter, null);
                serializationContextImpl.getSerializationWriter().setPretty(true);
                this.writeToContext(serializationContextImpl);
            }
            finally {
                ((Writer)bufferedWriter).close();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement.getDocument", (String)"234", (Object)this);
            throw WSDDException.makeWSDDException(iOException);
        }
        try {
            return XMLUtils.newDocument(new InputSource(new StringReader(stringWriter.getBuffer().toString())));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement.getDocument", (String)"241", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
            return null;
        }
    }

    public void dump() {
        if (log.isDebugEnabled()) {
            try {
                Document document = this.getDocument();
                log.debug((Object)(this.getElementName().getLocalPart() + " is\n" + XMLUtils.DocumentToString(document)));
            }
            catch (IOException iOException) {
                log.debug((Object)Messages.getMessage("dumpService.failed"), (Throwable)iOException);
            }
        }
    }
}

