/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configuration;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.EngineConfigurationFactory;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.tools.ClassUtils;
import org.apache.commons.logging.Log;

public class EngineConfigurationFactoryFinder {
    protected static Log log = LogFactory.getLog(EngineConfigurationFactoryFinder.class.getName());
    private static final Class mySpi = EngineConfigurationFactory.class;
    private static final Class myFactory = EngineConfigurationFactoryFinder.class;
    private static final Class[] newFactoryParamTypes = new Class[]{Object.class};
    private static final String requiredMethod = "public static EngineConfigurationFactory newFactory(Object)";

    private EngineConfigurationFactoryFinder() {
    }

    public static EngineConfigurationFactory newFactory(Object object) {
        final Object[] objectArray = new Object[]{object};
        return (EngineConfigurationFactory)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator resourceClassIterator = WebServicesProperties.getResourceClassIterator(mySpi);
                Object object = null;
                while (object == null && resourceClassIterator.hasNext()) {
                    Class clazz = resourceClassIterator.nextResourceClass().loadClass();
                    if (clazz == null) continue;
                    object = EngineConfigurationFactoryFinder.newFactory(clazz, newFactoryParamTypes, objectArray);
                }
                if (object != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage("engineFactory", object.getClass().getName()));
                    }
                } else {
                    log.error((Object)Messages.getMessage("engineConfigFactoryMissing"));
                }
                return object;
            }
        });
    }

    public static EngineConfigurationFactory newFactory() {
        return EngineConfigurationFactoryFinder.newFactory(null);
    }

    private static EngineConfigurationFactory newFactory(Class clazz, Class[] classArray, Object[] objectArray) {
        block9: {
            try {
                Method method = ClassUtils.findPublicStaticMethod((Class)clazz, (Class)EngineConfigurationFactory.class, (String)"newFactory", (Class[])classArray);
                if (method == null) {
                    log.warn((Object)Messages.getMessage("engineConfigMissingNewFactory", clazz.getName(), requiredMethod));
                    break block9;
                }
                try {
                    return (EngineConfigurationFactory)method.invoke(null, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder.newFactory", (String)"223");
                    if (invocationTargetException.getTargetException() instanceof NoClassDefFoundError) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)Messages.getMessage("engineConfigLoadFactory", clazz.getName()));
                        }
                    } else {
                        log.warn((Object)Messages.getMessage("engineConfigInvokeNewFactory", clazz.getName(), requiredMethod), (Throwable)invocationTargetException);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder.newFactory", (String)"255");
                    log.warn((Object)Messages.getMessage("engineConfigInvokeNewFactory", clazz.getName(), requiredMethod), (Throwable)exception);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder.newFactory", (String)"262");
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)Messages.getMessage("engineConfigLoadFactory", clazz.getName()));
            }
        }
        return null;
    }

    static {
        WebServicesProperties.setClassOverrideProperty(EngineConfigurationFactory.class, "webservices.EngineConfigFactory");
        WebServicesProperties.setClassDefaults(EngineConfigurationFactory.class, new String[]{"com.ibm.ws.webservices.engine.configuration.DefaultEngineConfigurationFactory"});
    }
}

