/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.net;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.InvalidPasswordDecodingException;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.ssl.SSLConfig;
import com.ibm.ws.webservices.component.WSServerImpl;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;

public class SSLConfiguration {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register((Class)SSLConfiguration.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    public static final String configURLProperty = "com.ibm.CORBA.ConfigURL";
    public static final String wsSSLconfigURLProperty = "com.ibm.webservices.sslConfigURL";
    private String sslAliasConfigured = null;
    private SSLConfig sslConfigured = null;
    private boolean asServer = false;
    private static final String[] passwordList = new String[]{"com.ibm.ssl.keyStorePassword", "com.ibm.ssl.trustStorePassword", "com.ibm.ssl.tokenPassword"};
    private static Map pwMap = null;

    public SSLConfiguration(boolean bl) {
        this.sslConfigured = new SSLConfig(bl);
        this.asServer = bl;
        DefaultHTTPSTransportClientProperties defaultHTTPSTransportClientProperties = (DefaultHTTPSTransportClientProperties)TransportClientPropertiesFactory.create("https");
        String string = this.sslAliasConfigured = defaultHTTPSTransportClientProperties == null ? null : defaultHTTPSTransportClientProperties.getSSLConfigurationName();
        if (bl && !JavaUtils.hasValue(this.sslAliasConfigured)) {
            Tr.debug((TraceComponent)_tc, (String)"No SSL Alias was found.");
        }
        if (pwMap == null) {
            pwMap = new HashMap();
            for (int i = 0; i < passwordList.length; ++i) {
                pwMap.put(passwordList[i], "");
            }
        }
    }

    public String getIdentityKey() {
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)Messages.getMessage("enter00", "SSLConfiguration.getIdentityKey()"));
        }
        String string = null;
        Properties properties = null;
        if (this.asServer) {
            if (JavaUtils.hasValue(this.sslAliasConfigured) && (object = WSServerImpl.getSecurityService()) != null && JavaUtils.hasValue(this.sslAliasConfigured)) {
                properties = object.getSecureSocketLayer(this.sslAliasConfigured);
            }
        } else {
            properties = this.getPropertiesObject();
        }
        if (properties != null && JavaUtils.hasValue(string = properties.getProperty("com.ibm.ssl.keyStore")) && JavaUtils.hasValue((String)(object = properties.getProperty("com.ibm.ssl.keyStoreClientAlias")))) {
            string = string + " : " + (String)object;
        }
        if (string == null) {
            string = System.getProperty("javax.net.ssl.keyStore");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)Messages.getMessage("exit00", "SSLConfiguration.getIdentityKey()"));
        }
        return string;
    }

    public String configuredSSLAlias() {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)Messages.getMessage("enter00", "SSLConfiguration.configuredSSLAlias()..."));
            if (this.asServer) {
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"asServer=true; running on an application server");
                }
                Properties properties = null;
                if (JavaUtils.hasValue(this.sslAliasConfigured)) {
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("sslConfiguration00", this.sslAliasConfigured));
                    SecurityService securityService = WSServerImpl.getSecurityService();
                    if (securityService != null && JavaUtils.hasValue(this.sslAliasConfigured)) {
                        properties = securityService.getSecureSocketLayer(this.sslAliasConfigured);
                    }
                } else if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"No SSL Alias was found.");
                    Tr.event((TraceComponent)_tc, (String)"Either no SSL alias is configured on the port component binding, or the application is not JSR-109 compliant.");
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("sslConfiguration00", "JSSE"));
                }
                SSLConfiguration.printInfofromProperties(properties);
            } else {
                Tr.event((TraceComponent)_tc, (String)"asServer=false; NOT running on an application server");
            }
            Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exit00", "SSLConfiguration.configuredSSLAlias()"));
        }
        return this.sslAliasConfigured;
    }

    public Properties getPropertiesObject() {
        Properties properties;
        block14: {
            properties = null;
            try {
                String string;
                if (_tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)_tc, (String)Messages.getMessage("enter00", "SSLConfiguration.getPropertiesObject()"));
                }
                String string2 = string = JavaUtils.hasValue(System.getProperty(wsSSLconfigURLProperty)) ? System.getProperty(wsSSLconfigURLProperty) : System.getProperty(configURLProperty);
                if (string != null && (properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        InputStream inputStream = null;
                        Properties properties = null;
                        try {
                            URL uRL = new URL(string);
                            inputStream = uRL.openStream();
                            if (inputStream != null) {
                                properties = new Properties();
                                properties.load(inputStream);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.run", (String)"274", (Object)this);
                            throw exception;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        return properties;
                    }
                })) != null) {
                    String string3 = null;
                    for (int i = 0; i < passwordList.length; ++i) {
                        string3 = properties.getProperty(passwordList[i]);
                        if (!JavaUtils.hasValue(string3)) continue;
                        try {
                            string3 = PasswordUtil.decode(string3);
                            properties.setProperty(passwordList[i], string3);
                            if (!_tc.isEventEnabled()) continue;
                            Tr.event((TraceComponent)_tc, (String)Messages.getMessage("readKsPwdProperty", passwordList[i]));
                            continue;
                        }
                        catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                            // empty catch block
                        }
                    }
                    if (_tc.isDebugEnabled()) {
                        this.logProps(properties);
                    }
                }
                if (_tc.isEventEnabled()) {
                    if (JavaUtils.hasValue(string)) {
                        Tr.event((TraceComponent)_tc, (String)Messages.getMessage("sslConfiguration00", string));
                    } else {
                        Tr.event((TraceComponent)_tc, (String)Messages.getMessage("sslConfiguration00", "JSSE"));
                    }
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getPropertiesObject", (String)"332");
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(privilegedActionException.getCause() == null ? privilegedActionException : privilegedActionException.getCause())));
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getPropertiesObject", (String)"340");
                if (!_tc.isEventEnabled()) break block14;
                Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(throwable)));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)Messages.getMessage("exit00", "SSLConfiguration.getPropertiesObject()"));
        }
        return properties;
    }

    public boolean isValid(Properties properties) {
        boolean bl;
        SecurityService securityService;
        Properties properties2;
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"SSLConfiguration::isValid()");
        }
        if (JavaUtils.hasValue(string = (properties2 = properties).getProperty("alias")) && (securityService = WSServerImpl.getSecurityService()) != null) {
            properties2 = securityService.getSecureSocketLayer(string);
        }
        boolean bl2 = JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.keyStore")) && JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.keyStorePassword"));
        boolean bl3 = JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.trustStore")) && JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.trustStorePassword"));
        boolean bl4 = JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.tokenLibraryFile")) && JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.tokenPassword")) && JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.tokenType"));
        boolean bl5 = bl = JavaUtils.hasValue(System.getProperty("javax.net.ssl.keyStore")) && JavaUtils.hasValue(System.getProperty("javax.net.ssl.keyStorePassword")) && JavaUtils.hasValue(System.getProperty("javax.net.ssl.trustStore")) && JavaUtils.hasValue(System.getProperty("javax.net.ssl.trustStorePassword"));
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"SSLConfiguration::isValid()");
        }
        return bl2 && bl3 || bl4 || bl;
    }

    public static void printInfofromProperties(Properties properties) {
        block4: {
            if (!_tc.isDebugEnabled()) break block4;
            String[] stringArray = new String[]{"com.ibm.ssl.keyManager", "com.ibm.ssl.keyStoreType", "com.ibm.ssl.keyStoreProvider", "com.ibm.ssl.keyStore", "com.ibm.ssl.trustManager", "com.ibm.ssl.trustStoreType", "com.ibm.ssl.trustStoreProvider", "com.ibm.ssl.trustStore", "com.ibm.ssl.clientAuthentication", "com.ibm.ssl.tokenType", "com.ibm.ssl.tokenLibraryFile", "com.ibm.ssl.keyStoreClientAlias", "com.ibm.ssl.keyStoreServerAlias"};
            String[] stringArray2 = new String[]{"javax.net.ssl.keyStore", "javax.net.ssl.keyStoreType", "javax.net.ssl.trustStore", "javax.net.ssl.trustStoreType"};
            if (properties != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Tr.debug((TraceComponent)_tc, (String)(stringArray[i] + ": " + properties.getProperty(stringArray[i])));
                }
            } else {
                for (int i = 0; i < stringArray2.length; ++i) {
                    Tr.debug((TraceComponent)_tc, (String)(stringArray2[i] + ": " + System.getProperty(stringArray2[i])));
                }
            }
        }
    }

    public SSLSocketFactory getSocketFactoryByPropFile(final String string) {
        Properties properties;
        SSLSocketFactory sSLSocketFactory;
        block14: {
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)("SSLConfiguration::getSocketFactoryByPropFile(" + string + ")"));
            }
            sSLSocketFactory = null;
            properties = null;
            try {
                properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        InputStream inputStream = null;
                        Properties properties = null;
                        try {
                            URL uRL = new URL(string);
                            inputStream = uRL.openStream();
                            if (inputStream != null) {
                                properties = new Properties();
                                properties.load(inputStream);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.run", (String)"490", (Object)this);
                            throw exception;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        if (_tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)_tc, (String)"SSLConfiguration::getSocketFactoryByPropFile()");
                        }
                        return properties;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getSocketFactoryByPropFile", (String)"507", (Object)this);
                if (!_tc.isEventEnabled()) break block14;
                Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(privilegedActionException.getCause() == null ? privilegedActionException : privilegedActionException.getCause())));
            }
        }
        if (properties != null) {
            this.sslConfigured.init(properties);
            try {
                if (_tc.isDebugEnabled()) {
                    this.logProps(properties);
                }
                if (_tc.isEventEnabled()) {
                    String string2 = this.sslConfigured.getKeyFileName();
                    String string3 = this.sslConfigured.getTrustFileName();
                    String string4 = this.sslConfigured.getTokenLibraryFile();
                    if (JavaUtils.hasValue(string2) && JavaUtils.hasValue(string3) && JavaUtils.hasValue(string4)) {
                        Tr.event((TraceComponent)_tc, (String)Messages.getMessage("keyStoresUsed00", string2, string3, null));
                    } else {
                        Tr.event((TraceComponent)_tc, (String)Messages.getMessage("keyStoresUsed00", string2, string3, string4));
                    }
                }
                sSLSocketFactory = this.sslConfigured.getSocketFactory();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getSocketFactoryByPropFile", (String)"544", (Object)this);
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
                }
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("SSL Properties: " + properties));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"SSLConfiguration::getSocketFactoryByPropFile()");
        }
        return sSLSocketFactory;
    }

    private void logProps(Properties properties) {
        try {
            if (_tc.isDebugEnabled() && properties != null && _tc.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("theProp contents:\n{");
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (pwMap.containsValue(string)) {
                        stringBuffer.append(string + "=****, ");
                        continue;
                    }
                    Object object = properties.get(string);
                    if (object instanceof String) {
                        stringBuffer.append(string + "=" + object + ", ");
                        continue;
                    }
                    stringBuffer.append(string + "=(non-String), ");
                }
                stringBuffer.append("}");
                Tr.debug((TraceComponent)_tc, (String)stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SSLSocketFactory getSocketFactoryBySSLAlias(String string) {
        SSLSocketFactory sSLSocketFactory;
        block17: {
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)("SSLConfiguration::getSocketFactoryBySSLAlias(" + string + ")"));
            }
            sSLSocketFactory = null;
            Properties properties = null;
            if (string != null) {
                this.sslAliasConfigured = new String(string);
                try {
                    SecurityService securityService = WSServerImpl.getSecurityService();
                    if (securityService != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"Obtained SecurityService");
                        }
                        if ((properties = securityService.getSecureSocketLayer(this.sslAliasConfigured)) == null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("SSL Properties: " + properties));
                                Tr.debug((TraceComponent)_tc, (String)"ssllayerProp is null");
                            }
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"SSL Properties: non-null");
                                Tr.debug((TraceComponent)_tc, (String)"Init SSLConfig with ssllayerProp");
                            }
                            this.sslConfigured.init(properties);
                            if (_tc.isEventEnabled()) {
                                String string2 = this.sslConfigured.getKeyFileName();
                                String string3 = this.sslConfigured.getTrustFileName();
                                String string4 = this.sslConfigured.getTokenLibraryFile();
                                if (JavaUtils.hasValue(string2) && JavaUtils.hasValue(string3) && JavaUtils.hasValue(string4)) {
                                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("keyStoresUsed00", string2, string3, null));
                                } else {
                                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("keyStoresUsed00", string2, string3, string4));
                                }
                            }
                            sSLSocketFactory = this.sslConfigured.getSocketFactory();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Obtained the SSL socket factory");
                            }
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("SecurityService: " + securityService));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getSocketFactoryBySSLAlias", (String)"663", (Object)this);
                    if (!_tc.isEventEnabled()) break block17;
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"SSLConfiguration::getSocketFactoryBySSLAlias");
        }
        return sSLSocketFactory;
    }
}

