/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PivotHandlerWrapper;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.resources.Messages;
import org.apache.commons.logging.Log;

public class ClientEngine
extends WebServicesEngine {
    protected static Log log = LogFactory.getLog(ClientEngine.class.getName());

    public ClientEngine() {
        super(EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig());
    }

    public ClientEngine(EngineConfiguration engineConfiguration) {
        super(engineConfiguration == null ? EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig() : engineConfiguration);
    }

    public WebServicesEngine getClientEngine() {
        return this;
    }

    protected Handler createMessageFlow(MessageContext messageContext) throws WebServicesFault, ConfigurationException {
        Handler handler2;
        String string = messageContext.getTransportName();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("transport01", "ServerEngine.invoke", string));
        }
        if ((handler2 = this.getTransport(string)) == null) {
            throw new WebServicesFault(Messages.getMessage("noTransport00", string));
        }
        handler2 = PivotHandlerWrapper.factory(this.getGlobalHandler(), handler2);
        return PivotHandlerWrapper.factory(messageContext.getPort(), handler2);
    }

    public boolean isServer() {
        return false;
    }
}

